<?php
/**
 * AggregationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AggregationQuery Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AggregationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AggregationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'interval' => 'string',
        'granularity' => 'string',
        'timeZone' => 'string',
        'groupBy' => 'string[]',
        'filter' => '\PureCloudSDK\AnalyticsQueryFilter',
        'metrics' => 'string[]',
        'flattenMultivaluedDimensions' => 'bool',
        'views' => '\PureCloudSDK\AnalyticsView[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'interval' => 'interval',
        'granularity' => 'granularity',
        'timeZone' => 'timeZone',
        'groupBy' => 'groupBy',
        'filter' => 'filter',
        'metrics' => 'metrics',
        'flattenMultivaluedDimensions' => 'flattenMultivaluedDimensions',
        'views' => 'views'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'interval' => 'setInterval',
        'granularity' => 'setGranularity',
        'timeZone' => 'setTimeZone',
        'groupBy' => 'setGroupBy',
        'filter' => 'setFilter',
        'metrics' => 'setMetrics',
        'flattenMultivaluedDimensions' => 'setFlattenMultivaluedDimensions',
        'views' => 'setViews'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'interval' => 'getInterval',
        'granularity' => 'getGranularity',
        'timeZone' => 'getTimeZone',
        'groupBy' => 'getGroupBy',
        'filter' => 'getFilter',
        'metrics' => 'getMetrics',
        'flattenMultivaluedDimensions' => 'getFlattenMultivaluedDimensions',
        'views' => 'getViews'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const GROUP_BY_CONVERSATION_ID = 'conversationId';
    const GROUP_BY_SESSION_ID = 'sessionId';
    const GROUP_BY_MEDIA_TYPE = 'mediaType';
    const GROUP_BY_QUEUE_ID = 'queueId';
    const GROUP_BY_USER_ID = 'userId';
    const GROUP_BY_PARTICIPANT_ID = 'participantId';
    const GROUP_BY_PARTICIPANT_NAME = 'participantName';
    const GROUP_BY_DIRECTION = 'direction';
    const GROUP_BY_ORIGINATING_DIRECTION = 'originatingDirection';
    const GROUP_BY_WRAP_UP_CODE = 'wrapUpCode';
    const GROUP_BY_WRAP_UP_NOTE = 'wrapUpNote';
    const GROUP_BY_INTERACTION_TYPE = 'interactionType';
    const GROUP_BY_REQUESTED_ROUTING_SKILL_ID = 'requestedRoutingSkillId';
    const GROUP_BY_REQUESTED_LANGUAGE_ID = 'requestedLanguageId';
    const GROUP_BY_REQUESTED_ROUTING_USER_IDS = 'requestedRoutingUserIds';
    const GROUP_BY_ROUTING_PRIORITY = 'routingPriority';
    const GROUP_BY_PURPOSE = 'purpose';
    const GROUP_BY_PARTICIPANT_TYPE = 'participantType';
    const GROUP_BY_SEGMENT_TYPE = 'segmentType';
    const GROUP_BY_DISCONNECT_TYPE = 'disconnectType';
    const GROUP_BY_ERROR_CODE = 'errorCode';
    const GROUP_BY_CONVERSATION_END = 'conversationEnd';
    const GROUP_BY_SEGMENT_END = 'segmentEnd';
    const GROUP_BY_EXTERNAL_CONTACT_ID = 'externalContactId';
    const GROUP_BY_EXTERNAL_ORGANIZATION_ID = 'externalOrganizationId';
    const GROUP_BY_CONVERTED_FROM = 'convertedFrom';
    const GROUP_BY_CONVERTED_TO = 'convertedTo';
    const GROUP_BY_DIVISION_ID = 'divisionId';
    const GROUP_BY_FLAGGED_REASON = 'flaggedReason';
    const GROUP_BY_STATION_ID = 'stationId';
    const GROUP_BY_EDGE_ID = 'edgeId';
    const GROUP_BY_DNIS = 'dnis';
    const GROUP_BY_ANI = 'ani';
    const GROUP_BY_SESSION_DNIS = 'sessionDnis';
    const GROUP_BY_OUTBOUND_CAMPAIGN_ID = 'outboundCampaignId';
    const GROUP_BY_OUTBOUND_CONTACT_ID = 'outboundContactId';
    const GROUP_BY_OUTBOUND_CONTACT_LIST_ID = 'outboundContactListId';
    const GROUP_BY_MONITORED_PARTICIPANT_ID = 'monitoredParticipantId';
    const GROUP_BY_SOURCE_SESSION_ID = 'sourceSessionId';
    const GROUP_BY_DESTINATION_SESSION_ID = 'destinationSessionId';
    const GROUP_BY_SOURCE_CONVERSATION_ID = 'sourceConversationId';
    const GROUP_BY_DESTINATION_CONVERSATION_ID = 'destinationConversationId';
    const GROUP_BY_REMOTE_NAME_DISPLAYABLE = 'remoteNameDisplayable';
    const GROUP_BY_SIP_RESPONSE_CODE = 'sipResponseCode';
    const GROUP_BY_Q850_RESPONSE_CODE = 'q850ResponseCode';
    const GROUP_BY_CONFERENCE = 'conference';
    const GROUP_BY_GROUP_ID = 'groupId';
    const GROUP_BY_PROTOCOL_CALL_ID = 'protocolCallId';
    const GROUP_BY_ROOM_ID = 'roomId';
    const GROUP_BY_ADDRESS_FROM = 'addressFrom';
    const GROUP_BY_ADDRESS_TO = 'addressTo';
    const GROUP_BY_ADDRESS_SELF = 'addressSelf';
    const GROUP_BY_ADDRESS_OTHER = 'addressOther';
    const GROUP_BY_SUBJECT = 'subject';
    const GROUP_BY_MESSAGE_TYPE = 'messageType';
    const GROUP_BY_PEER_ID = 'peerId';
    const GROUP_BY_SCRIPT_ID = 'scriptId';
    const GROUP_BY_EVALUATION_ID = 'evaluationId';
    const GROUP_BY_EVALUATOR_ID = 'evaluatorId';
    const GROUP_BY_CONTEXT_ID = 'contextId';
    const GROUP_BY_FORM_ID = 'formId';
    const GROUP_BY_FORM_NAME = 'formName';
    const GROUP_BY_EVENT_TIME = 'eventTime';
    const GROUP_BY_CALIBRATION_ID = 'calibrationId';
    const GROUP_BY_SURVEY_ID = 'surveyId';
    const GROUP_BY_SURVEY_FORM_CONTEXT_ID = 'surveyFormContextId';
    const GROUP_BY_SURVEY_FORM_ID = 'surveyFormId';
    const GROUP_BY_SURVEY_FORM_NAME = 'surveyFormName';
    const GROUP_BY_SURVEY_ANSWER_ID = 'surveyAnswerId';
    const GROUP_BY_SURVEY_QUESTION_ID = 'surveyQuestionId';
    const GROUP_BY_SURVEY_QUESTION_GROUP_ID = 'surveyQuestionGroupId';
    const GROUP_BY_SURVEY_PROMOTER_SCORE = 'surveyPromoterScore';
    const GROUP_BY_SURVEY_COMPLETED_DATE = 'surveyCompletedDate';
    const GROUP_BY_SURVEY_ERROR_REASON = 'surveyErrorReason';
    const GROUP_BY_SURVEY_PREVIOUS_STATUS = 'surveyPreviousStatus';
    const GROUP_BY_SURVEY_STATUS = 'surveyStatus';
    const GROUP_BY_SYSTEM_PRESENCE = 'systemPresence';
    const GROUP_BY_ORGANIZATION_PRESENCE_ID = 'organizationPresenceId';
    const GROUP_BY_ROUTING_STATUS = 'routingStatus';
    const GROUP_BY_FLOW_ID = 'flowId';
    const GROUP_BY_FLOW_NAME = 'flowName';
    const GROUP_BY_FLOW_VERSION = 'flowVersion';
    const GROUP_BY_FLOW_TYPE = 'flowType';
    const GROUP_BY_EXIT_REASON = 'exitReason';
    const GROUP_BY_ENTRY_REASON = 'entryReason';
    const GROUP_BY_ENTRY_TYPE = 'entryType';
    const GROUP_BY_TRANSFER_TYPE = 'transferType';
    const GROUP_BY_TRANSFER_TARGET_NAME = 'transferTargetName';
    const GROUP_BY_TRANSFER_TARGET_ADDRESS = 'transferTargetAddress';
    const GROUP_BY_ISSUED_CALLBACK = 'issuedCallback';
    const GROUP_BY_STARTING_LANGUAGE = 'startingLanguage';
    const GROUP_BY_ENDING_LANGUAGE = 'endingLanguage';
    const GROUP_BY_FLOW_OUTCOME_ID = 'flowOutcomeId';
    const GROUP_BY_FLOW_OUTCOME_VALUE = 'flowOutcomeValue';
    const GROUP_BY_FLOW_OUTCOME = 'flowOutcome';
    const GROUP_BY_JOURNEY_CUSTOMER_ID = 'journeyCustomerId';
    const GROUP_BY_JOURNEY_CUSTOMER_ID_TYPE = 'journeyCustomerIdType';
    const GROUP_BY_JOURNEY_CUSTOMER_SESSION_ID = 'journeyCustomerSessionId';
    const GROUP_BY_JOURNEY_CUSTOMER_SESSION_ID_TYPE = 'journeyCustomerSessionIdType';
    const GROUP_BY_JOURNEY_ACTION_ID = 'journeyActionId';
    const GROUP_BY_JOURNEY_ACTION_MAP_ID = 'journeyActionMapId';
    const GROUP_BY_JOURNEY_ACTION_MAP_VERSION = 'journeyActionMapVersion';
    const GROUP_BY_MIN_MOS = 'minMos';
    const GROUP_BY_MEDIA_STATS_MIN_CONVERSATION_MOS = 'mediaStatsMinConversationMos';
    const GROUP_BY_MIN_R_FACTOR = 'minRFactor';
    const GROUP_BY_MEDIA_STATS_MIN_CONVERSATION_R_FACTOR = 'mediaStatsMinConversationRFactor';
    const METRICS_T_SEGMENT_DURATION = 'tSegmentDuration';
    const METRICS_T_CONVERSATION_DURATION = 'tConversationDuration';
    const METRICS_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    const METRICS_O_TOTAL_SCORE = 'oTotalScore';
    const METRICS_N_EVALUATIONS = 'nEvaluations';
    const METRICS_T_ABANDON = 'tAbandon';
    const METRICS_T_IVR = 'tIvr';
    const METRICS_T_ANSWERED = 'tAnswered';
    const METRICS_T_FLOW_OUT = 'tFlowOut';
    const METRICS_T_ACD = 'tAcd';
    const METRICS_T_TALK = 'tTalk';
    const METRICS_T_HELD = 'tHeld';
    const METRICS_T_TALK_COMPLETE = 'tTalkComplete';
    const METRICS_T_HELD_COMPLETE = 'tHeldComplete';
    const METRICS_T_ACW = 'tAcw';
    const METRICS_T_HANDLE = 'tHandle';
    const METRICS_T_CONTACTING = 'tContacting';
    const METRICS_T_DIALING = 'tDialing';
    const METRICS_T_WAIT = 'tWait';
    const METRICS_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    const METRICS_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    const METRICS_T_SYSTEM_PRESENCE = 'tSystemPresence';
    const METRICS_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    const METRICS_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    const METRICS_T_VOICEMAIL = 'tVoicemail';
    const METRICS_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    const METRICS_N_OFFERED = 'nOffered';
    const METRICS_N_OVER_SLA = 'nOverSla';
    const METRICS_N_TRANSFERRED = 'nTransferred';
    const METRICS_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    const METRICS_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    const METRICS_N_CONSULT = 'nConsult';
    const METRICS_N_CONNECTED = 'nConnected';
    const METRICS_T_ALERT = 'tAlert';
    const METRICS_T_NOT_RESPONDING = 'tNotResponding';
    const METRICS_N_OUTBOUND = 'nOutbound';
    const METRICS_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    const METRICS_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    const METRICS_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    const METRICS_N_ERROR = 'nError';
    const METRICS_O_SERVICE_TARGET = 'oServiceTarget';
    const METRICS_O_SERVICE_LEVEL = 'oServiceLevel';
    const METRICS_T_ACTIVE = 'tActive';
    const METRICS_T_INACTIVE = 'tInactive';
    const METRICS_O_ACTIVE_USERS = 'oActiveUsers';
    const METRICS_O_MEMBER_USERS = 'oMemberUsers';
    const METRICS_O_ACTIVE_QUEUES = 'oActiveQueues';
    const METRICS_O_MEMBER_QUEUES = 'oMemberQueues';
    const METRICS_O_INTERACTING = 'oInteracting';
    const METRICS_O_WAITING = 'oWaiting';
    const METRICS_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    const METRICS_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    const METRICS_O_USER_PRESENCES = 'oUserPresences';
    const METRICS_O_USER_ROUTING_STATUSES = 'oUserRoutingStatuses';
    const METRICS_N_SURVEYS_SENT = 'nSurveysSent';
    const METRICS_N_SURVEYS_STARTED = 'nSurveysStarted';
    const METRICS_N_SURVEYS_ABANDONED = 'nSurveysAbandoned';
    const METRICS_N_SURVEYS_EXPIRED = 'nSurveysExpired';
    const METRICS_N_SURVEY_ERRORS = 'nSurveyErrors';
    const METRICS_N_SURVEY_RESPONSES = 'nSurveyResponses';
    const METRICS_N_SURVEY_ANSWER_RESPONSES = 'nSurveyAnswerResponses';
    const METRICS_O_SURVEY_TOTAL_SCORE = 'oSurveyTotalScore';
    const METRICS_O_SURVEY_QUESTION_GROUP_SCORE = 'oSurveyQuestionGroupScore';
    const METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES = 'nSurveyQuestionGroupResponses';
    const METRICS_O_SURVEY_QUESTION_SCORE = 'oSurveyQuestionScore';
    const METRICS_N_SURVEY_QUESTION_RESPONSES = 'nSurveyQuestionResponses';
    const METRICS_N_SURVEY_NPS_RESPONSES = 'nSurveyNpsResponses';
    const METRICS_N_SURVEY_NPS_PROMOTERS = 'nSurveyNpsPromoters';
    const METRICS_N_SURVEY_NPS_DETRACTORS = 'nSurveyNpsDetractors';
    const METRICS_N_FLOW = 'nFlow';
    const METRICS_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    const METRICS_T_FLOW_EXIT = 'tFlowExit';
    const METRICS_T_FLOW = 'tFlow';
    const METRICS_O_FLOW = 'oFlow';
    const METRICS_T_FLOW_OUTCOME = 'tFlowOutcome';
    const METRICS_N_FLOW_OUTCOME = 'nFlowOutcome';
    const METRICS_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getGroupByAllowableValues()
    {
        return [
            self::GROUP_BY_CONVERSATION_ID,
            self::GROUP_BY_SESSION_ID,
            self::GROUP_BY_MEDIA_TYPE,
            self::GROUP_BY_QUEUE_ID,
            self::GROUP_BY_USER_ID,
            self::GROUP_BY_PARTICIPANT_ID,
            self::GROUP_BY_PARTICIPANT_NAME,
            self::GROUP_BY_DIRECTION,
            self::GROUP_BY_ORIGINATING_DIRECTION,
            self::GROUP_BY_WRAP_UP_CODE,
            self::GROUP_BY_WRAP_UP_NOTE,
            self::GROUP_BY_INTERACTION_TYPE,
            self::GROUP_BY_REQUESTED_ROUTING_SKILL_ID,
            self::GROUP_BY_REQUESTED_LANGUAGE_ID,
            self::GROUP_BY_REQUESTED_ROUTING_USER_IDS,
            self::GROUP_BY_ROUTING_PRIORITY,
            self::GROUP_BY_PURPOSE,
            self::GROUP_BY_PARTICIPANT_TYPE,
            self::GROUP_BY_SEGMENT_TYPE,
            self::GROUP_BY_DISCONNECT_TYPE,
            self::GROUP_BY_ERROR_CODE,
            self::GROUP_BY_CONVERSATION_END,
            self::GROUP_BY_SEGMENT_END,
            self::GROUP_BY_EXTERNAL_CONTACT_ID,
            self::GROUP_BY_EXTERNAL_ORGANIZATION_ID,
            self::GROUP_BY_CONVERTED_FROM,
            self::GROUP_BY_CONVERTED_TO,
            self::GROUP_BY_DIVISION_ID,
            self::GROUP_BY_FLAGGED_REASON,
            self::GROUP_BY_STATION_ID,
            self::GROUP_BY_EDGE_ID,
            self::GROUP_BY_DNIS,
            self::GROUP_BY_ANI,
            self::GROUP_BY_SESSION_DNIS,
            self::GROUP_BY_OUTBOUND_CAMPAIGN_ID,
            self::GROUP_BY_OUTBOUND_CONTACT_ID,
            self::GROUP_BY_OUTBOUND_CONTACT_LIST_ID,
            self::GROUP_BY_MONITORED_PARTICIPANT_ID,
            self::GROUP_BY_SOURCE_SESSION_ID,
            self::GROUP_BY_DESTINATION_SESSION_ID,
            self::GROUP_BY_SOURCE_CONVERSATION_ID,
            self::GROUP_BY_DESTINATION_CONVERSATION_ID,
            self::GROUP_BY_REMOTE_NAME_DISPLAYABLE,
            self::GROUP_BY_SIP_RESPONSE_CODE,
            self::GROUP_BY_Q850_RESPONSE_CODE,
            self::GROUP_BY_CONFERENCE,
            self::GROUP_BY_GROUP_ID,
            self::GROUP_BY_PROTOCOL_CALL_ID,
            self::GROUP_BY_ROOM_ID,
            self::GROUP_BY_ADDRESS_FROM,
            self::GROUP_BY_ADDRESS_TO,
            self::GROUP_BY_ADDRESS_SELF,
            self::GROUP_BY_ADDRESS_OTHER,
            self::GROUP_BY_SUBJECT,
            self::GROUP_BY_MESSAGE_TYPE,
            self::GROUP_BY_PEER_ID,
            self::GROUP_BY_SCRIPT_ID,
            self::GROUP_BY_EVALUATION_ID,
            self::GROUP_BY_EVALUATOR_ID,
            self::GROUP_BY_CONTEXT_ID,
            self::GROUP_BY_FORM_ID,
            self::GROUP_BY_FORM_NAME,
            self::GROUP_BY_EVENT_TIME,
            self::GROUP_BY_CALIBRATION_ID,
            self::GROUP_BY_SURVEY_ID,
            self::GROUP_BY_SURVEY_FORM_CONTEXT_ID,
            self::GROUP_BY_SURVEY_FORM_ID,
            self::GROUP_BY_SURVEY_FORM_NAME,
            self::GROUP_BY_SURVEY_ANSWER_ID,
            self::GROUP_BY_SURVEY_QUESTION_ID,
            self::GROUP_BY_SURVEY_QUESTION_GROUP_ID,
            self::GROUP_BY_SURVEY_PROMOTER_SCORE,
            self::GROUP_BY_SURVEY_COMPLETED_DATE,
            self::GROUP_BY_SURVEY_ERROR_REASON,
            self::GROUP_BY_SURVEY_PREVIOUS_STATUS,
            self::GROUP_BY_SURVEY_STATUS,
            self::GROUP_BY_SYSTEM_PRESENCE,
            self::GROUP_BY_ORGANIZATION_PRESENCE_ID,
            self::GROUP_BY_ROUTING_STATUS,
            self::GROUP_BY_FLOW_ID,
            self::GROUP_BY_FLOW_NAME,
            self::GROUP_BY_FLOW_VERSION,
            self::GROUP_BY_FLOW_TYPE,
            self::GROUP_BY_EXIT_REASON,
            self::GROUP_BY_ENTRY_REASON,
            self::GROUP_BY_ENTRY_TYPE,
            self::GROUP_BY_TRANSFER_TYPE,
            self::GROUP_BY_TRANSFER_TARGET_NAME,
            self::GROUP_BY_TRANSFER_TARGET_ADDRESS,
            self::GROUP_BY_ISSUED_CALLBACK,
            self::GROUP_BY_STARTING_LANGUAGE,
            self::GROUP_BY_ENDING_LANGUAGE,
            self::GROUP_BY_FLOW_OUTCOME_ID,
            self::GROUP_BY_FLOW_OUTCOME_VALUE,
            self::GROUP_BY_FLOW_OUTCOME,
            self::GROUP_BY_JOURNEY_CUSTOMER_ID,
            self::GROUP_BY_JOURNEY_CUSTOMER_ID_TYPE,
            self::GROUP_BY_JOURNEY_CUSTOMER_SESSION_ID,
            self::GROUP_BY_JOURNEY_CUSTOMER_SESSION_ID_TYPE,
            self::GROUP_BY_JOURNEY_ACTION_ID,
            self::GROUP_BY_JOURNEY_ACTION_MAP_ID,
            self::GROUP_BY_JOURNEY_ACTION_MAP_VERSION,
            self::GROUP_BY_MIN_MOS,
            self::GROUP_BY_MEDIA_STATS_MIN_CONVERSATION_MOS,
            self::GROUP_BY_MIN_R_FACTOR,
            self::GROUP_BY_MEDIA_STATS_MIN_CONVERSATION_R_FACTOR,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_T_SEGMENT_DURATION,
            self::METRICS_T_CONVERSATION_DURATION,
            self::METRICS_O_TOTAL_CRITICAL_SCORE,
            self::METRICS_O_TOTAL_SCORE,
            self::METRICS_N_EVALUATIONS,
            self::METRICS_T_ABANDON,
            self::METRICS_T_IVR,
            self::METRICS_T_ANSWERED,
            self::METRICS_T_FLOW_OUT,
            self::METRICS_T_ACD,
            self::METRICS_T_TALK,
            self::METRICS_T_HELD,
            self::METRICS_T_TALK_COMPLETE,
            self::METRICS_T_HELD_COMPLETE,
            self::METRICS_T_ACW,
            self::METRICS_T_HANDLE,
            self::METRICS_T_CONTACTING,
            self::METRICS_T_DIALING,
            self::METRICS_T_WAIT,
            self::METRICS_T_AGENT_ROUTING_STATUS,
            self::METRICS_T_ORGANIZATION_PRESENCE,
            self::METRICS_T_SYSTEM_PRESENCE,
            self::METRICS_T_USER_RESPONSE_TIME,
            self::METRICS_T_AGENT_RESPONSE_TIME,
            self::METRICS_T_VOICEMAIL,
            self::METRICS_N_STATE_TRANSITION_ERROR,
            self::METRICS_N_OFFERED,
            self::METRICS_N_OVER_SLA,
            self::METRICS_N_TRANSFERRED,
            self::METRICS_N_BLIND_TRANSFERRED,
            self::METRICS_N_CONSULT_TRANSFERRED,
            self::METRICS_N_CONSULT,
            self::METRICS_N_CONNECTED,
            self::METRICS_T_ALERT,
            self::METRICS_T_NOT_RESPONDING,
            self::METRICS_N_OUTBOUND,
            self::METRICS_N_OUTBOUND_ATTEMPTED,
            self::METRICS_N_OUTBOUND_CONNECTED,
            self::METRICS_N_OUTBOUND_ABANDONED,
            self::METRICS_N_ERROR,
            self::METRICS_O_SERVICE_TARGET,
            self::METRICS_O_SERVICE_LEVEL,
            self::METRICS_T_ACTIVE,
            self::METRICS_T_INACTIVE,
            self::METRICS_O_ACTIVE_USERS,
            self::METRICS_O_MEMBER_USERS,
            self::METRICS_O_ACTIVE_QUEUES,
            self::METRICS_O_MEMBER_QUEUES,
            self::METRICS_O_INTERACTING,
            self::METRICS_O_WAITING,
            self::METRICS_O_ON_QUEUE_USERS,
            self::METRICS_O_OFF_QUEUE_USERS,
            self::METRICS_O_USER_PRESENCES,
            self::METRICS_O_USER_ROUTING_STATUSES,
            self::METRICS_N_SURVEYS_SENT,
            self::METRICS_N_SURVEYS_STARTED,
            self::METRICS_N_SURVEYS_ABANDONED,
            self::METRICS_N_SURVEYS_EXPIRED,
            self::METRICS_N_SURVEY_ERRORS,
            self::METRICS_N_SURVEY_RESPONSES,
            self::METRICS_N_SURVEY_ANSWER_RESPONSES,
            self::METRICS_O_SURVEY_TOTAL_SCORE,
            self::METRICS_O_SURVEY_QUESTION_GROUP_SCORE,
            self::METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES,
            self::METRICS_O_SURVEY_QUESTION_SCORE,
            self::METRICS_N_SURVEY_QUESTION_RESPONSES,
            self::METRICS_N_SURVEY_NPS_RESPONSES,
            self::METRICS_N_SURVEY_NPS_PROMOTERS,
            self::METRICS_N_SURVEY_NPS_DETRACTORS,
            self::METRICS_N_FLOW,
            self::METRICS_T_FLOW_DISCONNECT,
            self::METRICS_T_FLOW_EXIT,
            self::METRICS_T_FLOW,
            self::METRICS_O_FLOW,
            self::METRICS_T_FLOW_OUTCOME,
            self::METRICS_N_FLOW_OUTCOME,
            self::METRICS_N_FLOW_OUTCOME_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['interval'] = isset($data['interval']) ? $data['interval'] : null;
        $this->container['granularity'] = isset($data['granularity']) ? $data['granularity'] : null;
        $this->container['timeZone'] = isset($data['timeZone']) ? $data['timeZone'] : null;
        $this->container['groupBy'] = isset($data['groupBy']) ? $data['groupBy'] : null;
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['flattenMultivaluedDimensions'] = isset($data['flattenMultivaluedDimensions']) ? $data['flattenMultivaluedDimensions'] : null;
        $this->container['views'] = isset($data['views']) ? $data['views'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets interval
     * @return string
     */
    public function getInterval()
    {
        return $this->container['interval'];
    }

    /**
     * Sets interval
     * @param string $interval Behaves like one clause in a SQL WHERE. Specifies the date and time range of data being queried. Intervals are represented as an ISO-8601 string. For example: YYYY-MM-DDThh:mm:ss/YYYY-MM-DDThh:mm:ss
     * @return $this
     */
    public function setInterval($interval)
    {
        $this->container['interval'] = $interval;

        return $this;
    }

    /**
     * Gets granularity
     * @return string
     */
    public function getGranularity()
    {
        return $this->container['granularity'];
    }

    /**
     * Sets granularity
     * @param string $granularity Granularity aggregates metrics into subpartitions within the time interval specified. The default granularity is the same duration as the interval. Periods are represented as an ISO-8601 string. For example: P1D or P1DT12H
     * @return $this
     */
    public function setGranularity($granularity)
    {
        $this->container['granularity'] = $granularity;

        return $this;
    }

    /**
     * Gets timeZone
     * @return string
     */
    public function getTimeZone()
    {
        return $this->container['timeZone'];
    }

    /**
     * Sets timeZone
     * @param string $timeZone Sets the time zone for the query interval, defaults to UTC. Time zones are represented as a string of the zone name as found in the IANA time zone database. For example: UTC, Etc/UTC, or Europe/London
     * @return $this
     */
    public function setTimeZone($timeZone)
    {
        $this->container['timeZone'] = $timeZone;

        return $this;
    }

    /**
     * Gets groupBy
     * @return string[]
     */
    public function getGroupBy()
    {
        return $this->container['groupBy'];
    }

    /**
     * Sets groupBy
     * @param string[] $groupBy Behaves like a SQL GROUPBY. Allows for multiple levels of grouping as a list of dimensions. Partitions resulting aggregate computations into distinct named subgroups rather than across the entire result set as if it were one group.
     * @return $this
     */
    public function setGroupBy($groupBy)
    {
        $allowed_values = array('conversationId', 'sessionId', 'mediaType', 'queueId', 'userId', 'participantId', 'participantName', 'direction', 'originatingDirection', 'wrapUpCode', 'wrapUpNote', 'interactionType', 'requestedRoutingSkillId', 'requestedLanguageId', 'requestedRoutingUserIds', 'routingPriority', 'purpose', 'participantType', 'segmentType', 'disconnectType', 'errorCode', 'conversationEnd', 'segmentEnd', 'externalContactId', 'externalOrganizationId', 'convertedFrom', 'convertedTo', 'divisionId', 'flaggedReason', 'stationId', 'edgeId', 'dnis', 'ani', 'sessionDnis', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'monitoredParticipantId', 'sourceSessionId', 'destinationSessionId', 'sourceConversationId', 'destinationConversationId', 'remoteNameDisplayable', 'sipResponseCode', 'q850ResponseCode', 'conference', 'groupId', 'protocolCallId', 'roomId', 'addressFrom', 'addressTo', 'addressSelf', 'addressOther', 'subject', 'messageType', 'peerId', 'scriptId', 'evaluationId', 'evaluatorId', 'contextId', 'formId', 'formName', 'eventTime', 'calibrationId', 'surveyId', 'surveyFormContextId', 'surveyFormId', 'surveyFormName', 'surveyAnswerId', 'surveyQuestionId', 'surveyQuestionGroupId', 'surveyPromoterScore', 'surveyCompletedDate', 'surveyErrorReason', 'surveyPreviousStatus', 'surveyStatus', 'systemPresence', 'organizationPresenceId', 'routingStatus', 'flowId', 'flowName', 'flowVersion', 'flowType', 'exitReason', 'entryReason', 'entryType', 'transferType', 'transferTargetName', 'transferTargetAddress', 'issuedCallback', 'startingLanguage', 'endingLanguage', 'flowOutcomeId', 'flowOutcomeValue', 'flowOutcome', 'journeyCustomerId', 'journeyCustomerIdType', 'journeyCustomerSessionId', 'journeyCustomerSessionIdType', 'journeyActionId', 'journeyActionMapId', 'journeyActionMapVersion', 'minMos', 'mediaStatsMinConversationMos', 'minRFactor', 'mediaStatsMinConversationRFactor');
        if (!in_array($groupBy, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'groupBy', must be one of 'conversationId', 'sessionId', 'mediaType', 'queueId', 'userId', 'participantId', 'participantName', 'direction', 'originatingDirection', 'wrapUpCode', 'wrapUpNote', 'interactionType', 'requestedRoutingSkillId', 'requestedLanguageId', 'requestedRoutingUserIds', 'routingPriority', 'purpose', 'participantType', 'segmentType', 'disconnectType', 'errorCode', 'conversationEnd', 'segmentEnd', 'externalContactId', 'externalOrganizationId', 'convertedFrom', 'convertedTo', 'divisionId', 'flaggedReason', 'stationId', 'edgeId', 'dnis', 'ani', 'sessionDnis', 'outboundCampaignId', 'outboundContactId', 'outboundContactListId', 'monitoredParticipantId', 'sourceSessionId', 'destinationSessionId', 'sourceConversationId', 'destinationConversationId', 'remoteNameDisplayable', 'sipResponseCode', 'q850ResponseCode', 'conference', 'groupId', 'protocolCallId', 'roomId', 'addressFrom', 'addressTo', 'addressSelf', 'addressOther', 'subject', 'messageType', 'peerId', 'scriptId', 'evaluationId', 'evaluatorId', 'contextId', 'formId', 'formName', 'eventTime', 'calibrationId', 'surveyId', 'surveyFormContextId', 'surveyFormId', 'surveyFormName', 'surveyAnswerId', 'surveyQuestionId', 'surveyQuestionGroupId', 'surveyPromoterScore', 'surveyCompletedDate', 'surveyErrorReason', 'surveyPreviousStatus', 'surveyStatus', 'systemPresence', 'organizationPresenceId', 'routingStatus', 'flowId', 'flowName', 'flowVersion', 'flowType', 'exitReason', 'entryReason', 'entryType', 'transferType', 'transferTargetName', 'transferTargetAddress', 'issuedCallback', 'startingLanguage', 'endingLanguage', 'flowOutcomeId', 'flowOutcomeValue', 'flowOutcome', 'journeyCustomerId', 'journeyCustomerIdType', 'journeyCustomerSessionId', 'journeyCustomerSessionIdType', 'journeyActionId', 'journeyActionMapId', 'journeyActionMapVersion', 'minMos', 'mediaStatsMinConversationMos', 'minRFactor', 'mediaStatsMinConversationRFactor'");
        }
        $this->container['groupBy'] = $groupBy;

        return $this;
    }

    /**
     * Gets filter
     * @return \PureCloudSDK\AnalyticsQueryFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\AnalyticsQueryFilter $filter Behaves like a SQL WHERE clause. This is ANDed with the interval parameter. Expresses boolean logical predicates as well as dimensional filters
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets flattenMultivaluedDimensions
     * @return bool
     */
    public function getFlattenMultivaluedDimensions()
    {
        return $this->container['flattenMultivaluedDimensions'];
    }

    /**
     * Sets flattenMultivaluedDimensions
     * @param bool $flattenMultivaluedDimensions Flattens any multivalued dimensions used in response groups (e.g. ['a','b','c']->'a,b,c')
     * @return $this
     */
    public function setFlattenMultivaluedDimensions($flattenMultivaluedDimensions)
    {
        $this->container['flattenMultivaluedDimensions'] = $flattenMultivaluedDimensions;

        return $this;
    }

    /**
     * Gets views
     * @return \PureCloudSDK\AnalyticsView[]
     */
    public function getViews()
    {
        return $this->container['views'];
    }

    /**
     * Sets views
     * @param \PureCloudSDK\AnalyticsView[] $views Custom derived metric views
     * @return $this
     */
    public function setViews($views)
    {
        $this->container['views'] = $views;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


