<?php
/**
 * AnalyticsFlowOutcome
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsFlowOutcome Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsFlowOutcome implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsFlowOutcome';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'flowOutcomeId' => 'string',
        'flowOutcomeValue' => 'string',
        'flowOutcome' => 'string',
        'flowOutcomeStartTimestamp' => '\DateTime',
        'flowOutcomeEndTimestamp' => '\DateTime'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'flowOutcomeId' => 'flowOutcomeId',
        'flowOutcomeValue' => 'flowOutcomeValue',
        'flowOutcome' => 'flowOutcome',
        'flowOutcomeStartTimestamp' => 'flowOutcomeStartTimestamp',
        'flowOutcomeEndTimestamp' => 'flowOutcomeEndTimestamp'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'flowOutcomeId' => 'setFlowOutcomeId',
        'flowOutcomeValue' => 'setFlowOutcomeValue',
        'flowOutcome' => 'setFlowOutcome',
        'flowOutcomeStartTimestamp' => 'setFlowOutcomeStartTimestamp',
        'flowOutcomeEndTimestamp' => 'setFlowOutcomeEndTimestamp'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'flowOutcomeId' => 'getFlowOutcomeId',
        'flowOutcomeValue' => 'getFlowOutcomeValue',
        'flowOutcome' => 'getFlowOutcome',
        'flowOutcomeStartTimestamp' => 'getFlowOutcomeStartTimestamp',
        'flowOutcomeEndTimestamp' => 'getFlowOutcomeEndTimestamp'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['flowOutcomeId'] = isset($data['flowOutcomeId']) ? $data['flowOutcomeId'] : null;
        $this->container['flowOutcomeValue'] = isset($data['flowOutcomeValue']) ? $data['flowOutcomeValue'] : null;
        $this->container['flowOutcome'] = isset($data['flowOutcome']) ? $data['flowOutcome'] : null;
        $this->container['flowOutcomeStartTimestamp'] = isset($data['flowOutcomeStartTimestamp']) ? $data['flowOutcomeStartTimestamp'] : null;
        $this->container['flowOutcomeEndTimestamp'] = isset($data['flowOutcomeEndTimestamp']) ? $data['flowOutcomeEndTimestamp'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets flowOutcomeId
     * @return string
     */
    public function getFlowOutcomeId()
    {
        return $this->container['flowOutcomeId'];
    }

    /**
     * Sets flowOutcomeId
     * @param string $flowOutcomeId Unique identifiers of a flow outcome
     * @return $this
     */
    public function setFlowOutcomeId($flowOutcomeId)
    {
        $this->container['flowOutcomeId'] = $flowOutcomeId;

        return $this;
    }

    /**
     * Gets flowOutcomeValue
     * @return string
     */
    public function getFlowOutcomeValue()
    {
        return $this->container['flowOutcomeValue'];
    }

    /**
     * Sets flowOutcomeValue
     * @param string $flowOutcomeValue Flow outcome value, e.g. SUCCESS
     * @return $this
     */
    public function setFlowOutcomeValue($flowOutcomeValue)
    {
        $this->container['flowOutcomeValue'] = $flowOutcomeValue;

        return $this;
    }

    /**
     * Gets flowOutcome
     * @return string
     */
    public function getFlowOutcome()
    {
        return $this->container['flowOutcome'];
    }

    /**
     * Sets flowOutcome
     * @param string $flowOutcome Colon-separated combinations of unique flow outcome identifier and value
     * @return $this
     */
    public function setFlowOutcome($flowOutcome)
    {
        $this->container['flowOutcome'] = $flowOutcome;

        return $this;
    }

    /**
     * Gets flowOutcomeStartTimestamp
     * @return \DateTime
     */
    public function getFlowOutcomeStartTimestamp()
    {
        return $this->container['flowOutcomeStartTimestamp'];
    }

    /**
     * Sets flowOutcomeStartTimestamp
     * @param \DateTime $flowOutcomeStartTimestamp Date/time the outcome started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setFlowOutcomeStartTimestamp($flowOutcomeStartTimestamp)
    {
        $this->container['flowOutcomeStartTimestamp'] = $flowOutcomeStartTimestamp;

        return $this;
    }

    /**
     * Gets flowOutcomeEndTimestamp
     * @return \DateTime
     */
    public function getFlowOutcomeEndTimestamp()
    {
        return $this->container['flowOutcomeEndTimestamp'];
    }

    /**
     * Sets flowOutcomeEndTimestamp
     * @param \DateTime $flowOutcomeEndTimestamp Date/time the outcome ended. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setFlowOutcomeEndTimestamp($flowOutcomeEndTimestamp)
    {
        $this->container['flowOutcomeEndTimestamp'] = $flowOutcomeEndTimestamp;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


