<?php
/**
 * StationsApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use \PureCloudSDK\Configuration;
use \PureCloudSDK\ApiClient;
use \PureCloudSDK\ApiException;
use \PureCloudSDK\ObjectSerializer;

/**
 * StationsApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class StationsApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return StationsApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteStationAssociateduser
     *
     * Unassigns the user assigned to this station
     *
     * @param string $stationId Station ID (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteStationAssociateduser($stationId)
    {
        list($response) = $this->deleteStationAssociateduserWithHttpInfo($stationId);
        return $response;
    }

    /**
     * Operation deleteStationAssociateduserWithHttpInfo
     *
     * Unassigns the user assigned to this station
     *
     * @param string $stationId Station ID (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteStationAssociateduserWithHttpInfo($stationId)
    {
        // verify the required parameter 'stationId' is set
        if ($stationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $stationId when calling deleteStationAssociateduser');
        }
        // parse inputs
        $resourcePath = "/api/v2/stations/{stationId}/associateduser";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($stationId !== null) {
            $resourcePath = str_replace(
                "{" . "stationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($stationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/stations/{stationId}/associateduser'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getStation
     *
     * Get station.
     *
     * @param string $stationId Station ID (required)
     * @return \PureCloudSDK\Station
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getStation($stationId)
    {
        list($response) = $this->getStationWithHttpInfo($stationId);
        return $response;
    }

    /**
     * Operation getStationWithHttpInfo
     *
     * Get station.
     *
     * @param string $stationId Station ID (required)
     * @return Array of \PureCloudSDK\Station, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getStationWithHttpInfo($stationId)
    {
        // verify the required parameter 'stationId' is set
        if ($stationId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $stationId when calling getStation');
        }
        // parse inputs
        $resourcePath = "/api/v2/stations/{stationId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($stationId !== null) {
            $resourcePath = str_replace(
                "{" . "stationId" . "}",
                $this->apiClient->getSerializer()->toPathValue($stationId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Station',
                '/api/v2/stations/{stationId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Station', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Station', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getStations
     *
     * Get the list of available stations.
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $name Name (optional)
     * @param string $userSelectable True for stations that the user can select otherwise false (optional)
     * @param string $webRtcUserId Filter for the webRtc station of the webRtcUserId (optional)
     * @param string $id Comma separated list of stationIds (optional)
     * @param string $lineAppearanceId lineAppearanceId (optional)
     * @return \PureCloudSDK\StationEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getStations($pageSize = null, $pageNumber = null, $sortBy = null, $name = null, $userSelectable = null, $webRtcUserId = null, $id = null, $lineAppearanceId = null)
    {
        list($response) = $this->getStationsWithHttpInfo($pageSize, $pageNumber, $sortBy, $name, $userSelectable, $webRtcUserId, $id, $lineAppearanceId);
        return $response;
    }

    /**
     * Operation getStationsWithHttpInfo
     *
     * Get the list of available stations.
     *
     * @param int $pageSize Page size (optional, default to 25)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param string $sortBy Sort by (optional, default to name)
     * @param string $name Name (optional)
     * @param string $userSelectable True for stations that the user can select otherwise false (optional)
     * @param string $webRtcUserId Filter for the webRtc station of the webRtcUserId (optional)
     * @param string $id Comma separated list of stationIds (optional)
     * @param string $lineAppearanceId lineAppearanceId (optional)
     * @return Array of \PureCloudSDK\StationEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getStationsWithHttpInfo($pageSize = null, $pageNumber = null, $sortBy = null, $name = null, $userSelectable = null, $webRtcUserId = null, $id = null, $lineAppearanceId = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/stations";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($userSelectable !== null) {
            $queryParams['userSelectable'] = $this->apiClient->getSerializer()->toQueryValue($userSelectable);
        }
        // query params
        if ($webRtcUserId !== null) {
            $queryParams['webRtcUserId'] = $this->apiClient->getSerializer()->toQueryValue($webRtcUserId);
        }
        // query params
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($lineAppearanceId !== null) {
            $queryParams['lineAppearanceId'] = $this->apiClient->getSerializer()->toQueryValue($lineAppearanceId);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\StationEntityListing',
                '/api/v2/stations'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\StationEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\StationEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getStationsSettings
     *
     * Get an organization's StationSettings
     *
     * @return \PureCloudSDK\StationSettings
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getStationsSettings()
    {
        list($response) = $this->getStationsSettingsWithHttpInfo();
        return $response;
    }

    /**
     * Operation getStationsSettingsWithHttpInfo
     *
     * Get an organization's StationSettings
     *
     * @return Array of \PureCloudSDK\StationSettings, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getStationsSettingsWithHttpInfo()
    {
        // parse inputs
        $resourcePath = "/api/v2/stations/settings";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\StationSettings',
                '/api/v2/stations/settings'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\StationSettings', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\StationSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation patchStationsSettings
     *
     * Patch an organization's StationSettings
     *
     * @param \PureCloudSDK\StationSettings $body Station settings (required)
     * @return \PureCloudSDK\StationSettings
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchStationsSettings($body)
    {
        list($response) = $this->patchStationsSettingsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation patchStationsSettingsWithHttpInfo
     *
     * Patch an organization's StationSettings
     *
     * @param \PureCloudSDK\StationSettings $body Station settings (required)
     * @return Array of \PureCloudSDK\StationSettings, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function patchStationsSettingsWithHttpInfo($body)
    {
        // verify the required parameter 'body' is set
        if ($body === null) {
            throw new \InvalidArgumentException('Missing the required parameter $body when calling patchStationsSettings');
        }
        // parse inputs
        $resourcePath = "/api/v2/stations/settings";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PATCH',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\StationSettings',
                '/api/v2/stations/settings'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\StationSettings', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\StationSettings', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
