<?php
/**
 * Campaign
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Campaign Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Campaign implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Campaign';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'version' => 'int',
        'contactList' => '\PureCloudSDK\UriReference',
        'queue' => '\PureCloudSDK\UriReference',
        'dialingMode' => 'string',
        'script' => '\PureCloudSDK\UriReference',
        'edgeGroup' => '\PureCloudSDK\UriReference',
        'site' => '\PureCloudSDK\UriReference',
        'campaignStatus' => 'string',
        'phoneColumns' => '\PureCloudSDK\PhoneColumn[]',
        'abandonRate' => 'double',
        'dncLists' => '\PureCloudSDK\UriReference[]',
        'callableTimeSet' => '\PureCloudSDK\UriReference',
        'callAnalysisResponseSet' => '\PureCloudSDK\UriReference',
        'errors' => '\PureCloudSDK\RestErrorDetail[]',
        'callerName' => 'string',
        'callerAddress' => 'string',
        'outboundLineCount' => 'int',
        'ruleSets' => '\PureCloudSDK\UriReference[]',
        'skipPreviewDisabled' => 'bool',
        'previewTimeOutSeconds' => 'int',
        'alwaysRunning' => 'bool',
        'contactSort' => '\PureCloudSDK\ContactSort',
        'contactSorts' => '\PureCloudSDK\ContactSort[]',
        'noAnswerTimeout' => 'int',
        'callAnalysisLanguage' => 'string',
        'priority' => 'int',
        'contactListFilters' => '\PureCloudSDK\UriReference[]',
        'division' => '\PureCloudSDK\UriReference',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'version' => 'version',
        'contactList' => 'contactList',
        'queue' => 'queue',
        'dialingMode' => 'dialingMode',
        'script' => 'script',
        'edgeGroup' => 'edgeGroup',
        'site' => 'site',
        'campaignStatus' => 'campaignStatus',
        'phoneColumns' => 'phoneColumns',
        'abandonRate' => 'abandonRate',
        'dncLists' => 'dncLists',
        'callableTimeSet' => 'callableTimeSet',
        'callAnalysisResponseSet' => 'callAnalysisResponseSet',
        'errors' => 'errors',
        'callerName' => 'callerName',
        'callerAddress' => 'callerAddress',
        'outboundLineCount' => 'outboundLineCount',
        'ruleSets' => 'ruleSets',
        'skipPreviewDisabled' => 'skipPreviewDisabled',
        'previewTimeOutSeconds' => 'previewTimeOutSeconds',
        'alwaysRunning' => 'alwaysRunning',
        'contactSort' => 'contactSort',
        'contactSorts' => 'contactSorts',
        'noAnswerTimeout' => 'noAnswerTimeout',
        'callAnalysisLanguage' => 'callAnalysisLanguage',
        'priority' => 'priority',
        'contactListFilters' => 'contactListFilters',
        'division' => 'division',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'version' => 'setVersion',
        'contactList' => 'setContactList',
        'queue' => 'setQueue',
        'dialingMode' => 'setDialingMode',
        'script' => 'setScript',
        'edgeGroup' => 'setEdgeGroup',
        'site' => 'setSite',
        'campaignStatus' => 'setCampaignStatus',
        'phoneColumns' => 'setPhoneColumns',
        'abandonRate' => 'setAbandonRate',
        'dncLists' => 'setDncLists',
        'callableTimeSet' => 'setCallableTimeSet',
        'callAnalysisResponseSet' => 'setCallAnalysisResponseSet',
        'errors' => 'setErrors',
        'callerName' => 'setCallerName',
        'callerAddress' => 'setCallerAddress',
        'outboundLineCount' => 'setOutboundLineCount',
        'ruleSets' => 'setRuleSets',
        'skipPreviewDisabled' => 'setSkipPreviewDisabled',
        'previewTimeOutSeconds' => 'setPreviewTimeOutSeconds',
        'alwaysRunning' => 'setAlwaysRunning',
        'contactSort' => 'setContactSort',
        'contactSorts' => 'setContactSorts',
        'noAnswerTimeout' => 'setNoAnswerTimeout',
        'callAnalysisLanguage' => 'setCallAnalysisLanguage',
        'priority' => 'setPriority',
        'contactListFilters' => 'setContactListFilters',
        'division' => 'setDivision',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'version' => 'getVersion',
        'contactList' => 'getContactList',
        'queue' => 'getQueue',
        'dialingMode' => 'getDialingMode',
        'script' => 'getScript',
        'edgeGroup' => 'getEdgeGroup',
        'site' => 'getSite',
        'campaignStatus' => 'getCampaignStatus',
        'phoneColumns' => 'getPhoneColumns',
        'abandonRate' => 'getAbandonRate',
        'dncLists' => 'getDncLists',
        'callableTimeSet' => 'getCallableTimeSet',
        'callAnalysisResponseSet' => 'getCallAnalysisResponseSet',
        'errors' => 'getErrors',
        'callerName' => 'getCallerName',
        'callerAddress' => 'getCallerAddress',
        'outboundLineCount' => 'getOutboundLineCount',
        'ruleSets' => 'getRuleSets',
        'skipPreviewDisabled' => 'getSkipPreviewDisabled',
        'previewTimeOutSeconds' => 'getPreviewTimeOutSeconds',
        'alwaysRunning' => 'getAlwaysRunning',
        'contactSort' => 'getContactSort',
        'contactSorts' => 'getContactSorts',
        'noAnswerTimeout' => 'getNoAnswerTimeout',
        'callAnalysisLanguage' => 'getCallAnalysisLanguage',
        'priority' => 'getPriority',
        'contactListFilters' => 'getContactListFilters',
        'division' => 'getDivision',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DIALING_MODE_AGENTLESS = 'agentless';
    const DIALING_MODE_PREVIEW = 'preview';
    const DIALING_MODE_POWER = 'power';
    const DIALING_MODE_PREDICTIVE = 'predictive';
    const DIALING_MODE_PROGRESSIVE = 'progressive';
    const CAMPAIGN_STATUS_ON = 'on';
    const CAMPAIGN_STATUS_STOPPING = 'stopping';
    const CAMPAIGN_STATUS_OFF = 'off';
    const CAMPAIGN_STATUS_COMPLETE = 'complete';
    const CAMPAIGN_STATUS_INVALID = 'invalid';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDialingModeAllowableValues()
    {
        return [
            self::DIALING_MODE_AGENTLESS,
            self::DIALING_MODE_PREVIEW,
            self::DIALING_MODE_POWER,
            self::DIALING_MODE_PREDICTIVE,
            self::DIALING_MODE_PROGRESSIVE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCampaignStatusAllowableValues()
    {
        return [
            self::CAMPAIGN_STATUS_ON,
            self::CAMPAIGN_STATUS_STOPPING,
            self::CAMPAIGN_STATUS_OFF,
            self::CAMPAIGN_STATUS_COMPLETE,
            self::CAMPAIGN_STATUS_INVALID,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['contactList'] = isset($data['contactList']) ? $data['contactList'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['dialingMode'] = isset($data['dialingMode']) ? $data['dialingMode'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['edgeGroup'] = isset($data['edgeGroup']) ? $data['edgeGroup'] : null;
        $this->container['site'] = isset($data['site']) ? $data['site'] : null;
        $this->container['campaignStatus'] = isset($data['campaignStatus']) ? $data['campaignStatus'] : null;
        $this->container['phoneColumns'] = isset($data['phoneColumns']) ? $data['phoneColumns'] : null;
        $this->container['abandonRate'] = isset($data['abandonRate']) ? $data['abandonRate'] : null;
        $this->container['dncLists'] = isset($data['dncLists']) ? $data['dncLists'] : null;
        $this->container['callableTimeSet'] = isset($data['callableTimeSet']) ? $data['callableTimeSet'] : null;
        $this->container['callAnalysisResponseSet'] = isset($data['callAnalysisResponseSet']) ? $data['callAnalysisResponseSet'] : null;
        $this->container['errors'] = isset($data['errors']) ? $data['errors'] : null;
        $this->container['callerName'] = isset($data['callerName']) ? $data['callerName'] : null;
        $this->container['callerAddress'] = isset($data['callerAddress']) ? $data['callerAddress'] : null;
        $this->container['outboundLineCount'] = isset($data['outboundLineCount']) ? $data['outboundLineCount'] : null;
        $this->container['ruleSets'] = isset($data['ruleSets']) ? $data['ruleSets'] : null;
        $this->container['skipPreviewDisabled'] = isset($data['skipPreviewDisabled']) ? $data['skipPreviewDisabled'] : null;
        $this->container['previewTimeOutSeconds'] = isset($data['previewTimeOutSeconds']) ? $data['previewTimeOutSeconds'] : null;
        $this->container['alwaysRunning'] = isset($data['alwaysRunning']) ? $data['alwaysRunning'] : null;
        $this->container['contactSort'] = isset($data['contactSort']) ? $data['contactSort'] : null;
        $this->container['contactSorts'] = isset($data['contactSorts']) ? $data['contactSorts'] : null;
        $this->container['noAnswerTimeout'] = isset($data['noAnswerTimeout']) ? $data['noAnswerTimeout'] : null;
        $this->container['callAnalysisLanguage'] = isset($data['callAnalysisLanguage']) ? $data['callAnalysisLanguage'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['contactListFilters'] = isset($data['contactListFilters']) ? $data['contactListFilters'] : null;
        $this->container['division'] = isset($data['division']) ? $data['division'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['contactList'] === null) {
            $invalid_properties[] = "'contactList' can't be null";
        }
        if ($this->container['dialingMode'] === null) {
            $invalid_properties[] = "'dialingMode' can't be null";
        }
        $allowed_values = array("agentless", "preview", "power", "predictive", "progressive");
        if (!in_array($this->container['dialingMode'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dialingMode', must be one of #{allowed_values}.";
        }

        $allowed_values = array("on", "stopping", "off", "complete", "invalid");
        if (!in_array($this->container['campaignStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'campaignStatus', must be one of #{allowed_values}.";
        }

        if ($this->container['phoneColumns'] === null) {
            $invalid_properties[] = "'phoneColumns' can't be null";
        }
        if ($this->container['callerName'] === null) {
            $invalid_properties[] = "'callerName' can't be null";
        }
        if ($this->container['callerAddress'] === null) {
            $invalid_properties[] = "'callerAddress' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['contactList'] === null) {
            return false;
        }
        if ($this->container['dialingMode'] === null) {
            return false;
        }
        $allowed_values = array("agentless", "preview", "power", "predictive", "progressive");
        if (!in_array($this->container['dialingMode'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("on", "stopping", "off", "complete", "invalid");
        if (!in_array($this->container['campaignStatus'], $allowed_values)) {
            return false;
        }
        if ($this->container['phoneColumns'] === null) {
            return false;
        }
        if ($this->container['callerName'] === null) {
            return false;
        }
        if ($this->container['callerAddress'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the Campaign.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required for updates, must match the version number of the most recent update
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets contactList
     * @return \PureCloudSDK\UriReference
     */
    public function getContactList()
    {
        return $this->container['contactList'];
    }

    /**
     * Sets contactList
     * @param \PureCloudSDK\UriReference $contactList The ContactList for this Campaign to dial.
     * @return $this
     */
    public function setContactList($contactList)
    {
        $this->container['contactList'] = $contactList;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue The Queue for this Campaign to route calls to. Required for all dialing modes except agentless.
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets dialingMode
     * @return string
     */
    public function getDialingMode()
    {
        return $this->container['dialingMode'];
    }

    /**
     * Sets dialingMode
     * @param string $dialingMode The strategy this Campaign will use for dialing.
     * @return $this
     */
    public function setDialingMode($dialingMode)
    {
        $allowed_values = array('agentless', 'preview', 'power', 'predictive', 'progressive');
        if (!in_array($dialingMode, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dialingMode', must be one of 'agentless', 'preview', 'power', 'predictive', 'progressive'");
        }
        $this->container['dialingMode'] = $dialingMode;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\UriReference
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\UriReference $script The Script to be displayed to agents that are handling outbound calls. Required for all dialing modes except agentless.
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets edgeGroup
     * @return \PureCloudSDK\UriReference
     */
    public function getEdgeGroup()
    {
        return $this->container['edgeGroup'];
    }

    /**
     * Sets edgeGroup
     * @param \PureCloudSDK\UriReference $edgeGroup The EdgeGroup that will place the calls. Required for all dialing modes except preview.
     * @return $this
     */
    public function setEdgeGroup($edgeGroup)
    {
        $this->container['edgeGroup'] = $edgeGroup;

        return $this;
    }

    /**
     * Gets site
     * @return \PureCloudSDK\UriReference
     */
    public function getSite()
    {
        return $this->container['site'];
    }

    /**
     * Sets site
     * @param \PureCloudSDK\UriReference $site The identifier of the site to be used for dialing; can be set in place of an edge group.
     * @return $this
     */
    public function setSite($site)
    {
        $this->container['site'] = $site;

        return $this;
    }

    /**
     * Gets campaignStatus
     * @return string
     */
    public function getCampaignStatus()
    {
        return $this->container['campaignStatus'];
    }

    /**
     * Sets campaignStatus
     * @param string $campaignStatus The current status of the Campaign. A Campaign may be turned 'on' or 'off'. Required for updates.
     * @return $this
     */
    public function setCampaignStatus($campaignStatus)
    {
        $allowed_values = array('on', 'stopping', 'off', 'complete', 'invalid');
        if (!in_array($campaignStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'campaignStatus', must be one of 'on', 'stopping', 'off', 'complete', 'invalid'");
        }
        $this->container['campaignStatus'] = $campaignStatus;

        return $this;
    }

    /**
     * Gets phoneColumns
     * @return \PureCloudSDK\PhoneColumn[]
     */
    public function getPhoneColumns()
    {
        return $this->container['phoneColumns'];
    }

    /**
     * Sets phoneColumns
     * @param \PureCloudSDK\PhoneColumn[] $phoneColumns The ContactPhoneNumberColumns on the ContactList that this Campaign should dial.
     * @return $this
     */
    public function setPhoneColumns($phoneColumns)
    {
        $this->container['phoneColumns'] = $phoneColumns;

        return $this;
    }

    /**
     * Gets abandonRate
     * @return double
     */
    public function getAbandonRate()
    {
        return $this->container['abandonRate'];
    }

    /**
     * Sets abandonRate
     * @param double $abandonRate The targeted abandon rate percentage. Required for progressive, power, and predictive campaigns.
     * @return $this
     */
    public function setAbandonRate($abandonRate)
    {
        $this->container['abandonRate'] = $abandonRate;

        return $this;
    }

    /**
     * Gets dncLists
     * @return \PureCloudSDK\UriReference[]
     */
    public function getDncLists()
    {
        return $this->container['dncLists'];
    }

    /**
     * Sets dncLists
     * @param \PureCloudSDK\UriReference[] $dncLists DncLists for this Campaign to check before placing a call.
     * @return $this
     */
    public function setDncLists($dncLists)
    {
        $this->container['dncLists'] = $dncLists;

        return $this;
    }

    /**
     * Gets callableTimeSet
     * @return \PureCloudSDK\UriReference
     */
    public function getCallableTimeSet()
    {
        return $this->container['callableTimeSet'];
    }

    /**
     * Sets callableTimeSet
     * @param \PureCloudSDK\UriReference $callableTimeSet The callable time set for this campaign to check before placing a call.
     * @return $this
     */
    public function setCallableTimeSet($callableTimeSet)
    {
        $this->container['callableTimeSet'] = $callableTimeSet;

        return $this;
    }

    /**
     * Gets callAnalysisResponseSet
     * @return \PureCloudSDK\UriReference
     */
    public function getCallAnalysisResponseSet()
    {
        return $this->container['callAnalysisResponseSet'];
    }

    /**
     * Sets callAnalysisResponseSet
     * @param \PureCloudSDK\UriReference $callAnalysisResponseSet The call analysis response set to handle call analysis results from the edge. Required for all dialing modes except preview.
     * @return $this
     */
    public function setCallAnalysisResponseSet($callAnalysisResponseSet)
    {
        $this->container['callAnalysisResponseSet'] = $callAnalysisResponseSet;

        return $this;
    }

    /**
     * Gets errors
     * @return \PureCloudSDK\RestErrorDetail[]
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     * @param \PureCloudSDK\RestErrorDetail[] $errors A list of current error conditions associated with the campaign.
     * @return $this
     */
    public function setErrors($errors)
    {
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets callerName
     * @return string
     */
    public function getCallerName()
    {
        return $this->container['callerName'];
    }

    /**
     * Sets callerName
     * @param string $callerName The caller id name to be displayed on the outbound call.
     * @return $this
     */
    public function setCallerName($callerName)
    {
        $this->container['callerName'] = $callerName;

        return $this;
    }

    /**
     * Gets callerAddress
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['callerAddress'];
    }

    /**
     * Sets callerAddress
     * @param string $callerAddress The caller id phone number to be displayed on the outbound call.
     * @return $this
     */
    public function setCallerAddress($callerAddress)
    {
        $this->container['callerAddress'] = $callerAddress;

        return $this;
    }

    /**
     * Gets outboundLineCount
     * @return int
     */
    public function getOutboundLineCount()
    {
        return $this->container['outboundLineCount'];
    }

    /**
     * Sets outboundLineCount
     * @param int $outboundLineCount The number of outbound lines to be concurrently dialed. Only applicable to non-preview campaigns; only required for agentless.
     * @return $this
     */
    public function setOutboundLineCount($outboundLineCount)
    {
        $this->container['outboundLineCount'] = $outboundLineCount;

        return $this;
    }

    /**
     * Gets ruleSets
     * @return \PureCloudSDK\UriReference[]
     */
    public function getRuleSets()
    {
        return $this->container['ruleSets'];
    }

    /**
     * Sets ruleSets
     * @param \PureCloudSDK\UriReference[] $ruleSets Rule sets to be applied while this campaign is dialing.
     * @return $this
     */
    public function setRuleSets($ruleSets)
    {
        $this->container['ruleSets'] = $ruleSets;

        return $this;
    }

    /**
     * Gets skipPreviewDisabled
     * @return bool
     */
    public function getSkipPreviewDisabled()
    {
        return $this->container['skipPreviewDisabled'];
    }

    /**
     * Sets skipPreviewDisabled
     * @param bool $skipPreviewDisabled Whether or not agents can skip previews without placing a call. Only applicable for preview campaigns.
     * @return $this
     */
    public function setSkipPreviewDisabled($skipPreviewDisabled)
    {
        $this->container['skipPreviewDisabled'] = $skipPreviewDisabled;

        return $this;
    }

    /**
     * Gets previewTimeOutSeconds
     * @return int
     */
    public function getPreviewTimeOutSeconds()
    {
        return $this->container['previewTimeOutSeconds'];
    }

    /**
     * Sets previewTimeOutSeconds
     * @param int $previewTimeOutSeconds The number of seconds before a call will be automatically placed on a preview. A value of 0 indicates no automatic placement of calls. Only applicable to preview campaigns.
     * @return $this
     */
    public function setPreviewTimeOutSeconds($previewTimeOutSeconds)
    {
        $this->container['previewTimeOutSeconds'] = $previewTimeOutSeconds;

        return $this;
    }

    /**
     * Gets alwaysRunning
     * @return bool
     */
    public function getAlwaysRunning()
    {
        return $this->container['alwaysRunning'];
    }

    /**
     * Sets alwaysRunning
     * @param bool $alwaysRunning Indicates (when true) that the campaign will remain on after contacts are depleted, allowing additional contacts to be appended/added to the contact list and processed by the still-running campaign. The campaign can still be turned off manually.
     * @return $this
     */
    public function setAlwaysRunning($alwaysRunning)
    {
        $this->container['alwaysRunning'] = $alwaysRunning;

        return $this;
    }

    /**
     * Gets contactSort
     * @return \PureCloudSDK\ContactSort
     */
    public function getContactSort()
    {
        return $this->container['contactSort'];
    }

    /**
     * Sets contactSort
     * @param \PureCloudSDK\ContactSort $contactSort The order in which to sort contacts for dialing, based on a column.
     * @return $this
     */
    public function setContactSort($contactSort)
    {
        $this->container['contactSort'] = $contactSort;

        return $this;
    }

    /**
     * Gets contactSorts
     * @return \PureCloudSDK\ContactSort[]
     */
    public function getContactSorts()
    {
        return $this->container['contactSorts'];
    }

    /**
     * Sets contactSorts
     * @param \PureCloudSDK\ContactSort[] $contactSorts The order in which to sort contacts for dialing, based on up to four columns.
     * @return $this
     */
    public function setContactSorts($contactSorts)
    {
        $this->container['contactSorts'] = $contactSorts;

        return $this;
    }

    /**
     * Gets noAnswerTimeout
     * @return int
     */
    public function getNoAnswerTimeout()
    {
        return $this->container['noAnswerTimeout'];
    }

    /**
     * Sets noAnswerTimeout
     * @param int $noAnswerTimeout How long to wait before dispositioning a call as 'no-answer'. Default 30 seconds. Only applicable to non-preview campaigns.
     * @return $this
     */
    public function setNoAnswerTimeout($noAnswerTimeout)
    {
        $this->container['noAnswerTimeout'] = $noAnswerTimeout;

        return $this;
    }

    /**
     * Gets callAnalysisLanguage
     * @return string
     */
    public function getCallAnalysisLanguage()
    {
        return $this->container['callAnalysisLanguage'];
    }

    /**
     * Sets callAnalysisLanguage
     * @param string $callAnalysisLanguage The language the edge will use to analyze the call.
     * @return $this
     */
    public function setCallAnalysisLanguage($callAnalysisLanguage)
    {
        $this->container['callAnalysisLanguage'] = $callAnalysisLanguage;

        return $this;
    }

    /**
     * Gets priority
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param int $priority The priority of this campaign relative to other campaigns that are running on the same queue. 5 is the highest priority, 1 the lowest.
     * @return $this
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets contactListFilters
     * @return \PureCloudSDK\UriReference[]
     */
    public function getContactListFilters()
    {
        return $this->container['contactListFilters'];
    }

    /**
     * Sets contactListFilters
     * @param \PureCloudSDK\UriReference[] $contactListFilters Filter to apply to the contact list before dialing. Currently a campaign can only have one filter applied.
     * @return $this
     */
    public function setContactListFilters($contactListFilters)
    {
        $this->container['contactListFilters'] = $contactListFilters;

        return $this;
    }

    /**
     * Gets division
     * @return \PureCloudSDK\UriReference
     */
    public function getDivision()
    {
        return $this->container['division'];
    }

    /**
     * Sets division
     * @param \PureCloudSDK\UriReference $division The division this campaign belongs to.
     * @return $this
     */
    public function setDivision($division)
    {
        $this->container['division'] = $division;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


