<?php
/**
 * ContactListFilterRange
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ContactListFilterRange Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ContactListFilterRange implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ContactListFilterRange';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'min' => 'string',
        'max' => 'string',
        'minInclusive' => 'bool',
        'maxInclusive' => 'bool',
        'inSet' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'min' => 'min',
        'max' => 'max',
        'minInclusive' => 'minInclusive',
        'maxInclusive' => 'maxInclusive',
        'inSet' => 'inSet'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'min' => 'setMin',
        'max' => 'setMax',
        'minInclusive' => 'setMinInclusive',
        'maxInclusive' => 'setMaxInclusive',
        'inSet' => 'setInSet'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'min' => 'getMin',
        'max' => 'getMax',
        'minInclusive' => 'getMinInclusive',
        'maxInclusive' => 'getMaxInclusive',
        'inSet' => 'getInSet'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['min'] = isset($data['min']) ? $data['min'] : null;
        $this->container['max'] = isset($data['max']) ? $data['max'] : null;
        $this->container['minInclusive'] = isset($data['minInclusive']) ? $data['minInclusive'] : null;
        $this->container['maxInclusive'] = isset($data['maxInclusive']) ? $data['maxInclusive'] : null;
        $this->container['inSet'] = isset($data['inSet']) ? $data['inSet'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets min
     * @return string
     */
    public function getMin()
    {
        return $this->container['min'];
    }

    /**
     * Sets min
     * @param string $min The minimum value of the range. Required for the operator BETWEEN.
     * @return $this
     */
    public function setMin($min)
    {
        $this->container['min'] = $min;

        return $this;
    }

    /**
     * Gets max
     * @return string
     */
    public function getMax()
    {
        return $this->container['max'];
    }

    /**
     * Sets max
     * @param string $max The maximum value of the range. Required for the operator BETWEEN.
     * @return $this
     */
    public function setMax($max)
    {
        $this->container['max'] = $max;

        return $this;
    }

    /**
     * Gets minInclusive
     * @return bool
     */
    public function getMinInclusive()
    {
        return $this->container['minInclusive'];
    }

    /**
     * Sets minInclusive
     * @param bool $minInclusive Whether or not to include the minimum in the range.
     * @return $this
     */
    public function setMinInclusive($minInclusive)
    {
        $this->container['minInclusive'] = $minInclusive;

        return $this;
    }

    /**
     * Gets maxInclusive
     * @return bool
     */
    public function getMaxInclusive()
    {
        return $this->container['maxInclusive'];
    }

    /**
     * Sets maxInclusive
     * @param bool $maxInclusive Whether or not to include the maximum in the range.
     * @return $this
     */
    public function setMaxInclusive($maxInclusive)
    {
        $this->container['maxInclusive'] = $maxInclusive;

        return $this;
    }

    /**
     * Gets inSet
     * @return string[]
     */
    public function getInSet()
    {
        return $this->container['inSet'];
    }

    /**
     * Sets inSet
     * @param string[] $inSet A set of values that the contact data should be in. Required for the IN operator.
     * @return $this
     */
    public function setInSet($inSet)
    {
        $this->container['inSet'] = $inSet;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


