<?php
/**
 * CreateOutboundMessagingConversationRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CreateOutboundMessagingConversationRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateOutboundMessagingConversationRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateOutboundMessagingConversationRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'queueId' => 'string',
        'toAddress' => 'string',
        'toAddressMessengerType' => 'string',
        'useExistingConversation' => 'bool',
        'externalContactId' => 'string',
        'externalOrganizationId' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'queueId' => 'queueId',
        'toAddress' => 'toAddress',
        'toAddressMessengerType' => 'toAddressMessengerType',
        'useExistingConversation' => 'useExistingConversation',
        'externalContactId' => 'externalContactId',
        'externalOrganizationId' => 'externalOrganizationId'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'queueId' => 'setQueueId',
        'toAddress' => 'setToAddress',
        'toAddressMessengerType' => 'setToAddressMessengerType',
        'useExistingConversation' => 'setUseExistingConversation',
        'externalContactId' => 'setExternalContactId',
        'externalOrganizationId' => 'setExternalOrganizationId'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'queueId' => 'getQueueId',
        'toAddress' => 'getToAddress',
        'toAddressMessengerType' => 'getToAddressMessengerType',
        'useExistingConversation' => 'getUseExistingConversation',
        'externalContactId' => 'getExternalContactId',
        'externalOrganizationId' => 'getExternalOrganizationId'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TO_ADDRESS_MESSENGER_TYPE_SMS = 'sms';
    const TO_ADDRESS_MESSENGER_TYPE_FACEBOOK = 'facebook';
    const TO_ADDRESS_MESSENGER_TYPE_TWITTER = 'twitter';
    const TO_ADDRESS_MESSENGER_TYPE_LINE = 'line';
    const TO_ADDRESS_MESSENGER_TYPE_WHATSAPP = 'whatsapp';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getToAddressMessengerTypeAllowableValues()
    {
        return [
            self::TO_ADDRESS_MESSENGER_TYPE_SMS,
            self::TO_ADDRESS_MESSENGER_TYPE_FACEBOOK,
            self::TO_ADDRESS_MESSENGER_TYPE_TWITTER,
            self::TO_ADDRESS_MESSENGER_TYPE_LINE,
            self::TO_ADDRESS_MESSENGER_TYPE_WHATSAPP,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['queueId'] = isset($data['queueId']) ? $data['queueId'] : null;
        $this->container['toAddress'] = isset($data['toAddress']) ? $data['toAddress'] : null;
        $this->container['toAddressMessengerType'] = isset($data['toAddressMessengerType']) ? $data['toAddressMessengerType'] : null;
        $this->container['useExistingConversation'] = isset($data['useExistingConversation']) ? $data['useExistingConversation'] : null;
        $this->container['externalContactId'] = isset($data['externalContactId']) ? $data['externalContactId'] : null;
        $this->container['externalOrganizationId'] = isset($data['externalOrganizationId']) ? $data['externalOrganizationId'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['queueId'] === null) {
            $invalid_properties[] = "'queueId' can't be null";
        }
        if ($this->container['toAddress'] === null) {
            $invalid_properties[] = "'toAddress' can't be null";
        }
        if ($this->container['toAddressMessengerType'] === null) {
            $invalid_properties[] = "'toAddressMessengerType' can't be null";
        }
        $allowed_values = array("sms", "facebook", "twitter", "line", "whatsapp");
        if (!in_array($this->container['toAddressMessengerType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'toAddressMessengerType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['queueId'] === null) {
            return false;
        }
        if ($this->container['toAddress'] === null) {
            return false;
        }
        if ($this->container['toAddressMessengerType'] === null) {
            return false;
        }
        $allowed_values = array("sms", "facebook", "twitter", "line", "whatsapp");
        if (!in_array($this->container['toAddressMessengerType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets queueId
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queueId'];
    }

    /**
     * Sets queueId
     * @param string $queueId The ID of the queue to be associated with the message. This will determine the fromAddress of the message.
     * @return $this
     */
    public function setQueueId($queueId)
    {
        $this->container['queueId'] = $queueId;

        return $this;
    }

    /**
     * Gets toAddress
     * @return string
     */
    public function getToAddress()
    {
        return $this->container['toAddress'];
    }

    /**
     * Sets toAddress
     * @param string $toAddress The messaging address of the recipient of the message. For an SMS messenger type, the phone number address must be in E.164 format. E.g. +13175555555 or +34234234234
     * @return $this
     */
    public function setToAddress($toAddress)
    {
        $this->container['toAddress'] = $toAddress;

        return $this;
    }

    /**
     * Gets toAddressMessengerType
     * @return string
     */
    public function getToAddressMessengerType()
    {
        return $this->container['toAddressMessengerType'];
    }

    /**
     * Sets toAddressMessengerType
     * @param string $toAddressMessengerType The messaging address messenger type.
     * @return $this
     */
    public function setToAddressMessengerType($toAddressMessengerType)
    {
        $allowed_values = array('sms', 'facebook', 'twitter', 'line', 'whatsapp');
        if (!in_array($toAddressMessengerType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'toAddressMessengerType', must be one of 'sms', 'facebook', 'twitter', 'line', 'whatsapp'");
        }
        $this->container['toAddressMessengerType'] = $toAddressMessengerType;

        return $this;
    }

    /**
     * Gets useExistingConversation
     * @return bool
     */
    public function getUseExistingConversation()
    {
        return $this->container['useExistingConversation'];
    }

    /**
     * Sets useExistingConversation
     * @param bool $useExistingConversation An override to use an existing conversation.  If set to true, an existing conversation will be used if there is one within the conversation window.  If set to false, create request fails if there is a conversation within the conversation window.
     * @return $this
     */
    public function setUseExistingConversation($useExistingConversation)
    {
        $this->container['useExistingConversation'] = $useExistingConversation;

        return $this;
    }

    /**
     * Gets externalContactId
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['externalContactId'];
    }

    /**
     * Sets externalContactId
     * @param string $externalContactId The external contact Id of the recipient of the message.
     * @return $this
     */
    public function setExternalContactId($externalContactId)
    {
        $this->container['externalContactId'] = $externalContactId;

        return $this;
    }

    /**
     * Gets externalOrganizationId
     * @return string
     */
    public function getExternalOrganizationId()
    {
        return $this->container['externalOrganizationId'];
    }

    /**
     * Sets externalOrganizationId
     * @param string $externalOrganizationId The external organization Id of the recipient of the message.
     * @return $this
     */
    public function setExternalOrganizationId($externalOrganizationId)
    {
        $this->container['externalOrganizationId'] = $externalOrganizationId;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


