<?php
/**
 * CreateWebChatMessageRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CreateWebChatMessageRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateWebChatMessageRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateWebChatMessageRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'body' => 'string',
        'bodyType' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'body' => 'body',
        'bodyType' => 'bodyType'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'body' => 'setBody',
        'bodyType' => 'setBodyType'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'body' => 'getBody',
        'bodyType' => 'getBodyType'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const BODY_TYPE_STANDARD = 'standard';
    const BODY_TYPE_NOTICE = 'notice';
    const BODY_TYPE_MEMBER_JOIN = 'member-join';
    const BODY_TYPE_MEMBER_LEAVE = 'member-leave';
    const BODY_TYPE_MEDIA_REQUEST = 'media-request';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getBodyTypeAllowableValues()
    {
        return [
            self::BODY_TYPE_STANDARD,
            self::BODY_TYPE_NOTICE,
            self::BODY_TYPE_MEMBER_JOIN,
            self::BODY_TYPE_MEMBER_LEAVE,
            self::BODY_TYPE_MEDIA_REQUEST,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['body'] = isset($data['body']) ? $data['body'] : null;
        $this->container['bodyType'] = isset($data['bodyType']) ? $data['bodyType'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['body'] === null) {
            $invalid_properties[] = "'body' can't be null";
        }
        $allowed_values = array("standard", "notice", "member-join", "member-leave", "media-request");
        if (!in_array($this->container['bodyType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'bodyType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['body'] === null) {
            return false;
        }
        $allowed_values = array("standard", "notice", "member-join", "member-leave", "media-request");
        if (!in_array($this->container['bodyType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets body
     * @return string
     */
    public function getBody()
    {
        return $this->container['body'];
    }

    /**
     * Sets body
     * @param string $body The message body. Note that message bodies are limited to 4,000 characters.
     * @return $this
     */
    public function setBody($body)
    {
        $this->container['body'] = $body;

        return $this;
    }

    /**
     * Gets bodyType
     * @return string
     */
    public function getBodyType()
    {
        return $this->container['bodyType'];
    }

    /**
     * Sets bodyType
     * @param string $bodyType The purpose of the message within the conversation, such as a standard text entry versus a greeting.
     * @return $this
     */
    public function setBodyType($bodyType)
    {
        $allowed_values = array('standard', 'notice', 'member-join', 'member-leave', 'media-request');
        if (!in_array($bodyType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'bodyType', must be one of 'standard', 'notice', 'member-join', 'member-leave', 'media-request'");
        }
        $this->container['bodyType'] = $bodyType;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


