<?php
/**
 * DialerAction
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DialerAction Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DialerAction implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DialerAction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'type' => 'string',
        'actionTypeName' => 'string',
        'updateOption' => 'string',
        'properties' => 'map[string,string]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'type' => 'type',
        'actionTypeName' => 'actionTypeName',
        'updateOption' => 'updateOption',
        'properties' => 'properties'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'type' => 'setType',
        'actionTypeName' => 'setActionTypeName',
        'updateOption' => 'setUpdateOption',
        'properties' => 'setProperties'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'type' => 'getType',
        'actionTypeName' => 'getActionTypeName',
        'updateOption' => 'getUpdateOption',
        'properties' => 'getProperties'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TYPE_ACTION = 'Action';
    const TYPE_MODIFY_CONTACT_ATTRIBUTE = 'modifyContactAttribute';
    const ACTION_TYPE_NAME_DO_NOT_DIAL = 'DO_NOT_DIAL';
    const ACTION_TYPE_NAME_MODIFY_CONTACT_ATTRIBUTE = 'MODIFY_CONTACT_ATTRIBUTE';
    const ACTION_TYPE_NAME_SWITCH_TO_PREVIEW = 'SWITCH_TO_PREVIEW';
    const ACTION_TYPE_NAME_APPEND_NUMBER_TO_DNC_LIST = 'APPEND_NUMBER_TO_DNC_LIST';
    const ACTION_TYPE_NAME_SCHEDULE_CALLBACK = 'SCHEDULE_CALLBACK';
    const ACTION_TYPE_NAME_CONTACT_UNCALLABLE = 'CONTACT_UNCALLABLE';
    const ACTION_TYPE_NAME_NUMBER_UNCALLABLE = 'NUMBER_UNCALLABLE';
    const ACTION_TYPE_NAME_SET_CALLER_ID = 'SET_CALLER_ID';
    const ACTION_TYPE_NAME_SET_SKILLS = 'SET_SKILLS';
    const UPDATE_OPTION_SET = 'SET';
    const UPDATE_OPTION_INCREMENT = 'INCREMENT';
    const UPDATE_OPTION_DECREMENT = 'DECREMENT';
    const UPDATE_OPTION_CURRENT_TIME = 'CURRENT_TIME';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_ACTION,
            self::TYPE_MODIFY_CONTACT_ATTRIBUTE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionTypeNameAllowableValues()
    {
        return [
            self::ACTION_TYPE_NAME_DO_NOT_DIAL,
            self::ACTION_TYPE_NAME_MODIFY_CONTACT_ATTRIBUTE,
            self::ACTION_TYPE_NAME_SWITCH_TO_PREVIEW,
            self::ACTION_TYPE_NAME_APPEND_NUMBER_TO_DNC_LIST,
            self::ACTION_TYPE_NAME_SCHEDULE_CALLBACK,
            self::ACTION_TYPE_NAME_CONTACT_UNCALLABLE,
            self::ACTION_TYPE_NAME_NUMBER_UNCALLABLE,
            self::ACTION_TYPE_NAME_SET_CALLER_ID,
            self::ACTION_TYPE_NAME_SET_SKILLS,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUpdateOptionAllowableValues()
    {
        return [
            self::UPDATE_OPTION_SET,
            self::UPDATE_OPTION_INCREMENT,
            self::UPDATE_OPTION_DECREMENT,
            self::UPDATE_OPTION_CURRENT_TIME,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['actionTypeName'] = isset($data['actionTypeName']) ? $data['actionTypeName'] : null;
        $this->container['updateOption'] = isset($data['updateOption']) ? $data['updateOption'] : null;
        $this->container['properties'] = isset($data['properties']) ? $data['properties'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['type'] === null) {
            $invalid_properties[] = "'type' can't be null";
        }
        $allowed_values = array("Action", "modifyContactAttribute");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        if ($this->container['actionTypeName'] === null) {
            $invalid_properties[] = "'actionTypeName' can't be null";
        }
        $allowed_values = array("DO_NOT_DIAL", "MODIFY_CONTACT_ATTRIBUTE", "SWITCH_TO_PREVIEW", "APPEND_NUMBER_TO_DNC_LIST", "SCHEDULE_CALLBACK", "CONTACT_UNCALLABLE", "NUMBER_UNCALLABLE", "SET_CALLER_ID", "SET_SKILLS");
        if (!in_array($this->container['actionTypeName'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actionTypeName', must be one of #{allowed_values}.";
        }

        $allowed_values = array("SET", "INCREMENT", "DECREMENT", "CURRENT_TIME");
        if (!in_array($this->container['updateOption'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'updateOption', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['type'] === null) {
            return false;
        }
        $allowed_values = array("Action", "modifyContactAttribute");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        if ($this->container['actionTypeName'] === null) {
            return false;
        }
        $allowed_values = array("DO_NOT_DIAL", "MODIFY_CONTACT_ATTRIBUTE", "SWITCH_TO_PREVIEW", "APPEND_NUMBER_TO_DNC_LIST", "SCHEDULE_CALLBACK", "CONTACT_UNCALLABLE", "NUMBER_UNCALLABLE", "SET_CALLER_ID", "SET_SKILLS");
        if (!in_array($this->container['actionTypeName'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("SET", "INCREMENT", "DECREMENT", "CURRENT_TIME");
        if (!in_array($this->container['updateOption'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type The type of this DialerAction.
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('Action', 'modifyContactAttribute');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'Action', 'modifyContactAttribute'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets actionTypeName
     * @return string
     */
    public function getActionTypeName()
    {
        return $this->container['actionTypeName'];
    }

    /**
     * Sets actionTypeName
     * @param string $actionTypeName Additional type specification for this DialerAction.
     * @return $this
     */
    public function setActionTypeName($actionTypeName)
    {
        $allowed_values = array('DO_NOT_DIAL', 'MODIFY_CONTACT_ATTRIBUTE', 'SWITCH_TO_PREVIEW', 'APPEND_NUMBER_TO_DNC_LIST', 'SCHEDULE_CALLBACK', 'CONTACT_UNCALLABLE', 'NUMBER_UNCALLABLE', 'SET_CALLER_ID', 'SET_SKILLS');
        if (!in_array($actionTypeName, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actionTypeName', must be one of 'DO_NOT_DIAL', 'MODIFY_CONTACT_ATTRIBUTE', 'SWITCH_TO_PREVIEW', 'APPEND_NUMBER_TO_DNC_LIST', 'SCHEDULE_CALLBACK', 'CONTACT_UNCALLABLE', 'NUMBER_UNCALLABLE', 'SET_CALLER_ID', 'SET_SKILLS'");
        }
        $this->container['actionTypeName'] = $actionTypeName;

        return $this;
    }

    /**
     * Gets updateOption
     * @return string
     */
    public function getUpdateOption()
    {
        return $this->container['updateOption'];
    }

    /**
     * Sets updateOption
     * @param string $updateOption Specifies how a contact attribute should be updated. Required for MODIFY_CONTACT_ATTRIBUTE.
     * @return $this
     */
    public function setUpdateOption($updateOption)
    {
        $allowed_values = array('SET', 'INCREMENT', 'DECREMENT', 'CURRENT_TIME');
        if (!in_array($updateOption, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'updateOption', must be one of 'SET', 'INCREMENT', 'DECREMENT', 'CURRENT_TIME'");
        }
        $this->container['updateOption'] = $updateOption;

        return $this;
    }

    /**
     * Gets properties
     * @return map[string,string]
     */
    public function getProperties()
    {
        return $this->container['properties'];
    }

    /**
     * Sets properties
     * @param map[string,string] $properties A map of key-value pairs pertinent to the DialerAction. Different types of DialerActions require different properties. MODIFY_CONTACT_ATTRIBUTE with an updateOption of SET takes a contact column as the key and accepts any value. SCHEDULE_CALLBACK takes a key 'callbackOffset' that specifies how far in the future the callback should be scheduled, in minutes. SET_CALLER_ID takes two keys: 'callerAddress', which should be the caller id phone number, and 'callerName'. For either key, you can also specify a column on the contact to get the value from. To do this, specify 'contact.Column', where 'Column' is the name of the contact column from which to get the value. SET_SKILLS takes a key 'skills' with an array of skill ids wrapped into a string (Example: {'skills': '['skillIdHere']'} ).
     * @return $this
     */
    public function setProperties($properties)
    {
        $this->container['properties'] = $properties;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


