<?php
/**
 * Edge
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Edge Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Edge implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Edge';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'modifiedBy' => 'string',
        'createdBy' => 'string',
        'state' => 'string',
        'modifiedByApp' => 'string',
        'createdByApp' => 'string',
        'interfaces' => '\PureCloudSDK\EdgeInterface[]',
        'make' => 'string',
        'model' => 'string',
        'apiVersion' => 'string',
        'softwareVersion' => 'string',
        'softwareVersionTimestamp' => 'string',
        'softwareVersionPlatform' => 'string',
        'softwareVersionConfiguration' => 'string',
        'fullSoftwareVersion' => 'string',
        'pairingId' => 'string',
        'fingerprint' => 'string',
        'fingerprintHint' => 'string',
        'currentVersion' => 'string',
        'stagedVersion' => 'string',
        'patch' => 'string',
        'statusCode' => 'string',
        'edgeGroup' => '\PureCloudSDK\EdgeGroup',
        'site' => '\PureCloudSDK\Site',
        'softwareStatus' => '\PureCloudSDK\DomainEdgeSoftwareUpdateDto',
        'onlineStatus' => 'string',
        'serialNumber' => 'string',
        'physicalEdge' => 'bool',
        'managed' => 'bool',
        'edgeDeploymentType' => 'string',
        'callDrainingState' => 'string',
        'conversationCount' => 'int',
        'proxy' => 'string',
        'offlineConfigCalled' => 'bool',
        'osName' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'modifiedBy' => 'modifiedBy',
        'createdBy' => 'createdBy',
        'state' => 'state',
        'modifiedByApp' => 'modifiedByApp',
        'createdByApp' => 'createdByApp',
        'interfaces' => 'interfaces',
        'make' => 'make',
        'model' => 'model',
        'apiVersion' => 'apiVersion',
        'softwareVersion' => 'softwareVersion',
        'softwareVersionTimestamp' => 'softwareVersionTimestamp',
        'softwareVersionPlatform' => 'softwareVersionPlatform',
        'softwareVersionConfiguration' => 'softwareVersionConfiguration',
        'fullSoftwareVersion' => 'fullSoftwareVersion',
        'pairingId' => 'pairingId',
        'fingerprint' => 'fingerprint',
        'fingerprintHint' => 'fingerprintHint',
        'currentVersion' => 'currentVersion',
        'stagedVersion' => 'stagedVersion',
        'patch' => 'patch',
        'statusCode' => 'statusCode',
        'edgeGroup' => 'edgeGroup',
        'site' => 'site',
        'softwareStatus' => 'softwareStatus',
        'onlineStatus' => 'onlineStatus',
        'serialNumber' => 'serialNumber',
        'physicalEdge' => 'physicalEdge',
        'managed' => 'managed',
        'edgeDeploymentType' => 'edgeDeploymentType',
        'callDrainingState' => 'callDrainingState',
        'conversationCount' => 'conversationCount',
        'proxy' => 'proxy',
        'offlineConfigCalled' => 'offlineConfigCalled',
        'osName' => 'osName',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'modifiedBy' => 'setModifiedBy',
        'createdBy' => 'setCreatedBy',
        'state' => 'setState',
        'modifiedByApp' => 'setModifiedByApp',
        'createdByApp' => 'setCreatedByApp',
        'interfaces' => 'setInterfaces',
        'make' => 'setMake',
        'model' => 'setModel',
        'apiVersion' => 'setApiVersion',
        'softwareVersion' => 'setSoftwareVersion',
        'softwareVersionTimestamp' => 'setSoftwareVersionTimestamp',
        'softwareVersionPlatform' => 'setSoftwareVersionPlatform',
        'softwareVersionConfiguration' => 'setSoftwareVersionConfiguration',
        'fullSoftwareVersion' => 'setFullSoftwareVersion',
        'pairingId' => 'setPairingId',
        'fingerprint' => 'setFingerprint',
        'fingerprintHint' => 'setFingerprintHint',
        'currentVersion' => 'setCurrentVersion',
        'stagedVersion' => 'setStagedVersion',
        'patch' => 'setPatch',
        'statusCode' => 'setStatusCode',
        'edgeGroup' => 'setEdgeGroup',
        'site' => 'setSite',
        'softwareStatus' => 'setSoftwareStatus',
        'onlineStatus' => 'setOnlineStatus',
        'serialNumber' => 'setSerialNumber',
        'physicalEdge' => 'setPhysicalEdge',
        'managed' => 'setManaged',
        'edgeDeploymentType' => 'setEdgeDeploymentType',
        'callDrainingState' => 'setCallDrainingState',
        'conversationCount' => 'setConversationCount',
        'proxy' => 'setProxy',
        'offlineConfigCalled' => 'setOfflineConfigCalled',
        'osName' => 'setOsName',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'modifiedBy' => 'getModifiedBy',
        'createdBy' => 'getCreatedBy',
        'state' => 'getState',
        'modifiedByApp' => 'getModifiedByApp',
        'createdByApp' => 'getCreatedByApp',
        'interfaces' => 'getInterfaces',
        'make' => 'getMake',
        'model' => 'getModel',
        'apiVersion' => 'getApiVersion',
        'softwareVersion' => 'getSoftwareVersion',
        'softwareVersionTimestamp' => 'getSoftwareVersionTimestamp',
        'softwareVersionPlatform' => 'getSoftwareVersionPlatform',
        'softwareVersionConfiguration' => 'getSoftwareVersionConfiguration',
        'fullSoftwareVersion' => 'getFullSoftwareVersion',
        'pairingId' => 'getPairingId',
        'fingerprint' => 'getFingerprint',
        'fingerprintHint' => 'getFingerprintHint',
        'currentVersion' => 'getCurrentVersion',
        'stagedVersion' => 'getStagedVersion',
        'patch' => 'getPatch',
        'statusCode' => 'getStatusCode',
        'edgeGroup' => 'getEdgeGroup',
        'site' => 'getSite',
        'softwareStatus' => 'getSoftwareStatus',
        'onlineStatus' => 'getOnlineStatus',
        'serialNumber' => 'getSerialNumber',
        'physicalEdge' => 'getPhysicalEdge',
        'managed' => 'getManaged',
        'edgeDeploymentType' => 'getEdgeDeploymentType',
        'callDrainingState' => 'getCallDrainingState',
        'conversationCount' => 'getConversationCount',
        'proxy' => 'getProxy',
        'offlineConfigCalled' => 'getOfflineConfigCalled',
        'osName' => 'getOsName',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    const STATUS_CODE_NEW = 'NEW';
    const STATUS_CODE_AWAITING_CONNECTION = 'AWAITING_CONNECTION';
    const STATUS_CODE_AWAITING_FINGERPRINT = 'AWAITING_FINGERPRINT';
    const STATUS_CODE_AWAITING_FINGERPRINT_VERIFICATION = 'AWAITING_FINGERPRINT_VERIFICATION';
    const STATUS_CODE_FINGERPRINT_VERIFIED = 'FINGERPRINT_VERIFIED';
    const STATUS_CODE_AWAITING_BOOTSTRAP = 'AWAITING_BOOTSTRAP';
    const STATUS_CODE_ACTIVE = 'ACTIVE';
    const STATUS_CODE_INACTIVE = 'INACTIVE';
    const STATUS_CODE_RMA = 'RMA';
    const STATUS_CODE_UNPAIRING = 'UNPAIRING';
    const STATUS_CODE_UNPAIRED = 'UNPAIRED';
    const ONLINE_STATUS_ONLINE = 'ONLINE';
    const ONLINE_STATUS_OFFLINE = 'OFFLINE';
    const EDGE_DEPLOYMENT_TYPE_HARDWARE = 'HARDWARE';
    const EDGE_DEPLOYMENT_TYPE_LDM = 'LDM';
    const EDGE_DEPLOYMENT_TYPE_CDM = 'CDM';
    const EDGE_DEPLOYMENT_TYPE_INVALID = 'INVALID';
    const CALL_DRAINING_STATE_NONE = 'NONE';
    const CALL_DRAINING_STATE_WAIT = 'WAIT';
    const CALL_DRAINING_STATE_WAIT_TIMEOUT = 'WAIT_TIMEOUT';
    const CALL_DRAINING_STATE_TERMINATE = 'TERMINATE';
    const CALL_DRAINING_STATE_COMPLETE = 'COMPLETE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusCodeAllowableValues()
    {
        return [
            self::STATUS_CODE_NEW,
            self::STATUS_CODE_AWAITING_CONNECTION,
            self::STATUS_CODE_AWAITING_FINGERPRINT,
            self::STATUS_CODE_AWAITING_FINGERPRINT_VERIFICATION,
            self::STATUS_CODE_FINGERPRINT_VERIFIED,
            self::STATUS_CODE_AWAITING_BOOTSTRAP,
            self::STATUS_CODE_ACTIVE,
            self::STATUS_CODE_INACTIVE,
            self::STATUS_CODE_RMA,
            self::STATUS_CODE_UNPAIRING,
            self::STATUS_CODE_UNPAIRED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOnlineStatusAllowableValues()
    {
        return [
            self::ONLINE_STATUS_ONLINE,
            self::ONLINE_STATUS_OFFLINE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getEdgeDeploymentTypeAllowableValues()
    {
        return [
            self::EDGE_DEPLOYMENT_TYPE_HARDWARE,
            self::EDGE_DEPLOYMENT_TYPE_LDM,
            self::EDGE_DEPLOYMENT_TYPE_CDM,
            self::EDGE_DEPLOYMENT_TYPE_INVALID,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCallDrainingStateAllowableValues()
    {
        return [
            self::CALL_DRAINING_STATE_NONE,
            self::CALL_DRAINING_STATE_WAIT,
            self::CALL_DRAINING_STATE_WAIT_TIMEOUT,
            self::CALL_DRAINING_STATE_TERMINATE,
            self::CALL_DRAINING_STATE_COMPLETE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modifiedByApp'] = isset($data['modifiedByApp']) ? $data['modifiedByApp'] : null;
        $this->container['createdByApp'] = isset($data['createdByApp']) ? $data['createdByApp'] : null;
        $this->container['interfaces'] = isset($data['interfaces']) ? $data['interfaces'] : null;
        $this->container['make'] = isset($data['make']) ? $data['make'] : null;
        $this->container['model'] = isset($data['model']) ? $data['model'] : null;
        $this->container['apiVersion'] = isset($data['apiVersion']) ? $data['apiVersion'] : null;
        $this->container['softwareVersion'] = isset($data['softwareVersion']) ? $data['softwareVersion'] : null;
        $this->container['softwareVersionTimestamp'] = isset($data['softwareVersionTimestamp']) ? $data['softwareVersionTimestamp'] : null;
        $this->container['softwareVersionPlatform'] = isset($data['softwareVersionPlatform']) ? $data['softwareVersionPlatform'] : null;
        $this->container['softwareVersionConfiguration'] = isset($data['softwareVersionConfiguration']) ? $data['softwareVersionConfiguration'] : null;
        $this->container['fullSoftwareVersion'] = isset($data['fullSoftwareVersion']) ? $data['fullSoftwareVersion'] : null;
        $this->container['pairingId'] = isset($data['pairingId']) ? $data['pairingId'] : null;
        $this->container['fingerprint'] = isset($data['fingerprint']) ? $data['fingerprint'] : null;
        $this->container['fingerprintHint'] = isset($data['fingerprintHint']) ? $data['fingerprintHint'] : null;
        $this->container['currentVersion'] = isset($data['currentVersion']) ? $data['currentVersion'] : null;
        $this->container['stagedVersion'] = isset($data['stagedVersion']) ? $data['stagedVersion'] : null;
        $this->container['patch'] = isset($data['patch']) ? $data['patch'] : null;
        $this->container['statusCode'] = isset($data['statusCode']) ? $data['statusCode'] : null;
        $this->container['edgeGroup'] = isset($data['edgeGroup']) ? $data['edgeGroup'] : null;
        $this->container['site'] = isset($data['site']) ? $data['site'] : null;
        $this->container['softwareStatus'] = isset($data['softwareStatus']) ? $data['softwareStatus'] : null;
        $this->container['onlineStatus'] = isset($data['onlineStatus']) ? $data['onlineStatus'] : null;
        $this->container['serialNumber'] = isset($data['serialNumber']) ? $data['serialNumber'] : null;
        $this->container['physicalEdge'] = isset($data['physicalEdge']) ? $data['physicalEdge'] : null;
        $this->container['managed'] = isset($data['managed']) ? $data['managed'] : null;
        $this->container['edgeDeploymentType'] = isset($data['edgeDeploymentType']) ? $data['edgeDeploymentType'] : null;
        $this->container['callDrainingState'] = isset($data['callDrainingState']) ? $data['callDrainingState'] : null;
        $this->container['conversationCount'] = isset($data['conversationCount']) ? $data['conversationCount'] : null;
        $this->container['proxy'] = isset($data['proxy']) ? $data['proxy'] : null;
        $this->container['offlineConfigCalled'] = isset($data['offlineConfigCalled']) ? $data['offlineConfigCalled'] : null;
        $this->container['osName'] = isset($data['osName']) ? $data['osName'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NEW", "AWAITING_CONNECTION", "AWAITING_FINGERPRINT", "AWAITING_FINGERPRINT_VERIFICATION", "FINGERPRINT_VERIFIED", "AWAITING_BOOTSTRAP", "ACTIVE", "INACTIVE", "RMA", "UNPAIRING", "UNPAIRED");
        if (!in_array($this->container['statusCode'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'statusCode', must be one of #{allowed_values}.";
        }

        $allowed_values = array("ONLINE", "OFFLINE");
        if (!in_array($this->container['onlineStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'onlineStatus', must be one of #{allowed_values}.";
        }

        $allowed_values = array("HARDWARE", "LDM", "CDM", "INVALID");
        if (!in_array($this->container['edgeDeploymentType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'edgeDeploymentType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NONE", "WAIT", "WAIT_TIMEOUT", "TERMINATE", "COMPLETE");
        if (!in_array($this->container['callDrainingState'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'callDrainingState', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NEW", "AWAITING_CONNECTION", "AWAITING_FINGERPRINT", "AWAITING_FINGERPRINT_VERIFICATION", "FINGERPRINT_VERIFIED", "AWAITING_BOOTSTRAP", "ACTIVE", "INACTIVE", "RMA", "UNPAIRING", "UNPAIRED");
        if (!in_array($this->container['statusCode'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("ONLINE", "OFFLINE");
        if (!in_array($this->container['onlineStatus'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("HARDWARE", "LDM", "CDM", "INVALID");
        if (!in_array($this->container['edgeDeploymentType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NONE", "WAIT", "WAIT_TIMEOUT", "TERMINATE", "COMPLETE");
        if (!in_array($this->container['callDrainingState'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The name of the entity.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description The resource's description.
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version The current version of the resource.
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated The date the resource was created. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified The date of the last modification to the resource. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param string $modifiedBy The ID of the user that last modified the resource.
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets createdBy
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param string $createdBy The ID of the user that created the resource.
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state Indicates if the resource is active, inactive, or deleted.
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modifiedByApp
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modifiedByApp'];
    }

    /**
     * Sets modifiedByApp
     * @param string $modifiedByApp The application that last modified the resource.
     * @return $this
     */
    public function setModifiedByApp($modifiedByApp)
    {
        $this->container['modifiedByApp'] = $modifiedByApp;

        return $this;
    }

    /**
     * Gets createdByApp
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['createdByApp'];
    }

    /**
     * Sets createdByApp
     * @param string $createdByApp The application that created the resource.
     * @return $this
     */
    public function setCreatedByApp($createdByApp)
    {
        $this->container['createdByApp'] = $createdByApp;

        return $this;
    }

    /**
     * Gets interfaces
     * @return \PureCloudSDK\EdgeInterface[]
     */
    public function getInterfaces()
    {
        return $this->container['interfaces'];
    }

    /**
     * Sets interfaces
     * @param \PureCloudSDK\EdgeInterface[] $interfaces The list of interfaces for the edge. (Deprecated) Replaced by configuring trunks/ip info on the logical interface instead
     * @return $this
     */
    public function setInterfaces($interfaces)
    {
        $this->container['interfaces'] = $interfaces;

        return $this;
    }

    /**
     * Gets make
     * @return string
     */
    public function getMake()
    {
        return $this->container['make'];
    }

    /**
     * Sets make
     * @param string $make
     * @return $this
     */
    public function setMake($make)
    {
        $this->container['make'] = $make;

        return $this;
    }

    /**
     * Gets model
     * @return string
     */
    public function getModel()
    {
        return $this->container['model'];
    }

    /**
     * Sets model
     * @param string $model
     * @return $this
     */
    public function setModel($model)
    {
        $this->container['model'] = $model;

        return $this;
    }

    /**
     * Gets apiVersion
     * @return string
     */
    public function getApiVersion()
    {
        return $this->container['apiVersion'];
    }

    /**
     * Sets apiVersion
     * @param string $apiVersion
     * @return $this
     */
    public function setApiVersion($apiVersion)
    {
        $this->container['apiVersion'] = $apiVersion;

        return $this;
    }

    /**
     * Gets softwareVersion
     * @return string
     */
    public function getSoftwareVersion()
    {
        return $this->container['softwareVersion'];
    }

    /**
     * Sets softwareVersion
     * @param string $softwareVersion
     * @return $this
     */
    public function setSoftwareVersion($softwareVersion)
    {
        $this->container['softwareVersion'] = $softwareVersion;

        return $this;
    }

    /**
     * Gets softwareVersionTimestamp
     * @return string
     */
    public function getSoftwareVersionTimestamp()
    {
        return $this->container['softwareVersionTimestamp'];
    }

    /**
     * Sets softwareVersionTimestamp
     * @param string $softwareVersionTimestamp
     * @return $this
     */
    public function setSoftwareVersionTimestamp($softwareVersionTimestamp)
    {
        $this->container['softwareVersionTimestamp'] = $softwareVersionTimestamp;

        return $this;
    }

    /**
     * Gets softwareVersionPlatform
     * @return string
     */
    public function getSoftwareVersionPlatform()
    {
        return $this->container['softwareVersionPlatform'];
    }

    /**
     * Sets softwareVersionPlatform
     * @param string $softwareVersionPlatform
     * @return $this
     */
    public function setSoftwareVersionPlatform($softwareVersionPlatform)
    {
        $this->container['softwareVersionPlatform'] = $softwareVersionPlatform;

        return $this;
    }

    /**
     * Gets softwareVersionConfiguration
     * @return string
     */
    public function getSoftwareVersionConfiguration()
    {
        return $this->container['softwareVersionConfiguration'];
    }

    /**
     * Sets softwareVersionConfiguration
     * @param string $softwareVersionConfiguration
     * @return $this
     */
    public function setSoftwareVersionConfiguration($softwareVersionConfiguration)
    {
        $this->container['softwareVersionConfiguration'] = $softwareVersionConfiguration;

        return $this;
    }

    /**
     * Gets fullSoftwareVersion
     * @return string
     */
    public function getFullSoftwareVersion()
    {
        return $this->container['fullSoftwareVersion'];
    }

    /**
     * Sets fullSoftwareVersion
     * @param string $fullSoftwareVersion
     * @return $this
     */
    public function setFullSoftwareVersion($fullSoftwareVersion)
    {
        $this->container['fullSoftwareVersion'] = $fullSoftwareVersion;

        return $this;
    }

    /**
     * Gets pairingId
     * @return string
     */
    public function getPairingId()
    {
        return $this->container['pairingId'];
    }

    /**
     * Sets pairingId
     * @param string $pairingId The pairing Id for a hardware Edge in the format: 00000-00000-00000-00000-00000. This field is only required when creating an Edge with a deployment type of HARDWARE.
     * @return $this
     */
    public function setPairingId($pairingId)
    {
        $this->container['pairingId'] = $pairingId;

        return $this;
    }

    /**
     * Gets fingerprint
     * @return string
     */
    public function getFingerprint()
    {
        return $this->container['fingerprint'];
    }

    /**
     * Sets fingerprint
     * @param string $fingerprint
     * @return $this
     */
    public function setFingerprint($fingerprint)
    {
        $this->container['fingerprint'] = $fingerprint;

        return $this;
    }

    /**
     * Gets fingerprintHint
     * @return string
     */
    public function getFingerprintHint()
    {
        return $this->container['fingerprintHint'];
    }

    /**
     * Sets fingerprintHint
     * @param string $fingerprintHint
     * @return $this
     */
    public function setFingerprintHint($fingerprintHint)
    {
        $this->container['fingerprintHint'] = $fingerprintHint;

        return $this;
    }

    /**
     * Gets currentVersion
     * @return string
     */
    public function getCurrentVersion()
    {
        return $this->container['currentVersion'];
    }

    /**
     * Sets currentVersion
     * @param string $currentVersion
     * @return $this
     */
    public function setCurrentVersion($currentVersion)
    {
        $this->container['currentVersion'] = $currentVersion;

        return $this;
    }

    /**
     * Gets stagedVersion
     * @return string
     */
    public function getStagedVersion()
    {
        return $this->container['stagedVersion'];
    }

    /**
     * Sets stagedVersion
     * @param string $stagedVersion
     * @return $this
     */
    public function setStagedVersion($stagedVersion)
    {
        $this->container['stagedVersion'] = $stagedVersion;

        return $this;
    }

    /**
     * Gets patch
     * @return string
     */
    public function getPatch()
    {
        return $this->container['patch'];
    }

    /**
     * Sets patch
     * @param string $patch
     * @return $this
     */
    public function setPatch($patch)
    {
        $this->container['patch'] = $patch;

        return $this;
    }

    /**
     * Gets statusCode
     * @return string
     */
    public function getStatusCode()
    {
        return $this->container['statusCode'];
    }

    /**
     * Sets statusCode
     * @param string $statusCode The current status of the Edge.
     * @return $this
     */
    public function setStatusCode($statusCode)
    {
        $allowed_values = array('NEW', 'AWAITING_CONNECTION', 'AWAITING_FINGERPRINT', 'AWAITING_FINGERPRINT_VERIFICATION', 'FINGERPRINT_VERIFIED', 'AWAITING_BOOTSTRAP', 'ACTIVE', 'INACTIVE', 'RMA', 'UNPAIRING', 'UNPAIRED');
        if (!in_array($statusCode, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'statusCode', must be one of 'NEW', 'AWAITING_CONNECTION', 'AWAITING_FINGERPRINT', 'AWAITING_FINGERPRINT_VERIFICATION', 'FINGERPRINT_VERIFIED', 'AWAITING_BOOTSTRAP', 'ACTIVE', 'INACTIVE', 'RMA', 'UNPAIRING', 'UNPAIRED'");
        }
        $this->container['statusCode'] = $statusCode;

        return $this;
    }

    /**
     * Gets edgeGroup
     * @return \PureCloudSDK\EdgeGroup
     */
    public function getEdgeGroup()
    {
        return $this->container['edgeGroup'];
    }

    /**
     * Sets edgeGroup
     * @param \PureCloudSDK\EdgeGroup $edgeGroup
     * @return $this
     */
    public function setEdgeGroup($edgeGroup)
    {
        $this->container['edgeGroup'] = $edgeGroup;

        return $this;
    }

    /**
     * Gets site
     * @return \PureCloudSDK\Site
     */
    public function getSite()
    {
        return $this->container['site'];
    }

    /**
     * Sets site
     * @param \PureCloudSDK\Site $site The Site to which the Edge is assigned.
     * @return $this
     */
    public function setSite($site)
    {
        $this->container['site'] = $site;

        return $this;
    }

    /**
     * Gets softwareStatus
     * @return \PureCloudSDK\DomainEdgeSoftwareUpdateDto
     */
    public function getSoftwareStatus()
    {
        return $this->container['softwareStatus'];
    }

    /**
     * Sets softwareStatus
     * @param \PureCloudSDK\DomainEdgeSoftwareUpdateDto $softwareStatus
     * @return $this
     */
    public function setSoftwareStatus($softwareStatus)
    {
        $this->container['softwareStatus'] = $softwareStatus;

        return $this;
    }

    /**
     * Gets onlineStatus
     * @return string
     */
    public function getOnlineStatus()
    {
        return $this->container['onlineStatus'];
    }

    /**
     * Sets onlineStatus
     * @param string $onlineStatus
     * @return $this
     */
    public function setOnlineStatus($onlineStatus)
    {
        $allowed_values = array('ONLINE', 'OFFLINE');
        if (!in_array($onlineStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'onlineStatus', must be one of 'ONLINE', 'OFFLINE'");
        }
        $this->container['onlineStatus'] = $onlineStatus;

        return $this;
    }

    /**
     * Gets serialNumber
     * @return string
     */
    public function getSerialNumber()
    {
        return $this->container['serialNumber'];
    }

    /**
     * Sets serialNumber
     * @param string $serialNumber
     * @return $this
     */
    public function setSerialNumber($serialNumber)
    {
        $this->container['serialNumber'] = $serialNumber;

        return $this;
    }

    /**
     * Gets physicalEdge
     * @return bool
     */
    public function getPhysicalEdge()
    {
        return $this->container['physicalEdge'];
    }

    /**
     * Sets physicalEdge
     * @param bool $physicalEdge
     * @return $this
     */
    public function setPhysicalEdge($physicalEdge)
    {
        $this->container['physicalEdge'] = $physicalEdge;

        return $this;
    }

    /**
     * Gets managed
     * @return bool
     */
    public function getManaged()
    {
        return $this->container['managed'];
    }

    /**
     * Sets managed
     * @param bool $managed
     * @return $this
     */
    public function setManaged($managed)
    {
        $this->container['managed'] = $managed;

        return $this;
    }

    /**
     * Gets edgeDeploymentType
     * @return string
     */
    public function getEdgeDeploymentType()
    {
        return $this->container['edgeDeploymentType'];
    }

    /**
     * Sets edgeDeploymentType
     * @param string $edgeDeploymentType
     * @return $this
     */
    public function setEdgeDeploymentType($edgeDeploymentType)
    {
        $allowed_values = array('HARDWARE', 'LDM', 'CDM', 'INVALID');
        if (!in_array($edgeDeploymentType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'edgeDeploymentType', must be one of 'HARDWARE', 'LDM', 'CDM', 'INVALID'");
        }
        $this->container['edgeDeploymentType'] = $edgeDeploymentType;

        return $this;
    }

    /**
     * Gets callDrainingState
     * @return string
     */
    public function getCallDrainingState()
    {
        return $this->container['callDrainingState'];
    }

    /**
     * Sets callDrainingState
     * @param string $callDrainingState
     * @return $this
     */
    public function setCallDrainingState($callDrainingState)
    {
        $allowed_values = array('NONE', 'WAIT', 'WAIT_TIMEOUT', 'TERMINATE', 'COMPLETE');
        if (!in_array($callDrainingState, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'callDrainingState', must be one of 'NONE', 'WAIT', 'WAIT_TIMEOUT', 'TERMINATE', 'COMPLETE'");
        }
        $this->container['callDrainingState'] = $callDrainingState;

        return $this;
    }

    /**
     * Gets conversationCount
     * @return int
     */
    public function getConversationCount()
    {
        return $this->container['conversationCount'];
    }

    /**
     * Sets conversationCount
     * @param int $conversationCount
     * @return $this
     */
    public function setConversationCount($conversationCount)
    {
        $this->container['conversationCount'] = $conversationCount;

        return $this;
    }

    /**
     * Gets proxy
     * @return string
     */
    public function getProxy()
    {
        return $this->container['proxy'];
    }

    /**
     * Sets proxy
     * @param string $proxy Edge HTTP proxy configuration for the WAN port. The field can be a hostname, FQDN, IPv4 or IPv6 address. If port is not included, port 80 is assumed.
     * @return $this
     */
    public function setProxy($proxy)
    {
        $this->container['proxy'] = $proxy;

        return $this;
    }

    /**
     * Gets offlineConfigCalled
     * @return bool
     */
    public function getOfflineConfigCalled()
    {
        return $this->container['offlineConfigCalled'];
    }

    /**
     * Sets offlineConfigCalled
     * @param bool $offlineConfigCalled True if the offline edge configuration endpoint has been called for this edge.
     * @return $this
     */
    public function setOfflineConfigCalled($offlineConfigCalled)
    {
        $this->container['offlineConfigCalled'] = $offlineConfigCalled;

        return $this;
    }

    /**
     * Gets osName
     * @return string
     */
    public function getOsName()
    {
        return $this->container['osName'];
    }

    /**
     * Sets osName
     * @param string $osName The name provided by the operating system of the Edge.
     * @return $this
     */
    public function setOsName($osName)
    {
        $this->container['osName'] = $osName;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


