<?php
/**
 * EmailMediaParticipant
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * EmailMediaParticipant Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class EmailMediaParticipant implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'EmailMediaParticipant';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'address' => 'string',
        'startTime' => '\DateTime',
        'connectedTime' => '\DateTime',
        'endTime' => '\DateTime',
        'startHoldTime' => '\DateTime',
        'purpose' => 'string',
        'state' => 'string',
        'direction' => 'string',
        'disconnectType' => 'string',
        'held' => 'bool',
        'wrapupRequired' => 'bool',
        'wrapupPrompt' => 'string',
        'user' => '\PureCloudSDK\UriReference',
        'queue' => '\PureCloudSDK\UriReference',
        'attributes' => 'map[string,string]',
        'errorInfo' => '\PureCloudSDK\ErrorBody',
        'script' => '\PureCloudSDK\UriReference',
        'wrapupTimeoutMs' => 'int',
        'wrapupSkipped' => 'bool',
        'alertingTimeoutMs' => 'int',
        'provider' => 'string',
        'externalContact' => '\PureCloudSDK\UriReference',
        'externalOrganization' => '\PureCloudSDK\UriReference',
        'wrapup' => '\PureCloudSDK\Wrapup',
        'peer' => 'string',
        'flaggedReason' => 'string',
        'journeyContext' => '\PureCloudSDK\JourneyContext',
        'subject' => 'string',
        'messagesSent' => 'int',
        'autoGenerated' => 'bool',
        'draftAttachments' => '\PureCloudSDK\Attachment[]',
        'spam' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'address' => 'address',
        'startTime' => 'startTime',
        'connectedTime' => 'connectedTime',
        'endTime' => 'endTime',
        'startHoldTime' => 'startHoldTime',
        'purpose' => 'purpose',
        'state' => 'state',
        'direction' => 'direction',
        'disconnectType' => 'disconnectType',
        'held' => 'held',
        'wrapupRequired' => 'wrapupRequired',
        'wrapupPrompt' => 'wrapupPrompt',
        'user' => 'user',
        'queue' => 'queue',
        'attributes' => 'attributes',
        'errorInfo' => 'errorInfo',
        'script' => 'script',
        'wrapupTimeoutMs' => 'wrapupTimeoutMs',
        'wrapupSkipped' => 'wrapupSkipped',
        'alertingTimeoutMs' => 'alertingTimeoutMs',
        'provider' => 'provider',
        'externalContact' => 'externalContact',
        'externalOrganization' => 'externalOrganization',
        'wrapup' => 'wrapup',
        'peer' => 'peer',
        'flaggedReason' => 'flaggedReason',
        'journeyContext' => 'journeyContext',
        'subject' => 'subject',
        'messagesSent' => 'messagesSent',
        'autoGenerated' => 'autoGenerated',
        'draftAttachments' => 'draftAttachments',
        'spam' => 'spam'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'address' => 'setAddress',
        'startTime' => 'setStartTime',
        'connectedTime' => 'setConnectedTime',
        'endTime' => 'setEndTime',
        'startHoldTime' => 'setStartHoldTime',
        'purpose' => 'setPurpose',
        'state' => 'setState',
        'direction' => 'setDirection',
        'disconnectType' => 'setDisconnectType',
        'held' => 'setHeld',
        'wrapupRequired' => 'setWrapupRequired',
        'wrapupPrompt' => 'setWrapupPrompt',
        'user' => 'setUser',
        'queue' => 'setQueue',
        'attributes' => 'setAttributes',
        'errorInfo' => 'setErrorInfo',
        'script' => 'setScript',
        'wrapupTimeoutMs' => 'setWrapupTimeoutMs',
        'wrapupSkipped' => 'setWrapupSkipped',
        'alertingTimeoutMs' => 'setAlertingTimeoutMs',
        'provider' => 'setProvider',
        'externalContact' => 'setExternalContact',
        'externalOrganization' => 'setExternalOrganization',
        'wrapup' => 'setWrapup',
        'peer' => 'setPeer',
        'flaggedReason' => 'setFlaggedReason',
        'journeyContext' => 'setJourneyContext',
        'subject' => 'setSubject',
        'messagesSent' => 'setMessagesSent',
        'autoGenerated' => 'setAutoGenerated',
        'draftAttachments' => 'setDraftAttachments',
        'spam' => 'setSpam'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'address' => 'getAddress',
        'startTime' => 'getStartTime',
        'connectedTime' => 'getConnectedTime',
        'endTime' => 'getEndTime',
        'startHoldTime' => 'getStartHoldTime',
        'purpose' => 'getPurpose',
        'state' => 'getState',
        'direction' => 'getDirection',
        'disconnectType' => 'getDisconnectType',
        'held' => 'getHeld',
        'wrapupRequired' => 'getWrapupRequired',
        'wrapupPrompt' => 'getWrapupPrompt',
        'user' => 'getUser',
        'queue' => 'getQueue',
        'attributes' => 'getAttributes',
        'errorInfo' => 'getErrorInfo',
        'script' => 'getScript',
        'wrapupTimeoutMs' => 'getWrapupTimeoutMs',
        'wrapupSkipped' => 'getWrapupSkipped',
        'alertingTimeoutMs' => 'getAlertingTimeoutMs',
        'provider' => 'getProvider',
        'externalContact' => 'getExternalContact',
        'externalOrganization' => 'getExternalOrganization',
        'wrapup' => 'getWrapup',
        'peer' => 'getPeer',
        'flaggedReason' => 'getFlaggedReason',
        'journeyContext' => 'getJourneyContext',
        'subject' => 'getSubject',
        'messagesSent' => 'getMessagesSent',
        'autoGenerated' => 'getAutoGenerated',
        'draftAttachments' => 'getDraftAttachments',
        'spam' => 'getSpam'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ALERTING = 'alerting';
    const STATE_DIALING = 'dialing';
    const STATE_CONTACTING = 'contacting';
    const STATE_OFFERING = 'offering';
    const STATE_CONNECTED = 'connected';
    const STATE_DISCONNECTED = 'disconnected';
    const STATE_TERMINATED = 'terminated';
    const STATE_CONVERTING = 'converting';
    const STATE_UPLOADING = 'uploading';
    const STATE_TRANSMITTING = 'transmitting';
    const STATE_NONE = 'none';
    const DIRECTION_INBOUND = 'inbound';
    const DIRECTION_OUTBOUND = 'outbound';
    const DISCONNECT_TYPE_ENDPOINT = 'endpoint';
    const DISCONNECT_TYPE_CLIENT = 'client';
    const DISCONNECT_TYPE_SYSTEM = 'system';
    const DISCONNECT_TYPE_TRANSFER = 'transfer';
    const DISCONNECT_TYPE_TRANSFERCONFERENCE = 'transfer.conference';
    const DISCONNECT_TYPE_TRANSFERCONSULT = 'transfer.consult';
    const DISCONNECT_TYPE_TRANSFERFORWARD = 'transfer.forward';
    const DISCONNECT_TYPE_TRANSFERNOANSWER = 'transfer.noanswer';
    const DISCONNECT_TYPE_TRANSFERNOTAVAILABLE = 'transfer.notavailable';
    const DISCONNECT_TYPE_TRANSPORTFAILURE = 'transport.failure';
    const DISCONNECT_TYPE_ERROR = 'error';
    const DISCONNECT_TYPE_PEER = 'peer';
    const DISCONNECT_TYPE_OTHER = 'other';
    const DISCONNECT_TYPE_SPAM = 'spam';
    const FLAGGED_REASON_GENERAL = 'general';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ALERTING,
            self::STATE_DIALING,
            self::STATE_CONTACTING,
            self::STATE_OFFERING,
            self::STATE_CONNECTED,
            self::STATE_DISCONNECTED,
            self::STATE_TERMINATED,
            self::STATE_CONVERTING,
            self::STATE_UPLOADING,
            self::STATE_TRANSMITTING,
            self::STATE_NONE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDisconnectTypeAllowableValues()
    {
        return [
            self::DISCONNECT_TYPE_ENDPOINT,
            self::DISCONNECT_TYPE_CLIENT,
            self::DISCONNECT_TYPE_SYSTEM,
            self::DISCONNECT_TYPE_TRANSFER,
            self::DISCONNECT_TYPE_TRANSFERCONFERENCE,
            self::DISCONNECT_TYPE_TRANSFERCONSULT,
            self::DISCONNECT_TYPE_TRANSFERFORWARD,
            self::DISCONNECT_TYPE_TRANSFERNOANSWER,
            self::DISCONNECT_TYPE_TRANSFERNOTAVAILABLE,
            self::DISCONNECT_TYPE_TRANSPORTFAILURE,
            self::DISCONNECT_TYPE_ERROR,
            self::DISCONNECT_TYPE_PEER,
            self::DISCONNECT_TYPE_OTHER,
            self::DISCONNECT_TYPE_SPAM,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFlaggedReasonAllowableValues()
    {
        return [
            self::FLAGGED_REASON_GENERAL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['startTime'] = isset($data['startTime']) ? $data['startTime'] : null;
        $this->container['connectedTime'] = isset($data['connectedTime']) ? $data['connectedTime'] : null;
        $this->container['endTime'] = isset($data['endTime']) ? $data['endTime'] : null;
        $this->container['startHoldTime'] = isset($data['startHoldTime']) ? $data['startHoldTime'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['disconnectType'] = isset($data['disconnectType']) ? $data['disconnectType'] : null;
        $this->container['held'] = isset($data['held']) ? $data['held'] : null;
        $this->container['wrapupRequired'] = isset($data['wrapupRequired']) ? $data['wrapupRequired'] : null;
        $this->container['wrapupPrompt'] = isset($data['wrapupPrompt']) ? $data['wrapupPrompt'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['errorInfo'] = isset($data['errorInfo']) ? $data['errorInfo'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['wrapupTimeoutMs'] = isset($data['wrapupTimeoutMs']) ? $data['wrapupTimeoutMs'] : null;
        $this->container['wrapupSkipped'] = isset($data['wrapupSkipped']) ? $data['wrapupSkipped'] : null;
        $this->container['alertingTimeoutMs'] = isset($data['alertingTimeoutMs']) ? $data['alertingTimeoutMs'] : null;
        $this->container['provider'] = isset($data['provider']) ? $data['provider'] : null;
        $this->container['externalContact'] = isset($data['externalContact']) ? $data['externalContact'] : null;
        $this->container['externalOrganization'] = isset($data['externalOrganization']) ? $data['externalOrganization'] : null;
        $this->container['wrapup'] = isset($data['wrapup']) ? $data['wrapup'] : null;
        $this->container['peer'] = isset($data['peer']) ? $data['peer'] : null;
        $this->container['flaggedReason'] = isset($data['flaggedReason']) ? $data['flaggedReason'] : null;
        $this->container['journeyContext'] = isset($data['journeyContext']) ? $data['journeyContext'] : null;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
        $this->container['messagesSent'] = isset($data['messagesSent']) ? $data['messagesSent'] : null;
        $this->container['autoGenerated'] = isset($data['autoGenerated']) ? $data['autoGenerated'] : null;
        $this->container['draftAttachments'] = isset($data['draftAttachments']) ? $data['draftAttachments'] : null;
        $this->container['spam'] = isset($data['spam']) ? $data['spam'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        $allowed_values = array("endpoint", "client", "system", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'disconnectType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("general");
        if (!in_array($this->container['flaggedReason'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'flaggedReason', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("alerting", "dialing", "contacting", "offering", "connected", "disconnected", "terminated", "converting", "uploading", "transmitting", "none");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("endpoint", "client", "system", "transfer", "transfer.conference", "transfer.consult", "transfer.forward", "transfer.noanswer", "transfer.notavailable", "transport.failure", "error", "peer", "other", "spam");
        if (!in_array($this->container['disconnectType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("general");
        if (!in_array($this->container['flaggedReason'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The unique participant ID.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The display friendly name of the participant.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address The participant address.
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets startTime
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['startTime'];
    }

    /**
     * Sets startTime
     * @param \DateTime $startTime The time when this participant first joined the conversation. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($startTime)
    {
        $this->container['startTime'] = $startTime;

        return $this;
    }

    /**
     * Gets connectedTime
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connectedTime'];
    }

    /**
     * Sets connectedTime
     * @param \DateTime $connectedTime The time when this participant went connected for this media (eg: video connected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connectedTime)
    {
        $this->container['connectedTime'] = $connectedTime;

        return $this;
    }

    /**
     * Gets endTime
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['endTime'];
    }

    /**
     * Sets endTime
     * @param \DateTime $endTime The time when this participant went disconnected for this media (eg: video disconnected time). Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndTime($endTime)
    {
        $this->container['endTime'] = $endTime;

        return $this;
    }

    /**
     * Gets startHoldTime
     * @return \DateTime
     */
    public function getStartHoldTime()
    {
        return $this->container['startHoldTime'];
    }

    /**
     * Sets startHoldTime
     * @param \DateTime $startHoldTime The time when this participant's hold started. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartHoldTime($startHoldTime)
    {
        $this->container['startHoldTime'] = $startHoldTime;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose The participant's purpose.  Values can be: 'agent', 'user', 'customer', 'external', 'acd', 'ivr
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state The participant's state.  Values can be: 'alerting', 'connected', 'disconnected', 'dialing', 'contacting
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'none');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'alerting', 'dialing', 'contacting', 'offering', 'connected', 'disconnected', 'terminated', 'converting', 'uploading', 'transmitting', 'none'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction The participant's direction.  Values can be: 'inbound' or 'outbound'
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets disconnectType
     * @return string
     */
    public function getDisconnectType()
    {
        return $this->container['disconnectType'];
    }

    /**
     * Sets disconnectType
     * @param string $disconnectType The reason the participant was disconnected from the conversation.
     * @return $this
     */
    public function setDisconnectType($disconnectType)
    {
        $allowed_values = array('endpoint', 'client', 'system', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam');
        if (!in_array($disconnectType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'disconnectType', must be one of 'endpoint', 'client', 'system', 'transfer', 'transfer.conference', 'transfer.consult', 'transfer.forward', 'transfer.noanswer', 'transfer.notavailable', 'transport.failure', 'error', 'peer', 'other', 'spam'");
        }
        $this->container['disconnectType'] = $disconnectType;

        return $this;
    }

    /**
     * Gets held
     * @return bool
     */
    public function getHeld()
    {
        return $this->container['held'];
    }

    /**
     * Sets held
     * @param bool $held Value is true when the participant is on hold.
     * @return $this
     */
    public function setHeld($held)
    {
        $this->container['held'] = $held;

        return $this;
    }

    /**
     * Gets wrapupRequired
     * @return bool
     */
    public function getWrapupRequired()
    {
        return $this->container['wrapupRequired'];
    }

    /**
     * Sets wrapupRequired
     * @param bool $wrapupRequired Value is true when the participant requires wrap-up.
     * @return $this
     */
    public function setWrapupRequired($wrapupRequired)
    {
        $this->container['wrapupRequired'] = $wrapupRequired;

        return $this;
    }

    /**
     * Gets wrapupPrompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapupPrompt'];
    }

    /**
     * Sets wrapupPrompt
     * @param string $wrapupPrompt The wrap-up prompt indicating the type of wrap-up to be performed.
     * @return $this
     */
    public function setWrapupPrompt($wrapupPrompt)
    {
        $this->container['wrapupPrompt'] = $wrapupPrompt;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\UriReference
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\UriReference $user The PureCloud user for this participant.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue The PureCloud queue for this participant.
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes A list of ad-hoc attributes for the participant.
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets errorInfo
     * @return \PureCloudSDK\ErrorBody
     */
    public function getErrorInfo()
    {
        return $this->container['errorInfo'];
    }

    /**
     * Sets errorInfo
     * @param \PureCloudSDK\ErrorBody $errorInfo If the conversation ends in error, contains additional error details.
     * @return $this
     */
    public function setErrorInfo($errorInfo)
    {
        $this->container['errorInfo'] = $errorInfo;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\UriReference
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\UriReference $script The Engage script that should be used by this participant.
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets wrapupTimeoutMs
     * @return int
     */
    public function getWrapupTimeoutMs()
    {
        return $this->container['wrapupTimeoutMs'];
    }

    /**
     * Sets wrapupTimeoutMs
     * @param int $wrapupTimeoutMs The amount of time the participant has to complete wrap-up.
     * @return $this
     */
    public function setWrapupTimeoutMs($wrapupTimeoutMs)
    {
        $this->container['wrapupTimeoutMs'] = $wrapupTimeoutMs;

        return $this;
    }

    /**
     * Gets wrapupSkipped
     * @return bool
     */
    public function getWrapupSkipped()
    {
        return $this->container['wrapupSkipped'];
    }

    /**
     * Sets wrapupSkipped
     * @param bool $wrapupSkipped Value is true when the participant has skipped wrap-up.
     * @return $this
     */
    public function setWrapupSkipped($wrapupSkipped)
    {
        $this->container['wrapupSkipped'] = $wrapupSkipped;

        return $this;
    }

    /**
     * Gets alertingTimeoutMs
     * @return int
     */
    public function getAlertingTimeoutMs()
    {
        return $this->container['alertingTimeoutMs'];
    }

    /**
     * Sets alertingTimeoutMs
     * @param int $alertingTimeoutMs Specifies how long the agent has to answer an interaction before being marked as not responding.
     * @return $this
     */
    public function setAlertingTimeoutMs($alertingTimeoutMs)
    {
        $this->container['alertingTimeoutMs'] = $alertingTimeoutMs;

        return $this;
    }

    /**
     * Gets provider
     * @return string
     */
    public function getProvider()
    {
        return $this->container['provider'];
    }

    /**
     * Sets provider
     * @param string $provider The source provider for the communication.
     * @return $this
     */
    public function setProvider($provider)
    {
        $this->container['provider'] = $provider;

        return $this;
    }

    /**
     * Gets externalContact
     * @return \PureCloudSDK\UriReference
     */
    public function getExternalContact()
    {
        return $this->container['externalContact'];
    }

    /**
     * Sets externalContact
     * @param \PureCloudSDK\UriReference $externalContact If this participant represents an external contact, then this will be the reference for the external contact.
     * @return $this
     */
    public function setExternalContact($externalContact)
    {
        $this->container['externalContact'] = $externalContact;

        return $this;
    }

    /**
     * Gets externalOrganization
     * @return \PureCloudSDK\UriReference
     */
    public function getExternalOrganization()
    {
        return $this->container['externalOrganization'];
    }

    /**
     * Sets externalOrganization
     * @param \PureCloudSDK\UriReference $externalOrganization If this participant represents an external org, then this will be the reference for the external org.
     * @return $this
     */
    public function setExternalOrganization($externalOrganization)
    {
        $this->container['externalOrganization'] = $externalOrganization;

        return $this;
    }

    /**
     * Gets wrapup
     * @return \PureCloudSDK\Wrapup
     */
    public function getWrapup()
    {
        return $this->container['wrapup'];
    }

    /**
     * Sets wrapup
     * @param \PureCloudSDK\Wrapup $wrapup Wrapup for this participant, if it has been applied.
     * @return $this
     */
    public function setWrapup($wrapup)
    {
        $this->container['wrapup'] = $wrapup;

        return $this;
    }

    /**
     * Gets peer
     * @return string
     */
    public function getPeer()
    {
        return $this->container['peer'];
    }

    /**
     * Sets peer
     * @param string $peer The peer communication corresponding to a matching leg for this communication.
     * @return $this
     */
    public function setPeer($peer)
    {
        $this->container['peer'] = $peer;

        return $this;
    }

    /**
     * Gets flaggedReason
     * @return string
     */
    public function getFlaggedReason()
    {
        return $this->container['flaggedReason'];
    }

    /**
     * Sets flaggedReason
     * @param string $flaggedReason The reason specifying why participant flagged the conversation.
     * @return $this
     */
    public function setFlaggedReason($flaggedReason)
    {
        $allowed_values = array('general');
        if (!in_array($flaggedReason, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'flaggedReason', must be one of 'general'");
        }
        $this->container['flaggedReason'] = $flaggedReason;

        return $this;
    }

    /**
     * Gets journeyContext
     * @return \PureCloudSDK\JourneyContext
     */
    public function getJourneyContext()
    {
        return $this->container['journeyContext'];
    }

    /**
     * Sets journeyContext
     * @param \PureCloudSDK\JourneyContext $journeyContext Journey System data/context that is applicable to this communication.  When used for historical purposes, the context should be immutable.  When null, there is no applicable Journey System context.
     * @return $this
     */
    public function setJourneyContext($journeyContext)
    {
        $this->container['journeyContext'] = $journeyContext;

        return $this;
    }

    /**
     * Gets subject
     * @return string
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     * @param string $subject The subject of the email.
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets messagesSent
     * @return int
     */
    public function getMessagesSent()
    {
        return $this->container['messagesSent'];
    }

    /**
     * Sets messagesSent
     * @param int $messagesSent The number of messages that have been sent in this email conversation.
     * @return $this
     */
    public function setMessagesSent($messagesSent)
    {
        $this->container['messagesSent'] = $messagesSent;

        return $this;
    }

    /**
     * Gets autoGenerated
     * @return bool
     */
    public function getAutoGenerated()
    {
        return $this->container['autoGenerated'];
    }

    /**
     * Sets autoGenerated
     * @param bool $autoGenerated Indicates that the email was auto-generated like an Out of Office reply.
     * @return $this
     */
    public function setAutoGenerated($autoGenerated)
    {
        $this->container['autoGenerated'] = $autoGenerated;

        return $this;
    }

    /**
     * Gets draftAttachments
     * @return \PureCloudSDK\Attachment[]
     */
    public function getDraftAttachments()
    {
        return $this->container['draftAttachments'];
    }

    /**
     * Sets draftAttachments
     * @param \PureCloudSDK\Attachment[] $draftAttachments A list of uploaded attachments on the email draft.
     * @return $this
     */
    public function setDraftAttachments($draftAttachments)
    {
        $this->container['draftAttachments'] = $draftAttachments;

        return $this;
    }

    /**
     * Gets spam
     * @return bool
     */
    public function getSpam()
    {
        return $this->container['spam'];
    }

    /**
     * Sets spam
     * @param bool $spam Indicates if the inbound email was marked as spam.
     * @return $this
     */
    public function setSpam($spam)
    {
        $this->container['spam'] = $spam;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


