<?php
/**
 * ImportWeekScheduleRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ImportWeekScheduleRequest Class Doc Comment
 *
 * @category    Class */
 // @description Information to create a schedule for a week in management unit using imported data
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ImportWeekScheduleRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ImportWeekScheduleRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'description' => 'string',
        'userSchedules' => 'map[string,\PureCloudSDK\UserSchedule]',
        'published' => 'bool',
        'shortTermForecastId' => 'string',
        'partialUploadIds' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'description' => 'description',
        'userSchedules' => 'userSchedules',
        'published' => 'published',
        'shortTermForecastId' => 'shortTermForecastId',
        'partialUploadIds' => 'partialUploadIds'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'description' => 'setDescription',
        'userSchedules' => 'setUserSchedules',
        'published' => 'setPublished',
        'shortTermForecastId' => 'setShortTermForecastId',
        'partialUploadIds' => 'setPartialUploadIds'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'description' => 'getDescription',
        'userSchedules' => 'getUserSchedules',
        'published' => 'getPublished',
        'shortTermForecastId' => 'getShortTermForecastId',
        'partialUploadIds' => 'getPartialUploadIds'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['userSchedules'] = isset($data['userSchedules']) ? $data['userSchedules'] : null;
        $this->container['published'] = isset($data['published']) ? $data['published'] : null;
        $this->container['shortTermForecastId'] = isset($data['shortTermForecastId']) ? $data['shortTermForecastId'] : null;
        $this->container['partialUploadIds'] = isset($data['partialUploadIds']) ? $data['partialUploadIds'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['description'] === null) {
            $invalid_properties[] = "'description' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['description'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description Description for the schedule
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets userSchedules
     * @return map[string,\PureCloudSDK\UserSchedule]
     */
    public function getUserSchedules()
    {
        return $this->container['userSchedules'];
    }

    /**
     * Sets userSchedules
     * @param map[string,\PureCloudSDK\UserSchedule] $userSchedules User schedules
     * @return $this
     */
    public function setUserSchedules($userSchedules)
    {
        $this->container['userSchedules'] = $userSchedules;

        return $this;
    }

    /**
     * Gets published
     * @return bool
     */
    public function getPublished()
    {
        return $this->container['published'];
    }

    /**
     * Sets published
     * @param bool $published Whether the schedule is published
     * @return $this
     */
    public function setPublished($published)
    {
        $this->container['published'] = $published;

        return $this;
    }

    /**
     * Gets shortTermForecastId
     * @return string
     */
    public function getShortTermForecastId()
    {
        return $this->container['shortTermForecastId'];
    }

    /**
     * Sets shortTermForecastId
     * @param string $shortTermForecastId Short term forecast that should be associated with this schedule
     * @return $this
     */
    public function setShortTermForecastId($shortTermForecastId)
    {
        $this->container['shortTermForecastId'] = $shortTermForecastId;

        return $this;
    }

    /**
     * Gets partialUploadIds
     * @return string[]
     */
    public function getPartialUploadIds()
    {
        return $this->container['partialUploadIds'];
    }

    /**
     * Sets partialUploadIds
     * @param string[] $partialUploadIds IDs of partial uploads of user schedules to import week schedule. It is applicable only for large schedules where activity count in schedule is greater than 17500
     * @return $this
     */
    public function setPartialUploadIds($partialUploadIds)
    {
        $this->container['partialUploadIds'] = $partialUploadIds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


