<?php
/**
 * ObservationQuery
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ObservationQuery Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ObservationQuery implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ObservationQuery';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'filter' => '\PureCloudSDK\AnalyticsQueryFilter',
        'metrics' => 'string[]',
        'detailMetrics' => 'string[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'filter' => 'filter',
        'metrics' => 'metrics',
        'detailMetrics' => 'detailMetrics'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'filter' => 'setFilter',
        'metrics' => 'setMetrics',
        'detailMetrics' => 'setDetailMetrics'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'filter' => 'getFilter',
        'metrics' => 'getMetrics',
        'detailMetrics' => 'getDetailMetrics'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const METRICS_T_SEGMENT_DURATION = 'tSegmentDuration';
    const METRICS_T_CONVERSATION_DURATION = 'tConversationDuration';
    const METRICS_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    const METRICS_O_TOTAL_SCORE = 'oTotalScore';
    const METRICS_N_EVALUATIONS = 'nEvaluations';
    const METRICS_T_ABANDON = 'tAbandon';
    const METRICS_T_IVR = 'tIvr';
    const METRICS_T_ANSWERED = 'tAnswered';
    const METRICS_T_FLOW_OUT = 'tFlowOut';
    const METRICS_T_ACD = 'tAcd';
    const METRICS_T_TALK = 'tTalk';
    const METRICS_T_HELD = 'tHeld';
    const METRICS_T_TALK_COMPLETE = 'tTalkComplete';
    const METRICS_T_HELD_COMPLETE = 'tHeldComplete';
    const METRICS_T_ACW = 'tAcw';
    const METRICS_T_HANDLE = 'tHandle';
    const METRICS_T_CONTACTING = 'tContacting';
    const METRICS_T_DIALING = 'tDialing';
    const METRICS_T_WAIT = 'tWait';
    const METRICS_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    const METRICS_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    const METRICS_T_SYSTEM_PRESENCE = 'tSystemPresence';
    const METRICS_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    const METRICS_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    const METRICS_T_VOICEMAIL = 'tVoicemail';
    const METRICS_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    const METRICS_N_OFFERED = 'nOffered';
    const METRICS_N_OVER_SLA = 'nOverSla';
    const METRICS_N_TRANSFERRED = 'nTransferred';
    const METRICS_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    const METRICS_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    const METRICS_N_CONSULT = 'nConsult';
    const METRICS_N_CONNECTED = 'nConnected';
    const METRICS_T_ALERT = 'tAlert';
    const METRICS_T_NOT_RESPONDING = 'tNotResponding';
    const METRICS_N_OUTBOUND = 'nOutbound';
    const METRICS_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    const METRICS_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    const METRICS_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    const METRICS_N_ERROR = 'nError';
    const METRICS_O_SERVICE_TARGET = 'oServiceTarget';
    const METRICS_O_SERVICE_LEVEL = 'oServiceLevel';
    const METRICS_T_ACTIVE = 'tActive';
    const METRICS_T_INACTIVE = 'tInactive';
    const METRICS_O_ACTIVE_USERS = 'oActiveUsers';
    const METRICS_O_MEMBER_USERS = 'oMemberUsers';
    const METRICS_O_ACTIVE_QUEUES = 'oActiveQueues';
    const METRICS_O_MEMBER_QUEUES = 'oMemberQueues';
    const METRICS_O_INTERACTING = 'oInteracting';
    const METRICS_O_WAITING = 'oWaiting';
    const METRICS_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    const METRICS_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    const METRICS_O_USER_PRESENCES = 'oUserPresences';
    const METRICS_O_USER_ROUTING_STATUSES = 'oUserRoutingStatuses';
    const METRICS_N_SURVEYS_SENT = 'nSurveysSent';
    const METRICS_N_SURVEYS_STARTED = 'nSurveysStarted';
    const METRICS_N_SURVEYS_ABANDONED = 'nSurveysAbandoned';
    const METRICS_N_SURVEYS_EXPIRED = 'nSurveysExpired';
    const METRICS_N_SURVEY_ERRORS = 'nSurveyErrors';
    const METRICS_N_SURVEY_RESPONSES = 'nSurveyResponses';
    const METRICS_N_SURVEY_ANSWER_RESPONSES = 'nSurveyAnswerResponses';
    const METRICS_O_SURVEY_TOTAL_SCORE = 'oSurveyTotalScore';
    const METRICS_O_SURVEY_QUESTION_GROUP_SCORE = 'oSurveyQuestionGroupScore';
    const METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES = 'nSurveyQuestionGroupResponses';
    const METRICS_O_SURVEY_QUESTION_SCORE = 'oSurveyQuestionScore';
    const METRICS_N_SURVEY_QUESTION_RESPONSES = 'nSurveyQuestionResponses';
    const METRICS_N_SURVEY_NPS_RESPONSES = 'nSurveyNpsResponses';
    const METRICS_N_SURVEY_NPS_PROMOTERS = 'nSurveyNpsPromoters';
    const METRICS_N_SURVEY_NPS_DETRACTORS = 'nSurveyNpsDetractors';
    const METRICS_N_FLOW = 'nFlow';
    const METRICS_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    const METRICS_T_FLOW_EXIT = 'tFlowExit';
    const METRICS_T_FLOW = 'tFlow';
    const METRICS_O_FLOW = 'oFlow';
    const METRICS_T_FLOW_OUTCOME = 'tFlowOutcome';
    const METRICS_N_FLOW_OUTCOME = 'nFlowOutcome';
    const METRICS_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    const DETAIL_METRICS_T_SEGMENT_DURATION = 'tSegmentDuration';
    const DETAIL_METRICS_T_CONVERSATION_DURATION = 'tConversationDuration';
    const DETAIL_METRICS_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    const DETAIL_METRICS_O_TOTAL_SCORE = 'oTotalScore';
    const DETAIL_METRICS_N_EVALUATIONS = 'nEvaluations';
    const DETAIL_METRICS_T_ABANDON = 'tAbandon';
    const DETAIL_METRICS_T_IVR = 'tIvr';
    const DETAIL_METRICS_T_ANSWERED = 'tAnswered';
    const DETAIL_METRICS_T_FLOW_OUT = 'tFlowOut';
    const DETAIL_METRICS_T_ACD = 'tAcd';
    const DETAIL_METRICS_T_TALK = 'tTalk';
    const DETAIL_METRICS_T_HELD = 'tHeld';
    const DETAIL_METRICS_T_TALK_COMPLETE = 'tTalkComplete';
    const DETAIL_METRICS_T_HELD_COMPLETE = 'tHeldComplete';
    const DETAIL_METRICS_T_ACW = 'tAcw';
    const DETAIL_METRICS_T_HANDLE = 'tHandle';
    const DETAIL_METRICS_T_CONTACTING = 'tContacting';
    const DETAIL_METRICS_T_DIALING = 'tDialing';
    const DETAIL_METRICS_T_WAIT = 'tWait';
    const DETAIL_METRICS_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    const DETAIL_METRICS_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    const DETAIL_METRICS_T_SYSTEM_PRESENCE = 'tSystemPresence';
    const DETAIL_METRICS_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    const DETAIL_METRICS_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    const DETAIL_METRICS_T_VOICEMAIL = 'tVoicemail';
    const DETAIL_METRICS_N_STATE_TRANSITION_ERROR = 'nStateTransitionError';
    const DETAIL_METRICS_N_OFFERED = 'nOffered';
    const DETAIL_METRICS_N_OVER_SLA = 'nOverSla';
    const DETAIL_METRICS_N_TRANSFERRED = 'nTransferred';
    const DETAIL_METRICS_N_BLIND_TRANSFERRED = 'nBlindTransferred';
    const DETAIL_METRICS_N_CONSULT_TRANSFERRED = 'nConsultTransferred';
    const DETAIL_METRICS_N_CONSULT = 'nConsult';
    const DETAIL_METRICS_N_CONNECTED = 'nConnected';
    const DETAIL_METRICS_T_ALERT = 'tAlert';
    const DETAIL_METRICS_T_NOT_RESPONDING = 'tNotResponding';
    const DETAIL_METRICS_N_OUTBOUND = 'nOutbound';
    const DETAIL_METRICS_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    const DETAIL_METRICS_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    const DETAIL_METRICS_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    const DETAIL_METRICS_N_ERROR = 'nError';
    const DETAIL_METRICS_O_SERVICE_TARGET = 'oServiceTarget';
    const DETAIL_METRICS_O_SERVICE_LEVEL = 'oServiceLevel';
    const DETAIL_METRICS_T_ACTIVE = 'tActive';
    const DETAIL_METRICS_T_INACTIVE = 'tInactive';
    const DETAIL_METRICS_O_ACTIVE_USERS = 'oActiveUsers';
    const DETAIL_METRICS_O_MEMBER_USERS = 'oMemberUsers';
    const DETAIL_METRICS_O_ACTIVE_QUEUES = 'oActiveQueues';
    const DETAIL_METRICS_O_MEMBER_QUEUES = 'oMemberQueues';
    const DETAIL_METRICS_O_INTERACTING = 'oInteracting';
    const DETAIL_METRICS_O_WAITING = 'oWaiting';
    const DETAIL_METRICS_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    const DETAIL_METRICS_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    const DETAIL_METRICS_O_USER_PRESENCES = 'oUserPresences';
    const DETAIL_METRICS_O_USER_ROUTING_STATUSES = 'oUserRoutingStatuses';
    const DETAIL_METRICS_N_SURVEYS_SENT = 'nSurveysSent';
    const DETAIL_METRICS_N_SURVEYS_STARTED = 'nSurveysStarted';
    const DETAIL_METRICS_N_SURVEYS_ABANDONED = 'nSurveysAbandoned';
    const DETAIL_METRICS_N_SURVEYS_EXPIRED = 'nSurveysExpired';
    const DETAIL_METRICS_N_SURVEY_ERRORS = 'nSurveyErrors';
    const DETAIL_METRICS_N_SURVEY_RESPONSES = 'nSurveyResponses';
    const DETAIL_METRICS_N_SURVEY_ANSWER_RESPONSES = 'nSurveyAnswerResponses';
    const DETAIL_METRICS_O_SURVEY_TOTAL_SCORE = 'oSurveyTotalScore';
    const DETAIL_METRICS_O_SURVEY_QUESTION_GROUP_SCORE = 'oSurveyQuestionGroupScore';
    const DETAIL_METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES = 'nSurveyQuestionGroupResponses';
    const DETAIL_METRICS_O_SURVEY_QUESTION_SCORE = 'oSurveyQuestionScore';
    const DETAIL_METRICS_N_SURVEY_QUESTION_RESPONSES = 'nSurveyQuestionResponses';
    const DETAIL_METRICS_N_SURVEY_NPS_RESPONSES = 'nSurveyNpsResponses';
    const DETAIL_METRICS_N_SURVEY_NPS_PROMOTERS = 'nSurveyNpsPromoters';
    const DETAIL_METRICS_N_SURVEY_NPS_DETRACTORS = 'nSurveyNpsDetractors';
    const DETAIL_METRICS_N_FLOW = 'nFlow';
    const DETAIL_METRICS_T_FLOW_DISCONNECT = 'tFlowDisconnect';
    const DETAIL_METRICS_T_FLOW_EXIT = 'tFlowExit';
    const DETAIL_METRICS_T_FLOW = 'tFlow';
    const DETAIL_METRICS_O_FLOW = 'oFlow';
    const DETAIL_METRICS_T_FLOW_OUTCOME = 'tFlowOutcome';
    const DETAIL_METRICS_N_FLOW_OUTCOME = 'nFlowOutcome';
    const DETAIL_METRICS_N_FLOW_OUTCOME_FAILED = 'nFlowOutcomeFailed';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricsAllowableValues()
    {
        return [
            self::METRICS_T_SEGMENT_DURATION,
            self::METRICS_T_CONVERSATION_DURATION,
            self::METRICS_O_TOTAL_CRITICAL_SCORE,
            self::METRICS_O_TOTAL_SCORE,
            self::METRICS_N_EVALUATIONS,
            self::METRICS_T_ABANDON,
            self::METRICS_T_IVR,
            self::METRICS_T_ANSWERED,
            self::METRICS_T_FLOW_OUT,
            self::METRICS_T_ACD,
            self::METRICS_T_TALK,
            self::METRICS_T_HELD,
            self::METRICS_T_TALK_COMPLETE,
            self::METRICS_T_HELD_COMPLETE,
            self::METRICS_T_ACW,
            self::METRICS_T_HANDLE,
            self::METRICS_T_CONTACTING,
            self::METRICS_T_DIALING,
            self::METRICS_T_WAIT,
            self::METRICS_T_AGENT_ROUTING_STATUS,
            self::METRICS_T_ORGANIZATION_PRESENCE,
            self::METRICS_T_SYSTEM_PRESENCE,
            self::METRICS_T_USER_RESPONSE_TIME,
            self::METRICS_T_AGENT_RESPONSE_TIME,
            self::METRICS_T_VOICEMAIL,
            self::METRICS_N_STATE_TRANSITION_ERROR,
            self::METRICS_N_OFFERED,
            self::METRICS_N_OVER_SLA,
            self::METRICS_N_TRANSFERRED,
            self::METRICS_N_BLIND_TRANSFERRED,
            self::METRICS_N_CONSULT_TRANSFERRED,
            self::METRICS_N_CONSULT,
            self::METRICS_N_CONNECTED,
            self::METRICS_T_ALERT,
            self::METRICS_T_NOT_RESPONDING,
            self::METRICS_N_OUTBOUND,
            self::METRICS_N_OUTBOUND_ATTEMPTED,
            self::METRICS_N_OUTBOUND_CONNECTED,
            self::METRICS_N_OUTBOUND_ABANDONED,
            self::METRICS_N_ERROR,
            self::METRICS_O_SERVICE_TARGET,
            self::METRICS_O_SERVICE_LEVEL,
            self::METRICS_T_ACTIVE,
            self::METRICS_T_INACTIVE,
            self::METRICS_O_ACTIVE_USERS,
            self::METRICS_O_MEMBER_USERS,
            self::METRICS_O_ACTIVE_QUEUES,
            self::METRICS_O_MEMBER_QUEUES,
            self::METRICS_O_INTERACTING,
            self::METRICS_O_WAITING,
            self::METRICS_O_ON_QUEUE_USERS,
            self::METRICS_O_OFF_QUEUE_USERS,
            self::METRICS_O_USER_PRESENCES,
            self::METRICS_O_USER_ROUTING_STATUSES,
            self::METRICS_N_SURVEYS_SENT,
            self::METRICS_N_SURVEYS_STARTED,
            self::METRICS_N_SURVEYS_ABANDONED,
            self::METRICS_N_SURVEYS_EXPIRED,
            self::METRICS_N_SURVEY_ERRORS,
            self::METRICS_N_SURVEY_RESPONSES,
            self::METRICS_N_SURVEY_ANSWER_RESPONSES,
            self::METRICS_O_SURVEY_TOTAL_SCORE,
            self::METRICS_O_SURVEY_QUESTION_GROUP_SCORE,
            self::METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES,
            self::METRICS_O_SURVEY_QUESTION_SCORE,
            self::METRICS_N_SURVEY_QUESTION_RESPONSES,
            self::METRICS_N_SURVEY_NPS_RESPONSES,
            self::METRICS_N_SURVEY_NPS_PROMOTERS,
            self::METRICS_N_SURVEY_NPS_DETRACTORS,
            self::METRICS_N_FLOW,
            self::METRICS_T_FLOW_DISCONNECT,
            self::METRICS_T_FLOW_EXIT,
            self::METRICS_T_FLOW,
            self::METRICS_O_FLOW,
            self::METRICS_T_FLOW_OUTCOME,
            self::METRICS_N_FLOW_OUTCOME,
            self::METRICS_N_FLOW_OUTCOME_FAILED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDetailMetricsAllowableValues()
    {
        return [
            self::DETAIL_METRICS_T_SEGMENT_DURATION,
            self::DETAIL_METRICS_T_CONVERSATION_DURATION,
            self::DETAIL_METRICS_O_TOTAL_CRITICAL_SCORE,
            self::DETAIL_METRICS_O_TOTAL_SCORE,
            self::DETAIL_METRICS_N_EVALUATIONS,
            self::DETAIL_METRICS_T_ABANDON,
            self::DETAIL_METRICS_T_IVR,
            self::DETAIL_METRICS_T_ANSWERED,
            self::DETAIL_METRICS_T_FLOW_OUT,
            self::DETAIL_METRICS_T_ACD,
            self::DETAIL_METRICS_T_TALK,
            self::DETAIL_METRICS_T_HELD,
            self::DETAIL_METRICS_T_TALK_COMPLETE,
            self::DETAIL_METRICS_T_HELD_COMPLETE,
            self::DETAIL_METRICS_T_ACW,
            self::DETAIL_METRICS_T_HANDLE,
            self::DETAIL_METRICS_T_CONTACTING,
            self::DETAIL_METRICS_T_DIALING,
            self::DETAIL_METRICS_T_WAIT,
            self::DETAIL_METRICS_T_AGENT_ROUTING_STATUS,
            self::DETAIL_METRICS_T_ORGANIZATION_PRESENCE,
            self::DETAIL_METRICS_T_SYSTEM_PRESENCE,
            self::DETAIL_METRICS_T_USER_RESPONSE_TIME,
            self::DETAIL_METRICS_T_AGENT_RESPONSE_TIME,
            self::DETAIL_METRICS_T_VOICEMAIL,
            self::DETAIL_METRICS_N_STATE_TRANSITION_ERROR,
            self::DETAIL_METRICS_N_OFFERED,
            self::DETAIL_METRICS_N_OVER_SLA,
            self::DETAIL_METRICS_N_TRANSFERRED,
            self::DETAIL_METRICS_N_BLIND_TRANSFERRED,
            self::DETAIL_METRICS_N_CONSULT_TRANSFERRED,
            self::DETAIL_METRICS_N_CONSULT,
            self::DETAIL_METRICS_N_CONNECTED,
            self::DETAIL_METRICS_T_ALERT,
            self::DETAIL_METRICS_T_NOT_RESPONDING,
            self::DETAIL_METRICS_N_OUTBOUND,
            self::DETAIL_METRICS_N_OUTBOUND_ATTEMPTED,
            self::DETAIL_METRICS_N_OUTBOUND_CONNECTED,
            self::DETAIL_METRICS_N_OUTBOUND_ABANDONED,
            self::DETAIL_METRICS_N_ERROR,
            self::DETAIL_METRICS_O_SERVICE_TARGET,
            self::DETAIL_METRICS_O_SERVICE_LEVEL,
            self::DETAIL_METRICS_T_ACTIVE,
            self::DETAIL_METRICS_T_INACTIVE,
            self::DETAIL_METRICS_O_ACTIVE_USERS,
            self::DETAIL_METRICS_O_MEMBER_USERS,
            self::DETAIL_METRICS_O_ACTIVE_QUEUES,
            self::DETAIL_METRICS_O_MEMBER_QUEUES,
            self::DETAIL_METRICS_O_INTERACTING,
            self::DETAIL_METRICS_O_WAITING,
            self::DETAIL_METRICS_O_ON_QUEUE_USERS,
            self::DETAIL_METRICS_O_OFF_QUEUE_USERS,
            self::DETAIL_METRICS_O_USER_PRESENCES,
            self::DETAIL_METRICS_O_USER_ROUTING_STATUSES,
            self::DETAIL_METRICS_N_SURVEYS_SENT,
            self::DETAIL_METRICS_N_SURVEYS_STARTED,
            self::DETAIL_METRICS_N_SURVEYS_ABANDONED,
            self::DETAIL_METRICS_N_SURVEYS_EXPIRED,
            self::DETAIL_METRICS_N_SURVEY_ERRORS,
            self::DETAIL_METRICS_N_SURVEY_RESPONSES,
            self::DETAIL_METRICS_N_SURVEY_ANSWER_RESPONSES,
            self::DETAIL_METRICS_O_SURVEY_TOTAL_SCORE,
            self::DETAIL_METRICS_O_SURVEY_QUESTION_GROUP_SCORE,
            self::DETAIL_METRICS_N_SURVEY_QUESTION_GROUP_RESPONSES,
            self::DETAIL_METRICS_O_SURVEY_QUESTION_SCORE,
            self::DETAIL_METRICS_N_SURVEY_QUESTION_RESPONSES,
            self::DETAIL_METRICS_N_SURVEY_NPS_RESPONSES,
            self::DETAIL_METRICS_N_SURVEY_NPS_PROMOTERS,
            self::DETAIL_METRICS_N_SURVEY_NPS_DETRACTORS,
            self::DETAIL_METRICS_N_FLOW,
            self::DETAIL_METRICS_T_FLOW_DISCONNECT,
            self::DETAIL_METRICS_T_FLOW_EXIT,
            self::DETAIL_METRICS_T_FLOW,
            self::DETAIL_METRICS_O_FLOW,
            self::DETAIL_METRICS_T_FLOW_OUTCOME,
            self::DETAIL_METRICS_N_FLOW_OUTCOME,
            self::DETAIL_METRICS_N_FLOW_OUTCOME_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['filter'] = isset($data['filter']) ? $data['filter'] : null;
        $this->container['metrics'] = isset($data['metrics']) ? $data['metrics'] : null;
        $this->container['detailMetrics'] = isset($data['detailMetrics']) ? $data['detailMetrics'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['filter'] === null) {
            $invalid_properties[] = "'filter' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['filter'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets filter
     * @return \PureCloudSDK\AnalyticsQueryFilter
     */
    public function getFilter()
    {
        return $this->container['filter'];
    }

    /**
     * Sets filter
     * @param \PureCloudSDK\AnalyticsQueryFilter $filter Filter to return a subset of observations. Expresses boolean logical predicates as well as dimensional filters
     * @return $this
     */
    public function setFilter($filter)
    {
        $this->container['filter'] = $filter;

        return $this;
    }

    /**
     * Gets metrics
     * @return string[]
     */
    public function getMetrics()
    {
        return $this->container['metrics'];
    }

    /**
     * Sets metrics
     * @param string[] $metrics Behaves like a SQL SELECT clause. Enables retrieving only named metrics. If omitted, all metrics that are available will be returned (like SELECT *).
     * @return $this
     */
    public function setMetrics($metrics)
    {
        $allowed_values = array('tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed');
        if (!in_array($metrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metrics', must be one of 'tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed'");
        }
        $this->container['metrics'] = $metrics;

        return $this;
    }

    /**
     * Gets detailMetrics
     * @return string[]
     */
    public function getDetailMetrics()
    {
        return $this->container['detailMetrics'];
    }

    /**
     * Sets detailMetrics
     * @param string[] $detailMetrics Metrics for which to include additional detailed observations
     * @return $this
     */
    public function setDetailMetrics($detailMetrics)
    {
        $allowed_values = array('tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed');
        if (!in_array($detailMetrics, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'detailMetrics', must be one of 'tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tFlowOut', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tContacting', 'tDialing', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'tVoicemail', 'nStateTransitionError', 'nOffered', 'nOverSla', 'nTransferred', 'nBlindTransferred', 'nConsultTransferred', 'nConsult', 'nConnected', 'tAlert', 'tNotResponding', 'nOutbound', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers', 'oUserPresences', 'oUserRoutingStatuses', 'nSurveysSent', 'nSurveysStarted', 'nSurveysAbandoned', 'nSurveysExpired', 'nSurveyErrors', 'nSurveyResponses', 'nSurveyAnswerResponses', 'oSurveyTotalScore', 'oSurveyQuestionGroupScore', 'nSurveyQuestionGroupResponses', 'oSurveyQuestionScore', 'nSurveyQuestionResponses', 'nSurveyNpsResponses', 'nSurveyNpsPromoters', 'nSurveyNpsDetractors', 'nFlow', 'tFlowDisconnect', 'tFlowExit', 'tFlow', 'oFlow', 'tFlowOutcome', 'nFlowOutcome', 'nFlowOutcomeFailed'");
        }
        $this->container['detailMetrics'] = $detailMetrics;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


