<?php
/**
 * PredictionResults
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PredictionResults Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PredictionResults implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PredictionResults';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'intent' => 'string',
        'formula' => 'string',
        'estimatedWaitTimeSeconds' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'intent' => 'intent',
        'formula' => 'formula',
        'estimatedWaitTimeSeconds' => 'estimatedWaitTimeSeconds'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'intent' => 'setIntent',
        'formula' => 'setFormula',
        'estimatedWaitTimeSeconds' => 'setEstimatedWaitTimeSeconds'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'intent' => 'getIntent',
        'formula' => 'getFormula',
        'estimatedWaitTimeSeconds' => 'getEstimatedWaitTimeSeconds'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const INTENT_ALL = 'ALL';
    const INTENT_CALL = 'CALL';
    const INTENT_CALLBACK = 'CALLBACK';
    const INTENT_CHAT = 'CHAT';
    const INTENT_EMAIL = 'EMAIL';
    const INTENT_SOCIALEXPRESSION = 'SOCIALEXPRESSION';
    const INTENT_VIDEOCOMM = 'VIDEOCOMM';
    const INTENT_MESSAGE = 'MESSAGE';
    const FORMULA_BEST = 'BEST';
    const FORMULA_SIMPLE = 'SIMPLE';
    const FORMULA_ABANDON = 'ABANDON';
    const FORMULA_PATIENCE_ABANDON = 'PATIENCE_ABANDON';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getIntentAllowableValues()
    {
        return [
            self::INTENT_ALL,
            self::INTENT_CALL,
            self::INTENT_CALLBACK,
            self::INTENT_CHAT,
            self::INTENT_EMAIL,
            self::INTENT_SOCIALEXPRESSION,
            self::INTENT_VIDEOCOMM,
            self::INTENT_MESSAGE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFormulaAllowableValues()
    {
        return [
            self::FORMULA_BEST,
            self::FORMULA_SIMPLE,
            self::FORMULA_ABANDON,
            self::FORMULA_PATIENCE_ABANDON,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['intent'] = isset($data['intent']) ? $data['intent'] : null;
        $this->container['formula'] = isset($data['formula']) ? $data['formula'] : null;
        $this->container['estimatedWaitTimeSeconds'] = isset($data['estimatedWaitTimeSeconds']) ? $data['estimatedWaitTimeSeconds'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("ALL", "CALL", "CALLBACK", "CHAT", "EMAIL", "SOCIALEXPRESSION", "VIDEOCOMM", "MESSAGE");
        if (!in_array($this->container['intent'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'intent', must be one of #{allowed_values}.";
        }

        if ($this->container['formula'] === null) {
            $invalid_properties[] = "'formula' can't be null";
        }
        $allowed_values = array("BEST", "SIMPLE", "ABANDON", "PATIENCE_ABANDON");
        if (!in_array($this->container['formula'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'formula', must be one of #{allowed_values}.";
        }

        if ($this->container['estimatedWaitTimeSeconds'] === null) {
            $invalid_properties[] = "'estimatedWaitTimeSeconds' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("ALL", "CALL", "CALLBACK", "CHAT", "EMAIL", "SOCIALEXPRESSION", "VIDEOCOMM", "MESSAGE");
        if (!in_array($this->container['intent'], $allowed_values)) {
            return false;
        }
        if ($this->container['formula'] === null) {
            return false;
        }
        $allowed_values = array("BEST", "SIMPLE", "ABANDON", "PATIENCE_ABANDON");
        if (!in_array($this->container['formula'], $allowed_values)) {
            return false;
        }
        if ($this->container['estimatedWaitTimeSeconds'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets intent
     * @return string
     */
    public function getIntent()
    {
        return $this->container['intent'];
    }

    /**
     * Sets intent
     * @param string $intent Indicates the media type scope of this estimated wait time
     * @return $this
     */
    public function setIntent($intent)
    {
        $allowed_values = array('ALL', 'CALL', 'CALLBACK', 'CHAT', 'EMAIL', 'SOCIALEXPRESSION', 'VIDEOCOMM', 'MESSAGE');
        if (!in_array($intent, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'intent', must be one of 'ALL', 'CALL', 'CALLBACK', 'CHAT', 'EMAIL', 'SOCIALEXPRESSION', 'VIDEOCOMM', 'MESSAGE'");
        }
        $this->container['intent'] = $intent;

        return $this;
    }

    /**
     * Gets formula
     * @return string
     */
    public function getFormula()
    {
        return $this->container['formula'];
    }

    /**
     * Sets formula
     * @param string $formula Indicates the estimated wait time Formula
     * @return $this
     */
    public function setFormula($formula)
    {
        $allowed_values = array('BEST', 'SIMPLE', 'ABANDON', 'PATIENCE_ABANDON');
        if (!in_array($formula, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'formula', must be one of 'BEST', 'SIMPLE', 'ABANDON', 'PATIENCE_ABANDON'");
        }
        $this->container['formula'] = $formula;

        return $this;
    }

    /**
     * Gets estimatedWaitTimeSeconds
     * @return int
     */
    public function getEstimatedWaitTimeSeconds()
    {
        return $this->container['estimatedWaitTimeSeconds'];
    }

    /**
     * Sets estimatedWaitTimeSeconds
     * @param int $estimatedWaitTimeSeconds Estimated wait time in seconds
     * @return $this
     */
    public function setEstimatedWaitTimeSeconds($estimatedWaitTimeSeconds)
    {
        $this->container['estimatedWaitTimeSeconds'] = $estimatedWaitTimeSeconds;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


