<?php
/**
 * ScimV2User
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ScimV2User Class Doc Comment
 *
 * @category    Class */
 // @description Represents a SCIM V2 User
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ScimV2User implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ScimV2User';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'displayName' => 'string',
        'schemas' => 'string[]',
        'active' => 'bool',
        'userName' => 'string',
        'password' => 'string',
        'title' => 'string',
        'phoneNumbers' => '\PureCloudSDK\ScimPhoneNumber[]',
        'emails' => '\PureCloudSDK\ScimEmail[]',
        'photos' => '\PureCloudSDK\Photo[]',
        'groups' => '\PureCloudSDK\ScimV2GroupReference[]',
        'meta' => '\PureCloudSDK\ScimMetadata',
        'urnietfparamsscimschemasextensionenterprise20User' => '\PureCloudSDK\ScimV2EnterpriseUser'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'displayName' => 'displayName',
        'schemas' => 'schemas',
        'active' => 'active',
        'userName' => 'userName',
        'password' => 'password',
        'title' => 'title',
        'phoneNumbers' => 'phoneNumbers',
        'emails' => 'emails',
        'photos' => 'photos',
        'groups' => 'groups',
        'meta' => 'meta',
        'urnietfparamsscimschemasextensionenterprise20User' => 'urn:ietf:params:scim:schemas:extension:enterprise:2.0:User'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'displayName' => 'setDisplayName',
        'schemas' => 'setSchemas',
        'active' => 'setActive',
        'userName' => 'setUserName',
        'password' => 'setPassword',
        'title' => 'setTitle',
        'phoneNumbers' => 'setPhoneNumbers',
        'emails' => 'setEmails',
        'photos' => 'setPhotos',
        'groups' => 'setGroups',
        'meta' => 'setMeta',
        'urnietfparamsscimschemasextensionenterprise20User' => 'setUrnietfparamsscimschemasextensionenterprise20User'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'displayName' => 'getDisplayName',
        'schemas' => 'getSchemas',
        'active' => 'getActive',
        'userName' => 'getUserName',
        'password' => 'getPassword',
        'title' => 'getTitle',
        'phoneNumbers' => 'getPhoneNumbers',
        'emails' => 'getEmails',
        'photos' => 'getPhotos',
        'groups' => 'getGroups',
        'meta' => 'getMeta',
        'urnietfparamsscimschemasextensionenterprise20User' => 'getUrnietfparamsscimschemasextensionenterprise20User'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['displayName'] = isset($data['displayName']) ? $data['displayName'] : null;
        $this->container['schemas'] = isset($data['schemas']) ? $data['schemas'] : null;
        $this->container['active'] = isset($data['active']) ? $data['active'] : null;
        $this->container['userName'] = isset($data['userName']) ? $data['userName'] : null;
        $this->container['password'] = isset($data['password']) ? $data['password'] : null;
        $this->container['title'] = isset($data['title']) ? $data['title'] : null;
        $this->container['phoneNumbers'] = isset($data['phoneNumbers']) ? $data['phoneNumbers'] : null;
        $this->container['emails'] = isset($data['emails']) ? $data['emails'] : null;
        $this->container['photos'] = isset($data['photos']) ? $data['photos'] : null;
        $this->container['groups'] = isset($data['groups']) ? $data['groups'] : null;
        $this->container['meta'] = isset($data['meta']) ? $data['meta'] : null;
        $this->container['urnietfparamsscimschemasextensionenterprise20User'] = isset($data['urnietfparamsscimschemasextensionenterprise20User']) ? $data['urnietfparamsscimschemasextensionenterprise20User'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id SCIM Resource identifier
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets displayName
     * @return string
     */
    public function getDisplayName()
    {
        return $this->container['displayName'];
    }

    /**
     * Sets displayName
     * @param string $displayName Display Name
     * @return $this
     */
    public function setDisplayName($displayName)
    {
        $this->container['displayName'] = $displayName;

        return $this;
    }

    /**
     * Gets schemas
     * @return string[]
     */
    public function getSchemas()
    {
        return $this->container['schemas'];
    }

    /**
     * Sets schemas
     * @param string[] $schemas schemas supported
     * @return $this
     */
    public function setSchemas($schemas)
    {
        $this->container['schemas'] = $schemas;

        return $this;
    }

    /**
     * Gets active
     * @return bool
     */
    public function getActive()
    {
        return $this->container['active'];
    }

    /**
     * Sets active
     * @param bool $active Active flag
     * @return $this
     */
    public function setActive($active)
    {
        $this->container['active'] = $active;

        return $this;
    }

    /**
     * Gets userName
     * @return string
     */
    public function getUserName()
    {
        return $this->container['userName'];
    }

    /**
     * Sets userName
     * @param string $userName User Name (Must be Unique) maps to PureCloud e-mail address
     * @return $this
     */
    public function setUserName($userName)
    {
        $this->container['userName'] = $userName;

        return $this;
    }

    /**
     * Gets password
     * @return string
     */
    public function getPassword()
    {
        return $this->container['password'];
    }

    /**
     * Sets password
     * @param string $password Password (updateOnly)
     * @return $this
     */
    public function setPassword($password)
    {
        $this->container['password'] = $password;

        return $this;
    }

    /**
     * Gets title
     * @return string
     */
    public function getTitle()
    {
        return $this->container['title'];
    }

    /**
     * Sets title
     * @param string $title Title
     * @return $this
     */
    public function setTitle($title)
    {
        $this->container['title'] = $title;

        return $this;
    }

    /**
     * Gets phoneNumbers
     * @return \PureCloudSDK\ScimPhoneNumber[]
     */
    public function getPhoneNumbers()
    {
        return $this->container['phoneNumbers'];
    }

    /**
     * Sets phoneNumbers
     * @param \PureCloudSDK\ScimPhoneNumber[] $phoneNumbers Phone numbers
     * @return $this
     */
    public function setPhoneNumbers($phoneNumbers)
    {
        $this->container['phoneNumbers'] = $phoneNumbers;

        return $this;
    }

    /**
     * Gets emails
     * @return \PureCloudSDK\ScimEmail[]
     */
    public function getEmails()
    {
        return $this->container['emails'];
    }

    /**
     * Sets emails
     * @param \PureCloudSDK\ScimEmail[] $emails Emails
     * @return $this
     */
    public function setEmails($emails)
    {
        $this->container['emails'] = $emails;

        return $this;
    }

    /**
     * Gets photos
     * @return \PureCloudSDK\Photo[]
     */
    public function getPhotos()
    {
        return $this->container['photos'];
    }

    /**
     * Sets photos
     * @param \PureCloudSDK\Photo[] $photos Photos
     * @return $this
     */
    public function setPhotos($photos)
    {
        $this->container['photos'] = $photos;

        return $this;
    }

    /**
     * Gets groups
     * @return \PureCloudSDK\ScimV2GroupReference[]
     */
    public function getGroups()
    {
        return $this->container['groups'];
    }

    /**
     * Sets groups
     * @param \PureCloudSDK\ScimV2GroupReference[] $groups Group References
     * @return $this
     */
    public function setGroups($groups)
    {
        $this->container['groups'] = $groups;

        return $this;
    }

    /**
     * Gets meta
     * @return \PureCloudSDK\ScimMetadata
     */
    public function getMeta()
    {
        return $this->container['meta'];
    }

    /**
     * Sets meta
     * @param \PureCloudSDK\ScimMetadata $meta
     * @return $this
     */
    public function setMeta($meta)
    {
        $this->container['meta'] = $meta;

        return $this;
    }

    /**
     * Gets urnietfparamsscimschemasextensionenterprise20User
     * @return \PureCloudSDK\ScimV2EnterpriseUser
     */
    public function getUrnietfparamsscimschemasextensionenterprise20User()
    {
        return $this->container['urnietfparamsscimschemasextensionenterprise20User'];
    }

    /**
     * Sets urnietfparamsscimschemasextensionenterprise20User
     * @param \PureCloudSDK\ScimV2EnterpriseUser $urnietfparamsscimschemasextensionenterprise20User
     * @return $this
     */
    public function setUrnietfparamsscimschemasextensionenterprise20User($urnietfparamsscimschemasextensionenterprise20User)
    {
        $this->container['urnietfparamsscimschemasextensionenterprise20User'] = $urnietfparamsscimschemasextensionenterprise20User;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


