<?php
/**
 * ShiftTradeSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ShiftTradeSettings Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ShiftTradeSettings implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ShiftTradeSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'enabled' => 'bool',
        'autoReview' => 'bool',
        'allowDirectTrades' => 'bool',
        'minHoursInFuture' => 'int',
        'unequalPaid' => 'string',
        'oneSided' => 'string',
        'weeklyMinPaidViolations' => 'string',
        'weeklyMaxPaidViolations' => 'string',
        'requiresMatchingQueues' => 'bool',
        'requiresMatchingLanguages' => 'bool',
        'requiresMatchingSkills' => 'bool',
        'activityCategoryRules' => '\PureCloudSDK\ShiftTradeActivityRule[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'enabled' => 'enabled',
        'autoReview' => 'autoReview',
        'allowDirectTrades' => 'allowDirectTrades',
        'minHoursInFuture' => 'minHoursInFuture',
        'unequalPaid' => 'unequalPaid',
        'oneSided' => 'oneSided',
        'weeklyMinPaidViolations' => 'weeklyMinPaidViolations',
        'weeklyMaxPaidViolations' => 'weeklyMaxPaidViolations',
        'requiresMatchingQueues' => 'requiresMatchingQueues',
        'requiresMatchingLanguages' => 'requiresMatchingLanguages',
        'requiresMatchingSkills' => 'requiresMatchingSkills',
        'activityCategoryRules' => 'activityCategoryRules'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'enabled' => 'setEnabled',
        'autoReview' => 'setAutoReview',
        'allowDirectTrades' => 'setAllowDirectTrades',
        'minHoursInFuture' => 'setMinHoursInFuture',
        'unequalPaid' => 'setUnequalPaid',
        'oneSided' => 'setOneSided',
        'weeklyMinPaidViolations' => 'setWeeklyMinPaidViolations',
        'weeklyMaxPaidViolations' => 'setWeeklyMaxPaidViolations',
        'requiresMatchingQueues' => 'setRequiresMatchingQueues',
        'requiresMatchingLanguages' => 'setRequiresMatchingLanguages',
        'requiresMatchingSkills' => 'setRequiresMatchingSkills',
        'activityCategoryRules' => 'setActivityCategoryRules'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'enabled' => 'getEnabled',
        'autoReview' => 'getAutoReview',
        'allowDirectTrades' => 'getAllowDirectTrades',
        'minHoursInFuture' => 'getMinHoursInFuture',
        'unequalPaid' => 'getUnequalPaid',
        'oneSided' => 'getOneSided',
        'weeklyMinPaidViolations' => 'getWeeklyMinPaidViolations',
        'weeklyMaxPaidViolations' => 'getWeeklyMaxPaidViolations',
        'requiresMatchingQueues' => 'getRequiresMatchingQueues',
        'requiresMatchingLanguages' => 'getRequiresMatchingLanguages',
        'requiresMatchingSkills' => 'getRequiresMatchingSkills',
        'activityCategoryRules' => 'getActivityCategoryRules'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const UNEQUAL_PAID_ALLOW = 'Allow';
    const UNEQUAL_PAID_DISALLOW = 'Disallow';
    const UNEQUAL_PAID_ADMIN_REVIEW = 'AdminReview';
    const ONE_SIDED_ALLOW = 'Allow';
    const ONE_SIDED_DISALLOW = 'Disallow';
    const ONE_SIDED_ADMIN_REVIEW = 'AdminReview';
    const WEEKLY_MIN_PAID_VIOLATIONS_ALLOW = 'Allow';
    const WEEKLY_MIN_PAID_VIOLATIONS_DISALLOW = 'Disallow';
    const WEEKLY_MIN_PAID_VIOLATIONS_ADMIN_REVIEW = 'AdminReview';
    const WEEKLY_MAX_PAID_VIOLATIONS_ALLOW = 'Allow';
    const WEEKLY_MAX_PAID_VIOLATIONS_DISALLOW = 'Disallow';
    const WEEKLY_MAX_PAID_VIOLATIONS_ADMIN_REVIEW = 'AdminReview';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUnequalPaidAllowableValues()
    {
        return [
            self::UNEQUAL_PAID_ALLOW,
            self::UNEQUAL_PAID_DISALLOW,
            self::UNEQUAL_PAID_ADMIN_REVIEW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getOneSidedAllowableValues()
    {
        return [
            self::ONE_SIDED_ALLOW,
            self::ONE_SIDED_DISALLOW,
            self::ONE_SIDED_ADMIN_REVIEW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getWeeklyMinPaidViolationsAllowableValues()
    {
        return [
            self::WEEKLY_MIN_PAID_VIOLATIONS_ALLOW,
            self::WEEKLY_MIN_PAID_VIOLATIONS_DISALLOW,
            self::WEEKLY_MIN_PAID_VIOLATIONS_ADMIN_REVIEW,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getWeeklyMaxPaidViolationsAllowableValues()
    {
        return [
            self::WEEKLY_MAX_PAID_VIOLATIONS_ALLOW,
            self::WEEKLY_MAX_PAID_VIOLATIONS_DISALLOW,
            self::WEEKLY_MAX_PAID_VIOLATIONS_ADMIN_REVIEW,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : null;
        $this->container['autoReview'] = isset($data['autoReview']) ? $data['autoReview'] : null;
        $this->container['allowDirectTrades'] = isset($data['allowDirectTrades']) ? $data['allowDirectTrades'] : null;
        $this->container['minHoursInFuture'] = isset($data['minHoursInFuture']) ? $data['minHoursInFuture'] : null;
        $this->container['unequalPaid'] = isset($data['unequalPaid']) ? $data['unequalPaid'] : null;
        $this->container['oneSided'] = isset($data['oneSided']) ? $data['oneSided'] : null;
        $this->container['weeklyMinPaidViolations'] = isset($data['weeklyMinPaidViolations']) ? $data['weeklyMinPaidViolations'] : null;
        $this->container['weeklyMaxPaidViolations'] = isset($data['weeklyMaxPaidViolations']) ? $data['weeklyMaxPaidViolations'] : null;
        $this->container['requiresMatchingQueues'] = isset($data['requiresMatchingQueues']) ? $data['requiresMatchingQueues'] : null;
        $this->container['requiresMatchingLanguages'] = isset($data['requiresMatchingLanguages']) ? $data['requiresMatchingLanguages'] : null;
        $this->container['requiresMatchingSkills'] = isset($data['requiresMatchingSkills']) ? $data['requiresMatchingSkills'] : null;
        $this->container['activityCategoryRules'] = isset($data['activityCategoryRules']) ? $data['activityCategoryRules'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("Allow", "Disallow", "AdminReview");
        if (!in_array($this->container['unequalPaid'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'unequalPaid', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Allow", "Disallow", "AdminReview");
        if (!in_array($this->container['oneSided'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'oneSided', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Allow", "Disallow", "AdminReview");
        if (!in_array($this->container['weeklyMinPaidViolations'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'weeklyMinPaidViolations', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Allow", "Disallow", "AdminReview");
        if (!in_array($this->container['weeklyMaxPaidViolations'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'weeklyMaxPaidViolations', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("Allow", "Disallow", "AdminReview");
        if (!in_array($this->container['unequalPaid'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Allow", "Disallow", "AdminReview");
        if (!in_array($this->container['oneSided'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Allow", "Disallow", "AdminReview");
        if (!in_array($this->container['weeklyMinPaidViolations'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Allow", "Disallow", "AdminReview");
        if (!in_array($this->container['weeklyMaxPaidViolations'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled Whether shift trading is enabled for this management unit
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets autoReview
     * @return bool
     */
    public function getAutoReview()
    {
        return $this->container['autoReview'];
    }

    /**
     * Sets autoReview
     * @param bool $autoReview Whether automatic shift trade review is enabled according to the rules defined in for this management unit
     * @return $this
     */
    public function setAutoReview($autoReview)
    {
        $this->container['autoReview'] = $autoReview;

        return $this;
    }

    /**
     * Gets allowDirectTrades
     * @return bool
     */
    public function getAllowDirectTrades()
    {
        return $this->container['allowDirectTrades'];
    }

    /**
     * Sets allowDirectTrades
     * @param bool $allowDirectTrades Whether direct shift trades between agents are allowed
     * @return $this
     */
    public function setAllowDirectTrades($allowDirectTrades)
    {
        $this->container['allowDirectTrades'] = $allowDirectTrades;

        return $this;
    }

    /**
     * Gets minHoursInFuture
     * @return int
     */
    public function getMinHoursInFuture()
    {
        return $this->container['minHoursInFuture'];
    }

    /**
     * Sets minHoursInFuture
     * @param int $minHoursInFuture The minimum number of hours in the future shift trades are allowed
     * @return $this
     */
    public function setMinHoursInFuture($minHoursInFuture)
    {
        $this->container['minHoursInFuture'] = $minHoursInFuture;

        return $this;
    }

    /**
     * Gets unequalPaid
     * @return string
     */
    public function getUnequalPaid()
    {
        return $this->container['unequalPaid'];
    }

    /**
     * Sets unequalPaid
     * @param string $unequalPaid How to handle shift trades which involve unequal paid times
     * @return $this
     */
    public function setUnequalPaid($unequalPaid)
    {
        $allowed_values = array('Allow', 'Disallow', 'AdminReview');
        if (!in_array($unequalPaid, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'unequalPaid', must be one of 'Allow', 'Disallow', 'AdminReview'");
        }
        $this->container['unequalPaid'] = $unequalPaid;

        return $this;
    }

    /**
     * Gets oneSided
     * @return string
     */
    public function getOneSided()
    {
        return $this->container['oneSided'];
    }

    /**
     * Sets oneSided
     * @param string $oneSided How to handle one-sided shift trades
     * @return $this
     */
    public function setOneSided($oneSided)
    {
        $allowed_values = array('Allow', 'Disallow', 'AdminReview');
        if (!in_array($oneSided, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'oneSided', must be one of 'Allow', 'Disallow', 'AdminReview'");
        }
        $this->container['oneSided'] = $oneSided;

        return $this;
    }

    /**
     * Gets weeklyMinPaidViolations
     * @return string
     */
    public function getWeeklyMinPaidViolations()
    {
        return $this->container['weeklyMinPaidViolations'];
    }

    /**
     * Sets weeklyMinPaidViolations
     * @param string $weeklyMinPaidViolations How to handle shift trades which result in violations of weekly minimum paid time constraint
     * @return $this
     */
    public function setWeeklyMinPaidViolations($weeklyMinPaidViolations)
    {
        $allowed_values = array('Allow', 'Disallow', 'AdminReview');
        if (!in_array($weeklyMinPaidViolations, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'weeklyMinPaidViolations', must be one of 'Allow', 'Disallow', 'AdminReview'");
        }
        $this->container['weeklyMinPaidViolations'] = $weeklyMinPaidViolations;

        return $this;
    }

    /**
     * Gets weeklyMaxPaidViolations
     * @return string
     */
    public function getWeeklyMaxPaidViolations()
    {
        return $this->container['weeklyMaxPaidViolations'];
    }

    /**
     * Sets weeklyMaxPaidViolations
     * @param string $weeklyMaxPaidViolations How to handle shift trades which result in violations of weekly maximum paid time constraint
     * @return $this
     */
    public function setWeeklyMaxPaidViolations($weeklyMaxPaidViolations)
    {
        $allowed_values = array('Allow', 'Disallow', 'AdminReview');
        if (!in_array($weeklyMaxPaidViolations, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'weeklyMaxPaidViolations', must be one of 'Allow', 'Disallow', 'AdminReview'");
        }
        $this->container['weeklyMaxPaidViolations'] = $weeklyMaxPaidViolations;

        return $this;
    }

    /**
     * Gets requiresMatchingQueues
     * @return bool
     */
    public function getRequiresMatchingQueues()
    {
        return $this->container['requiresMatchingQueues'];
    }

    /**
     * Sets requiresMatchingQueues
     * @param bool $requiresMatchingQueues Whether to constrain shift trades to agents with matching queues
     * @return $this
     */
    public function setRequiresMatchingQueues($requiresMatchingQueues)
    {
        $this->container['requiresMatchingQueues'] = $requiresMatchingQueues;

        return $this;
    }

    /**
     * Gets requiresMatchingLanguages
     * @return bool
     */
    public function getRequiresMatchingLanguages()
    {
        return $this->container['requiresMatchingLanguages'];
    }

    /**
     * Sets requiresMatchingLanguages
     * @param bool $requiresMatchingLanguages Whether to constrain shift trades to agents with matching languages
     * @return $this
     */
    public function setRequiresMatchingLanguages($requiresMatchingLanguages)
    {
        $this->container['requiresMatchingLanguages'] = $requiresMatchingLanguages;

        return $this;
    }

    /**
     * Gets requiresMatchingSkills
     * @return bool
     */
    public function getRequiresMatchingSkills()
    {
        return $this->container['requiresMatchingSkills'];
    }

    /**
     * Sets requiresMatchingSkills
     * @param bool $requiresMatchingSkills Whether to constrain shift trades to agents with matching skills
     * @return $this
     */
    public function setRequiresMatchingSkills($requiresMatchingSkills)
    {
        $this->container['requiresMatchingSkills'] = $requiresMatchingSkills;

        return $this;
    }

    /**
     * Gets activityCategoryRules
     * @return \PureCloudSDK\ShiftTradeActivityRule[]
     */
    public function getActivityCategoryRules()
    {
        return $this->container['activityCategoryRules'];
    }

    /**
     * Sets activityCategoryRules
     * @param \PureCloudSDK\ShiftTradeActivityRule[] $activityCategoryRules Rules that specify what to do with activity categories that are part of a shift defined in a trade
     * @return $this
     */
    public function setActivityCategoryRules($activityCategoryRules)
    {
        $this->container['activityCategoryRules'] = $activityCategoryRules;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


