<?php
/**
 * SubscriptionOverviewUsage
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@genesys.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * SubscriptionOverviewUsage Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class SubscriptionOverviewUsage implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'SubscriptionOverviewUsage';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'name' => 'string',
        'partNumber' => 'string',
        'grouping' => 'string',
        'unitOfMeasureType' => 'string',
        'usageQuantity' => 'string',
        'overagePrice' => 'string',
        'prepayQuantity' => 'string',
        'prepayPrice' => 'string',
        'usageNotes' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'name' => 'name',
        'partNumber' => 'partNumber',
        'grouping' => 'grouping',
        'unitOfMeasureType' => 'unitOfMeasureType',
        'usageQuantity' => 'usageQuantity',
        'overagePrice' => 'overagePrice',
        'prepayQuantity' => 'prepayQuantity',
        'prepayPrice' => 'prepayPrice',
        'usageNotes' => 'usageNotes'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'name' => 'setName',
        'partNumber' => 'setPartNumber',
        'grouping' => 'setGrouping',
        'unitOfMeasureType' => 'setUnitOfMeasureType',
        'usageQuantity' => 'setUsageQuantity',
        'overagePrice' => 'setOveragePrice',
        'prepayQuantity' => 'setPrepayQuantity',
        'prepayPrice' => 'setPrepayPrice',
        'usageNotes' => 'setUsageNotes'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'name' => 'getName',
        'partNumber' => 'getPartNumber',
        'grouping' => 'getGrouping',
        'unitOfMeasureType' => 'getUnitOfMeasureType',
        'usageQuantity' => 'getUsageQuantity',
        'overagePrice' => 'getOveragePrice',
        'prepayQuantity' => 'getPrepayQuantity',
        'prepayPrice' => 'getPrepayPrice',
        'usageNotes' => 'getUsageNotes'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['partNumber'] = isset($data['partNumber']) ? $data['partNumber'] : null;
        $this->container['grouping'] = isset($data['grouping']) ? $data['grouping'] : null;
        $this->container['unitOfMeasureType'] = isset($data['unitOfMeasureType']) ? $data['unitOfMeasureType'] : null;
        $this->container['usageQuantity'] = isset($data['usageQuantity']) ? $data['usageQuantity'] : null;
        $this->container['overagePrice'] = isset($data['overagePrice']) ? $data['overagePrice'] : null;
        $this->container['prepayQuantity'] = isset($data['prepayQuantity']) ? $data['prepayQuantity'] : null;
        $this->container['prepayPrice'] = isset($data['prepayPrice']) ? $data['prepayPrice'] : null;
        $this->container['usageNotes'] = isset($data['usageNotes']) ? $data['usageNotes'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['name'] === null) {
            $invalid_properties[] = "'name' can't be null";
        }
        if ($this->container['partNumber'] === null) {
            $invalid_properties[] = "'partNumber' can't be null";
        }
        if ($this->container['grouping'] === null) {
            $invalid_properties[] = "'grouping' can't be null";
        }
        if ($this->container['unitOfMeasureType'] === null) {
            $invalid_properties[] = "'unitOfMeasureType' can't be null";
        }
        if ($this->container['usageQuantity'] === null) {
            $invalid_properties[] = "'usageQuantity' can't be null";
        }
        if ($this->container['prepayQuantity'] === null) {
            $invalid_properties[] = "'prepayQuantity' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['name'] === null) {
            return false;
        }
        if ($this->container['partNumber'] === null) {
            return false;
        }
        if ($this->container['grouping'] === null) {
            return false;
        }
        if ($this->container['unitOfMeasureType'] === null) {
            return false;
        }
        if ($this->container['usageQuantity'] === null) {
            return false;
        }
        if ($this->container['prepayQuantity'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name Product charge name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets partNumber
     * @return string
     */
    public function getPartNumber()
    {
        return $this->container['partNumber'];
    }

    /**
     * Sets partNumber
     * @param string $partNumber Product part number
     * @return $this
     */
    public function setPartNumber($partNumber)
    {
        $this->container['partNumber'] = $partNumber;

        return $this;
    }

    /**
     * Gets grouping
     * @return string
     */
    public function getGrouping()
    {
        return $this->container['grouping'];
    }

    /**
     * Sets grouping
     * @param string $grouping UI grouping key
     * @return $this
     */
    public function setGrouping($grouping)
    {
        $this->container['grouping'] = $grouping;

        return $this;
    }

    /**
     * Gets unitOfMeasureType
     * @return string
     */
    public function getUnitOfMeasureType()
    {
        return $this->container['unitOfMeasureType'];
    }

    /**
     * Sets unitOfMeasureType
     * @param string $unitOfMeasureType UI unit of measure
     * @return $this
     */
    public function setUnitOfMeasureType($unitOfMeasureType)
    {
        $this->container['unitOfMeasureType'] = $unitOfMeasureType;

        return $this;
    }

    /**
     * Gets usageQuantity
     * @return string
     */
    public function getUsageQuantity()
    {
        return $this->container['usageQuantity'];
    }

    /**
     * Sets usageQuantity
     * @param string $usageQuantity Usage count for specified period
     * @return $this
     */
    public function setUsageQuantity($usageQuantity)
    {
        $this->container['usageQuantity'] = $usageQuantity;

        return $this;
    }

    /**
     * Gets overagePrice
     * @return string
     */
    public function getOveragePrice()
    {
        return $this->container['overagePrice'];
    }

    /**
     * Sets overagePrice
     * @param string $overagePrice Price for usage / overage charge
     * @return $this
     */
    public function setOveragePrice($overagePrice)
    {
        $this->container['overagePrice'] = $overagePrice;

        return $this;
    }

    /**
     * Gets prepayQuantity
     * @return string
     */
    public function getPrepayQuantity()
    {
        return $this->container['prepayQuantity'];
    }

    /**
     * Sets prepayQuantity
     * @param string $prepayQuantity Items prepaid for specified period
     * @return $this
     */
    public function setPrepayQuantity($prepayQuantity)
    {
        $this->container['prepayQuantity'] = $prepayQuantity;

        return $this;
    }

    /**
     * Gets prepayPrice
     * @return string
     */
    public function getPrepayPrice()
    {
        return $this->container['prepayPrice'];
    }

    /**
     * Sets prepayPrice
     * @param string $prepayPrice Price for prepay charge
     * @return $this
     */
    public function setPrepayPrice($prepayPrice)
    {
        $this->container['prepayPrice'] = $prepayPrice;

        return $this;
    }

    /**
     * Gets usageNotes
     * @return string
     */
    public function getUsageNotes()
    {
        return $this->container['usageNotes'];
    }

    /**
     * Sets usageNotes
     * @param string $usageNotes Notes about the usage/charge item
     * @return $this
     */
    public function setUsageNotes($usageNotes)
    {
        $this->container['usageNotes'] = $usageNotes;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


