<?php
/**
 * AcwSettings
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AcwSettings Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AcwSettings implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AcwSettings';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'wrapupPrompt' => 'string',
        'timeoutMs' => 'int'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'wrapupPrompt' => 'wrapupPrompt',
        'timeoutMs' => 'timeoutMs'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'wrapupPrompt' => 'setWrapupPrompt',
        'timeoutMs' => 'setTimeoutMs'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'wrapupPrompt' => 'getWrapupPrompt',
        'timeoutMs' => 'getTimeoutMs'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const WRAPUP_PROMPT_MANDATORY = 'mandatory';
    const WRAPUP_PROMPT_OPTIONAL = 'optional';
    const WRAPUP_PROMPT_MANDATORY_TIMEOUT = 'mandatory_timeout';
    const WRAPUP_PROMPT_MANDATORY_FORCED_TIMEOUT = 'mandatory_FORCED_timeout';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getWrapupPromptAllowableValues()
    {
        return [
            self::WRAPUP_PROMPT_MANDATORY,
            self::WRAPUP_PROMPT_OPTIONAL,
            self::WRAPUP_PROMPT_MANDATORY_TIMEOUT,
            self::WRAPUP_PROMPT_MANDATORY_FORCED_TIMEOUT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['wrapupPrompt'] = isset($data['wrapupPrompt']) ? $data['wrapupPrompt'] : null;
        $this->container['timeoutMs'] = isset($data['timeoutMs']) ? $data['timeoutMs'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("mandatory", "optional", "mandatory_timeout", "mandatory_FORCED_timeout");
        if (!in_array($this->container['wrapupPrompt'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'wrapupPrompt', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("mandatory", "optional", "mandatory_timeout", "mandatory_FORCED_timeout");
        if (!in_array($this->container['wrapupPrompt'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets wrapupPrompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapupPrompt'];
    }

    /**
     * Sets wrapupPrompt
     * @param string $wrapupPrompt This field controls how the UI prompts the agent for a wrapup.
     * @return $this
     */
    public function setWrapupPrompt($wrapupPrompt)
    {
        $allowed_values = array('mandatory', 'optional', 'mandatory_timeout', 'mandatory_FORCED_timeout');
        if (!in_array($wrapupPrompt, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'wrapupPrompt', must be one of 'mandatory', 'optional', 'mandatory_timeout', 'mandatory_FORCED_timeout'");
        }
        $this->container['wrapupPrompt'] = $wrapupPrompt;

        return $this;
    }

    /**
     * Gets timeoutMs
     * @return int
     */
    public function getTimeoutMs()
    {
        return $this->container['timeoutMs'];
    }

    /**
     * Sets timeoutMs
     * @param int $timeoutMs The amount of time the agent can stay in ACW (Min: 1 sec, Max: 1 day).  Can only be used when ACW is mandatory_timeout or mandatory_FORCED_timeout.
     * @return $this
     */
    public function setTimeoutMs($timeoutMs)
    {
        $this->container['timeoutMs'] = $timeoutMs;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


