<?php
/**
 * ReplaceResponse
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ReplaceResponse Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ReplaceResponse implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ReplaceResponse';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'changeNumber' => 'int',
        'uploadStatus' => '\PureCloudSDK\UriReference',
        'uploadDestinationUri' => 'string',
        'uploadMethod' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'changeNumber' => 'changeNumber',
        'uploadStatus' => 'uploadStatus',
        'uploadDestinationUri' => 'uploadDestinationUri',
        'uploadMethod' => 'uploadMethod'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'changeNumber' => 'setChangeNumber',
        'uploadStatus' => 'setUploadStatus',
        'uploadDestinationUri' => 'setUploadDestinationUri',
        'uploadMethod' => 'setUploadMethod'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'changeNumber' => 'getChangeNumber',
        'uploadStatus' => 'getUploadStatus',
        'uploadDestinationUri' => 'getUploadDestinationUri',
        'uploadMethod' => 'getUploadMethod'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const UPLOAD_METHOD_SINGLE_PUT = 'SINGLE_PUT';
    const UPLOAD_METHOD_MULTIPART_POST = 'MULTIPART_POST';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUploadMethodAllowableValues()
    {
        return [
            self::UPLOAD_METHOD_SINGLE_PUT,
            self::UPLOAD_METHOD_MULTIPART_POST,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['changeNumber'] = isset($data['changeNumber']) ? $data['changeNumber'] : null;
        $this->container['uploadStatus'] = isset($data['uploadStatus']) ? $data['uploadStatus'] : null;
        $this->container['uploadDestinationUri'] = isset($data['uploadDestinationUri']) ? $data['uploadDestinationUri'] : null;
        $this->container['uploadMethod'] = isset($data['uploadMethod']) ? $data['uploadMethod'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("SINGLE_PUT", "MULTIPART_POST");
        if (!in_array($this->container['uploadMethod'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'uploadMethod', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("SINGLE_PUT", "MULTIPART_POST");
        if (!in_array($this->container['uploadMethod'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets changeNumber
     * @return int
     */
    public function getChangeNumber()
    {
        return $this->container['changeNumber'];
    }

    /**
     * Sets changeNumber
     * @param int $changeNumber
     * @return $this
     */
    public function setChangeNumber($changeNumber)
    {
        $this->container['changeNumber'] = $changeNumber;

        return $this;
    }

    /**
     * Gets uploadStatus
     * @return \PureCloudSDK\UriReference
     */
    public function getUploadStatus()
    {
        return $this->container['uploadStatus'];
    }

    /**
     * Sets uploadStatus
     * @param \PureCloudSDK\UriReference $uploadStatus
     * @return $this
     */
    public function setUploadStatus($uploadStatus)
    {
        $this->container['uploadStatus'] = $uploadStatus;

        return $this;
    }

    /**
     * Gets uploadDestinationUri
     * @return string
     */
    public function getUploadDestinationUri()
    {
        return $this->container['uploadDestinationUri'];
    }

    /**
     * Sets uploadDestinationUri
     * @param string $uploadDestinationUri
     * @return $this
     */
    public function setUploadDestinationUri($uploadDestinationUri)
    {
        $this->container['uploadDestinationUri'] = $uploadDestinationUri;

        return $this;
    }

    /**
     * Gets uploadMethod
     * @return string
     */
    public function getUploadMethod()
    {
        return $this->container['uploadMethod'];
    }

    /**
     * Sets uploadMethod
     * @param string $uploadMethod
     * @return $this
     */
    public function setUploadMethod($uploadMethod)
    {
        $allowed_values = array('SINGLE_PUT', 'MULTIPART_POST');
        if (!in_array($uploadMethod, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'uploadMethod', must be one of 'SINGLE_PUT', 'MULTIPART_POST'");
        }
        $this->container['uploadMethod'] = $uploadMethod;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


