<?php
/**
 * VoicemailOrganizationPolicy
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * VoicemailOrganizationPolicy Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class VoicemailOrganizationPolicy implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'VoicemailOrganizationPolicy';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'enabled' => 'bool',
        'retentionTimeDays' => 'int',
        'alertTimeoutSeconds' => 'int',
        'minimumRecordingTimeSeconds' => 'int',
        'maximumRecordingTimeSeconds' => 'int',
        'unavailableMessageUri' => 'string',
        'namePromptMessageUri' => 'string',
        'fullMessageUri' => 'string',
        'compressSilence' => 'bool',
        'pinConfiguration' => '\PureCloudSDK\PINConfiguration',
        'quotaSizeBytes' => 'int',
        'createdDate' => '\DateTime',
        'modifiedDate' => '\DateTime',
        'voicemailExtension' => 'string',
        'pinRequired' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'enabled' => 'enabled',
        'retentionTimeDays' => 'retentionTimeDays',
        'alertTimeoutSeconds' => 'alertTimeoutSeconds',
        'minimumRecordingTimeSeconds' => 'minimumRecordingTimeSeconds',
        'maximumRecordingTimeSeconds' => 'maximumRecordingTimeSeconds',
        'unavailableMessageUri' => 'unavailableMessageUri',
        'namePromptMessageUri' => 'namePromptMessageUri',
        'fullMessageUri' => 'fullMessageUri',
        'compressSilence' => 'compressSilence',
        'pinConfiguration' => 'pinConfiguration',
        'quotaSizeBytes' => 'quotaSizeBytes',
        'createdDate' => 'createdDate',
        'modifiedDate' => 'modifiedDate',
        'voicemailExtension' => 'voicemailExtension',
        'pinRequired' => 'pinRequired'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'enabled' => 'setEnabled',
        'retentionTimeDays' => 'setRetentionTimeDays',
        'alertTimeoutSeconds' => 'setAlertTimeoutSeconds',
        'minimumRecordingTimeSeconds' => 'setMinimumRecordingTimeSeconds',
        'maximumRecordingTimeSeconds' => 'setMaximumRecordingTimeSeconds',
        'unavailableMessageUri' => 'setUnavailableMessageUri',
        'namePromptMessageUri' => 'setNamePromptMessageUri',
        'fullMessageUri' => 'setFullMessageUri',
        'compressSilence' => 'setCompressSilence',
        'pinConfiguration' => 'setPinConfiguration',
        'quotaSizeBytes' => 'setQuotaSizeBytes',
        'createdDate' => 'setCreatedDate',
        'modifiedDate' => 'setModifiedDate',
        'voicemailExtension' => 'setVoicemailExtension',
        'pinRequired' => 'setPinRequired'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'enabled' => 'getEnabled',
        'retentionTimeDays' => 'getRetentionTimeDays',
        'alertTimeoutSeconds' => 'getAlertTimeoutSeconds',
        'minimumRecordingTimeSeconds' => 'getMinimumRecordingTimeSeconds',
        'maximumRecordingTimeSeconds' => 'getMaximumRecordingTimeSeconds',
        'unavailableMessageUri' => 'getUnavailableMessageUri',
        'namePromptMessageUri' => 'getNamePromptMessageUri',
        'fullMessageUri' => 'getFullMessageUri',
        'compressSilence' => 'getCompressSilence',
        'pinConfiguration' => 'getPinConfiguration',
        'quotaSizeBytes' => 'getQuotaSizeBytes',
        'createdDate' => 'getCreatedDate',
        'modifiedDate' => 'getModifiedDate',
        'voicemailExtension' => 'getVoicemailExtension',
        'pinRequired' => 'getPinRequired'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $this->container['retentionTimeDays'] = isset($data['retentionTimeDays']) ? $data['retentionTimeDays'] : null;
        $this->container['alertTimeoutSeconds'] = isset($data['alertTimeoutSeconds']) ? $data['alertTimeoutSeconds'] : null;
        $this->container['minimumRecordingTimeSeconds'] = isset($data['minimumRecordingTimeSeconds']) ? $data['minimumRecordingTimeSeconds'] : null;
        $this->container['maximumRecordingTimeSeconds'] = isset($data['maximumRecordingTimeSeconds']) ? $data['maximumRecordingTimeSeconds'] : null;
        $this->container['unavailableMessageUri'] = isset($data['unavailableMessageUri']) ? $data['unavailableMessageUri'] : null;
        $this->container['namePromptMessageUri'] = isset($data['namePromptMessageUri']) ? $data['namePromptMessageUri'] : null;
        $this->container['fullMessageUri'] = isset($data['fullMessageUri']) ? $data['fullMessageUri'] : null;
        $this->container['compressSilence'] = isset($data['compressSilence']) ? $data['compressSilence'] : false;
        $this->container['pinConfiguration'] = isset($data['pinConfiguration']) ? $data['pinConfiguration'] : null;
        $this->container['quotaSizeBytes'] = isset($data['quotaSizeBytes']) ? $data['quotaSizeBytes'] : null;
        $this->container['createdDate'] = isset($data['createdDate']) ? $data['createdDate'] : null;
        $this->container['modifiedDate'] = isset($data['modifiedDate']) ? $data['modifiedDate'] : null;
        $this->container['voicemailExtension'] = isset($data['voicemailExtension']) ? $data['voicemailExtension'] : null;
        $this->container['pinRequired'] = isset($data['pinRequired']) ? $data['pinRequired'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets retentionTimeDays
     * @return int
     */
    public function getRetentionTimeDays()
    {
        return $this->container['retentionTimeDays'];
    }

    /**
     * Sets retentionTimeDays
     * @param int $retentionTimeDays
     * @return $this
     */
    public function setRetentionTimeDays($retentionTimeDays)
    {
        $this->container['retentionTimeDays'] = $retentionTimeDays;

        return $this;
    }

    /**
     * Gets alertTimeoutSeconds
     * @return int
     */
    public function getAlertTimeoutSeconds()
    {
        return $this->container['alertTimeoutSeconds'];
    }

    /**
     * Sets alertTimeoutSeconds
     * @param int $alertTimeoutSeconds
     * @return $this
     */
    public function setAlertTimeoutSeconds($alertTimeoutSeconds)
    {
        $this->container['alertTimeoutSeconds'] = $alertTimeoutSeconds;

        return $this;
    }

    /**
     * Gets minimumRecordingTimeSeconds
     * @return int
     */
    public function getMinimumRecordingTimeSeconds()
    {
        return $this->container['minimumRecordingTimeSeconds'];
    }

    /**
     * Sets minimumRecordingTimeSeconds
     * @param int $minimumRecordingTimeSeconds
     * @return $this
     */
    public function setMinimumRecordingTimeSeconds($minimumRecordingTimeSeconds)
    {
        $this->container['minimumRecordingTimeSeconds'] = $minimumRecordingTimeSeconds;

        return $this;
    }

    /**
     * Gets maximumRecordingTimeSeconds
     * @return int
     */
    public function getMaximumRecordingTimeSeconds()
    {
        return $this->container['maximumRecordingTimeSeconds'];
    }

    /**
     * Sets maximumRecordingTimeSeconds
     * @param int $maximumRecordingTimeSeconds
     * @return $this
     */
    public function setMaximumRecordingTimeSeconds($maximumRecordingTimeSeconds)
    {
        $this->container['maximumRecordingTimeSeconds'] = $maximumRecordingTimeSeconds;

        return $this;
    }

    /**
     * Gets unavailableMessageUri
     * @return string
     */
    public function getUnavailableMessageUri()
    {
        return $this->container['unavailableMessageUri'];
    }

    /**
     * Sets unavailableMessageUri
     * @param string $unavailableMessageUri
     * @return $this
     */
    public function setUnavailableMessageUri($unavailableMessageUri)
    {
        $this->container['unavailableMessageUri'] = $unavailableMessageUri;

        return $this;
    }

    /**
     * Gets namePromptMessageUri
     * @return string
     */
    public function getNamePromptMessageUri()
    {
        return $this->container['namePromptMessageUri'];
    }

    /**
     * Sets namePromptMessageUri
     * @param string $namePromptMessageUri
     * @return $this
     */
    public function setNamePromptMessageUri($namePromptMessageUri)
    {
        $this->container['namePromptMessageUri'] = $namePromptMessageUri;

        return $this;
    }

    /**
     * Gets fullMessageUri
     * @return string
     */
    public function getFullMessageUri()
    {
        return $this->container['fullMessageUri'];
    }

    /**
     * Sets fullMessageUri
     * @param string $fullMessageUri
     * @return $this
     */
    public function setFullMessageUri($fullMessageUri)
    {
        $this->container['fullMessageUri'] = $fullMessageUri;

        return $this;
    }

    /**
     * Gets compressSilence
     * @return bool
     */
    public function getCompressSilence()
    {
        return $this->container['compressSilence'];
    }

    /**
     * Sets compressSilence
     * @param bool $compressSilence
     * @return $this
     */
    public function setCompressSilence($compressSilence)
    {
        $this->container['compressSilence'] = $compressSilence;

        return $this;
    }

    /**
     * Gets pinConfiguration
     * @return \PureCloudSDK\PINConfiguration
     */
    public function getPinConfiguration()
    {
        return $this->container['pinConfiguration'];
    }

    /**
     * Sets pinConfiguration
     * @param \PureCloudSDK\PINConfiguration $pinConfiguration
     * @return $this
     */
    public function setPinConfiguration($pinConfiguration)
    {
        $this->container['pinConfiguration'] = $pinConfiguration;

        return $this;
    }

    /**
     * Gets quotaSizeBytes
     * @return int
     */
    public function getQuotaSizeBytes()
    {
        return $this->container['quotaSizeBytes'];
    }

    /**
     * Sets quotaSizeBytes
     * @param int $quotaSizeBytes
     * @return $this
     */
    public function setQuotaSizeBytes($quotaSizeBytes)
    {
        $this->container['quotaSizeBytes'] = $quotaSizeBytes;

        return $this;
    }

    /**
     * Gets createdDate
     * @return \DateTime
     */
    public function getCreatedDate()
    {
        return $this->container['createdDate'];
    }

    /**
     * Sets createdDate
     * @param \DateTime $createdDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCreatedDate($createdDate)
    {
        $this->container['createdDate'] = $createdDate;

        return $this;
    }

    /**
     * Gets modifiedDate
     * @return \DateTime
     */
    public function getModifiedDate()
    {
        return $this->container['modifiedDate'];
    }

    /**
     * Sets modifiedDate
     * @param \DateTime $modifiedDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setModifiedDate($modifiedDate)
    {
        $this->container['modifiedDate'] = $modifiedDate;

        return $this;
    }

    /**
     * Gets voicemailExtension
     * @return string
     */
    public function getVoicemailExtension()
    {
        return $this->container['voicemailExtension'];
    }

    /**
     * Sets voicemailExtension
     * @param string $voicemailExtension The extension for voicemail retrieval.  The default value is *86.
     * @return $this
     */
    public function setVoicemailExtension($voicemailExtension)
    {
        $this->container['voicemailExtension'] = $voicemailExtension;

        return $this;
    }

    /**
     * Gets pinRequired
     * @return bool
     */
    public function getPinRequired()
    {
        return $this->container['pinRequired'];
    }

    /**
     * Sets pinRequired
     * @param bool $pinRequired If this is true, a PIN is required when accessing a user's voicemail from a phone.
     * @return $this
     */
    public function setPinRequired($pinRequired)
    {
        $this->container['pinRequired'] = $pinRequired;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


