# PureCloudSDK\AlertingApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteHeartbeatAlertsAlertId**](AlertingApi.md#deleteHeartbeatAlertsAlertId) | **DELETE** /api/v2/alerting/heartbeat/alerts/{alertId} | Delete a heart beat alert
[**deleteHeartbeatRulesRuleId**](AlertingApi.md#deleteHeartbeatRulesRuleId) | **DELETE** /api/v2/alerting/heartbeat/rules/{ruleId} | Delete a heart beat rule.
[**deleteInteractionstatsAlertsAlertId**](AlertingApi.md#deleteInteractionstatsAlertsAlertId) | **DELETE** /api/v2/alerting/interactionstats/alerts/{alertId} | Delete an interaction stats alert
[**deleteInteractionstatsRulesRuleId**](AlertingApi.md#deleteInteractionstatsRulesRuleId) | **DELETE** /api/v2/alerting/interactionstats/rules/{ruleId} | Delete an interaction stats rule.
[**getHeartbeatAlerts**](AlertingApi.md#getHeartbeatAlerts) | **GET** /api/v2/alerting/heartbeat/alerts | Get heart beat alert list.
[**getHeartbeatAlertsAlertId**](AlertingApi.md#getHeartbeatAlertsAlertId) | **GET** /api/v2/alerting/heartbeat/alerts/{alertId} | Get a heart beat alert
[**getHeartbeatRules**](AlertingApi.md#getHeartbeatRules) | **GET** /api/v2/alerting/heartbeat/rules | Get a heart beat rule list.
[**getHeartbeatRulesRuleId**](AlertingApi.md#getHeartbeatRulesRuleId) | **GET** /api/v2/alerting/heartbeat/rules/{ruleId} | Get a heart beat rule.
[**getInteractionstatsAlerts**](AlertingApi.md#getInteractionstatsAlerts) | **GET** /api/v2/alerting/interactionstats/alerts | Get interaction stats alert list.
[**getInteractionstatsAlertsAlertId**](AlertingApi.md#getInteractionstatsAlertsAlertId) | **GET** /api/v2/alerting/interactionstats/alerts/{alertId} | Get an interaction stats alert
[**getInteractionstatsAlertsUnread**](AlertingApi.md#getInteractionstatsAlertsUnread) | **GET** /api/v2/alerting/interactionstats/alerts/unread | Gets user unread count of interaction stats alerts.
[**getInteractionstatsRules**](AlertingApi.md#getInteractionstatsRules) | **GET** /api/v2/alerting/interactionstats/rules | Get an interaction stats rule list.
[**getInteractionstatsRulesRuleId**](AlertingApi.md#getInteractionstatsRulesRuleId) | **GET** /api/v2/alerting/interactionstats/rules/{ruleId} | Get an interaction stats rule.
[**postHeartbeatRules**](AlertingApi.md#postHeartbeatRules) | **POST** /api/v2/alerting/heartbeat/rules | Create a heart beat rule.
[**postInteractionstatsRules**](AlertingApi.md#postInteractionstatsRules) | **POST** /api/v2/alerting/interactionstats/rules | Create an interaction stats rule.
[**putHeartbeatRulesRuleId**](AlertingApi.md#putHeartbeatRulesRuleId) | **PUT** /api/v2/alerting/heartbeat/rules/{ruleId} | Update a heart beat rule
[**putInteractionstatsAlertsAlertId**](AlertingApi.md#putInteractionstatsAlertsAlertId) | **PUT** /api/v2/alerting/interactionstats/alerts/{alertId} | Update an interaction stats alert read status
[**putInteractionstatsRulesRuleId**](AlertingApi.md#putInteractionstatsRulesRuleId) | **PUT** /api/v2/alerting/interactionstats/rules/{ruleId} | Update an interaction stats rule


# **deleteHeartbeatAlertsAlertId**
> deleteHeartbeatAlertsAlertId($alertId)

Delete a heart beat alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteHeartbeatAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteHeartbeatAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteHeartbeatRulesRuleId**
> deleteHeartbeatRulesRuleId($ruleId)

Delete a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $api_instance->deleteHeartbeatRulesRuleId($ruleId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteInteractionstatsAlertsAlertId**
> deleteInteractionstatsAlertsAlertId($alertId)

Delete an interaction stats alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $api_instance->deleteInteractionstatsAlertsAlertId($alertId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteInteractionstatsRulesRuleId**
> deleteInteractionstatsRulesRuleId($ruleId)

Delete an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $api_instance->deleteInteractionstatsRulesRuleId($ruleId);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->deleteInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getHeartbeatAlerts**
> \PureCloudSDK\HeartBeatAlertContainer getHeartbeatAlerts()

Get heart beat alert list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getHeartbeatAlerts();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getHeartbeatAlerts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\HeartBeatAlertContainer**](../Model/HeartBeatAlertContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getHeartbeatAlertsAlertId**
> \PureCloudSDK\HeartBeatAlert getHeartbeatAlertsAlertId($alertId)

Get a heart beat alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $result = $api_instance->getHeartbeatAlertsAlertId($alertId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getHeartbeatAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

[**\PureCloudSDK\HeartBeatAlert**](../Model/HeartBeatAlert.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getHeartbeatRules**
> \PureCloudSDK\HeartBeatRuleContainer getHeartbeatRules()

Get a heart beat rule list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getHeartbeatRules();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getHeartbeatRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\HeartBeatRuleContainer**](../Model/HeartBeatRuleContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getHeartbeatRulesRuleId**
> \PureCloudSDK\HeartBeatRule getHeartbeatRulesRuleId($ruleId)

Get a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $result = $api_instance->getHeartbeatRulesRuleId($ruleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getInteractionstatsAlerts**
> \PureCloudSDK\InteractionStatsAlertContainer getInteractionstatsAlerts()

Get interaction stats alert list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getInteractionstatsAlerts();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getInteractionstatsAlerts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\InteractionStatsAlertContainer**](../Model/InteractionStatsAlertContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getInteractionstatsAlertsAlertId**
> \PureCloudSDK\InteractionStatsAlert getInteractionstatsAlertsAlertId($alertId)

Get an interaction stats alert



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID

try {
    $result = $api_instance->getInteractionstatsAlertsAlertId($alertId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |

### Return type

[**\PureCloudSDK\InteractionStatsAlert**](../Model/InteractionStatsAlert.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getInteractionstatsAlertsUnread**
> \PureCloudSDK\UnreadMetric getInteractionstatsAlertsUnread()

Gets user unread count of interaction stats alerts.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getInteractionstatsAlertsUnread();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getInteractionstatsAlertsUnread: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\UnreadMetric**](../Model/UnreadMetric.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getInteractionstatsRules**
> \PureCloudSDK\InteractionStatsRuleContainer getInteractionstatsRules()

Get an interaction stats rule list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();

try {
    $result = $api_instance->getInteractionstatsRules();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getInteractionstatsRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\InteractionStatsRuleContainer**](../Model/InteractionStatsRuleContainer.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getInteractionstatsRulesRuleId**
> \PureCloudSDK\InteractionStatsRule getInteractionstatsRulesRuleId($ruleId)

Get an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID

try {
    $result = $api_instance->getInteractionstatsRulesRuleId($ruleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->getInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postHeartbeatRules**
> \PureCloudSDK\HeartBeatRule postHeartbeatRules($body)

Create a heart beat rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$body = new \PureCloudSDK\HeartBeatRule(); // \PureCloudSDK\HeartBeatRule | HeartBeatRule

try {
    $result = $api_instance->postHeartbeatRules($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->postHeartbeatRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\HeartBeatRule**](../Model/\PureCloudSDK\HeartBeatRule.md)| HeartBeatRule |

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postInteractionstatsRules**
> \PureCloudSDK\InteractionStatsRule postInteractionstatsRules($body)

Create an interaction stats rule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$body = new \PureCloudSDK\InteractionStatsRule(); // \PureCloudSDK\InteractionStatsRule | AlertingRule

try {
    $result = $api_instance->postInteractionstatsRules($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->postInteractionstatsRules: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\InteractionStatsRule**](../Model/\PureCloudSDK\InteractionStatsRule.md)| AlertingRule |

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putHeartbeatRulesRuleId**
> \PureCloudSDK\HeartBeatRule putHeartbeatRulesRuleId($ruleId, $body)

Update a heart beat rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$body = new \PureCloudSDK\HeartBeatRule(); // \PureCloudSDK\HeartBeatRule | HeartBeatRule

try {
    $result = $api_instance->putHeartbeatRulesRuleId($ruleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putHeartbeatRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **body** | [**\PureCloudSDK\HeartBeatRule**](../Model/\PureCloudSDK\HeartBeatRule.md)| HeartBeatRule |

### Return type

[**\PureCloudSDK\HeartBeatRule**](../Model/HeartBeatRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putInteractionstatsAlertsAlertId**
> \PureCloudSDK\UnreadStatus putInteractionstatsAlertsAlertId($alertId, $body)

Update an interaction stats alert read status



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$alertId = "alertId_example"; // string | Alert ID
$body = new \PureCloudSDK\UnreadStatus(); // \PureCloudSDK\UnreadStatus | InteractionStatsAlert

try {
    $result = $api_instance->putInteractionstatsAlertsAlertId($alertId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putInteractionstatsAlertsAlertId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **alertId** | **string**| Alert ID |
 **body** | [**\PureCloudSDK\UnreadStatus**](../Model/\PureCloudSDK\UnreadStatus.md)| InteractionStatsAlert |

### Return type

[**\PureCloudSDK\UnreadStatus**](../Model/UnreadStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putInteractionstatsRulesRuleId**
> \PureCloudSDK\InteractionStatsRule putInteractionstatsRulesRuleId($ruleId, $body)

Update an interaction stats rule



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AlertingApi();
$ruleId = "ruleId_example"; // string | Rule ID
$body = new \PureCloudSDK\InteractionStatsRule(); // \PureCloudSDK\InteractionStatsRule | AlertingRule

try {
    $result = $api_instance->putInteractionstatsRulesRuleId($ruleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AlertingApi->putInteractionstatsRulesRuleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleId** | **string**| Rule ID |
 **body** | [**\PureCloudSDK\InteractionStatsRule**](../Model/\PureCloudSDK\InteractionStatsRule.md)| AlertingRule |

### Return type

[**\PureCloudSDK\InteractionStatsRule**](../Model/InteractionStatsRule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

