# PureCloudSDK\AuthorizationApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteRolesRoleId**](AuthorizationApi.md#deleteRolesRoleId) | **DELETE** /api/v2/authorization/roles/{roleId} | Delete an organization role.
[**deleteUserIdRoles**](AuthorizationApi.md#deleteUserIdRoles) | **DELETE** /api/v2/users/{userId}/roles | Removes all the roles from the user.
[**getPermissions**](AuthorizationApi.md#getPermissions) | **GET** /api/v2/authorization/permissions | Get all permissions.
[**getProducts**](AuthorizationApi.md#getProducts) | **GET** /api/v2/authorization/products | Get the list of enabled products
[**getRoles**](AuthorizationApi.md#getRoles) | **GET** /api/v2/authorization/roles | Retrieve a list of all roles defined for the organization
[**getRolesLeftroleIdComparedefaultRightroleId**](AuthorizationApi.md#getRolesLeftroleIdComparedefaultRightroleId) | **GET** /api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId} | Get an org role to default role comparison comparison
[**getRolesRoleId**](AuthorizationApi.md#getRolesRoleId) | **GET** /api/v2/authorization/roles/{roleId} | Get a single organization role.
[**getUserIdRoles**](AuthorizationApi.md#getUserIdRoles) | **GET** /api/v2/users/{userId}/roles | Returns a listing of roles and permissions for a user.
[**patchRolesRoleId**](AuthorizationApi.md#patchRolesRoleId) | **PATCH** /api/v2/authorization/roles/{roleId} | Patch Organization Role for needsUpdate Field
[**postRoles**](AuthorizationApi.md#postRoles) | **POST** /api/v2/authorization/roles | Create an organization role.
[**postRolesDefault**](AuthorizationApi.md#postRolesDefault) | **POST** /api/v2/authorization/roles/default | Restores all default roles
[**postRolesLeftroleIdComparedefaultRightroleId**](AuthorizationApi.md#postRolesLeftroleIdComparedefaultRightroleId) | **POST** /api/v2/authorization/roles/{leftRoleId}/comparedefault/{rightRoleId} | Get an unsaved org role to default role comparison
[**putRolesDefault**](AuthorizationApi.md#putRolesDefault) | **PUT** /api/v2/authorization/roles/default | Restore specified default roles
[**putRolesRoleId**](AuthorizationApi.md#putRolesRoleId) | **PUT** /api/v2/authorization/roles/{roleId} | Update an organization role.
[**putRolesRoleIdUsersAdd**](AuthorizationApi.md#putRolesRoleIdUsersAdd) | **PUT** /api/v2/authorization/roles/{roleId}/users/add | Sets the users for the role
[**putRolesRoleIdUsersRemove**](AuthorizationApi.md#putRolesRoleIdUsersRemove) | **PUT** /api/v2/authorization/roles/{roleId}/users/remove | Removes the users from the role
[**putUserIdRoles**](AuthorizationApi.md#putUserIdRoles) | **PUT** /api/v2/users/{userId}/roles | Sets the user&#39;s roles


# **deleteRolesRoleId**
> deleteRolesRoleId($roleId)

Delete an organization role.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID

try {
    $api_instance->deleteRolesRoleId($roleId);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->deleteRolesRoleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteUserIdRoles**
> deleteUserIdRoles($userId)

Removes all the roles from the user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$userId = "userId_example"; // string | User ID

try {
    $api_instance->deleteUserIdRoles($userId);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->deleteUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getPermissions**
> \PureCloudSDK\PermissionCollectionEntityListing getPermissions($pageSize, $pageNumber)

Get all permissions.

Retrieve a list of all permission defined in the system.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number

try {
    $result = $api_instance->getPermissions($pageSize, $pageNumber);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getPermissions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]

### Return type

[**\PureCloudSDK\PermissionCollectionEntityListing**](../Model/PermissionCollectionEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getProducts**
> \PureCloudSDK\OrganizationProductEntityListing getProducts()

Get the list of enabled products

Gets the list of enabled products. Some example product names are: collaborateFree, collaboratePro, communicate, and engage.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();

try {
    $result = $api_instance->getProducts();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getProducts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OrganizationProductEntityListing**](../Model/OrganizationProductEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRoles**
> \PureCloudSDK\OrganizationRoleEntityListing getRoles($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $permission, $userCount)

Retrieve a list of all roles defined for the organization



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$pageSize = 25; // int | The total page size requested
$pageNumber = 1; // int | The page number requested
$sortBy = "sortBy_example"; // string | variable name requested to sort by
$expand = NULL; // object[] | variable name requested by expand list
$nextPage = "nextPage_example"; // string | next page token
$previousPage = "previousPage_example"; // string | Previous page token
$permission = NULL; // object[] | 
$userCount = true; // bool | 

try {
    $result = $api_instance->getRoles($pageSize, $pageNumber, $sortBy, $expand, $nextPage, $previousPage, $permission, $userCount);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| The total page size requested | [optional] [default to 25]
 **pageNumber** | **int**| The page number requested | [optional] [default to 1]
 **sortBy** | **string**| variable name requested to sort by | [optional]
 **expand** | [**object[]**](../Model/object.md)| variable name requested by expand list | [optional]
 **nextPage** | **string**| next page token | [optional]
 **previousPage** | **string**| Previous page token | [optional]
 **permission** | [**object[]**](../Model/object.md)|  | [optional]
 **userCount** | **bool**|  | [optional] [default to true]

### Return type

[**\PureCloudSDK\OrganizationRoleEntityListing**](../Model/OrganizationRoleEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRolesLeftroleIdComparedefaultRightroleId**
> \PureCloudSDK\DomainOrgRoleDifference getRolesLeftroleIdComparedefaultRightroleId($leftRoleId, $rightRoleId)

Get an org role to default role comparison comparison

Compares any organization role to a default role id and show differences

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$leftRoleId = "leftRoleId_example"; // string | Left Role ID
$rightRoleId = "rightRoleId_example"; // string | Right Role id

try {
    $result = $api_instance->getRolesLeftroleIdComparedefaultRightroleId($leftRoleId, $rightRoleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getRolesLeftroleIdComparedefaultRightroleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **leftRoleId** | **string**| Left Role ID |
 **rightRoleId** | **string**| Right Role id |

### Return type

[**\PureCloudSDK\DomainOrgRoleDifference**](../Model/DomainOrgRoleDifference.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRolesRoleId**
> \PureCloudSDK\DomainOrganizationRole getRolesRoleId($roleId)

Get a single organization role.

Get the organization role specified by its ID.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID

try {
    $result = $api_instance->getRolesRoleId($roleId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getRolesRoleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |

### Return type

[**\PureCloudSDK\DomainOrganizationRole**](../Model/DomainOrganizationRole.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserIdRoles**
> \PureCloudSDK\UserAuthorization getUserIdRoles($userId)

Returns a listing of roles and permissions for a user.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$userId = "userId_example"; // string | User ID

try {
    $result = $api_instance->getUserIdRoles($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->getUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |

### Return type

[**\PureCloudSDK\UserAuthorization**](../Model/UserAuthorization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchRolesRoleId**
> \PureCloudSDK\DomainOrganizationRole patchRolesRoleId($roleId, $body)

Patch Organization Role for needsUpdate Field

Patch Organization Role for needsUpdate Field

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID
$body = new \PureCloudSDK\DomainOrganizationRole(); // \PureCloudSDK\DomainOrganizationRole | Organization role

try {
    $result = $api_instance->patchRolesRoleId($roleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->patchRolesRoleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |
 **body** | [**\PureCloudSDK\DomainOrganizationRole**](../Model/\PureCloudSDK\DomainOrganizationRole.md)| Organization role |

### Return type

[**\PureCloudSDK\DomainOrganizationRole**](../Model/DomainOrganizationRole.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRoles**
> \PureCloudSDK\DomainOrganizationRole postRoles($body)

Create an organization role.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$body = new \PureCloudSDK\DomainOrganizationRoleCreate(); // \PureCloudSDK\DomainOrganizationRoleCreate | Organization role

try {
    $result = $api_instance->postRoles($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->postRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DomainOrganizationRoleCreate**](../Model/\PureCloudSDK\DomainOrganizationRoleCreate.md)| Organization role |

### Return type

[**\PureCloudSDK\DomainOrganizationRole**](../Model/DomainOrganizationRole.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRolesDefault**
> \PureCloudSDK\OrganizationRoleEntityListing postRolesDefault($force)

Restores all default roles

This endpoint serves several purposes. 1. It provides the org with default roles. This is important for default roles that will be added after go-live (they can retroactively add the new default-role). Note: When not using a query param of force=true, it only adds the default roles not configured for the org; it does not overwrite roles. 2. Using the query param force=true, you can restore all default roles. Note: This does not have an effect on custom roles.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$force = false; // bool | Restore default roles

try {
    $result = $api_instance->postRolesDefault($force);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->postRolesDefault: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **force** | **bool**| Restore default roles | [optional] [default to false]

### Return type

[**\PureCloudSDK\OrganizationRoleEntityListing**](../Model/OrganizationRoleEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRolesLeftroleIdComparedefaultRightroleId**
> \PureCloudSDK\DomainOrgRoleDifference postRolesLeftroleIdComparedefaultRightroleId($leftRoleId, $rightRoleId, $body)

Get an unsaved org role to default role comparison

Allows users to compare their existing roles in an unsaved state to its default role

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$leftRoleId = "leftRoleId_example"; // string | Left Role ID
$rightRoleId = "rightRoleId_example"; // string | Right Role id
$body = new \PureCloudSDK\DomainOrganizationRole(); // \PureCloudSDK\DomainOrganizationRole | Organization role

try {
    $result = $api_instance->postRolesLeftroleIdComparedefaultRightroleId($leftRoleId, $rightRoleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->postRolesLeftroleIdComparedefaultRightroleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **leftRoleId** | **string**| Left Role ID |
 **rightRoleId** | **string**| Right Role id |
 **body** | [**\PureCloudSDK\DomainOrganizationRole**](../Model/\PureCloudSDK\DomainOrganizationRole.md)| Organization role |

### Return type

[**\PureCloudSDK\DomainOrgRoleDifference**](../Model/DomainOrgRoleDifference.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRolesDefault**
> \PureCloudSDK\OrganizationRoleEntityListing putRolesDefault($body)

Restore specified default roles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$body = array(new DomainOrganizationRole()); // \PureCloudSDK\DomainOrganizationRole[] | Organization roles list

try {
    $result = $api_instance->putRolesDefault($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putRolesDefault: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DomainOrganizationRole[]**](../Model/DomainOrganizationRole.md)| Organization roles list |

### Return type

[**\PureCloudSDK\OrganizationRoleEntityListing**](../Model/OrganizationRoleEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRolesRoleId**
> \PureCloudSDK\DomainOrganizationRole putRolesRoleId($roleId, $body)

Update an organization role.

Update

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID
$body = new \PureCloudSDK\DomainOrganizationRoleUpdate(); // \PureCloudSDK\DomainOrganizationRoleUpdate | Organization role

try {
    $result = $api_instance->putRolesRoleId($roleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putRolesRoleId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |
 **body** | [**\PureCloudSDK\DomainOrganizationRoleUpdate**](../Model/\PureCloudSDK\DomainOrganizationRoleUpdate.md)| Organization role |

### Return type

[**\PureCloudSDK\DomainOrganizationRole**](../Model/DomainOrganizationRole.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRolesRoleIdUsersAdd**
> string[] putRolesRoleIdUsersAdd($roleId, $body)

Sets the users for the role



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID
$body = array(new string[]()); // string[] | List of user IDs

try {
    $result = $api_instance->putRolesRoleIdUsersAdd($roleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putRolesRoleIdUsersAdd: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |
 **body** | **string[]**| List of user IDs |

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRolesRoleIdUsersRemove**
> string[] putRolesRoleIdUsersRemove($roleId, $body)

Removes the users from the role



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$roleId = "roleId_example"; // string | Role ID
$body = array(new string[]()); // string[] | List of user IDs

try {
    $result = $api_instance->putRolesRoleIdUsersRemove($roleId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putRolesRoleIdUsersRemove: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **roleId** | **string**| Role ID |
 **body** | **string[]**| List of user IDs |

### Return type

**string[]**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putUserIdRoles**
> \PureCloudSDK\UserAuthorization putUserIdRoles($userId, $body)

Sets the user's roles



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\AuthorizationApi();
$userId = "userId_example"; // string | User ID
$body = array(new string[]()); // string[] | List of roles

try {
    $result = $api_instance->putUserIdRoles($userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling AuthorizationApi->putUserIdRoles: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| User ID |
 **body** | **string[]**| List of roles |

### Return type

[**\PureCloudSDK\UserAuthorization**](../Model/UserAuthorization.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

