# PureCloudSDK\ConversationsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteCallsCallIdParticipantsParticipantIdConsult**](ConversationsApi.md#deleteCallsCallIdParticipantsParticipantIdConsult) | **DELETE** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Cancel the transfer
[**deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode**](ConversationsApi.md#deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode) | **DELETE** /api/v2/conversations/{conversationId}/participants/{participantId}/codes/{addCommunicationCode} | Delete a code used to add a communication to this participant
[**deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId**](ConversationsApi.md#deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId) | **DELETE** /api/v2/conversations/emails/{emailId}/messages/draft/attachments/{attachmentId} | Delete attachment from draft
[**getCallbacks**](ConversationsApi.md#getCallbacks) | **GET** /api/v2/conversations/callbacks | Get callback conversations
[**getCallbacksCallbackId**](ConversationsApi.md#getCallbacksCallbackId) | **GET** /api/v2/conversations/callbacks/{callbackId} | Get callback conversation
[**getCallbacksCallbackIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getCallbacksCallbackIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getCalls**](ConversationsApi.md#getCalls) | **GET** /api/v2/conversations/calls | Get recent conversations
[**getCallsCallId**](ConversationsApi.md#getCallsCallId) | **GET** /api/v2/conversations/calls/{callId} | Get call conversation
[**getCallsCallIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getCallsCallIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/calls/{callId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getCallsCallIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getCallsCallIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/calls/{callId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getCallsHistory**](ConversationsApi.md#getCallsHistory) | **GET** /api/v2/conversations/calls/history | Get call history
[**getCallsMaximumconferenceparties**](ConversationsApi.md#getCallsMaximumconferenceparties) | **GET** /api/v2/conversations/calls/maximumconferenceparties | Get the maximum number of participants that this user can have on a conference
[**getChats**](ConversationsApi.md#getChats) | **GET** /api/v2/conversations/chats | Get recent chat conversations
[**getChatsChatId**](ConversationsApi.md#getChatsChatId) | **GET** /api/v2/conversations/chats/{chatId} | Get chat conversation
[**getChatsChatIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getChatsChatIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getChatsChatIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getChatsChatIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/chats/{chatId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getCobrowsesessions**](ConversationsApi.md#getCobrowsesessions) | **GET** /api/v2/conversations/cobrowsesessions | Get recent cobrowse conversations
[**getCobrowsesessionsCobrowseId**](ConversationsApi.md#getCobrowsesessionsCobrowseId) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId} | Get cobrowse conversation
[**getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversationId**](ConversationsApi.md#getConversationId) | **GET** /api/v2/conversations/{conversationId} | Get conversation
[**getConversationIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getConversationIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getConversationIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getConversationIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/{conversationId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**getConversations**](ConversationsApi.md#getConversations) | **GET** /api/v2/conversations | Get conversations
[**getConversationsConversationIdDetails**](ConversationsApi.md#getConversationsConversationIdDetails) | **GET** /api/v2/analytics/conversations/{conversationId}/details | Get a conversation by id
[**getEmails**](ConversationsApi.md#getEmails) | **GET** /api/v2/conversations/emails | Get recent email conversations
[**getEmailsEmailId**](ConversationsApi.md#getEmailsEmailId) | **GET** /api/v2/conversations/emails/{emailId} | Get email conversation
[**getEmailsEmailIdMessages**](ConversationsApi.md#getEmailsEmailIdMessages) | **GET** /api/v2/conversations/emails/{emailId}/messages | Get conversation messages
[**getEmailsEmailIdMessagesDraft**](ConversationsApi.md#getEmailsEmailIdMessagesDraft) | **GET** /api/v2/conversations/emails/{emailId}/messages/draft | Get conversation draft reply
[**getEmailsEmailIdMessagesMessageId**](ConversationsApi.md#getEmailsEmailIdMessagesMessageId) | **GET** /api/v2/conversations/emails/{emailId}/messages/{messageId} | Get conversation message
[**getEmailsEmailIdParticipantsParticipantIdWrapup**](ConversationsApi.md#getEmailsEmailIdParticipantsParticipantIdWrapup) | **GET** /api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapup | Get the wrap-up for this conversation participant.
[**getEmailsEmailIdParticipantsParticipantIdWrapupcodes**](ConversationsApi.md#getEmailsEmailIdParticipantsParticipantIdWrapupcodes) | **GET** /api/v2/conversations/emails/{emailId}/participants/{participantId}/wrapupcodes | Get list of wrapup codes for this conversation participant
[**patchCallbacksCallbackId**](ConversationsApi.md#patchCallbacksCallbackId) | **PATCH** /api/v2/conversations/callbacks/{callbackId} | Update a conversation by disconnecting all of the participants
[**patchCallbacksCallbackIdParticipantsParticipantId**](ConversationsApi.md#patchCallbacksCallbackIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId} | Update conversation participant
[**patchCallbacksCallbackIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchCallbacksCallbackIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchCallsCallId**](ConversationsApi.md#patchCallsCallId) | **PATCH** /api/v2/conversations/calls/{callId} | Update a conversation by setting it&#39;s recording state, merging in other conversations to create a conference, or disconnecting all of the participants
[**patchCallsCallIdParticipantsParticipantId**](ConversationsApi.md#patchCallsCallIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId} | Update conversation participant
[**patchCallsCallIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchCallsCallIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchCallsCallIdParticipantsParticipantIdConsult**](ConversationsApi.md#patchCallsCallIdParticipantsParticipantIdConsult) | **PATCH** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Change who can speak
[**patchChatsChatId**](ConversationsApi.md#patchChatsChatId) | **PATCH** /api/v2/conversations/chats/{chatId} | Update a conversation by disconnecting all of the participants
[**patchChatsChatIdParticipantsParticipantId**](ConversationsApi.md#patchChatsChatIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId} | Update conversation participant
[**patchChatsChatIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchChatsChatIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/chats/{chatId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchCobrowsesessionsCobrowseId**](ConversationsApi.md#patchCobrowsesessionsCobrowseId) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId} | Update a conversation by disconnecting all of the participants
[**patchCobrowsesessionsCobrowseIdParticipantsParticipantId**](ConversationsApi.md#patchCobrowsesessionsCobrowseIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId} | Update conversation participant
[**patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**patchConversationIdParticipantsParticipantId**](ConversationsApi.md#patchConversationIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId} | Update a participant.
[**patchConversationIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchConversationIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/{conversationId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchEmailsEmailId**](ConversationsApi.md#patchEmailsEmailId) | **PATCH** /api/v2/conversations/emails/{emailId} | Update a conversation by disconnecting all of the participants
[**patchEmailsEmailIdParticipantsParticipantId**](ConversationsApi.md#patchEmailsEmailIdParticipantsParticipantId) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId} | Update conversation participant
[**patchEmailsEmailIdParticipantsParticipantIdAttributes**](ConversationsApi.md#patchEmailsEmailIdParticipantsParticipantIdAttributes) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId}/attributes | Update the attributes on a conversation participant.
[**patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId**](ConversationsApi.md#patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId) | **PATCH** /api/v2/conversations/emails/{emailId}/participants/{participantId}/communications/{communicationId} | Update conversation participant&#39;s communication by disconnecting it.
[**postCallbacks**](ConversationsApi.md#postCallbacks) | **POST** /api/v2/conversations/callbacks | Create a Callback
[**postCallbacksCallbackIdParticipantsParticipantIdReplace**](ConversationsApi.md#postCallbacksCallbackIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/callbacks/{callbackId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postCalls**](ConversationsApi.md#postCalls) | **POST** /api/v2/conversations/calls | Create a call conversation
[**postCallsCallId**](ConversationsApi.md#postCallsCallId) | **POST** /api/v2/conversations/calls/{callId} | Add a new call to a conversation
[**postCallsCallIdParticipants**](ConversationsApi.md#postCallsCallIdParticipants) | **POST** /api/v2/conversations/calls/{callId}/participants | Add participants to a conversation
[**postCallsCallIdParticipantsParticipantIdConsult**](ConversationsApi.md#postCallsCallIdParticipantsParticipantIdConsult) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/consult | Initiate and update consult transfer
[**postCallsCallIdParticipantsParticipantIdMonitor**](ConversationsApi.md#postCallsCallIdParticipantsParticipantIdMonitor) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/monitor | Listen in on the conversation from the point of view of a given participant.
[**postCallsCallIdParticipantsParticipantIdReplace**](ConversationsApi.md#postCallsCallIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/calls/{callId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postChatsChatIdParticipantsParticipantIdReplace**](ConversationsApi.md#postChatsChatIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/chats/{chatId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace**](ConversationsApi.md#postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/cobrowsesessions/{cobrowseId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationIdParticipantsParticipantIdCallbacks**](ConversationsApi.md#postConversationIdParticipantsParticipantIdCallbacks) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/callbacks | Create a new callback for the specified participant on the conversation.
[**postConversationIdParticipantsParticipantIdReplace**](ConversationsApi.md#postConversationIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/{conversationId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postConversationsAggregatesQuery**](ConversationsApi.md#postConversationsAggregatesQuery) | **POST** /api/v2/analytics/conversations/aggregates/query | Query for conversation aggregates
[**postConversationsConversationIdDetailsProperties**](ConversationsApi.md#postConversationsConversationIdDetailsProperties) | **POST** /api/v2/analytics/conversations/{conversationId}/details/properties | Index conversation properties
[**postConversationsDetailsQuery**](ConversationsApi.md#postConversationsDetailsQuery) | **POST** /api/v2/analytics/conversations/details/query | Query for conversation details
[**postEmailsEmailIdMessages**](ConversationsApi.md#postEmailsEmailIdMessages) | **POST** /api/v2/conversations/emails/{emailId}/messages | Send an email reply
[**postEmailsEmailIdParticipantsParticipantIdReplace**](ConversationsApi.md#postEmailsEmailIdParticipantsParticipantIdReplace) | **POST** /api/v2/conversations/emails/{emailId}/participants/{participantId}/replace | Replace this participant with the specified user and/or address
[**postFaxes**](ConversationsApi.md#postFaxes) | **POST** /api/v2/conversations/faxes | Create Fax Conversation
[**putEmailsEmailIdMessagesDraft**](ConversationsApi.md#putEmailsEmailIdMessagesDraft) | **PUT** /api/v2/conversations/emails/{emailId}/messages/draft | Update conversation draft reply


# **deleteCallsCallIdParticipantsParticipantIdConsult**
> string deleteCallsCallIdParticipantsParticipantIdConsult($callId, $participantId)

Cancel the transfer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->deleteCallsCallIdParticipantsParticipantIdConsult($callId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteCallsCallIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode**
> deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode($conversationId, $participantId, $addCommunicationCode)

Delete a code used to add a communication to this participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$addCommunicationCode = "addCommunicationCode_example"; // string | addCommunicationCode

try {
    $api_instance->deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode($conversationId, $participantId, $addCommunicationCode);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteConversationIdParticipantsParticipantIdCodesAddcommunicationcode: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **addCommunicationCode** | **string**| addCommunicationCode |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId**
> string deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId($emailId, $attachmentId)

Delete attachment from draft



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$attachmentId = "attachmentId_example"; // string | attachmentId

try {
    $result = $api_instance->deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId($emailId, $attachmentId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->deleteEmailsEmailIdMessagesDraftAttachmentsAttachmentId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **attachmentId** | **string**| attachmentId |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallbacks**
> \PureCloudSDK\CallbackConversationEntityListing getCallbacks()

Get callback conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getCallbacks();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CallbackConversationEntityListing**](../Model/CallbackConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallbacksCallbackId**
> \PureCloudSDK\CallbackConversation getCallbacksCallbackId($callbackId)

Get callback conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId

try {
    $result = $api_instance->getCallbacksCallbackId($callbackId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallbacksCallbackId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |

### Return type

[**\PureCloudSDK\CallbackConversation**](../Model/CallbackConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallbacksCallbackIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getCallbacksCallbackIdParticipantsParticipantIdWrapup($callbackId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getCallbacksCallbackIdParticipantsParticipantIdWrapup($callbackId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallbacksCallbackIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes($callbackId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes($callbackId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallbacksCallbackIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCalls**
> \PureCloudSDK\CallConversationEntityListing getCalls()

Get recent conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getCalls();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCalls: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CallConversationEntityListing**](../Model/CallConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallsCallId**
> \PureCloudSDK\CallConversation getCallsCallId($callId)

Get call conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId

try {
    $result = $api_instance->getCallsCallId($callId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallsCallId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |

### Return type

[**\PureCloudSDK\CallConversation**](../Model/CallConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallsCallIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getCallsCallIdParticipantsParticipantIdWrapup($callId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getCallsCallIdParticipantsParticipantIdWrapup($callId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallsCallIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallsCallIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getCallsCallIdParticipantsParticipantIdWrapupcodes($callId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getCallsCallIdParticipantsParticipantIdWrapupcodes($callId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallsCallIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallsHistory**
> \PureCloudSDK\CallConversationEntityListing getCallsHistory($pageSize, $pageNumber, $interval)

Get call history



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$interval = "interval_example"; // string | Interval string; format is ISO-8601. Separate start and end times with forward slash '/'

try {
    $result = $api_instance->getCallsHistory($pageSize, $pageNumber, $interval);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallsHistory: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **interval** | **string**| Interval string; format is ISO-8601. Separate start and end times with forward slash &#39;/&#39; | [optional]

### Return type

[**\PureCloudSDK\CallConversationEntityListing**](../Model/CallConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallsMaximumconferenceparties**
> \PureCloudSDK\MaxParticipants getCallsMaximumconferenceparties()

Get the maximum number of participants that this user can have on a conference



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getCallsMaximumconferenceparties();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCallsMaximumconferenceparties: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\MaxParticipants**](../Model/MaxParticipants.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getChats**
> \PureCloudSDK\ChatConversationEntityListing getChats()

Get recent chat conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getChats();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getChats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\ChatConversationEntityListing**](../Model/ChatConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getChatsChatId**
> \PureCloudSDK\ChatConversation getChatsChatId($chatId)

Get chat conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId

try {
    $result = $api_instance->getChatsChatId($chatId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getChatsChatId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |

### Return type

[**\PureCloudSDK\ChatConversation**](../Model/ChatConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getChatsChatIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getChatsChatIdParticipantsParticipantIdWrapup($chatId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getChatsChatIdParticipantsParticipantIdWrapup($chatId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getChatsChatIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getChatsChatIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getChatsChatIdParticipantsParticipantIdWrapupcodes($chatId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getChatsChatIdParticipantsParticipantIdWrapupcodes($chatId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getChatsChatIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCobrowsesessions**
> \PureCloudSDK\CobrowseConversationEntityListing getCobrowsesessions()

Get recent cobrowse conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getCobrowsesessions();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCobrowsesessions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CobrowseConversationEntityListing**](../Model/CobrowseConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCobrowsesessionsCobrowseId**
> \PureCloudSDK\CobrowseConversation getCobrowsesessionsCobrowseId($cobrowseId)

Get cobrowse conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId

try {
    $result = $api_instance->getCobrowsesessionsCobrowseId($cobrowseId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCobrowsesessionsCobrowseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |

### Return type

[**\PureCloudSDK\CobrowseConversation**](../Model/CobrowseConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup($cobrowseId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup($cobrowseId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes($cobrowseId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes($cobrowseId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getCobrowsesessionsCobrowseIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationId**
> \PureCloudSDK\Conversation getConversationId($conversationId)

Get conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID

try {
    $result = $api_instance->getConversationId($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\WrapupCode getConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getConversationIdParticipantsParticipantIdWrapup($conversationId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\WrapupCode**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID

try {
    $result = $api_instance->getConversationIdParticipantsParticipantIdWrapupcodes($conversationId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversations**
> \PureCloudSDK\ConversationEntityListing getConversations($communicationType)

Get conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$communicationType = "communicationType_example"; // string | Call or Chat communication filtering

try {
    $result = $api_instance->getConversations($communicationType);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **communicationType** | **string**| Call or Chat communication filtering | [optional]

### Return type

[**\PureCloudSDK\ConversationEntityListing**](../Model/ConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getConversationsConversationIdDetails**
> \PureCloudSDK\AnalyticsConversation getConversationsConversationIdDetails($conversationId)

Get a conversation by id



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId

try {
    $result = $api_instance->getConversationsConversationIdDetails($conversationId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getConversationsConversationIdDetails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |

### Return type

[**\PureCloudSDK\AnalyticsConversation**](../Model/AnalyticsConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmails**
> \PureCloudSDK\EmailConversationEntityListing getEmails()

Get recent email conversations



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();

try {
    $result = $api_instance->getEmails();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getEmails: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\EmailConversationEntityListing**](../Model/EmailConversationEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailsEmailId**
> \PureCloudSDK\EmailConversation getEmailsEmailId($emailId)

Get email conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId

try {
    $result = $api_instance->getEmailsEmailId($emailId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getEmailsEmailId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |

### Return type

[**\PureCloudSDK\EmailConversation**](../Model/EmailConversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailsEmailIdMessages**
> \PureCloudSDK\EmailMessageListing getEmailsEmailIdMessages($emailId)

Get conversation messages



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId

try {
    $result = $api_instance->getEmailsEmailIdMessages($emailId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getEmailsEmailIdMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |

### Return type

[**\PureCloudSDK\EmailMessageListing**](../Model/EmailMessageListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailsEmailIdMessagesDraft**
> \PureCloudSDK\EmailMessage getEmailsEmailIdMessagesDraft($emailId)

Get conversation draft reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId

try {
    $result = $api_instance->getEmailsEmailIdMessagesDraft($emailId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getEmailsEmailIdMessagesDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailsEmailIdMessagesMessageId**
> \PureCloudSDK\EmailMessage getEmailsEmailIdMessagesMessageId($emailId, $messageId)

Get conversation message



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$messageId = "messageId_example"; // string | messageId

try {
    $result = $api_instance->getEmailsEmailIdMessagesMessageId($emailId, $messageId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getEmailsEmailIdMessagesMessageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **messageId** | **string**| messageId |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailsEmailIdParticipantsParticipantIdWrapup**
> \PureCloudSDK\Wrapup getEmailsEmailIdParticipantsParticipantIdWrapup($emailId, $participantId, $provisional)

Get the wrap-up for this conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$provisional = false; // bool | Indicates if the wrap-up code is provisional.

try {
    $result = $api_instance->getEmailsEmailIdParticipantsParticipantIdWrapup($emailId, $participantId, $provisional);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getEmailsEmailIdParticipantsParticipantIdWrapup: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **provisional** | **bool**| Indicates if the wrap-up code is provisional. | [optional] [default to false]

### Return type

[**\PureCloudSDK\Wrapup**](../Model/Wrapup.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getEmailsEmailIdParticipantsParticipantIdWrapupcodes**
> \PureCloudSDK\WrapupCode[] getEmailsEmailIdParticipantsParticipantIdWrapupcodes($emailId, $participantId)

Get list of wrapup codes for this conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId

try {
    $result = $api_instance->getEmailsEmailIdParticipantsParticipantIdWrapupcodes($emailId, $participantId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->getEmailsEmailIdParticipantsParticipantIdWrapupcodes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |

### Return type

[**\PureCloudSDK\WrapupCode[]**](../Model/WrapupCode.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallbacksCallbackId**
> \PureCloudSDK\Conversation patchCallbacksCallbackId($callbackId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchCallbacksCallbackId($callbackId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallbacksCallbackId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallbacksCallbackIdParticipantsParticipantId**
> patchCallbacksCallbackIdParticipantsParticipantId($callbackId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchCallbacksCallbackIdParticipantsParticipantId($callbackId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallbacksCallbackIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallbacksCallbackIdParticipantsParticipantIdAttributes**
> patchCallbacksCallbackIdParticipantsParticipantIdAttributes($callbackId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Attributes

try {
    $api_instance->patchCallbacksCallbackIdParticipantsParticipantIdAttributes($callbackId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallbacksCallbackIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId($callbackId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId($callbackId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallbacksCallbackIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallsCallId**
> \PureCloudSDK\Conversation patchCallsCallId($callId, $body)

Update a conversation by setting it's recording state, merging in other conversations to create a conference, or disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchCallsCallId($callId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallsCallId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallsCallIdParticipantsParticipantId**
> patchCallsCallIdParticipantsParticipantId($callId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant request

try {
    $api_instance->patchCallsCallIdParticipantsParticipantId($callId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallsCallIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallsCallIdParticipantsParticipantIdAttributes**
> patchCallsCallIdParticipantsParticipantIdAttributes($callId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchCallsCallIdParticipantsParticipantIdAttributes($callId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallsCallIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId($callId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId($callId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallsCallIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCallsCallIdParticipantsParticipantIdConsult**
> \PureCloudSDK\ConsultTransferResponse patchCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body)

Change who can speak



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ConsultTransferUpdate(); // \PureCloudSDK\ConsultTransferUpdate | new speak to

try {
    $result = $api_instance->patchCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCallsCallIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ConsultTransferUpdate**](../Model/\PureCloudSDK\ConsultTransferUpdate.md)| new speak to |

### Return type

[**\PureCloudSDK\ConsultTransferResponse**](../Model/ConsultTransferResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchChatsChatId**
> \PureCloudSDK\Conversation patchChatsChatId($chatId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchChatsChatId($chatId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchChatsChatId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchChatsChatIdParticipantsParticipantId**
> patchChatsChatIdParticipantsParticipantId($chatId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchChatsChatIdParticipantsParticipantId($chatId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchChatsChatIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchChatsChatIdParticipantsParticipantIdAttributes**
> patchChatsChatIdParticipantsParticipantIdAttributes($chatId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchChatsChatIdParticipantsParticipantIdAttributes($chatId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchChatsChatIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId($chatId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId($chatId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchChatsChatIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCobrowsesessionsCobrowseId**
> \PureCloudSDK\Conversation patchCobrowsesessionsCobrowseId($cobrowseId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchCobrowsesessionsCobrowseId($cobrowseId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCobrowsesessionsCobrowseId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCobrowsesessionsCobrowseIdParticipantsParticipantId**
> patchCobrowsesessionsCobrowseIdParticipantsParticipantId($cobrowseId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | 

try {
    $api_instance->patchCobrowsesessionsCobrowseIdParticipantsParticipantId($cobrowseId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCobrowsesessionsCobrowseIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes**
> patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes($cobrowseId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | 

try {
    $api_instance->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes($cobrowseId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId($cobrowseId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId($cobrowseId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchCobrowsesessionsCobrowseIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationIdParticipantsParticipantId**
> patchConversationIdParticipantsParticipantId($conversationId, $participantId, $body)

Update a participant.

Update conversation participant.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchConversationIdParticipantsParticipantId($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchConversationIdParticipantsParticipantIdAttributes**
> patchConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchConversationIdParticipantsParticipantIdAttributes($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchConversationIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchEmailsEmailId**
> \PureCloudSDK\Conversation patchEmailsEmailId($emailId, $body)

Update a conversation by disconnecting all of the participants



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->patchEmailsEmailId($emailId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchEmailsEmailId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchEmailsEmailIdParticipantsParticipantId**
> patchEmailsEmailIdParticipantsParticipantId($emailId, $participantId, $body)

Update conversation participant



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Update request

try {
    $api_instance->patchEmailsEmailIdParticipantsParticipantId($emailId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchEmailsEmailIdParticipantsParticipantId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Update request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchEmailsEmailIdParticipantsParticipantIdAttributes**
> patchEmailsEmailIdParticipantsParticipantIdAttributes($emailId, $participantId, $body)

Update the attributes on a conversation participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ParticipantAttributes(); // \PureCloudSDK\ParticipantAttributes | Participant attributes

try {
    $api_instance->patchEmailsEmailIdParticipantsParticipantIdAttributes($emailId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchEmailsEmailIdParticipantsParticipantIdAttributes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ParticipantAttributes**](../Model/\PureCloudSDK\ParticipantAttributes.md)| Participant attributes |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId**
> patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId($emailId, $participantId, $communicationId, $body)

Update conversation participant's communication by disconnecting it.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$communicationId = "communicationId_example"; // string | communicationId
$body = new \PureCloudSDK\MediaParticipantRequest(); // \PureCloudSDK\MediaParticipantRequest | Participant

try {
    $api_instance->patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId($emailId, $participantId, $communicationId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->patchEmailsEmailIdParticipantsParticipantIdCommunicationsCommunicationId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **communicationId** | **string**| communicationId |
 **body** | [**\PureCloudSDK\MediaParticipantRequest**](../Model/\PureCloudSDK\MediaParticipantRequest.md)| Participant |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallbacks**
> \PureCloudSDK\CreateCallbackResponse postCallbacks($body)

Create a Callback



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\CreateCallbackCommand(); // \PureCloudSDK\CreateCallbackCommand | Callback

try {
    $result = $api_instance->postCallbacks($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateCallbackCommand**](../Model/\PureCloudSDK\CreateCallbackCommand.md)| Callback |

### Return type

[**\PureCloudSDK\CreateCallbackResponse**](../Model/CreateCallbackResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallbacksCallbackIdParticipantsParticipantIdReplace**
> postCallbacksCallbackIdParticipantsParticipantIdReplace($callbackId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callbackId = "callbackId_example"; // string | callbackId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postCallbacksCallbackIdParticipantsParticipantIdReplace($callbackId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCallbacksCallbackIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callbackId** | **string**| callbackId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCalls**
> \PureCloudSDK\CreateCallResponse postCalls($body)

Create a call conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\CreateCallRequest(); // \PureCloudSDK\CreateCallRequest | Call request

try {
    $result = $api_instance->postCalls($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCalls: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CreateCallRequest**](../Model/\PureCloudSDK\CreateCallRequest.md)| Call request |

### Return type

[**\PureCloudSDK\CreateCallResponse**](../Model/CreateCallResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallsCallId**
> \PureCloudSDK\Conversation postCallsCallId($callId, $body)

Add a new call to a conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$body = new \PureCloudSDK\CallCommand(); // \PureCloudSDK\CallCommand | Conversation

try {
    $result = $api_instance->postCallsCallId($callId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCallsCallId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **body** | [**\PureCloudSDK\CallCommand**](../Model/\PureCloudSDK\CallCommand.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallsCallIdParticipants**
> \PureCloudSDK\Conversation postCallsCallIdParticipants($callId, $body)

Add participants to a conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$body = new \PureCloudSDK\Conversation(); // \PureCloudSDK\Conversation | Conversation

try {
    $result = $api_instance->postCallsCallIdParticipants($callId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCallsCallIdParticipants: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **body** | [**\PureCloudSDK\Conversation**](../Model/\PureCloudSDK\Conversation.md)| Conversation |

### Return type

[**\PureCloudSDK\Conversation**](../Model/Conversation.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallsCallIdParticipantsParticipantIdConsult**
> \PureCloudSDK\ConsultTransferResponse postCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body)

Initiate and update consult transfer



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\ConsultTransfer(); // \PureCloudSDK\ConsultTransfer | Destination address & initial speak to

try {
    $result = $api_instance->postCallsCallIdParticipantsParticipantIdConsult($callId, $participantId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCallsCallIdParticipantsParticipantIdConsult: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\ConsultTransfer**](../Model/\PureCloudSDK\ConsultTransfer.md)| Destination address &amp; initial speak to |

### Return type

[**\PureCloudSDK\ConsultTransferResponse**](../Model/ConsultTransferResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallsCallIdParticipantsParticipantIdMonitor**
> postCallsCallIdParticipantsParticipantIdMonitor($callId, $participantId)

Listen in on the conversation from the point of view of a given participant.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId

try {
    $api_instance->postCallsCallIdParticipantsParticipantIdMonitor($callId, $participantId);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCallsCallIdParticipantsParticipantIdMonitor: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallsCallIdParticipantsParticipantIdReplace**
> postCallsCallIdParticipantsParticipantIdReplace($callId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$callId = "callId_example"; // string | callId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postCallsCallIdParticipantsParticipantIdReplace($callId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCallsCallIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callId** | **string**| callId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postChatsChatIdParticipantsParticipantIdReplace**
> postChatsChatIdParticipantsParticipantIdReplace($chatId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$chatId = "chatId_example"; // string | chatId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postChatsChatIdParticipantsParticipantIdReplace($chatId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postChatsChatIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **chatId** | **string**| chatId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace**
> postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace($cobrowseId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$cobrowseId = "cobrowseId_example"; // string | cobrowseId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | 

try {
    $api_instance->postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace($cobrowseId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postCobrowsesessionsCobrowseIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **cobrowseId** | **string**| cobrowseId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationIdParticipantsParticipantIdCallbacks**
> postConversationIdParticipantsParticipantIdCallbacks($conversationId, $participantId, $body)

Create a new callback for the specified participant on the conversation.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\CreateCallbackCommand(); // \PureCloudSDK\CreateCallbackCommand | 

try {
    $api_instance->postConversationIdParticipantsParticipantIdCallbacks($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationIdParticipantsParticipantIdCallbacks: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\CreateCallbackCommand**](../Model/\PureCloudSDK\CreateCallbackCommand.md)|  | [optional]

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationIdParticipantsParticipantIdReplace**
> postConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversation ID
$participantId = "participantId_example"; // string | participant ID
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postConversationIdParticipantsParticipantIdReplace($conversationId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversation ID |
 **participantId** | **string**| participant ID |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsAggregatesQuery**
> \PureCloudSDK\AggregateQueryResponse postConversationsAggregatesQuery($body)

Query for conversation aggregates



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\AggregationQuery(); // \PureCloudSDK\AggregationQuery | query

try {
    $result = $api_instance->postConversationsAggregatesQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsAggregatesQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AggregationQuery**](../Model/\PureCloudSDK\AggregationQuery.md)| query |

### Return type

[**\PureCloudSDK\AggregateQueryResponse**](../Model/AggregateQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdDetailsProperties**
> \PureCloudSDK\PropertyIndexRequest postConversationsConversationIdDetailsProperties($conversationId, $body)

Index conversation properties



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$conversationId = "conversationId_example"; // string | conversationId
$body = new \PureCloudSDK\PropertyIndexRequest(); // \PureCloudSDK\PropertyIndexRequest | request

try {
    $result = $api_instance->postConversationsConversationIdDetailsProperties($conversationId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsConversationIdDetailsProperties: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| conversationId |
 **body** | [**\PureCloudSDK\PropertyIndexRequest**](../Model/\PureCloudSDK\PropertyIndexRequest.md)| request |

### Return type

[**\PureCloudSDK\PropertyIndexRequest**](../Model/PropertyIndexRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsDetailsQuery**
> \PureCloudSDK\AnalyticsConversationQueryResponse postConversationsDetailsQuery($body)

Query for conversation details



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\ConversationQuery(); // \PureCloudSDK\ConversationQuery | query

try {
    $result = $api_instance->postConversationsDetailsQuery($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postConversationsDetailsQuery: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ConversationQuery**](../Model/\PureCloudSDK\ConversationQuery.md)| query |

### Return type

[**\PureCloudSDK\AnalyticsConversationQueryResponse**](../Model/AnalyticsConversationQueryResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postEmailsEmailIdMessages**
> \PureCloudSDK\EmailMessage postEmailsEmailIdMessages($emailId, $body)

Send an email reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$body = new \PureCloudSDK\EmailMessage(); // \PureCloudSDK\EmailMessage | Reply

try {
    $result = $api_instance->postEmailsEmailIdMessages($emailId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postEmailsEmailIdMessages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **body** | [**\PureCloudSDK\EmailMessage**](../Model/\PureCloudSDK\EmailMessage.md)| Reply |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postEmailsEmailIdParticipantsParticipantIdReplace**
> postEmailsEmailIdParticipantsParticipantIdReplace($emailId, $participantId, $body)

Replace this participant with the specified user and/or address



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$participantId = "participantId_example"; // string | participantId
$body = new \PureCloudSDK\TransferRequest(); // \PureCloudSDK\TransferRequest | Transfer request

try {
    $api_instance->postEmailsEmailIdParticipantsParticipantIdReplace($emailId, $participantId, $body);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postEmailsEmailIdParticipantsParticipantIdReplace: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **participantId** | **string**| participantId |
 **body** | [**\PureCloudSDK\TransferRequest**](../Model/\PureCloudSDK\TransferRequest.md)| Transfer request |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postFaxes**
> \PureCloudSDK\FaxSendResponse postFaxes($body)

Create Fax Conversation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$body = new \PureCloudSDK\FaxSendRequest(); // \PureCloudSDK\FaxSendRequest | Fax

try {
    $result = $api_instance->postFaxes($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->postFaxes: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\FaxSendRequest**](../Model/\PureCloudSDK\FaxSendRequest.md)| Fax |

### Return type

[**\PureCloudSDK\FaxSendResponse**](../Model/FaxSendResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putEmailsEmailIdMessagesDraft**
> \PureCloudSDK\EmailMessage putEmailsEmailIdMessagesDraft($emailId, $body)

Update conversation draft reply



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\ConversationsApi();
$emailId = "emailId_example"; // string | emailId
$body = new \PureCloudSDK\EmailMessage(); // \PureCloudSDK\EmailMessage | Draft

try {
    $result = $api_instance->putEmailsEmailIdMessagesDraft($emailId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling ConversationsApi->putEmailsEmailIdMessagesDraft: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **emailId** | **string**| emailId |
 **body** | [**\PureCloudSDK\EmailMessage**](../Model/\PureCloudSDK\EmailMessage.md)| Draft |

### Return type

[**\PureCloudSDK\EmailMessage**](../Model/EmailMessage.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

