# PureCloudSDK\GroupsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteGroupId**](GroupsApi.md#deleteGroupId) | **DELETE** /api/v2/groups/{groupId} | Delete group
[**deleteGroupIdMembers**](GroupsApi.md#deleteGroupIdMembers) | **DELETE** /api/v2/groups/{groupId}/members | Remove members
[**getFieldconfig**](GroupsApi.md#getFieldconfig) | **GET** /api/v2/fieldconfig | Fetch field config for an entity type
[**getGroupId**](GroupsApi.md#getGroupId) | **GET** /api/v2/groups/{groupId} | Get group
[**getGroupIdMembers**](GroupsApi.md#getGroupIdMembers) | **GET** /api/v2/groups/{groupId}/members | Get group members
[**getGroups**](GroupsApi.md#getGroups) | **GET** /api/v2/groups | Get a group list
[**getSearch**](GroupsApi.md#getSearch) | **GET** /api/v2/groups/search | Search groups using the q64 value returned from a previous search
[**postGroupIdMembers**](GroupsApi.md#postGroupIdMembers) | **POST** /api/v2/groups/{groupId}/members | Add members
[**postGroups**](GroupsApi.md#postGroups) | **POST** /api/v2/groups | Create a group
[**postSearch**](GroupsApi.md#postSearch) | **POST** /api/v2/groups/search | Search groups
[**putGroupId**](GroupsApi.md#putGroupId) | **PUT** /api/v2/groups/{groupId} | Update group


# **deleteGroupId**
> string deleteGroupId($groupId)

Delete group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID

try {
    $result = $api_instance->deleteGroupId($groupId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->deleteGroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteGroupIdMembers**
> deleteGroupIdMembers($groupId, $ids)

Remove members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID
$ids = "ids_example"; // string | Comma separated list of userIds to remove

try {
    $api_instance->deleteGroupIdMembers($groupId, $ids);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->deleteGroupIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **ids** | **string**| Comma separated list of userIds to remove |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getFieldconfig**
> \PureCloudSDK\FieldConfig getFieldconfig($type)

Fetch field config for an entity type



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$type = "type_example"; // string | Field type

try {
    $result = $api_instance->getFieldconfig($type);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getFieldconfig: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **type** | **string**| Field type |

### Return type

[**\PureCloudSDK\FieldConfig**](../Model/FieldConfig.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGroupId**
> \PureCloudSDK\Group getGroupId($groupId)

Get group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID

try {
    $result = $api_instance->getGroupId($groupId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getGroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |

### Return type

[**\PureCloudSDK\Group**](../Model/Group.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGroupIdMembers**
> \PureCloudSDK\UserEntityListing getGroupIdMembers($groupId, $pageSize, $pageNumber, $sortOrder)

Get group members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Ascending or descending sort order

try {
    $result = $api_instance->getGroupIdMembers($groupId, $pageSize, $pageNumber, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getGroupIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\UserEntityListing**](../Model/UserEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getGroups**
> \PureCloudSDK\GroupEntityListing getGroups($pageSize, $pageNumber, $sortOrder)

Get a group list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Ascending or descending sort order

try {
    $result = $api_instance->getGroups($pageSize, $pageNumber, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getGroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]

### Return type

[**\PureCloudSDK\GroupEntityListing**](../Model/GroupEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSearch**
> \PureCloudSDK\GroupsSearchResponse getSearch($q64, $expand)

Search groups using the q64 value returned from a previous search



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$q64 = "q64_example"; // string | q64
$expand = array("expand_example"); // string[] | expand

try {
    $result = $api_instance->getSearch($q64, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->getSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **q64** | **string**| q64 |
 **expand** | [**string[]**](../Model/string.md)| expand | [optional]

### Return type

[**\PureCloudSDK\GroupsSearchResponse**](../Model/GroupsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postGroupIdMembers**
> postGroupIdMembers($groupId, $body)

Add members



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID
$body = new \PureCloudSDK\GroupMembersUpdate(); // \PureCloudSDK\GroupMembersUpdate | Add members

try {
    $api_instance->postGroupIdMembers($groupId, $body);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->postGroupIdMembers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **body** | [**\PureCloudSDK\GroupMembersUpdate**](../Model/\PureCloudSDK\GroupMembersUpdate.md)| Add members |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postGroups**
> \PureCloudSDK\Group postGroups($body)

Create a group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$body = new \PureCloudSDK\Group(); // \PureCloudSDK\Group | Group

try {
    $result = $api_instance->postGroups($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->postGroups: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Group**](../Model/\PureCloudSDK\Group.md)| Group |

### Return type

[**\PureCloudSDK\Group**](../Model/Group.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSearch**
> \PureCloudSDK\GroupsSearchResponse postSearch($body)

Search groups



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$body = new \PureCloudSDK\GroupSearchRequest(); // \PureCloudSDK\GroupSearchRequest | Search request options

try {
    $result = $api_instance->postSearch($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->postSearch: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\GroupSearchRequest**](../Model/\PureCloudSDK\GroupSearchRequest.md)| Search request options |

### Return type

[**\PureCloudSDK\GroupsSearchResponse**](../Model/GroupsSearchResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putGroupId**
> \PureCloudSDK\Group putGroupId($groupId, $body)

Update group



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\GroupsApi();
$groupId = "groupId_example"; // string | Group ID
$body = new \PureCloudSDK\GroupUpdate(); // \PureCloudSDK\GroupUpdate | Group

try {
    $result = $api_instance->putGroupId($groupId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling GroupsApi->putGroupId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **groupId** | **string**| Group ID |
 **body** | [**\PureCloudSDK\GroupUpdate**](../Model/\PureCloudSDK\GroupUpdate.md)| Group | [optional]

### Return type

[**\PureCloudSDK\Group**](../Model/Group.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

