# PureCloudSDK\LanguagesApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteLanguageId**](LanguagesApi.md#deleteLanguageId) | **DELETE** /api/v2/languages/{languageId} | Delete Language
[**getLanguageId**](LanguagesApi.md#getLanguageId) | **GET** /api/v2/languages/{languageId} | Get language
[**getLanguages**](LanguagesApi.md#getLanguages) | **GET** /api/v2/languages | Get the list of supported languages.
[**getTranslations**](LanguagesApi.md#getTranslations) | **GET** /api/v2/languages/translations | Get all available languages for translation
[**getTranslationsBuiltin**](LanguagesApi.md#getTranslationsBuiltin) | **GET** /api/v2/languages/translations/builtin | Get the builtin translation for a language
[**getTranslationsOrganization**](LanguagesApi.md#getTranslationsOrganization) | **GET** /api/v2/languages/translations/organization | Get effective translation for an organization by language
[**getTranslationsUsersUserId**](LanguagesApi.md#getTranslationsUsersUserId) | **GET** /api/v2/languages/translations/users/{userId} | Get effective language translation for a user
[**postLanguages**](LanguagesApi.md#postLanguages) | **POST** /api/v2/languages | Create Language
[**putLanguageId**](LanguagesApi.md#putLanguageId) | **PUT** /api/v2/languages/{languageId} | Update Language


# **deleteLanguageId**
> deleteLanguageId($languageId)

Delete Language



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();
$languageId = "languageId_example"; // string | Language ID

try {
    $api_instance->deleteLanguageId($languageId);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->deleteLanguageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **languageId** | **string**| Language ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLanguageId**
> \PureCloudSDK\Language getLanguageId($languageId)

Get language



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();
$languageId = "languageId_example"; // string | Language ID

try {
    $result = $api_instance->getLanguageId($languageId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->getLanguageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **languageId** | **string**| Language ID |

### Return type

[**\PureCloudSDK\Language**](../Model/Language.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getLanguages**
> \PureCloudSDK\LanguageEntityListing getLanguages($pageSize, $pageNumber, $sortOrder, $name)

Get the list of supported languages.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortOrder = "ASC"; // string | Ascending or descending sort order
$name = "name_example"; // string | Name

try {
    $result = $api_instance->getLanguages($pageSize, $pageNumber, $sortOrder, $name);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->getLanguages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortOrder** | **string**| Ascending or descending sort order | [optional] [default to ASC]
 **name** | **string**| Name | [optional]

### Return type

[**\PureCloudSDK\LanguageEntityListing**](../Model/LanguageEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTranslations**
> \PureCloudSDK\AvailableTranslations getTranslations()

Get all available languages for translation



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();

try {
    $result = $api_instance->getTranslations();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->getTranslations: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\AvailableTranslations**](../Model/AvailableTranslations.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTranslationsBuiltin**
> map[string,object] getTranslationsBuiltin($language)

Get the builtin translation for a language



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();
$language = "language_example"; // string | The language of the builtin translation to retrieve

try {
    $result = $api_instance->getTranslationsBuiltin($language);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->getTranslationsBuiltin: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **language** | **string**| The language of the builtin translation to retrieve |

### Return type

[**map[string,object]**](../Model/map.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTranslationsOrganization**
> map[string,object] getTranslationsOrganization($language)

Get effective translation for an organization by language



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();
$language = "language_example"; // string | The language of the translation to retrieve for the organization

try {
    $result = $api_instance->getTranslationsOrganization($language);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->getTranslationsOrganization: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **language** | **string**| The language of the translation to retrieve for the organization |

### Return type

[**map[string,object]**](../Model/map.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getTranslationsUsersUserId**
> map[string,object] getTranslationsUsersUserId($userId)

Get effective language translation for a user



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();
$userId = "userId_example"; // string | The user id

try {
    $result = $api_instance->getTranslationsUsersUserId($userId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->getTranslationsUsersUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **userId** | **string**| The user id |

### Return type

[**map[string,object]**](../Model/map.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postLanguages**
> \PureCloudSDK\Language postLanguages($body)

Create Language



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();
$body = new \PureCloudSDK\Language(); // \PureCloudSDK\Language | Language

try {
    $result = $api_instance->postLanguages($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->postLanguages: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Language**](../Model/\PureCloudSDK\Language.md)| Language |

### Return type

[**\PureCloudSDK\Language**](../Model/Language.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putLanguageId**
> \PureCloudSDK\Language putLanguageId($languageId, $body)

Update Language



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\LanguagesApi();
$languageId = "languageId_example"; // string | Language ID
$body = new \PureCloudSDK\Language(); // \PureCloudSDK\Language | Language

try {
    $result = $api_instance->putLanguageId($languageId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling LanguagesApi->putLanguageId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **languageId** | **string**| Language ID |
 **body** | [**\PureCloudSDK\Language**](../Model/\PureCloudSDK\Language.md)| Language |

### Return type

[**\PureCloudSDK\Language**](../Model/Language.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

