# PureCloudSDK\OAuthApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteClientsClientId**](OAuthApi.md#deleteClientsClientId) | **DELETE** /api/v2/oauth/clients/{clientId} | Delete OAuth Client
[**getClients**](OAuthApi.md#getClients) | **GET** /api/v2/oauth/clients | The list of OAuth clients
[**getClientsClientId**](OAuthApi.md#getClientsClientId) | **GET** /api/v2/oauth/clients/{clientId} | Get OAuth Client
[**postClients**](OAuthApi.md#postClients) | **POST** /api/v2/oauth/clients | Create OAuth client
[**postClientsClientIdSecret**](OAuthApi.md#postClientsClientIdSecret) | **POST** /api/v2/oauth/clients/{clientId}/secret | Regenerate Client Secret
[**putClientsClientId**](OAuthApi.md#putClientsClientId) | **PUT** /api/v2/oauth/clients/{clientId} | Update OAuth Client


# **deleteClientsClientId**
> deleteClientsClientId($clientId)

Delete OAuth Client



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OAuthApi();
$clientId = "clientId_example"; // string | Client ID

try {
    $api_instance->deleteClientsClientId($clientId);
} catch (Exception $e) {
    echo 'Exception when calling OAuthApi->deleteClientsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clientId** | **string**| Client ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getClients**
> \PureCloudSDK\OAuthClientEntityListing getClients()

The list of OAuth clients



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OAuthApi();

try {
    $result = $api_instance->getClients();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OAuthApi->getClients: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\OAuthClientEntityListing**](../Model/OAuthClientEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getClientsClientId**
> \PureCloudSDK\OAuthClient getClientsClientId($clientId)

Get OAuth Client



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OAuthApi();
$clientId = "clientId_example"; // string | Client ID

try {
    $result = $api_instance->getClientsClientId($clientId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OAuthApi->getClientsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clientId** | **string**| Client ID |

### Return type

[**\PureCloudSDK\OAuthClient**](../Model/OAuthClient.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postClients**
> \PureCloudSDK\OAuthClient postClients($body)

Create OAuth client

The OAuth Grant/Client is required in order to create an authentication token and gain access to PureCloud.  The preferred authorizedGrantTypes is 'CODE' which requires applications to send a client ID and client secret. This is typically a web server.  If the client is unable to secure the client secret then the 'TOKEN' grant type aka IMPLICIT should be used. This is would be for browser or mobile apps.  If a client is to be used outside of the context of a user then the 'CLIENT-CREDENTIALS' grant may be used. In this case the client must be granted roles  via the 'roleIds' field.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OAuthApi();
$body = new \PureCloudSDK\OAuthClient(); // \PureCloudSDK\OAuthClient | Client

try {
    $result = $api_instance->postClients($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OAuthApi->postClients: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\OAuthClient**](../Model/\PureCloudSDK\OAuthClient.md)| Client |

### Return type

[**\PureCloudSDK\OAuthClient**](../Model/OAuthClient.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postClientsClientIdSecret**
> postClientsClientIdSecret($clientId)

Regenerate Client Secret

This operation will set the client secret to a randomly generated cryptographically random value. All clients must be updated with the new secret. This operation should be used with caution.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OAuthApi();
$clientId = "clientId_example"; // string | Client ID

try {
    $api_instance->postClientsClientIdSecret($clientId);
} catch (Exception $e) {
    echo 'Exception when calling OAuthApi->postClientsClientIdSecret: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clientId** | **string**| Client ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putClientsClientId**
> \PureCloudSDK\OAuthClient putClientsClientId($clientId, $body)

Update OAuth Client



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OAuthApi();
$clientId = "clientId_example"; // string | Client ID
$body = new \PureCloudSDK\OAuthClient(); // \PureCloudSDK\OAuthClient | Client

try {
    $result = $api_instance->putClientsClientId($clientId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OAuthApi->putClientsClientId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **clientId** | **string**| Client ID |
 **body** | [**\PureCloudSDK\OAuthClient**](../Model/\PureCloudSDK\OAuthClient.md)| Client |

### Return type

[**\PureCloudSDK\OAuthClient**](../Model/OAuthClient.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

