# PureCloudSDK\OutboundApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteAttemptlimitsAttemptlimitsId**](OutboundApi.md#deleteAttemptlimitsAttemptlimitsId) | **DELETE** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Delete attempt limits
[**deleteCallabletimesetsCallabletimesetId**](OutboundApi.md#deleteCallabletimesetsCallabletimesetId) | **DELETE** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Delete callable time set
[**deleteCallanalysisresponsesetsCallanalysissetId**](OutboundApi.md#deleteCallanalysisresponsesetsCallanalysissetId) | **DELETE** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Delete a dialer call analysis response set.
[**deleteCampaignsCampaignId**](OutboundApi.md#deleteCampaignsCampaignId) | **DELETE** /api/v2/outbound/campaigns/{campaignId} | Delete a campaign.
[**deleteCampaignsCampaignIdProgress**](OutboundApi.md#deleteCampaignsCampaignIdProgress) | **DELETE** /api/v2/outbound/campaigns/{campaignId}/progress | Reset campaign progress and recycle the campaign
[**deleteContactlistsContactlistId**](OutboundApi.md#deleteContactlistsContactlistId) | **DELETE** /api/v2/outbound/contactlists/{contactListId} | Delete a contact list.
[**deleteContactlistsContactlistIdContactsContactId**](OutboundApi.md#deleteContactlistsContactlistIdContactsContactId) | **DELETE** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Delete a contact.
[**deleteDnclistsDnclistId**](OutboundApi.md#deleteDnclistsDnclistId) | **DELETE** /api/v2/outbound/dnclists/{dncListId} | Delete dialer DNC list
[**deleteRulesetsRulesetId**](OutboundApi.md#deleteRulesetsRulesetId) | **DELETE** /api/v2/outbound/rulesets/{ruleSetId} | Delete a Rule set.
[**deleteSchedulesCampaignsCampaignId**](OutboundApi.md#deleteSchedulesCampaignsCampaignId) | **DELETE** /api/v2/outbound/schedules/campaigns/{campaignId} | Delete a dialer campaign schedule.
[**deleteSchedulesSequencesSequenceId**](OutboundApi.md#deleteSchedulesSequencesSequenceId) | **DELETE** /api/v2/outbound/schedules/sequences/{sequenceId} | Delete a dialer sequence schedule.
[**deleteSequencesSequenceId**](OutboundApi.md#deleteSequencesSequenceId) | **DELETE** /api/v2/outbound/sequences/{sequenceId} | Delete a dialer campaign sequence.
[**getAttemptlimits**](OutboundApi.md#getAttemptlimits) | **GET** /api/v2/outbound/attemptlimits | Query attempt limits list
[**getAttemptlimitsAttemptlimitsId**](OutboundApi.md#getAttemptlimitsAttemptlimitsId) | **GET** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Get attempt limits
[**getCallabletimesets**](OutboundApi.md#getCallabletimesets) | **GET** /api/v2/outbound/callabletimesets | Query callable time set list
[**getCallabletimesetsCallabletimesetId**](OutboundApi.md#getCallabletimesetsCallabletimesetId) | **GET** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Get callable time set
[**getCallanalysisresponsesets**](OutboundApi.md#getCallanalysisresponsesets) | **GET** /api/v2/outbound/callanalysisresponsesets | Query a list of dialer call analysis response sets.
[**getCallanalysisresponsesetsCallanalysissetId**](OutboundApi.md#getCallanalysisresponsesetsCallanalysissetId) | **GET** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Get a dialer call analysis response set.
[**getCampaigns**](OutboundApi.md#getCampaigns) | **GET** /api/v2/outbound/campaigns | Query a list of dialer campaigns.
[**getCampaignsCampaignId**](OutboundApi.md#getCampaignsCampaignId) | **GET** /api/v2/outbound/campaigns/{campaignId} | Get dialer campaign.
[**getCampaignsCampaignIdDiagnostics**](OutboundApi.md#getCampaignsCampaignIdDiagnostics) | **GET** /api/v2/outbound/campaigns/{campaignId}/diagnostics | Get campaign diagnostics
[**getCampaignsCampaignIdInteractions**](OutboundApi.md#getCampaignsCampaignIdInteractions) | **GET** /api/v2/outbound/campaigns/{campaignId}/interactions | Get dialer campaign interactions.
[**getCampaignsCampaignIdProgress**](OutboundApi.md#getCampaignsCampaignIdProgress) | **GET** /api/v2/outbound/campaigns/{campaignId}/progress | Get campaign progress
[**getCampaignsCampaignIdStats**](OutboundApi.md#getCampaignsCampaignIdStats) | **GET** /api/v2/outbound/campaigns/{campaignId}/stats | Get statistics about a Dialer Campaign
[**getContactlists**](OutboundApi.md#getContactlists) | **GET** /api/v2/outbound/contactlists | Query a list of contact lists.
[**getContactlistsContactlistId**](OutboundApi.md#getContactlistsContactlistId) | **GET** /api/v2/outbound/contactlists/{contactListId} | Get a dialer contact list.
[**getContactlistsContactlistIdContactsContactId**](OutboundApi.md#getContactlistsContactlistIdContactsContactId) | **GET** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Get a contact.
[**getContactlistsContactlistIdExport**](OutboundApi.md#getContactlistsContactlistIdExport) | **GET** /api/v2/outbound/contactlists/{contactListId}/export | Get the URI of a contact list export.
[**getContactlistsContactlistIdImportstatus**](OutboundApi.md#getContactlistsContactlistIdImportstatus) | **GET** /api/v2/outbound/contactlists/{contactListId}/importstatus | Get dialer contactList import status.
[**getDnclists**](OutboundApi.md#getDnclists) | **GET** /api/v2/outbound/dnclists | Query dialer DNC lists
[**getDnclistsDnclistId**](OutboundApi.md#getDnclistsDnclistId) | **GET** /api/v2/outbound/dnclists/{dncListId} | Get dialer DNC list
[**getDnclistsDnclistIdExport**](OutboundApi.md#getDnclistsDnclistIdExport) | **GET** /api/v2/outbound/dnclists/{dncListId}/export | Get the URI of a DNC list export.
[**getDnclistsDnclistIdImportstatus**](OutboundApi.md#getDnclistsDnclistIdImportstatus) | **GET** /api/v2/outbound/dnclists/{dncListId}/importstatus | Get dialer dncList import status.
[**getRulesets**](OutboundApi.md#getRulesets) | **GET** /api/v2/outbound/rulesets | Query a list of Rule Sets.
[**getRulesetsRulesetId**](OutboundApi.md#getRulesetsRulesetId) | **GET** /api/v2/outbound/rulesets/{ruleSetId} | Get a Rule Set by ID.
[**getSchedulesCampaigns**](OutboundApi.md#getSchedulesCampaigns) | **GET** /api/v2/outbound/schedules/campaigns | Query for a list of dialer campaign schedules.
[**getSchedulesCampaignsCampaignId**](OutboundApi.md#getSchedulesCampaignsCampaignId) | **GET** /api/v2/outbound/schedules/campaigns/{campaignId} | Get a dialer campaign schedule.
[**getSchedulesSequences**](OutboundApi.md#getSchedulesSequences) | **GET** /api/v2/outbound/schedules/sequences | Query for a list of dialer sequence schedules.
[**getSchedulesSequencesSequenceId**](OutboundApi.md#getSchedulesSequencesSequenceId) | **GET** /api/v2/outbound/schedules/sequences/{sequenceId} | Get a dialer sequence schedule.
[**getSequences**](OutboundApi.md#getSequences) | **GET** /api/v2/outbound/sequences | Query a list of dialer campaign sequences.
[**getSequencesSequenceId**](OutboundApi.md#getSequencesSequenceId) | **GET** /api/v2/outbound/sequences/{sequenceId} | Get a dialer campaign sequence.
[**getWrapupcodemappings**](OutboundApi.md#getWrapupcodemappings) | **GET** /api/v2/outbound/wrapupcodemappings | Get the Dialer wrap up code mapping.
[**postAttemptlimits**](OutboundApi.md#postAttemptlimits) | **POST** /api/v2/outbound/attemptlimits | Create attempt limits
[**postAudits**](OutboundApi.md#postAudits) | **POST** /api/v2/outbound/audits | Retrieves audits for dialer.
[**postCallabletimesets**](OutboundApi.md#postCallabletimesets) | **POST** /api/v2/outbound/callabletimesets | Create callable time set
[**postCallanalysisresponsesets**](OutboundApi.md#postCallanalysisresponsesets) | **POST** /api/v2/outbound/callanalysisresponsesets | Create a dialer call analysis response set.
[**postCampaigns**](OutboundApi.md#postCampaigns) | **POST** /api/v2/outbound/campaigns | Create a campaign.
[**postCampaignsCampaignIdCallbackSchedule**](OutboundApi.md#postCampaignsCampaignIdCallbackSchedule) | **POST** /api/v2/outbound/campaigns/{campaignId}/callback/schedule | Schedule a Callback for a Dialer Campaign (Deprecated)
[**postCampaignsProgress**](OutboundApi.md#postCampaignsProgress) | **POST** /api/v2/outbound/campaigns/progress | Get progress for a list of campaigns
[**postContactlists**](OutboundApi.md#postContactlists) | **POST** /api/v2/outbound/contactlists | Create a contact List.
[**postContactlistsContactlistIdContacts**](OutboundApi.md#postContactlistsContactlistIdContacts) | **POST** /api/v2/outbound/contactlists/{contactListId}/contacts | Add contacts to a contact list.
[**postContactlistsContactlistIdExport**](OutboundApi.md#postContactlistsContactlistIdExport) | **POST** /api/v2/outbound/contactlists/{contactListId}/export | Initiate the export of a contact list.
[**postConversationsConversationIdDnc**](OutboundApi.md#postConversationsConversationIdDnc) | **POST** /api/v2/outbound/conversations/{conversationId}/dnc | Add phone numbers to a Dialer DNC list.
[**postDnclists**](OutboundApi.md#postDnclists) | **POST** /api/v2/outbound/dnclists | Create dialer DNC list
[**postDnclistsDnclistIdExport**](OutboundApi.md#postDnclistsDnclistIdExport) | **POST** /api/v2/outbound/dnclists/{dncListId}/export | Initiate the export of a dnc list.
[**postDnclistsDnclistIdPhonenumbers**](OutboundApi.md#postDnclistsDnclistIdPhonenumbers) | **POST** /api/v2/outbound/dnclists/{dncListId}/phonenumbers | Add phone numbers to a Dialer DNC list.
[**postRulesets**](OutboundApi.md#postRulesets) | **POST** /api/v2/outbound/rulesets | Create a Dialer Call Analysis Response Set.
[**postSequences**](OutboundApi.md#postSequences) | **POST** /api/v2/outbound/sequences | Create a new campaign sequence.
[**putAttemptlimitsAttemptlimitsId**](OutboundApi.md#putAttemptlimitsAttemptlimitsId) | **PUT** /api/v2/outbound/attemptlimits/{attemptLimitsId} | Update attempt limits
[**putCallabletimesetsCallabletimesetId**](OutboundApi.md#putCallabletimesetsCallabletimesetId) | **PUT** /api/v2/outbound/callabletimesets/{callableTimeSetId} | Update callable time set
[**putCallanalysisresponsesetsCallanalysissetId**](OutboundApi.md#putCallanalysisresponsesetsCallanalysissetId) | **PUT** /api/v2/outbound/callanalysisresponsesets/{callAnalysisSetId} | Update a dialer call analysis response set.
[**putCampaignsCampaignId**](OutboundApi.md#putCampaignsCampaignId) | **PUT** /api/v2/outbound/campaigns/{campaignId} | Update a campaign.
[**putCampaignsCampaignIdAgentsUserId**](OutboundApi.md#putCampaignsCampaignIdAgentsUserId) | **PUT** /api/v2/outbound/campaigns/{campaignId}/agents/{userId} | Send notification that an agent&#39;s state changed
[**putContactlistsContactlistId**](OutboundApi.md#putContactlistsContactlistId) | **PUT** /api/v2/outbound/contactlists/{contactListId} | Update a contact list.
[**putContactlistsContactlistIdContactsContactId**](OutboundApi.md#putContactlistsContactlistIdContactsContactId) | **PUT** /api/v2/outbound/contactlists/{contactListId}/contacts/{contactId} | Update a contact.
[**putDnclistsDnclistId**](OutboundApi.md#putDnclistsDnclistId) | **PUT** /api/v2/outbound/dnclists/{dncListId} | Update dialer DNC list
[**putRulesetsRulesetId**](OutboundApi.md#putRulesetsRulesetId) | **PUT** /api/v2/outbound/rulesets/{ruleSetId} | Update a RuleSet.
[**putSchedulesCampaignsCampaignId**](OutboundApi.md#putSchedulesCampaignsCampaignId) | **PUT** /api/v2/outbound/schedules/campaigns/{campaignId} | Update a new campaign schedule.
[**putSchedulesSequencesSequenceId**](OutboundApi.md#putSchedulesSequencesSequenceId) | **PUT** /api/v2/outbound/schedules/sequences/{sequenceId} | Update a new sequence schedule.
[**putSequencesSequenceId**](OutboundApi.md#putSequencesSequenceId) | **PUT** /api/v2/outbound/sequences/{sequenceId} | Update a new campaign sequence.
[**putWrapupcodemappings**](OutboundApi.md#putWrapupcodemappings) | **PUT** /api/v2/outbound/wrapupcodemappings | Update the Dialer wrap up code mapping.


# **deleteAttemptlimitsAttemptlimitsId**
> string deleteAttemptlimitsAttemptlimitsId($attemptLimitsId)

Delete attempt limits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$attemptLimitsId = "attemptLimitsId_example"; // string | Attempt limits ID

try {
    $result = $api_instance->deleteAttemptlimitsAttemptlimitsId($attemptLimitsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteAttemptlimitsAttemptlimitsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attemptLimitsId** | **string**| Attempt limits ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteCallabletimesetsCallabletimesetId**
> string deleteCallabletimesetsCallabletimesetId($callableTimeSetId)

Delete callable time set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callableTimeSetId = "callableTimeSetId_example"; // string | Callable Time Set ID

try {
    $result = $api_instance->deleteCallabletimesetsCallabletimesetId($callableTimeSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteCallabletimesetsCallabletimesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callableTimeSetId** | **string**| Callable Time Set ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteCallanalysisresponsesetsCallanalysissetId**
> string deleteCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId)

Delete a dialer call analysis response set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callAnalysisSetId = "callAnalysisSetId_example"; // string | Call Analysis Response Set ID

try {
    $result = $api_instance->deleteCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteCallanalysisresponsesetsCallanalysissetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callAnalysisSetId** | **string**| Call Analysis Response Set ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteCampaignsCampaignId**
> string deleteCampaignsCampaignId($campaignId)

Delete a campaign.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->deleteCampaignsCampaignId($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteCampaignsCampaignIdProgress**
> string deleteCampaignsCampaignIdProgress($campaignId)

Reset campaign progress and recycle the campaign



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->deleteCampaignsCampaignIdProgress($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteCampaignsCampaignIdProgress: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteContactlistsContactlistId**
> string deleteContactlistsContactlistId($contactListId)

Delete a contact list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID

try {
    $result = $api_instance->deleteContactlistsContactlistId($contactListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteContactlistsContactlistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteContactlistsContactlistIdContactsContactId**
> string deleteContactlistsContactlistIdContactsContactId($contactListId, $contactId)

Delete a contact.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | Contact List ID
$contactId = "contactId_example"; // string | Contact ID

try {
    $result = $api_instance->deleteContactlistsContactlistIdContactsContactId($contactListId, $contactId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteContactlistsContactlistIdContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| Contact List ID |
 **contactId** | **string**| Contact ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteDnclistsDnclistId**
> string deleteDnclistsDnclistId($dncListId)

Delete dialer DNC list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID

try {
    $result = $api_instance->deleteDnclistsDnclistId($dncListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteDnclistsDnclistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteRulesetsRulesetId**
> string deleteRulesetsRulesetId($ruleSetId)

Delete a Rule set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$ruleSetId = "ruleSetId_example"; // string | Rule Set ID

try {
    $result = $api_instance->deleteRulesetsRulesetId($ruleSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteRulesetsRulesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleSetId** | **string**| Rule Set ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteSchedulesCampaignsCampaignId**
> string deleteSchedulesCampaignsCampaignId($campaignId)

Delete a dialer campaign schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->deleteSchedulesCampaignsCampaignId($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteSchedulesCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteSchedulesSequencesSequenceId**
> string deleteSchedulesSequencesSequenceId($sequenceId)

Delete a dialer sequence schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Sequence ID

try {
    $result = $api_instance->deleteSchedulesSequencesSequenceId($sequenceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteSchedulesSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Sequence ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **deleteSequencesSequenceId**
> string deleteSequencesSequenceId($sequenceId)

Delete a dialer campaign sequence.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Campaign Sequence ID

try {
    $result = $api_instance->deleteSequencesSequenceId($sequenceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->deleteSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Campaign Sequence ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAttemptlimits**
> \PureCloudSDK\AttemptLimitsEntityListing getAttemptlimits($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query attempt limits list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getAttemptlimits($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getAttemptlimits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\AttemptLimitsEntityListing**](../Model/AttemptLimitsEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getAttemptlimitsAttemptlimitsId**
> \PureCloudSDK\AttemptLimits getAttemptlimitsAttemptlimitsId($attemptLimitsId)

Get attempt limits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$attemptLimitsId = "attemptLimitsId_example"; // string | Attempt limits ID

try {
    $result = $api_instance->getAttemptlimitsAttemptlimitsId($attemptLimitsId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getAttemptlimitsAttemptlimitsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attemptLimitsId** | **string**| Attempt limits ID |

### Return type

[**\PureCloudSDK\AttemptLimits**](../Model/AttemptLimits.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallabletimesets**
> \PureCloudSDK\CallableTimeSetEntityListing getCallabletimesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query callable time set list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getCallabletimesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCallabletimesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\CallableTimeSetEntityListing**](../Model/CallableTimeSetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallabletimesetsCallabletimesetId**
> \PureCloudSDK\CallableTimeSet getCallabletimesetsCallabletimesetId($callableTimeSetId)

Get callable time set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callableTimeSetId = "callableTimeSetId_example"; // string | Callable Time Set ID

try {
    $result = $api_instance->getCallabletimesetsCallabletimesetId($callableTimeSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCallabletimesetsCallabletimesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callableTimeSetId** | **string**| Callable Time Set ID |

### Return type

[**\PureCloudSDK\CallableTimeSet**](../Model/CallableTimeSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallanalysisresponsesets**
> \PureCloudSDK\ResponseSetEntityListing getCallanalysisresponsesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query a list of dialer call analysis response sets.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getCallanalysisresponsesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCallanalysisresponsesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\ResponseSetEntityListing**](../Model/ResponseSetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCallanalysisresponsesetsCallanalysissetId**
> \PureCloudSDK\ResponseSet getCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId)

Get a dialer call analysis response set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callAnalysisSetId = "callAnalysisSetId_example"; // string | Call Analysis Response Set ID

try {
    $result = $api_instance->getCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCallanalysisresponsesetsCallanalysissetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callAnalysisSetId** | **string**| Call Analysis Response Set ID |

### Return type

[**\PureCloudSDK\ResponseSet**](../Model/ResponseSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCampaigns**
> \PureCloudSDK\CampaignEntityListing getCampaigns($pageSize, $pageNumber, $filterType, $name, $contactListId, $dncListId, $distributionQueueId, $edgeGroupId, $callAnalysisResponseSetId, $sortBy, $sortOrder)

Query a list of dialer campaigns.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$contactListId = "contactListId_example"; // string | Contact List ID
$dncListId = "dncListId_example"; // string | DNC list ID
$distributionQueueId = "distributionQueueId_example"; // string | Distribution queue ID
$edgeGroupId = "edgeGroupId_example"; // string | Edge group ID
$callAnalysisResponseSetId = "callAnalysisResponseSetId_example"; // string | Call analysis response set ID
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getCampaigns($pageSize, $pageNumber, $filterType, $name, $contactListId, $dncListId, $distributionQueueId, $edgeGroupId, $callAnalysisResponseSetId, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCampaigns: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **contactListId** | **string**| Contact List ID | [optional]
 **dncListId** | **string**| DNC list ID | [optional]
 **distributionQueueId** | **string**| Distribution queue ID | [optional]
 **edgeGroupId** | **string**| Edge group ID | [optional]
 **callAnalysisResponseSetId** | **string**| Call analysis response set ID | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\CampaignEntityListing**](../Model/CampaignEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCampaignsCampaignId**
> \PureCloudSDK\Campaign getCampaignsCampaignId($campaignId)

Get dialer campaign.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getCampaignsCampaignId($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\Campaign**](../Model/Campaign.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCampaignsCampaignIdDiagnostics**
> \PureCloudSDK\CampaignDiagnostics getCampaignsCampaignIdDiagnostics($campaignId)

Get campaign diagnostics



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getCampaignsCampaignIdDiagnostics($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCampaignsCampaignIdDiagnostics: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignDiagnostics**](../Model/CampaignDiagnostics.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCampaignsCampaignIdInteractions**
> \PureCloudSDK\CampaignInteractions getCampaignsCampaignIdInteractions($campaignId)

Get dialer campaign interactions.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getCampaignsCampaignIdInteractions($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCampaignsCampaignIdInteractions: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignInteractions**](../Model/CampaignInteractions.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCampaignsCampaignIdProgress**
> \PureCloudSDK\CampaignProgress getCampaignsCampaignIdProgress($campaignId)

Get campaign progress



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getCampaignsCampaignIdProgress($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCampaignsCampaignIdProgress: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignProgress**](../Model/CampaignProgress.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getCampaignsCampaignIdStats**
> \PureCloudSDK\CampaignStats getCampaignsCampaignIdStats($campaignId)

Get statistics about a Dialer Campaign



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getCampaignsCampaignIdStats($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getCampaignsCampaignIdStats: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignStats**](../Model/CampaignStats.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContactlists**
> \PureCloudSDK\ContactListEntityListing getContactlists($includeImportStatus, $includeSize, $pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query a list of contact lists.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$includeImportStatus = false; // bool | Include import status
$includeSize = false; // bool | Include size
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getContactlists($includeImportStatus, $includeSize, $pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getContactlists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **includeImportStatus** | **bool**| Include import status | [optional] [default to false]
 **includeSize** | **bool**| Include size | [optional] [default to false]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\ContactListEntityListing**](../Model/ContactListEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContactlistsContactlistId**
> \PureCloudSDK\ContactList getContactlistsContactlistId($contactListId, $includeImportStatus, $includeSize)

Get a dialer contact list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID
$includeImportStatus = false; // bool | Import status
$includeSize = false; // bool | Include size

try {
    $result = $api_instance->getContactlistsContactlistId($contactListId, $includeImportStatus, $includeSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getContactlistsContactlistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |
 **includeImportStatus** | **bool**| Import status | [optional] [default to false]
 **includeSize** | **bool**| Include size | [optional] [default to false]

### Return type

[**\PureCloudSDK\ContactList**](../Model/ContactList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContactlistsContactlistIdContactsContactId**
> \PureCloudSDK\DialerContact getContactlistsContactlistIdContactsContactId($contactListId, $contactId)

Get a contact.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | Contact List ID
$contactId = "contactId_example"; // string | Contact ID

try {
    $result = $api_instance->getContactlistsContactlistIdContactsContactId($contactListId, $contactId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getContactlistsContactlistIdContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| Contact List ID |
 **contactId** | **string**| Contact ID |

### Return type

[**\PureCloudSDK\DialerContact**](../Model/DialerContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContactlistsContactlistIdExport**
> \PureCloudSDK\ExportUri getContactlistsContactlistIdExport($contactListId, $download)

Get the URI of a contact list export.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID
$download = "false"; // string | Redirect to download uri

try {
    $result = $api_instance->getContactlistsContactlistIdExport($contactListId, $download);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getContactlistsContactlistIdExport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |
 **download** | **string**| Redirect to download uri | [optional] [default to false]

### Return type

[**\PureCloudSDK\ExportUri**](../Model/ExportUri.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getContactlistsContactlistIdImportstatus**
> \PureCloudSDK\ImportStatus getContactlistsContactlistIdImportstatus($contactListId)

Get dialer contactList import status.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID

try {
    $result = $api_instance->getContactlistsContactlistIdImportstatus($contactListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getContactlistsContactlistIdImportstatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |

### Return type

[**\PureCloudSDK\ImportStatus**](../Model/ImportStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDnclists**
> \PureCloudSDK\DncListEntityListing getDnclists($includeImportStatus, $includeSize, $pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query dialer DNC lists



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$includeImportStatus = false; // bool | Import status
$includeSize = false; // bool | Include size
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "sortOrder_example"; // string | Sort order

try {
    $result = $api_instance->getDnclists($includeImportStatus, $includeSize, $pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getDnclists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **includeImportStatus** | **bool**| Import status | [optional] [default to false]
 **includeSize** | **bool**| Include size | [optional] [default to false]
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional]

### Return type

[**\PureCloudSDK\DncListEntityListing**](../Model/DncListEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDnclistsDnclistId**
> \PureCloudSDK\DncList getDnclistsDnclistId($dncListId, $includeImportStatus, $includeSize)

Get dialer DNC list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID
$includeImportStatus = false; // bool | Import status
$includeSize = false; // bool | Include size

try {
    $result = $api_instance->getDnclistsDnclistId($dncListId, $includeImportStatus, $includeSize);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getDnclistsDnclistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |
 **includeImportStatus** | **bool**| Import status | [optional] [default to false]
 **includeSize** | **bool**| Include size | [optional] [default to false]

### Return type

[**\PureCloudSDK\DncList**](../Model/DncList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDnclistsDnclistIdExport**
> \PureCloudSDK\ExportUri getDnclistsDnclistIdExport($dncListId, $download)

Get the URI of a DNC list export.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID
$download = "false"; // string | Redirect to download uri

try {
    $result = $api_instance->getDnclistsDnclistIdExport($dncListId, $download);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getDnclistsDnclistIdExport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |
 **download** | **string**| Redirect to download uri | [optional] [default to false]

### Return type

[**\PureCloudSDK\ExportUri**](../Model/ExportUri.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getDnclistsDnclistIdImportstatus**
> \PureCloudSDK\ImportStatus getDnclistsDnclistIdImportstatus($dncListId)

Get dialer dncList import status.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID

try {
    $result = $api_instance->getDnclistsDnclistIdImportstatus($dncListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getDnclistsDnclistIdImportstatus: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |

### Return type

[**\PureCloudSDK\ImportStatus**](../Model/ImportStatus.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRulesets**
> \PureCloudSDK\RuleSetEntityListing getRulesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query a list of Rule Sets.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getRulesets($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getRulesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\RuleSetEntityListing**](../Model/RuleSetEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRulesetsRulesetId**
> \PureCloudSDK\RuleSet getRulesetsRulesetId($ruleSetId)

Get a Rule Set by ID.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$ruleSetId = "ruleSetId_example"; // string | Rule Set ID

try {
    $result = $api_instance->getRulesetsRulesetId($ruleSetId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getRulesetsRulesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleSetId** | **string**| Rule Set ID |

### Return type

[**\PureCloudSDK\RuleSet**](../Model/RuleSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchedulesCampaigns**
> \PureCloudSDK\CampaignSchedule[] getSchedulesCampaigns()

Query for a list of dialer campaign schedules.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();

try {
    $result = $api_instance->getSchedulesCampaigns();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getSchedulesCampaigns: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\CampaignSchedule[]**](../Model/CampaignSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchedulesCampaignsCampaignId**
> \PureCloudSDK\CampaignSchedule getSchedulesCampaignsCampaignId($campaignId)

Get a dialer campaign schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID

try {
    $result = $api_instance->getSchedulesCampaignsCampaignId($campaignId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getSchedulesCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |

### Return type

[**\PureCloudSDK\CampaignSchedule**](../Model/CampaignSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchedulesSequences**
> \PureCloudSDK\SequenceSchedule[] getSchedulesSequences()

Query for a list of dialer sequence schedules.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();

try {
    $result = $api_instance->getSchedulesSequences();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getSchedulesSequences: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\SequenceSchedule[]**](../Model/SequenceSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSchedulesSequencesSequenceId**
> \PureCloudSDK\SequenceSchedule getSchedulesSequencesSequenceId($sequenceId)

Get a dialer sequence schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Sequence ID

try {
    $result = $api_instance->getSchedulesSequencesSequenceId($sequenceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getSchedulesSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Sequence ID |

### Return type

[**\PureCloudSDK\SequenceSchedule**](../Model/SequenceSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSequences**
> \PureCloudSDK\CampaignSequenceEntityListing getSequences($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder)

Query a list of dialer campaign sequences.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$filterType = "PREFIX"; // string | Filter type
$name = "name_example"; // string | Name
$sortBy = "sortBy_example"; // string | Sort by
$sortOrder = "a"; // string | Sort order

try {
    $result = $api_instance->getSequences($pageSize, $pageNumber, $filterType, $name, $sortBy, $sortOrder);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getSequences: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **filterType** | **string**| Filter type | [optional] [default to PREFIX]
 **name** | **string**| Name | [optional]
 **sortBy** | **string**| Sort by | [optional]
 **sortOrder** | **string**| Sort order | [optional] [default to a]

### Return type

[**\PureCloudSDK\CampaignSequenceEntityListing**](../Model/CampaignSequenceEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSequencesSequenceId**
> \PureCloudSDK\CampaignSequence getSequencesSequenceId($sequenceId)

Get a dialer campaign sequence.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Campaign Sequence ID

try {
    $result = $api_instance->getSequencesSequenceId($sequenceId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Campaign Sequence ID |

### Return type

[**\PureCloudSDK\CampaignSequence**](../Model/CampaignSequence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getWrapupcodemappings**
> \PureCloudSDK\WrapUpCodeMapping getWrapupcodemappings()

Get the Dialer wrap up code mapping.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();

try {
    $result = $api_instance->getWrapupcodemappings();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->getWrapupcodemappings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\WrapUpCodeMapping**](../Model/WrapUpCodeMapping.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAttemptlimits**
> \PureCloudSDK\AttemptLimits postAttemptlimits($body)

Create attempt limits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\AttemptLimits(); // \PureCloudSDK\AttemptLimits | AttemptLimits

try {
    $result = $api_instance->postAttemptlimits($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postAttemptlimits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\AttemptLimits**](../Model/\PureCloudSDK\AttemptLimits.md)| AttemptLimits |

### Return type

[**\PureCloudSDK\AttemptLimits**](../Model/AttemptLimits.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postAudits**
> \PureCloudSDK\AuditSearchResult postAudits($body, $pageSize, $pageNumber, $sortBy, $sortOrder, $facetsOnly)

Retrieves audits for dialer.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\DialerAuditRequest(); // \PureCloudSDK\DialerAuditRequest | AuditSearch
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$sortBy = "entity.name"; // string | Sort by
$sortOrder = "ascending"; // string | Sort order
$facetsOnly = false; // bool | Facets only

try {
    $result = $api_instance->postAudits($body, $pageSize, $pageNumber, $sortBy, $sortOrder, $facetsOnly);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postAudits: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DialerAuditRequest**](../Model/\PureCloudSDK\DialerAuditRequest.md)| AuditSearch |
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **sortBy** | **string**| Sort by | [optional] [default to entity.name]
 **sortOrder** | **string**| Sort order | [optional] [default to ascending]
 **facetsOnly** | **bool**| Facets only | [optional] [default to false]

### Return type

[**\PureCloudSDK\AuditSearchResult**](../Model/AuditSearchResult.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallabletimesets**
> \PureCloudSDK\CallableTimeSet postCallabletimesets($body)

Create callable time set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\CallableTimeSet(); // \PureCloudSDK\CallableTimeSet | DialerCallableTimeSet

try {
    $result = $api_instance->postCallabletimesets($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postCallabletimesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CallableTimeSet**](../Model/\PureCloudSDK\CallableTimeSet.md)| DialerCallableTimeSet |

### Return type

[**\PureCloudSDK\CallableTimeSet**](../Model/CallableTimeSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCallanalysisresponsesets**
> \PureCloudSDK\ResponseSet postCallanalysisresponsesets($body)

Create a dialer call analysis response set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\ResponseSet(); // \PureCloudSDK\ResponseSet | ResponseSet

try {
    $result = $api_instance->postCallanalysisresponsesets($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postCallanalysisresponsesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ResponseSet**](../Model/\PureCloudSDK\ResponseSet.md)| ResponseSet |

### Return type

[**\PureCloudSDK\ResponseSet**](../Model/ResponseSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCampaigns**
> \PureCloudSDK\Campaign postCampaigns($body)

Create a campaign.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\Campaign(); // \PureCloudSDK\Campaign | Campaign

try {
    $result = $api_instance->postCampaigns($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postCampaigns: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\Campaign**](../Model/\PureCloudSDK\Campaign.md)| Campaign |

### Return type

[**\PureCloudSDK\Campaign**](../Model/Campaign.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCampaignsCampaignIdCallbackSchedule**
> \PureCloudSDK\ContactCallbackRequest postCampaignsCampaignIdCallbackSchedule($campaignId, $body)

Schedule a Callback for a Dialer Campaign (Deprecated)

This endpoint is deprecated and may have unexpected results. Please use \"/conversations/{conversationId}/participants/{participantId}/callbacks instead.\"

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID
$body = new \PureCloudSDK\ContactCallbackRequest(); // \PureCloudSDK\ContactCallbackRequest | ContactCallbackRequest

try {
    $result = $api_instance->postCampaignsCampaignIdCallbackSchedule($campaignId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postCampaignsCampaignIdCallbackSchedule: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |
 **body** | [**\PureCloudSDK\ContactCallbackRequest**](../Model/\PureCloudSDK\ContactCallbackRequest.md)| ContactCallbackRequest |

### Return type

[**\PureCloudSDK\ContactCallbackRequest**](../Model/ContactCallbackRequest.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postCampaignsProgress**
> \PureCloudSDK\CampaignProgress[] postCampaignsProgress($body)

Get progress for a list of campaigns



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = array(new string[]()); // string[] | Campaign IDs

try {
    $result = $api_instance->postCampaignsProgress($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postCampaignsProgress: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | **string[]**| Campaign IDs |

### Return type

[**\PureCloudSDK\CampaignProgress[]**](../Model/CampaignProgress.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContactlists**
> \PureCloudSDK\ContactList postContactlists($body)

Create a contact List.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\ContactList(); // \PureCloudSDK\ContactList | ContactList

try {
    $result = $api_instance->postContactlists($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postContactlists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\ContactList**](../Model/\PureCloudSDK\ContactList.md)| ContactList |

### Return type

[**\PureCloudSDK\ContactList**](../Model/ContactList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContactlistsContactlistIdContacts**
> \PureCloudSDK\DialerContact[] postContactlistsContactlistIdContacts($contactListId, $body, $priority)

Add contacts to a contact list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | Contact List ID
$body = array(new DialerContact()); // \PureCloudSDK\DialerContact[] | Contact
$priority = true; // bool | Contact priority.  True means the contact(s) will go to the beginning of the list, false means at the end.

try {
    $result = $api_instance->postContactlistsContactlistIdContacts($contactListId, $body, $priority);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postContactlistsContactlistIdContacts: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| Contact List ID |
 **body** | [**\PureCloudSDK\DialerContact[]**](../Model/DialerContact.md)| Contact |
 **priority** | **bool**| Contact priority.  True means the contact(s) will go to the beginning of the list, false means at the end. | [optional]

### Return type

[**\PureCloudSDK\DialerContact[]**](../Model/DialerContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postContactlistsContactlistIdExport**
> string postContactlistsContactlistIdExport($contactListId)

Initiate the export of a contact list.

Returns 200 if received OK.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID

try {
    $result = $api_instance->postContactlistsContactlistIdExport($contactListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postContactlistsContactlistIdExport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postConversationsConversationIdDnc**
> postConversationsConversationIdDnc($conversationId)

Add phone numbers to a Dialer DNC list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$conversationId = "conversationId_example"; // string | Conversation ID

try {
    $api_instance->postConversationsConversationIdDnc($conversationId);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postConversationsConversationIdDnc: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **conversationId** | **string**| Conversation ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDnclists**
> \PureCloudSDK\DncList postDnclists($body)

Create dialer DNC list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\DncList(); // \PureCloudSDK\DncList | DncList

try {
    $result = $api_instance->postDnclists($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postDnclists: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\DncList**](../Model/\PureCloudSDK\DncList.md)| DncList |

### Return type

[**\PureCloudSDK\DncList**](../Model/DncList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDnclistsDnclistIdExport**
> string postDnclistsDnclistIdExport($dncListId)

Initiate the export of a dnc list.

Returns 200 if received OK.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID

try {
    $result = $api_instance->postDnclistsDnclistIdExport($dncListId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postDnclistsDnclistIdExport: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postDnclistsDnclistIdPhonenumbers**
> postDnclistsDnclistIdPhonenumbers($dncListId, $body)

Add phone numbers to a Dialer DNC list.

Only Internal DNC lists may be appended to

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID
$body = array(new string[]()); // string[] | DNC Phone Numbers

try {
    $api_instance->postDnclistsDnclistIdPhonenumbers($dncListId, $body);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postDnclistsDnclistIdPhonenumbers: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |
 **body** | **string[]**| DNC Phone Numbers |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postRulesets**
> \PureCloudSDK\RuleSet postRulesets($body)

Create a Dialer Call Analysis Response Set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\RuleSet(); // \PureCloudSDK\RuleSet | RuleSet

try {
    $result = $api_instance->postRulesets($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postRulesets: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\RuleSet**](../Model/\PureCloudSDK\RuleSet.md)| RuleSet |

### Return type

[**\PureCloudSDK\RuleSet**](../Model/RuleSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **postSequences**
> \PureCloudSDK\CampaignSequence postSequences($body)

Create a new campaign sequence.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\CampaignSequence(); // \PureCloudSDK\CampaignSequence | Organization

try {
    $result = $api_instance->postSequences($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->postSequences: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\CampaignSequence**](../Model/\PureCloudSDK\CampaignSequence.md)| Organization |

### Return type

[**\PureCloudSDK\CampaignSequence**](../Model/CampaignSequence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putAttemptlimitsAttemptlimitsId**
> \PureCloudSDK\AttemptLimits putAttemptlimitsAttemptlimitsId($attemptLimitsId, $body)

Update attempt limits



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$attemptLimitsId = "attemptLimitsId_example"; // string | Attempt limits ID
$body = new \PureCloudSDK\AttemptLimits(); // \PureCloudSDK\AttemptLimits | AttemptLimits

try {
    $result = $api_instance->putAttemptlimitsAttemptlimitsId($attemptLimitsId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putAttemptlimitsAttemptlimitsId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **attemptLimitsId** | **string**| Attempt limits ID |
 **body** | [**\PureCloudSDK\AttemptLimits**](../Model/\PureCloudSDK\AttemptLimits.md)| AttemptLimits |

### Return type

[**\PureCloudSDK\AttemptLimits**](../Model/AttemptLimits.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putCallabletimesetsCallabletimesetId**
> \PureCloudSDK\CallableTimeSet putCallabletimesetsCallabletimesetId($callableTimeSetId, $body)

Update callable time set



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callableTimeSetId = "callableTimeSetId_example"; // string | Callable Time Set ID
$body = new \PureCloudSDK\CallableTimeSet(); // \PureCloudSDK\CallableTimeSet | DialerCallableTimeSet

try {
    $result = $api_instance->putCallabletimesetsCallabletimesetId($callableTimeSetId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putCallabletimesetsCallabletimesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callableTimeSetId** | **string**| Callable Time Set ID |
 **body** | [**\PureCloudSDK\CallableTimeSet**](../Model/\PureCloudSDK\CallableTimeSet.md)| DialerCallableTimeSet |

### Return type

[**\PureCloudSDK\CallableTimeSet**](../Model/CallableTimeSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putCallanalysisresponsesetsCallanalysissetId**
> \PureCloudSDK\ResponseSet putCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId, $body)

Update a dialer call analysis response set.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$callAnalysisSetId = "callAnalysisSetId_example"; // string | Call Analysis Response Set ID
$body = new \PureCloudSDK\ResponseSet(); // \PureCloudSDK\ResponseSet | ResponseSet

try {
    $result = $api_instance->putCallanalysisresponsesetsCallanalysissetId($callAnalysisSetId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putCallanalysisresponsesetsCallanalysissetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **callAnalysisSetId** | **string**| Call Analysis Response Set ID |
 **body** | [**\PureCloudSDK\ResponseSet**](../Model/\PureCloudSDK\ResponseSet.md)| ResponseSet |

### Return type

[**\PureCloudSDK\ResponseSet**](../Model/ResponseSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putCampaignsCampaignId**
> \PureCloudSDK\Campaign putCampaignsCampaignId($campaignId, $body)

Update a campaign.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID
$body = new \PureCloudSDK\Campaign(); // \PureCloudSDK\Campaign | Campaign

try {
    $result = $api_instance->putCampaignsCampaignId($campaignId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |
 **body** | [**\PureCloudSDK\Campaign**](../Model/\PureCloudSDK\Campaign.md)| Campaign |

### Return type

[**\PureCloudSDK\Campaign**](../Model/Campaign.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putCampaignsCampaignIdAgentsUserId**
> string putCampaignsCampaignIdAgentsUserId($campaignId, $userId, $body)

Send notification that an agent's state changed

New agent state.

### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID
$userId = "userId_example"; // string | Agent's user ID
$body = new \PureCloudSDK\Agent(); // \PureCloudSDK\Agent | agent

try {
    $result = $api_instance->putCampaignsCampaignIdAgentsUserId($campaignId, $userId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putCampaignsCampaignIdAgentsUserId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |
 **userId** | **string**| Agent&#39;s user ID |
 **body** | [**\PureCloudSDK\Agent**](../Model/\PureCloudSDK\Agent.md)| agent |

### Return type

**string**

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putContactlistsContactlistId**
> \PureCloudSDK\ContactList putContactlistsContactlistId($contactListId, $body)

Update a contact list.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | ContactList ID
$body = new \PureCloudSDK\ContactList(); // \PureCloudSDK\ContactList | ContactList

try {
    $result = $api_instance->putContactlistsContactlistId($contactListId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putContactlistsContactlistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| ContactList ID |
 **body** | [**\PureCloudSDK\ContactList**](../Model/\PureCloudSDK\ContactList.md)| ContactList |

### Return type

[**\PureCloudSDK\ContactList**](../Model/ContactList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putContactlistsContactlistIdContactsContactId**
> \PureCloudSDK\DialerContact putContactlistsContactlistIdContactsContactId($contactListId, $contactId, $body)

Update a contact.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$contactListId = "contactListId_example"; // string | Contact List ID
$contactId = "contactId_example"; // string | Contact ID
$body = new \PureCloudSDK\DialerContact(); // \PureCloudSDK\DialerContact | Contact

try {
    $result = $api_instance->putContactlistsContactlistIdContactsContactId($contactListId, $contactId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putContactlistsContactlistIdContactsContactId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **contactListId** | **string**| Contact List ID |
 **contactId** | **string**| Contact ID |
 **body** | [**\PureCloudSDK\DialerContact**](../Model/\PureCloudSDK\DialerContact.md)| Contact |

### Return type

[**\PureCloudSDK\DialerContact**](../Model/DialerContact.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putDnclistsDnclistId**
> \PureCloudSDK\DncList putDnclistsDnclistId($dncListId, $body)

Update dialer DNC list



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$dncListId = "dncListId_example"; // string | DncList ID
$body = new \PureCloudSDK\DncList(); // \PureCloudSDK\DncList | DncList

try {
    $result = $api_instance->putDnclistsDnclistId($dncListId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putDnclistsDnclistId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **dncListId** | **string**| DncList ID |
 **body** | [**\PureCloudSDK\DncList**](../Model/\PureCloudSDK\DncList.md)| DncList |

### Return type

[**\PureCloudSDK\DncList**](../Model/DncList.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRulesetsRulesetId**
> \PureCloudSDK\RuleSet putRulesetsRulesetId($ruleSetId, $body)

Update a RuleSet.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$ruleSetId = "ruleSetId_example"; // string | Rule Set ID
$body = new \PureCloudSDK\RuleSet(); // \PureCloudSDK\RuleSet | RuleSet

try {
    $result = $api_instance->putRulesetsRulesetId($ruleSetId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putRulesetsRulesetId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **ruleSetId** | **string**| Rule Set ID |
 **body** | [**\PureCloudSDK\RuleSet**](../Model/\PureCloudSDK\RuleSet.md)| RuleSet |

### Return type

[**\PureCloudSDK\RuleSet**](../Model/RuleSet.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putSchedulesCampaignsCampaignId**
> \PureCloudSDK\CampaignSchedule putSchedulesCampaignsCampaignId($campaignId, $body)

Update a new campaign schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$campaignId = "campaignId_example"; // string | Campaign ID
$body = new \PureCloudSDK\CampaignSchedule(); // \PureCloudSDK\CampaignSchedule | CampaignSchedule

try {
    $result = $api_instance->putSchedulesCampaignsCampaignId($campaignId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putSchedulesCampaignsCampaignId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **campaignId** | **string**| Campaign ID |
 **body** | [**\PureCloudSDK\CampaignSchedule**](../Model/\PureCloudSDK\CampaignSchedule.md)| CampaignSchedule |

### Return type

[**\PureCloudSDK\CampaignSchedule**](../Model/CampaignSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putSchedulesSequencesSequenceId**
> \PureCloudSDK\SequenceSchedule putSchedulesSequencesSequenceId($sequenceId, $body)

Update a new sequence schedule.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Sequence ID
$body = new \PureCloudSDK\SequenceSchedule(); // \PureCloudSDK\SequenceSchedule | SequenceSchedule

try {
    $result = $api_instance->putSchedulesSequencesSequenceId($sequenceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putSchedulesSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Sequence ID |
 **body** | [**\PureCloudSDK\SequenceSchedule**](../Model/\PureCloudSDK\SequenceSchedule.md)| SequenceSchedule |

### Return type

[**\PureCloudSDK\SequenceSchedule**](../Model/SequenceSchedule.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putSequencesSequenceId**
> \PureCloudSDK\CampaignSequence putSequencesSequenceId($sequenceId, $body)

Update a new campaign sequence.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$sequenceId = "sequenceId_example"; // string | Campaign Sequence ID
$body = new \PureCloudSDK\CampaignSequence(); // \PureCloudSDK\CampaignSequence | Organization

try {
    $result = $api_instance->putSequencesSequenceId($sequenceId, $body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putSequencesSequenceId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **sequenceId** | **string**| Campaign Sequence ID |
 **body** | [**\PureCloudSDK\CampaignSequence**](../Model/\PureCloudSDK\CampaignSequence.md)| Organization |

### Return type

[**\PureCloudSDK\CampaignSequence**](../Model/CampaignSequence.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putWrapupcodemappings**
> \PureCloudSDK\WrapUpCodeMapping putWrapupcodemappings($body)

Update the Dialer wrap up code mapping.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\OutboundApi();
$body = new \PureCloudSDK\WrapUpCodeMapping(); // \PureCloudSDK\WrapUpCodeMapping | wrapUpCodeMapping

try {
    $result = $api_instance->putWrapupcodemappings($body);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling OutboundApi->putWrapupcodemappings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **body** | [**\PureCloudSDK\WrapUpCodeMapping**](../Model/\PureCloudSDK\WrapUpCodeMapping.md)| wrapUpCodeMapping |

### Return type

[**\PureCloudSDK\WrapUpCodeMapping**](../Model/WrapUpCodeMapping.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

