# PureCloudSDK\UserRecordingsApi

All URIs are relative to *https://api.mypurecloud.com*

Method | HTTP request | Description
------------- | ------------- | -------------
[**deleteRecordingId**](UserRecordingsApi.md#deleteRecordingId) | **DELETE** /api/v2/userrecordings/{recordingId} | Delete a user recording.
[**getRecordingId**](UserRecordingsApi.md#getRecordingId) | **GET** /api/v2/userrecordings/{recordingId} | Get a user recording.
[**getRecordingIdMedia**](UserRecordingsApi.md#getRecordingIdMedia) | **GET** /api/v2/userrecordings/{recordingId}/media | Download a user recording.
[**getSummary**](UserRecordingsApi.md#getSummary) | **GET** /api/v2/userrecordings/summary | Get user recording summary
[**getUserrecordings**](UserRecordingsApi.md#getUserrecordings) | **GET** /api/v2/userrecordings | Get a list of user recordings.
[**putRecordingId**](UserRecordingsApi.md#putRecordingId) | **PUT** /api/v2/userrecordings/{recordingId} | Update a user recording.


# **deleteRecordingId**
> deleteRecordingId($recordingId)

Delete a user recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$recordingId = "recordingId_example"; // string | User Recording ID

try {
    $api_instance->deleteRecordingId($recordingId);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->deleteRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recordingId** | **string**| User Recording ID |

### Return type

void (empty response body)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingId**
> \PureCloudSDK\UserRecording getRecordingId($recordingId, $expand)

Get a user recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$recordingId = "recordingId_example"; // string | User Recording ID
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getRecordingId($recordingId, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->getRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recordingId** | **string**| User Recording ID |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\UserRecording**](../Model/UserRecording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getRecordingIdMedia**
> \PureCloudSDK\DownloadResponse getRecordingIdMedia($recordingId, $formatId)

Download a user recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$recordingId = "recordingId_example"; // string | User Recording ID
$formatId = "WEBM"; // string | The desired media format.

try {
    $result = $api_instance->getRecordingIdMedia($recordingId, $formatId);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->getRecordingIdMedia: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recordingId** | **string**| User Recording ID |
 **formatId** | **string**| The desired media format. | [optional] [default to WEBM]

### Return type

[**\PureCloudSDK\DownloadResponse**](../Model/DownloadResponse.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getSummary**
> \PureCloudSDK\FaxSummary getSummary()

Get user recording summary



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();

try {
    $result = $api_instance->getSummary();
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->getSummary: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters
This endpoint does not need any parameter.

### Return type

[**\PureCloudSDK\FaxSummary**](../Model/FaxSummary.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **getUserrecordings**
> \PureCloudSDK\UserRecordingEntityListing getUserrecordings($pageSize, $pageNumber, $expand)

Get a list of user recordings.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$pageSize = 25; // int | Page size
$pageNumber = 1; // int | Page number
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->getUserrecordings($pageSize, $pageNumber, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->getUserrecordings: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **pageSize** | **int**| Page size | [optional] [default to 25]
 **pageNumber** | **int**| Page number | [optional] [default to 1]
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\UserRecordingEntityListing**](../Model/UserRecordingEntityListing.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

# **putRecordingId**
> \PureCloudSDK\UserRecording putRecordingId($recordingId, $body, $expand)

Update a user recording.



### Example
```php
<?php
require_once(__DIR__ . '/vendor/autoload.php');

// Configure OAuth2 access token for authorization: PureCloud Auth
PureCloudSDK\Configuration::getDefaultConfiguration()->setAccessToken('YOUR_ACCESS_TOKEN');

$api_instance = new PureCloudSDK\Api\UserRecordingsApi();
$recordingId = "recordingId_example"; // string | User Recording ID
$body = new \PureCloudSDK\UserRecording(); // \PureCloudSDK\UserRecording | UserRecording
$expand = array("expand_example"); // string[] | Which fields, if any, to expand.

try {
    $result = $api_instance->putRecordingId($recordingId, $body, $expand);
    print_r($result);
} catch (Exception $e) {
    echo 'Exception when calling UserRecordingsApi->putRecordingId: ', $e->getMessage(), PHP_EOL;
}
?>
```

### Parameters

Name | Type | Description  | Notes
------------- | ------------- | ------------- | -------------
 **recordingId** | **string**| User Recording ID |
 **body** | [**\PureCloudSDK\UserRecording**](../Model/\PureCloudSDK\UserRecording.md)| UserRecording |
 **expand** | [**string[]**](../Model/string.md)| Which fields, if any, to expand. | [optional]

### Return type

[**\PureCloudSDK\UserRecording**](../Model/UserRecording.md)

### Authorization

[PureCloud Auth](../../README.md#PureCloud Auth)

### HTTP request headers

 - **Content-Type**: application/json
 - **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../../README.md#documentation-for-api-endpoints) [[Back to Model list]](../../README.md#documentation-for-models) [[Back to README]](../../README.md)

