# UserMe

## Properties
Name | Type | Description | Notes
------------ | ------------- | ------------- | -------------
**id** | **string** | The globally unique identifier for the object. | [optional] 
**name** | **string** |  | [optional] 
**chat** | [**\PureCloudSDK\Chat**](Chat.md) |  | [optional] 
**department** | **string** |  | [optional] 
**email** | **string** |  | [optional] 
**primaryContactInfo** | [**\PureCloudSDK\Contact[]**](Contact.md) | Auto populated from addresses. | [optional] 
**addresses** | [**\PureCloudSDK\Contact[]**](Contact.md) | Email addresses and phone numbers for this user | [optional] 
**state** | **string** | The current state for this user. | [optional] 
**title** | **string** |  | [optional] 
**username** | **string** |  | [optional] 
**manager** | [**\PureCloudSDK\User**](User.md) |  | [optional] 
**images** | [**\PureCloudSDK\UserImage[]**](UserImage.md) |  | [optional] 
**version** | **int** | Required when updating a user, this value should be the current version of the user.  The current version can be obtained with a GET on the user before doing a PATCH. | 
**routingStatus** | [**\PureCloudSDK\RoutingStatus**](RoutingStatus.md) | ACD routing status | [optional] 
**presence** | [**\PureCloudSDK\UserPresence**](UserPresence.md) | Active presence | [optional] 
**conversationSummary** | [**\PureCloudSDK\UserConversationSummary**](UserConversationSummary.md) | Summary of conversion statistics for conversation types. | [optional] 
**outOfOffice** | [**\PureCloudSDK\OutOfOffice**](OutOfOffice.md) | Determine if out of office is enabled | [optional] 
**geolocation** | [**\PureCloudSDK\Geolocation**](Geolocation.md) | Current geolocation position | [optional] 
**station** | [**\PureCloudSDK\UserStations**](UserStations.md) | Effective, default, and last station information | [optional] 
**authorization** | [**\PureCloudSDK\UserAuthorization**](UserAuthorization.md) | Roles and permissions assigned to the user | [optional] 
**profileSkills** | **string[]** | Skills possessed by the user | [optional] 
**locations** | [**\PureCloudSDK\Location[]**](Location.md) | The user placement at each site location. | [optional] 
**date** | [**\PureCloudSDK\ServerDate**](ServerDate.md) | The PureCloud system date time. | [optional] 
**geolocationSettings** | [**\PureCloudSDK\GeolocationSettings**](GeolocationSettings.md) | Geolocation settings for user&#39;s organization. | [optional] 
**organization** | [**\PureCloudSDK\Organization**](Organization.md) | Organization details for this user. | [optional] 
**presenceDefinitions** | [**\PureCloudSDK\OrganizationPresence[]**](OrganizationPresence.md) | The first 100 presence definitions for user&#39;s organization. | [optional] 
**locationDefinitions** | [**\PureCloudSDK\LocationDefinition[]**](LocationDefinition.md) | The first 100 site locations for user&#39;s organization | [optional] 
**orgAuthorization** | [**\PureCloudSDK\DomainOrganizationRole[]**](DomainOrganizationRole.md) | The first 100 organization roles, with applicable permission policies, for user&#39;s organization. | [optional] 
**favorites** | [**\PureCloudSDK\User[]**](User.md) | The first 50 favorited users. | [optional] 
**superiors** | [**\PureCloudSDK\User[]**](User.md) | The first 50 superiors of this user. | [optional] 
**directReports** | [**\PureCloudSDK\User[]**](User.md) | The first 50 direct reports to this user. | [optional] 
**adjacents** | [**\PureCloudSDK\Adjacents**](Adjacents.md) | The first 50 superiors, direct reports, and siblings of this user. Mutually exclusive with superiors and direct reports expands. | [optional] 
**routingSkills** | [**\PureCloudSDK\RoutingSkill[]**](RoutingSkill.md) | The first 50 routing skills for user&#39;s organizations | [optional] 
**selfUri** | **string** | The URI for this object | [optional] 

[[Back to Model list]](../README.md#documentation-for-models) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to README]](../README.md)


