<?php
/**
 * Account
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Account Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Account implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Account';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'orgLegalName' => 'string',
        'billingAddressLine1' => 'string',
        'billingAddressLine2' => 'string',
        'billingAddressCity' => 'string',
        'billingAddressState' => 'string',
        'billingAddressZipCode' => 'string',
        'billingAddressCountry' => 'string',
        'legalAddressLine1' => 'string',
        'legalAddressLine2' => 'string',
        'legalAddressCity' => 'string',
        'legalAddressState' => 'string',
        'legalAddressZipCode' => 'string',
        'legalAddressCountry' => 'string',
        'billingContactFirstName' => 'string',
        'billingContactLastName' => 'string',
        'billingContactEmail' => 'string',
        'billingContactPhone' => 'string',
        'purchaseOrderNumber' => 'string',
        'isTaxExempt' => 'bool',
        'currency' => 'string',
        'paymentTerm' => 'string',
        'contractTerm' => 'int',
        'autoRenew' => 'bool',
        'enabled' => 'bool',
        'minCommitQuantities' => 'map[string,int]',
        'estimatedQuantities' => 'map[string,int]',
        'oneTimeCharges' => 'string[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'orgLegalName' => 'orgLegalName',
        'billingAddressLine1' => 'billingAddressLine1',
        'billingAddressLine2' => 'billingAddressLine2',
        'billingAddressCity' => 'billingAddressCity',
        'billingAddressState' => 'billingAddressState',
        'billingAddressZipCode' => 'billingAddressZipCode',
        'billingAddressCountry' => 'billingAddressCountry',
        'legalAddressLine1' => 'legalAddressLine1',
        'legalAddressLine2' => 'legalAddressLine2',
        'legalAddressCity' => 'legalAddressCity',
        'legalAddressState' => 'legalAddressState',
        'legalAddressZipCode' => 'legalAddressZipCode',
        'legalAddressCountry' => 'legalAddressCountry',
        'billingContactFirstName' => 'billingContactFirstName',
        'billingContactLastName' => 'billingContactLastName',
        'billingContactEmail' => 'billingContactEmail',
        'billingContactPhone' => 'billingContactPhone',
        'purchaseOrderNumber' => 'purchaseOrderNumber',
        'isTaxExempt' => 'isTaxExempt',
        'currency' => 'currency',
        'paymentTerm' => 'paymentTerm',
        'contractTerm' => 'contractTerm',
        'autoRenew' => 'autoRenew',
        'enabled' => 'enabled',
        'minCommitQuantities' => 'minCommitQuantities',
        'estimatedQuantities' => 'estimatedQuantities',
        'oneTimeCharges' => 'oneTimeCharges',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'orgLegalName' => 'setOrgLegalName',
        'billingAddressLine1' => 'setBillingAddressLine1',
        'billingAddressLine2' => 'setBillingAddressLine2',
        'billingAddressCity' => 'setBillingAddressCity',
        'billingAddressState' => 'setBillingAddressState',
        'billingAddressZipCode' => 'setBillingAddressZipCode',
        'billingAddressCountry' => 'setBillingAddressCountry',
        'legalAddressLine1' => 'setLegalAddressLine1',
        'legalAddressLine2' => 'setLegalAddressLine2',
        'legalAddressCity' => 'setLegalAddressCity',
        'legalAddressState' => 'setLegalAddressState',
        'legalAddressZipCode' => 'setLegalAddressZipCode',
        'legalAddressCountry' => 'setLegalAddressCountry',
        'billingContactFirstName' => 'setBillingContactFirstName',
        'billingContactLastName' => 'setBillingContactLastName',
        'billingContactEmail' => 'setBillingContactEmail',
        'billingContactPhone' => 'setBillingContactPhone',
        'purchaseOrderNumber' => 'setPurchaseOrderNumber',
        'isTaxExempt' => 'setIsTaxExempt',
        'currency' => 'setCurrency',
        'paymentTerm' => 'setPaymentTerm',
        'contractTerm' => 'setContractTerm',
        'autoRenew' => 'setAutoRenew',
        'enabled' => 'setEnabled',
        'minCommitQuantities' => 'setMinCommitQuantities',
        'estimatedQuantities' => 'setEstimatedQuantities',
        'oneTimeCharges' => 'setOneTimeCharges',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'orgLegalName' => 'getOrgLegalName',
        'billingAddressLine1' => 'getBillingAddressLine1',
        'billingAddressLine2' => 'getBillingAddressLine2',
        'billingAddressCity' => 'getBillingAddressCity',
        'billingAddressState' => 'getBillingAddressState',
        'billingAddressZipCode' => 'getBillingAddressZipCode',
        'billingAddressCountry' => 'getBillingAddressCountry',
        'legalAddressLine1' => 'getLegalAddressLine1',
        'legalAddressLine2' => 'getLegalAddressLine2',
        'legalAddressCity' => 'getLegalAddressCity',
        'legalAddressState' => 'getLegalAddressState',
        'legalAddressZipCode' => 'getLegalAddressZipCode',
        'legalAddressCountry' => 'getLegalAddressCountry',
        'billingContactFirstName' => 'getBillingContactFirstName',
        'billingContactLastName' => 'getBillingContactLastName',
        'billingContactEmail' => 'getBillingContactEmail',
        'billingContactPhone' => 'getBillingContactPhone',
        'purchaseOrderNumber' => 'getPurchaseOrderNumber',
        'isTaxExempt' => 'getIsTaxExempt',
        'currency' => 'getCurrency',
        'paymentTerm' => 'getPaymentTerm',
        'contractTerm' => 'getContractTerm',
        'autoRenew' => 'getAutoRenew',
        'enabled' => 'getEnabled',
        'minCommitQuantities' => 'getMinCommitQuantities',
        'estimatedQuantities' => 'getEstimatedQuantities',
        'oneTimeCharges' => 'getOneTimeCharges',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['orgLegalName'] = isset($data['orgLegalName']) ? $data['orgLegalName'] : null;
        $this->container['billingAddressLine1'] = isset($data['billingAddressLine1']) ? $data['billingAddressLine1'] : null;
        $this->container['billingAddressLine2'] = isset($data['billingAddressLine2']) ? $data['billingAddressLine2'] : null;
        $this->container['billingAddressCity'] = isset($data['billingAddressCity']) ? $data['billingAddressCity'] : null;
        $this->container['billingAddressState'] = isset($data['billingAddressState']) ? $data['billingAddressState'] : null;
        $this->container['billingAddressZipCode'] = isset($data['billingAddressZipCode']) ? $data['billingAddressZipCode'] : null;
        $this->container['billingAddressCountry'] = isset($data['billingAddressCountry']) ? $data['billingAddressCountry'] : null;
        $this->container['legalAddressLine1'] = isset($data['legalAddressLine1']) ? $data['legalAddressLine1'] : null;
        $this->container['legalAddressLine2'] = isset($data['legalAddressLine2']) ? $data['legalAddressLine2'] : null;
        $this->container['legalAddressCity'] = isset($data['legalAddressCity']) ? $data['legalAddressCity'] : null;
        $this->container['legalAddressState'] = isset($data['legalAddressState']) ? $data['legalAddressState'] : null;
        $this->container['legalAddressZipCode'] = isset($data['legalAddressZipCode']) ? $data['legalAddressZipCode'] : null;
        $this->container['legalAddressCountry'] = isset($data['legalAddressCountry']) ? $data['legalAddressCountry'] : null;
        $this->container['billingContactFirstName'] = isset($data['billingContactFirstName']) ? $data['billingContactFirstName'] : null;
        $this->container['billingContactLastName'] = isset($data['billingContactLastName']) ? $data['billingContactLastName'] : null;
        $this->container['billingContactEmail'] = isset($data['billingContactEmail']) ? $data['billingContactEmail'] : null;
        $this->container['billingContactPhone'] = isset($data['billingContactPhone']) ? $data['billingContactPhone'] : null;
        $this->container['purchaseOrderNumber'] = isset($data['purchaseOrderNumber']) ? $data['purchaseOrderNumber'] : null;
        $this->container['isTaxExempt'] = isset($data['isTaxExempt']) ? $data['isTaxExempt'] : false;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['paymentTerm'] = isset($data['paymentTerm']) ? $data['paymentTerm'] : null;
        $this->container['contractTerm'] = isset($data['contractTerm']) ? $data['contractTerm'] : null;
        $this->container['autoRenew'] = isset($data['autoRenew']) ? $data['autoRenew'] : false;
        $this->container['enabled'] = isset($data['enabled']) ? $data['enabled'] : false;
        $this->container['minCommitQuantities'] = isset($data['minCommitQuantities']) ? $data['minCommitQuantities'] : null;
        $this->container['estimatedQuantities'] = isset($data['estimatedQuantities']) ? $data['estimatedQuantities'] : null;
        $this->container['oneTimeCharges'] = isset($data['oneTimeCharges']) ? $data['oneTimeCharges'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['orgLegalName'] === null) {
            $invalid_properties[] = "'orgLegalName' can't be null";
        }
        if ($this->container['billingAddressLine1'] === null) {
            $invalid_properties[] = "'billingAddressLine1' can't be null";
        }
        if ($this->container['billingAddressCity'] === null) {
            $invalid_properties[] = "'billingAddressCity' can't be null";
        }
        if ($this->container['billingAddressState'] === null) {
            $invalid_properties[] = "'billingAddressState' can't be null";
        }
        if ($this->container['billingAddressZipCode'] === null) {
            $invalid_properties[] = "'billingAddressZipCode' can't be null";
        }
        if ($this->container['billingAddressCountry'] === null) {
            $invalid_properties[] = "'billingAddressCountry' can't be null";
        }
        if ($this->container['billingContactFirstName'] === null) {
            $invalid_properties[] = "'billingContactFirstName' can't be null";
        }
        if ($this->container['billingContactLastName'] === null) {
            $invalid_properties[] = "'billingContactLastName' can't be null";
        }
        if ($this->container['billingContactEmail'] === null) {
            $invalid_properties[] = "'billingContactEmail' can't be null";
        }
        if ($this->container['billingContactPhone'] === null) {
            $invalid_properties[] = "'billingContactPhone' can't be null";
        }
        if ($this->container['paymentTerm'] === null) {
            $invalid_properties[] = "'paymentTerm' can't be null";
        }
        if ($this->container['contractTerm'] === null) {
            $invalid_properties[] = "'contractTerm' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['orgLegalName'] === null) {
            return false;
        }
        if ($this->container['billingAddressLine1'] === null) {
            return false;
        }
        if ($this->container['billingAddressCity'] === null) {
            return false;
        }
        if ($this->container['billingAddressState'] === null) {
            return false;
        }
        if ($this->container['billingAddressZipCode'] === null) {
            return false;
        }
        if ($this->container['billingAddressCountry'] === null) {
            return false;
        }
        if ($this->container['billingContactFirstName'] === null) {
            return false;
        }
        if ($this->container['billingContactLastName'] === null) {
            return false;
        }
        if ($this->container['billingContactEmail'] === null) {
            return false;
        }
        if ($this->container['billingContactPhone'] === null) {
            return false;
        }
        if ($this->container['paymentTerm'] === null) {
            return false;
        }
        if ($this->container['contractTerm'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets orgLegalName
     * @return string
     */
    public function getOrgLegalName()
    {
        return $this->container['orgLegalName'];
    }

    /**
     * Sets orgLegalName
     * @param string $orgLegalName Org legal name
     * @return $this
     */
    public function setOrgLegalName($orgLegalName)
    {
        $this->container['orgLegalName'] = $orgLegalName;

        return $this;
    }

    /**
     * Gets billingAddressLine1
     * @return string
     */
    public function getBillingAddressLine1()
    {
        return $this->container['billingAddressLine1'];
    }

    /**
     * Sets billingAddressLine1
     * @param string $billingAddressLine1 Billing Address
     * @return $this
     */
    public function setBillingAddressLine1($billingAddressLine1)
    {
        $this->container['billingAddressLine1'] = $billingAddressLine1;

        return $this;
    }

    /**
     * Gets billingAddressLine2
     * @return string
     */
    public function getBillingAddressLine2()
    {
        return $this->container['billingAddressLine2'];
    }

    /**
     * Sets billingAddressLine2
     * @param string $billingAddressLine2
     * @return $this
     */
    public function setBillingAddressLine2($billingAddressLine2)
    {
        $this->container['billingAddressLine2'] = $billingAddressLine2;

        return $this;
    }

    /**
     * Gets billingAddressCity
     * @return string
     */
    public function getBillingAddressCity()
    {
        return $this->container['billingAddressCity'];
    }

    /**
     * Sets billingAddressCity
     * @param string $billingAddressCity Billing City
     * @return $this
     */
    public function setBillingAddressCity($billingAddressCity)
    {
        $this->container['billingAddressCity'] = $billingAddressCity;

        return $this;
    }

    /**
     * Gets billingAddressState
     * @return string
     */
    public function getBillingAddressState()
    {
        return $this->container['billingAddressState'];
    }

    /**
     * Sets billingAddressState
     * @param string $billingAddressState Billing State
     * @return $this
     */
    public function setBillingAddressState($billingAddressState)
    {
        $this->container['billingAddressState'] = $billingAddressState;

        return $this;
    }

    /**
     * Gets billingAddressZipCode
     * @return string
     */
    public function getBillingAddressZipCode()
    {
        return $this->container['billingAddressZipCode'];
    }

    /**
     * Sets billingAddressZipCode
     * @param string $billingAddressZipCode Billing ZipCode
     * @return $this
     */
    public function setBillingAddressZipCode($billingAddressZipCode)
    {
        $this->container['billingAddressZipCode'] = $billingAddressZipCode;

        return $this;
    }

    /**
     * Gets billingAddressCountry
     * @return string
     */
    public function getBillingAddressCountry()
    {
        return $this->container['billingAddressCountry'];
    }

    /**
     * Sets billingAddressCountry
     * @param string $billingAddressCountry Billing Country
     * @return $this
     */
    public function setBillingAddressCountry($billingAddressCountry)
    {
        $this->container['billingAddressCountry'] = $billingAddressCountry;

        return $this;
    }

    /**
     * Gets legalAddressLine1
     * @return string
     */
    public function getLegalAddressLine1()
    {
        return $this->container['legalAddressLine1'];
    }

    /**
     * Sets legalAddressLine1
     * @param string $legalAddressLine1
     * @return $this
     */
    public function setLegalAddressLine1($legalAddressLine1)
    {
        $this->container['legalAddressLine1'] = $legalAddressLine1;

        return $this;
    }

    /**
     * Gets legalAddressLine2
     * @return string
     */
    public function getLegalAddressLine2()
    {
        return $this->container['legalAddressLine2'];
    }

    /**
     * Sets legalAddressLine2
     * @param string $legalAddressLine2
     * @return $this
     */
    public function setLegalAddressLine2($legalAddressLine2)
    {
        $this->container['legalAddressLine2'] = $legalAddressLine2;

        return $this;
    }

    /**
     * Gets legalAddressCity
     * @return string
     */
    public function getLegalAddressCity()
    {
        return $this->container['legalAddressCity'];
    }

    /**
     * Sets legalAddressCity
     * @param string $legalAddressCity
     * @return $this
     */
    public function setLegalAddressCity($legalAddressCity)
    {
        $this->container['legalAddressCity'] = $legalAddressCity;

        return $this;
    }

    /**
     * Gets legalAddressState
     * @return string
     */
    public function getLegalAddressState()
    {
        return $this->container['legalAddressState'];
    }

    /**
     * Sets legalAddressState
     * @param string $legalAddressState
     * @return $this
     */
    public function setLegalAddressState($legalAddressState)
    {
        $this->container['legalAddressState'] = $legalAddressState;

        return $this;
    }

    /**
     * Gets legalAddressZipCode
     * @return string
     */
    public function getLegalAddressZipCode()
    {
        return $this->container['legalAddressZipCode'];
    }

    /**
     * Sets legalAddressZipCode
     * @param string $legalAddressZipCode
     * @return $this
     */
    public function setLegalAddressZipCode($legalAddressZipCode)
    {
        $this->container['legalAddressZipCode'] = $legalAddressZipCode;

        return $this;
    }

    /**
     * Gets legalAddressCountry
     * @return string
     */
    public function getLegalAddressCountry()
    {
        return $this->container['legalAddressCountry'];
    }

    /**
     * Sets legalAddressCountry
     * @param string $legalAddressCountry
     * @return $this
     */
    public function setLegalAddressCountry($legalAddressCountry)
    {
        $this->container['legalAddressCountry'] = $legalAddressCountry;

        return $this;
    }

    /**
     * Gets billingContactFirstName
     * @return string
     */
    public function getBillingContactFirstName()
    {
        return $this->container['billingContactFirstName'];
    }

    /**
     * Sets billingContactFirstName
     * @param string $billingContactFirstName Billing Contact first name.
     * @return $this
     */
    public function setBillingContactFirstName($billingContactFirstName)
    {
        $this->container['billingContactFirstName'] = $billingContactFirstName;

        return $this;
    }

    /**
     * Gets billingContactLastName
     * @return string
     */
    public function getBillingContactLastName()
    {
        return $this->container['billingContactLastName'];
    }

    /**
     * Sets billingContactLastName
     * @param string $billingContactLastName Billing Contact last name.
     * @return $this
     */
    public function setBillingContactLastName($billingContactLastName)
    {
        $this->container['billingContactLastName'] = $billingContactLastName;

        return $this;
    }

    /**
     * Gets billingContactEmail
     * @return string
     */
    public function getBillingContactEmail()
    {
        return $this->container['billingContactEmail'];
    }

    /**
     * Sets billingContactEmail
     * @param string $billingContactEmail Billing Contact email.
     * @return $this
     */
    public function setBillingContactEmail($billingContactEmail)
    {
        $this->container['billingContactEmail'] = $billingContactEmail;

        return $this;
    }

    /**
     * Gets billingContactPhone
     * @return string
     */
    public function getBillingContactPhone()
    {
        return $this->container['billingContactPhone'];
    }

    /**
     * Sets billingContactPhone
     * @param string $billingContactPhone Billing Contact phone
     * @return $this
     */
    public function setBillingContactPhone($billingContactPhone)
    {
        $this->container['billingContactPhone'] = $billingContactPhone;

        return $this;
    }

    /**
     * Gets purchaseOrderNumber
     * @return string
     */
    public function getPurchaseOrderNumber()
    {
        return $this->container['purchaseOrderNumber'];
    }

    /**
     * Sets purchaseOrderNumber
     * @param string $purchaseOrderNumber
     * @return $this
     */
    public function setPurchaseOrderNumber($purchaseOrderNumber)
    {
        $this->container['purchaseOrderNumber'] = $purchaseOrderNumber;

        return $this;
    }

    /**
     * Gets isTaxExempt
     * @return bool
     */
    public function getIsTaxExempt()
    {
        return $this->container['isTaxExempt'];
    }

    /**
     * Sets isTaxExempt
     * @param bool $isTaxExempt
     * @return $this
     */
    public function setIsTaxExempt($isTaxExempt)
    {
        $this->container['isTaxExempt'] = $isTaxExempt;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency
     * @return $this
     */
    public function setCurrency($currency)
    {
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets paymentTerm
     * @return string
     */
    public function getPaymentTerm()
    {
        return $this->container['paymentTerm'];
    }

    /**
     * Sets paymentTerm
     * @param string $paymentTerm Payment Term
     * @return $this
     */
    public function setPaymentTerm($paymentTerm)
    {
        $this->container['paymentTerm'] = $paymentTerm;

        return $this;
    }

    /**
     * Gets contractTerm
     * @return int
     */
    public function getContractTerm()
    {
        return $this->container['contractTerm'];
    }

    /**
     * Sets contractTerm
     * @param int $contractTerm Contract Term
     * @return $this
     */
    public function setContractTerm($contractTerm)
    {
        $this->container['contractTerm'] = $contractTerm;

        return $this;
    }

    /**
     * Gets autoRenew
     * @return bool
     */
    public function getAutoRenew()
    {
        return $this->container['autoRenew'];
    }

    /**
     * Sets autoRenew
     * @param bool $autoRenew
     * @return $this
     */
    public function setAutoRenew($autoRenew)
    {
        $this->container['autoRenew'] = $autoRenew;

        return $this;
    }

    /**
     * Gets enabled
     * @return bool
     */
    public function getEnabled()
    {
        return $this->container['enabled'];
    }

    /**
     * Sets enabled
     * @param bool $enabled
     * @return $this
     */
    public function setEnabled($enabled)
    {
        $this->container['enabled'] = $enabled;

        return $this;
    }

    /**
     * Gets minCommitQuantities
     * @return map[string,int]
     */
    public function getMinCommitQuantities()
    {
        return $this->container['minCommitQuantities'];
    }

    /**
     * Sets minCommitQuantities
     * @param map[string,int] $minCommitQuantities
     * @return $this
     */
    public function setMinCommitQuantities($minCommitQuantities)
    {
        $this->container['minCommitQuantities'] = $minCommitQuantities;

        return $this;
    }

    /**
     * Gets estimatedQuantities
     * @return map[string,int]
     */
    public function getEstimatedQuantities()
    {
        return $this->container['estimatedQuantities'];
    }

    /**
     * Sets estimatedQuantities
     * @param map[string,int] $estimatedQuantities
     * @return $this
     */
    public function setEstimatedQuantities($estimatedQuantities)
    {
        $this->container['estimatedQuantities'] = $estimatedQuantities;

        return $this;
    }

    /**
     * Gets oneTimeCharges
     * @return string[]
     */
    public function getOneTimeCharges()
    {
        return $this->container['oneTimeCharges'];
    }

    /**
     * Sets oneTimeCharges
     * @param string[] $oneTimeCharges
     * @return $this
     */
    public function setOneTimeCharges($oneTimeCharges)
    {
        $this->container['oneTimeCharges'] = $oneTimeCharges;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


