<?php
/**
 * AccountOverview
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AccountOverview Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AccountOverview implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AccountOverview';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'isSuperUser' => 'bool',
        'hasAccountNumber' => 'bool',
        'usageCharges' => '\PureCloudSDK\Charge[]',
        'domesticChargesTotal' => 'int',
        'internationalChargesTotal' => 'int',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'isSuperUser' => 'isSuperUser',
        'hasAccountNumber' => 'hasAccountNumber',
        'usageCharges' => 'usageCharges',
        'domesticChargesTotal' => 'domesticChargesTotal',
        'internationalChargesTotal' => 'internationalChargesTotal',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'isSuperUser' => 'setIsSuperUser',
        'hasAccountNumber' => 'setHasAccountNumber',
        'usageCharges' => 'setUsageCharges',
        'domesticChargesTotal' => 'setDomesticChargesTotal',
        'internationalChargesTotal' => 'setInternationalChargesTotal',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'isSuperUser' => 'getIsSuperUser',
        'hasAccountNumber' => 'getHasAccountNumber',
        'usageCharges' => 'getUsageCharges',
        'domesticChargesTotal' => 'getDomesticChargesTotal',
        'internationalChargesTotal' => 'getInternationalChargesTotal',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['isSuperUser'] = isset($data['isSuperUser']) ? $data['isSuperUser'] : false;
        $this->container['hasAccountNumber'] = isset($data['hasAccountNumber']) ? $data['hasAccountNumber'] : false;
        $this->container['usageCharges'] = isset($data['usageCharges']) ? $data['usageCharges'] : null;
        $this->container['domesticChargesTotal'] = isset($data['domesticChargesTotal']) ? $data['domesticChargesTotal'] : null;
        $this->container['internationalChargesTotal'] = isset($data['internationalChargesTotal']) ? $data['internationalChargesTotal'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets isSuperUser
     * @return bool
     */
    public function getIsSuperUser()
    {
        return $this->container['isSuperUser'];
    }

    /**
     * Sets isSuperUser
     * @param bool $isSuperUser
     * @return $this
     */
    public function setIsSuperUser($isSuperUser)
    {
        $this->container['isSuperUser'] = $isSuperUser;

        return $this;
    }

    /**
     * Gets hasAccountNumber
     * @return bool
     */
    public function getHasAccountNumber()
    {
        return $this->container['hasAccountNumber'];
    }

    /**
     * Sets hasAccountNumber
     * @param bool $hasAccountNumber
     * @return $this
     */
    public function setHasAccountNumber($hasAccountNumber)
    {
        $this->container['hasAccountNumber'] = $hasAccountNumber;

        return $this;
    }

    /**
     * Gets usageCharges
     * @return \PureCloudSDK\Charge[]
     */
    public function getUsageCharges()
    {
        return $this->container['usageCharges'];
    }

    /**
     * Sets usageCharges
     * @param \PureCloudSDK\Charge[] $usageCharges
     * @return $this
     */
    public function setUsageCharges($usageCharges)
    {
        $this->container['usageCharges'] = $usageCharges;

        return $this;
    }

    /**
     * Gets domesticChargesTotal
     * @return int
     */
    public function getDomesticChargesTotal()
    {
        return $this->container['domesticChargesTotal'];
    }

    /**
     * Sets domesticChargesTotal
     * @param int $domesticChargesTotal
     * @return $this
     */
    public function setDomesticChargesTotal($domesticChargesTotal)
    {
        $this->container['domesticChargesTotal'] = $domesticChargesTotal;

        return $this;
    }

    /**
     * Gets internationalChargesTotal
     * @return int
     */
    public function getInternationalChargesTotal()
    {
        return $this->container['internationalChargesTotal'];
    }

    /**
     * Sets internationalChargesTotal
     * @param int $internationalChargesTotal
     * @return $this
     */
    public function setInternationalChargesTotal($internationalChargesTotal)
    {
        $this->container['internationalChargesTotal'] = $internationalChargesTotal;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


