<?php
/**
 * AdditionalPortingFields
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AdditionalPortingFields Class Doc Comment
 *
 * @category    Class */
 // @description Additional fields required when requesting a toll free porting form.
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AdditionalPortingFields implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AdditionalPortingFields';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'billingAddress' => '\PureCloudSDK\PortBillingAddress',
        'contact' => '\PureCloudSDK\PortContact',
        'numbers' => '\PureCloudSDK\PhoneNumberAndType[]',
        'activationDateTime' => '\DateTime',
        'locale' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'billingAddress' => 'billingAddress',
        'contact' => 'contact',
        'numbers' => 'numbers',
        'activationDateTime' => 'activationDateTime',
        'locale' => 'locale'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'billingAddress' => 'setBillingAddress',
        'contact' => 'setContact',
        'numbers' => 'setNumbers',
        'activationDateTime' => 'setActivationDateTime',
        'locale' => 'setLocale'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'billingAddress' => 'getBillingAddress',
        'contact' => 'getContact',
        'numbers' => 'getNumbers',
        'activationDateTime' => 'getActivationDateTime',
        'locale' => 'getLocale'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const LOCALE_CA = 'fr_CA';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLocaleAllowableValues()
    {
        return [
            self::LOCALE_CA,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['billingAddress'] = isset($data['billingAddress']) ? $data['billingAddress'] : null;
        $this->container['contact'] = isset($data['contact']) ? $data['contact'] : null;
        $this->container['numbers'] = isset($data['numbers']) ? $data['numbers'] : null;
        $this->container['activationDateTime'] = isset($data['activationDateTime']) ? $data['activationDateTime'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("fr_CA");
        if (!in_array($this->container['locale'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'locale', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("fr_CA");
        if (!in_array($this->container['locale'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets billingAddress
     * @return \PureCloudSDK\PortBillingAddress
     */
    public function getBillingAddress()
    {
        return $this->container['billingAddress'];
    }

    /**
     * Sets billingAddress
     * @param \PureCloudSDK\PortBillingAddress $billingAddress Billing address of the organization that wants to port these numbers, this canbe different than the PureCloud organization's billing address
     * @return $this
     */
    public function setBillingAddress($billingAddress)
    {
        $this->container['billingAddress'] = $billingAddress;

        return $this;
    }

    /**
     * Gets contact
     * @return \PureCloudSDK\PortContact
     */
    public function getContact()
    {
        return $this->container['contact'];
    }

    /**
     * Sets contact
     * @param \PureCloudSDK\PortContact $contact Responsible contact that initiated the port
     * @return $this
     */
    public function setContact($contact)
    {
        $this->container['contact'] = $contact;

        return $this;
    }

    /**
     * Gets numbers
     * @return \PureCloudSDK\PhoneNumberAndType[]
     */
    public function getNumbers()
    {
        return $this->container['numbers'];
    }

    /**
     * Sets numbers
     * @param \PureCloudSDK\PhoneNumberAndType[] $numbers The actual numbers and types to be ported to PureCloud Voice.
     * @return $this
     */
    public function setNumbers($numbers)
    {
        $this->container['numbers'] = $numbers;

        return $this;
    }

    /**
     * Gets activationDateTime
     * @return \DateTime
     */
    public function getActivationDateTime()
    {
        return $this->container['activationDateTime'];
    }

    /**
     * Sets activationDateTime
     * @param \DateTime $activationDateTime Date and time in which the numbers should go live within PureCloud Voice. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setActivationDateTime($activationDateTime)
    {
        $this->container['activationDateTime'] = $activationDateTime;

        return $this;
    }

    /**
     * Gets locale
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     * @param string $locale Different locales might possibly have different port request forms to sign, consult the allowable values on which locales are currently supported.
     * @return $this
     */
    public function setLocale($locale)
    {
        $allowed_values = array('fr_CA');
        if (!in_array($locale, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'locale', must be one of 'fr_CA'");
        }
        $this->container['locale'] = $locale;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


