<?php
/**
 * ArchitectApi
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK\Api;

use \PureCloudSDK\Configuration;
use \PureCloudSDK\ApiClient;
use \PureCloudSDK\ApiException;
use \PureCloudSDK\ObjectSerializer;

/**
 * ArchitectApi Class Doc Comment
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */
class ArchitectApi
{

    /**
     * API Client
     *
     * @var \PureCloudSDK\ApiClient instance of the ApiClient
     */
    protected $apiClient;

    /**
     * Constructor
     *
     * @param \PureCloudSDK\ApiClient|null $apiClient The api client to use
     */
    public function __construct(\PureCloudSDK\ApiClient $apiClient = null)
    {
        if ($apiClient == null) {
            $apiClient = new ApiClient();
            $apiClient->getConfig()->setHost('https://api.mypurecloud.ie');
        }

        $this->apiClient = $apiClient;
    }

    /**
     * Get API client
     *
     * @return \PureCloudSDK\ApiClient get the API client
     */
    public function getApiClient()
    {
        return $this->apiClient;
    }

    /**
     * Set the API client
     *
     * @param \PureCloudSDK\ApiClient $apiClient set the API client
     *
     * @return ArchitectApi
     */
    public function setApiClient(\PureCloudSDK\ApiClient $apiClient)
    {
        $this->apiClient = $apiClient;
        return $this;
    }

    /**
     * Operation deleteArchitectPrompts
     *
     * Batch-delete a list of prompts asynchronously
     *
     * @param string[] $id List of Prompt IDs (required)
     * @return \PureCloudSDK\Operation
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPrompts($id)
    {
        list($response) = $this->deleteArchitectPromptsWithHttpInfo($id);
        return $response;
    }

    /**
     * Operation deleteArchitectPromptsWithHttpInfo
     *
     * Batch-delete a list of prompts asynchronously
     *
     * @param string[] $id List of Prompt IDs (required)
     * @return Array of \PureCloudSDK\Operation, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptsWithHttpInfo($id)
    {
        // verify the required parameter 'id' is set
        if ($id === null) {
            throw new \InvalidArgumentException('Missing the required parameter $id when calling deleteArchitectPrompts');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if (is_array($id)) {
            $id = $this->apiClient->getSerializer()->serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Operation',
                '/api/v2/architect/prompts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Operation', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Operation', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectPromptsPromptId
     *
     * Delete specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @param bool $allResources Whether or not to delete all the prompt resources (optional)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptsPromptId($promptId, $allResources = null)
    {
        list($response) = $this->deleteArchitectPromptsPromptIdWithHttpInfo($promptId, $allResources);
        return $response;
    }

    /**
     * Operation deleteArchitectPromptsPromptIdWithHttpInfo
     *
     * Delete specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @param bool $allResources Whether or not to delete all the prompt resources (optional)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptsPromptIdWithHttpInfo($promptId, $allResources = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling deleteArchitectPromptsPromptId');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($allResources !== null) {
            $queryParams['allResources'] = $this->apiClient->getSerializer()->toQueryValue($allResources);
        }
        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/prompts/{promptId}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectPromptsPromptIdResourcesLanguagecode
     *
     * Delete specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return void
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode)
    {
        list($response) = $this->deleteArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation deleteArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo
     *
     * Delete specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of null, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling deleteArchitectPromptsPromptIdResourcesLanguagecode');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling deleteArchitectPromptsPromptIdResourcesLanguagecode');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                null,
                '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'
            );

            return array(null, $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation deleteArchitectSystempromptsPromptIdResourcesLanguagecode
     *
     * Delete a system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return string
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode)
    {
        list($response) = $this->deleteArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation deleteArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo
     *
     * Delete a system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of string, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function deleteArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling deleteArchitectSystempromptsPromptIdResourcesLanguagecode');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling deleteArchitectSystempromptsPromptIdResourcesLanguagecode');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'DELETE',
                $queryParams,
                $httpBody,
                $headerParams,
                'string',
                '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, 'string', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), 'string', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPrompts
     *
     * Get a pageable list of user prompts
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return \PureCloudSDK\PromptEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPrompts($pageNumber = null, $pageSize = null, $name = null, $description = null, $nameOrDescription = null)
    {
        list($response) = $this->getArchitectPromptsWithHttpInfo($pageNumber, $pageSize, $name, $description, $nameOrDescription);
        return $response;
    }

    /**
     * Operation getArchitectPromptsWithHttpInfo
     *
     * Get a pageable list of user prompts
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return Array of \PureCloudSDK\PromptEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptsWithHttpInfo($pageNumber = null, $pageSize = null, $name = null, $description = null, $nameOrDescription = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($description !== null) {
            $queryParams['description'] = $this->apiClient->getSerializer()->toQueryValue($description);
        }
        // query params
        if ($nameOrDescription !== null) {
            $queryParams['nameOrDescription'] = $this->apiClient->getSerializer()->toQueryValue($nameOrDescription);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptEntityListing',
                '/api/v2/architect/prompts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPromptsPromptId
     *
     * Get specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @return \PureCloudSDK\Prompt
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptsPromptId($promptId)
    {
        list($response) = $this->getArchitectPromptsPromptIdWithHttpInfo($promptId);
        return $response;
    }

    /**
     * Operation getArchitectPromptsPromptIdWithHttpInfo
     *
     * Get specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @return Array of \PureCloudSDK\Prompt, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptsPromptIdWithHttpInfo($promptId)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectPromptsPromptId');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Prompt',
                '/api/v2/architect/prompts/{promptId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Prompt', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Prompt', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPromptsPromptIdResources
     *
     * Get a pageable list of user prompt resources
     *
     * @param string $promptId Prompt ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return \PureCloudSDK\PromptAssetEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptsPromptIdResources($promptId, $pageNumber = null, $pageSize = null)
    {
        list($response) = $this->getArchitectPromptsPromptIdResourcesWithHttpInfo($promptId, $pageNumber, $pageSize);
        return $response;
    }

    /**
     * Operation getArchitectPromptsPromptIdResourcesWithHttpInfo
     *
     * Get a pageable list of user prompt resources
     *
     * @param string $promptId Prompt ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @return Array of \PureCloudSDK\PromptAssetEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptsPromptIdResourcesWithHttpInfo($promptId, $pageNumber = null, $pageSize = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectPromptsPromptIdResources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptAssetEntityListing',
                '/api/v2/architect/prompts/{promptId}/resources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptAssetEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptAssetEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectPromptsPromptIdResourcesLanguagecode
     *
     * Get specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return \PureCloudSDK\PromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode)
    {
        list($response) = $this->getArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation getArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo
     *
     * Get specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of \PureCloudSDK\PromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectPromptsPromptIdResourcesLanguagecode');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getArchitectPromptsPromptIdResourcesLanguagecode');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptAsset',
                '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystemprompts
     *
     * Get System Prompts
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return \PureCloudSDK\SystemPromptEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystemprompts($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null, $description = null, $nameOrDescription = null)
    {
        list($response) = $this->getArchitectSystempromptsWithHttpInfo($pageNumber, $pageSize, $sortBy, $sortOrder, $name, $description, $nameOrDescription);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptsWithHttpInfo
     *
     * Get System Prompts
     *
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @return Array of \PureCloudSDK\SystemPromptEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptsWithHttpInfo($pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $name = null, $description = null, $nameOrDescription = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($description !== null) {
            $queryParams['description'] = $this->apiClient->getSerializer()->toQueryValue($description);
        }
        // query params
        if ($nameOrDescription !== null) {
            $queryParams['nameOrDescription'] = $this->apiClient->getSerializer()->toQueryValue($nameOrDescription);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptEntityListing',
                '/api/v2/architect/systemprompts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystempromptsPromptId
     *
     * Get a system prompt
     *
     * @param string $promptId promptId (required)
     * @return \PureCloudSDK\SystemPrompt
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptsPromptId($promptId)
    {
        list($response) = $this->getArchitectSystempromptsPromptIdWithHttpInfo($promptId);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptsPromptIdWithHttpInfo
     *
     * Get a system prompt
     *
     * @param string $promptId promptId (required)
     * @return Array of \PureCloudSDK\SystemPrompt, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptsPromptIdWithHttpInfo($promptId)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectSystempromptsPromptId');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPrompt',
                '/api/v2/architect/systemprompts/{promptId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPrompt', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPrompt', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystempromptsPromptIdResources
     *
     * Get IVR System Prompt resources.
     *
     * @param string $promptId Prompt ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @return \PureCloudSDK\SystemPromptAssetEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptsPromptIdResources($promptId, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null)
    {
        list($response) = $this->getArchitectSystempromptsPromptIdResourcesWithHttpInfo($promptId, $pageNumber, $pageSize, $sortBy, $sortOrder);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptsPromptIdResourcesWithHttpInfo
     *
     * Get IVR System Prompt resources.
     *
     * @param string $promptId Prompt ID (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @return Array of \PureCloudSDK\SystemPromptAssetEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptsPromptIdResourcesWithHttpInfo($promptId, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectSystempromptsPromptIdResources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptAssetEntityListing',
                '/api/v2/architect/systemprompts/{promptId}/resources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptAssetEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptAssetEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getArchitectSystempromptsPromptIdResourcesLanguagecode
     *
     * Get a system prompt resource.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return \PureCloudSDK\SystemPromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode)
    {
        list($response) = $this->getArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode);
        return $response;
    }

    /**
     * Operation getArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo
     *
     * Get a system prompt resource.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @return Array of \PureCloudSDK\SystemPromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling getArchitectSystempromptsPromptIdResourcesLanguagecode');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling getArchitectSystempromptsPromptIdResourcesLanguagecode');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptAsset',
                '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation getFlows
     *
     * Get a pageable list of flows, filtered by query parameters
     *
     * @param string $type Type (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @param string $publishVersionId Publish version ID (optional)
     * @param string $editableBy Editable by (optional)
     * @param string $lockedBy Locked by (optional)
     * @param string $secure Secure (optional)
     * @param bool $deleted Include deleted (optional, default to false)
     * @param bool $includeSchemas Include variable schemas (optional, default to false)
     * @return \PureCloudSDK\FlowEntityListing
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlows($type, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $description = null, $nameOrDescription = null, $publishVersionId = null, $editableBy = null, $lockedBy = null, $secure = null, $deleted = null, $includeSchemas = null)
    {
        list($response) = $this->getFlowsWithHttpInfo($type, $pageNumber, $pageSize, $sortBy, $sortOrder, $id, $name, $description, $nameOrDescription, $publishVersionId, $editableBy, $lockedBy, $secure, $deleted, $includeSchemas);
        return $response;
    }

    /**
     * Operation getFlowsWithHttpInfo
     *
     * Get a pageable list of flows, filtered by query parameters
     *
     * @param string $type Type (required)
     * @param int $pageNumber Page number (optional, default to 1)
     * @param int $pageSize Page size (optional, default to 25)
     * @param string $sortBy Sort by (optional, default to id)
     * @param string $sortOrder Sort order (optional, default to asc)
     * @param string[] $id ID (optional)
     * @param string $name Name (optional)
     * @param string $description Description (optional)
     * @param string $nameOrDescription Name or description (optional)
     * @param string $publishVersionId Publish version ID (optional)
     * @param string $editableBy Editable by (optional)
     * @param string $lockedBy Locked by (optional)
     * @param string $secure Secure (optional)
     * @param bool $deleted Include deleted (optional, default to false)
     * @param bool $includeSchemas Include variable schemas (optional, default to false)
     * @return Array of \PureCloudSDK\FlowEntityListing, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function getFlowsWithHttpInfo($type, $pageNumber = null, $pageSize = null, $sortBy = null, $sortOrder = null, $id = null, $name = null, $description = null, $nameOrDescription = null, $publishVersionId = null, $editableBy = null, $lockedBy = null, $secure = null, $deleted = null, $includeSchemas = null)
    {
        // verify the required parameter 'type' is set
        if ($type === null) {
            throw new \InvalidArgumentException('Missing the required parameter $type when calling getFlows');
        }
        // parse inputs
        $resourcePath = "/api/v2/flows";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // query params
        if ($type !== null) {
            $queryParams['type'] = $this->apiClient->getSerializer()->toQueryValue($type);
        }
        // query params
        if ($pageNumber !== null) {
            $queryParams['pageNumber'] = $this->apiClient->getSerializer()->toQueryValue($pageNumber);
        }
        // query params
        if ($pageSize !== null) {
            $queryParams['pageSize'] = $this->apiClient->getSerializer()->toQueryValue($pageSize);
        }
        // query params
        if ($sortBy !== null) {
            $queryParams['sortBy'] = $this->apiClient->getSerializer()->toQueryValue($sortBy);
        }
        // query params
        if ($sortOrder !== null) {
            $queryParams['sortOrder'] = $this->apiClient->getSerializer()->toQueryValue($sortOrder);
        }
        // query params
        if (is_array($id)) {
            $id = $this->apiClient->getSerializer()->serializeCollection($id, 'multi', true);
        }
        if ($id !== null) {
            $queryParams['id'] = $this->apiClient->getSerializer()->toQueryValue($id);
        }
        // query params
        if ($name !== null) {
            $queryParams['name'] = $this->apiClient->getSerializer()->toQueryValue($name);
        }
        // query params
        if ($description !== null) {
            $queryParams['description'] = $this->apiClient->getSerializer()->toQueryValue($description);
        }
        // query params
        if ($nameOrDescription !== null) {
            $queryParams['nameOrDescription'] = $this->apiClient->getSerializer()->toQueryValue($nameOrDescription);
        }
        // query params
        if ($publishVersionId !== null) {
            $queryParams['publishVersionId'] = $this->apiClient->getSerializer()->toQueryValue($publishVersionId);
        }
        // query params
        if ($editableBy !== null) {
            $queryParams['editableBy'] = $this->apiClient->getSerializer()->toQueryValue($editableBy);
        }
        // query params
        if ($lockedBy !== null) {
            $queryParams['lockedBy'] = $this->apiClient->getSerializer()->toQueryValue($lockedBy);
        }
        // query params
        if ($secure !== null) {
            $queryParams['secure'] = $this->apiClient->getSerializer()->toQueryValue($secure);
        }
        // query params
        if ($deleted !== null) {
            $queryParams['deleted'] = $this->apiClient->getSerializer()->toQueryValue($deleted);
        }
        // query params
        if ($includeSchemas !== null) {
            $queryParams['includeSchemas'] = $this->apiClient->getSerializer()->toQueryValue($includeSchemas);
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        
        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'GET',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\FlowEntityListing',
                '/api/v2/flows'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\FlowEntityListing', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\FlowEntityListing', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectPrompts
     *
     * Create a new user prompt
     *
     * @param \PureCloudSDK\Prompt $body  (optional)
     * @return \PureCloudSDK\Prompt
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPrompts($body = null)
    {
        list($response) = $this->postArchitectPromptsWithHttpInfo($body);
        return $response;
    }

    /**
     * Operation postArchitectPromptsWithHttpInfo
     *
     * Create a new user prompt
     *
     * @param \PureCloudSDK\Prompt $body  (optional)
     * @return Array of \PureCloudSDK\Prompt, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPromptsWithHttpInfo($body = null)
    {
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Prompt',
                '/api/v2/architect/prompts'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Prompt', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Prompt', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectPromptsPromptIdResources
     *
     * Create a new user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\PromptAssetCreate $body  (optional)
     * @return \PureCloudSDK\PromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPromptsPromptIdResources($promptId, $body = null)
    {
        list($response) = $this->postArchitectPromptsPromptIdResourcesWithHttpInfo($promptId, $body);
        return $response;
    }

    /**
     * Operation postArchitectPromptsPromptIdResourcesWithHttpInfo
     *
     * Create a new user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\PromptAssetCreate $body  (optional)
     * @return Array of \PureCloudSDK\PromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectPromptsPromptIdResourcesWithHttpInfo($promptId, $body = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling postArchitectPromptsPromptIdResources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptAsset',
                '/api/v2/architect/prompts/{promptId}/resources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation postArchitectSystempromptsPromptIdResources
     *
     * Create system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\SystemPromptAsset $body  (optional)
     * @return \PureCloudSDK\SystemPromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSystempromptsPromptIdResources($promptId, $body = null)
    {
        list($response) = $this->postArchitectSystempromptsPromptIdResourcesWithHttpInfo($promptId, $body);
        return $response;
    }

    /**
     * Operation postArchitectSystempromptsPromptIdResourcesWithHttpInfo
     *
     * Create system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\SystemPromptAsset $body  (optional)
     * @return Array of \PureCloudSDK\SystemPromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function postArchitectSystempromptsPromptIdResourcesWithHttpInfo($promptId, $body = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling postArchitectSystempromptsPromptIdResources');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'POST',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptAsset',
                '/api/v2/architect/systemprompts/{promptId}/resources'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectPromptsPromptId
     *
     * Update specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\Prompt $body  (optional)
     * @return \PureCloudSDK\Prompt
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectPromptsPromptId($promptId, $body = null)
    {
        list($response) = $this->putArchitectPromptsPromptIdWithHttpInfo($promptId, $body);
        return $response;
    }

    /**
     * Operation putArchitectPromptsPromptIdWithHttpInfo
     *
     * Update specified user prompt
     *
     * @param string $promptId Prompt ID (required)
     * @param \PureCloudSDK\Prompt $body  (optional)
     * @return Array of \PureCloudSDK\Prompt, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectPromptsPromptIdWithHttpInfo($promptId, $body = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling putArchitectPromptsPromptId');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\Prompt',
                '/api/v2/architect/prompts/{promptId}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\Prompt', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\Prompt', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectPromptsPromptIdResourcesLanguagecode
     *
     * Update specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @param \PureCloudSDK\PromptAsset $body  (optional)
     * @return \PureCloudSDK\PromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectPromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body = null)
    {
        list($response) = $this->putArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation putArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo
     *
     * Update specified user prompt resource
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @param \PureCloudSDK\PromptAsset $body  (optional)
     * @return Array of \PureCloudSDK\PromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectPromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode, $body = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling putArchitectPromptsPromptIdResourcesLanguagecode');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling putArchitectPromptsPromptIdResourcesLanguagecode');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/prompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\PromptAsset',
                '/api/v2/architect/prompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\PromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\PromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

    /**
     * Operation putArchitectSystempromptsPromptIdResourcesLanguagecode
     *
     * Updates a system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @param \PureCloudSDK\SystemPromptAsset $body  (optional)
     * @return \PureCloudSDK\SystemPromptAsset
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectSystempromptsPromptIdResourcesLanguagecode($promptId, $languageCode, $body = null)
    {
        list($response) = $this->putArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode, $body);
        return $response;
    }

    /**
     * Operation putArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo
     *
     * Updates a system prompt resource override.
     *
     * @param string $promptId Prompt ID (required)
     * @param string $languageCode Language (required)
     * @param \PureCloudSDK\SystemPromptAsset $body  (optional)
     * @return Array of \PureCloudSDK\SystemPromptAsset, HTTP status code, HTTP response headers (array of strings)
     * @throws \PureCloudSDK\ApiException on non-2xx response
     */
    public function putArchitectSystempromptsPromptIdResourcesLanguagecodeWithHttpInfo($promptId, $languageCode, $body = null)
    {
        // verify the required parameter 'promptId' is set
        if ($promptId === null) {
            throw new \InvalidArgumentException('Missing the required parameter $promptId when calling putArchitectSystempromptsPromptIdResourcesLanguagecode');
        }
        // verify the required parameter 'languageCode' is set
        if ($languageCode === null) {
            throw new \InvalidArgumentException('Missing the required parameter $languageCode when calling putArchitectSystempromptsPromptIdResourcesLanguagecode');
        }
        // parse inputs
        $resourcePath = "/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}";
        $httpBody = '';
        $queryParams = array();
        $headerParams = array();
        $formParams = array();
        $_header_accept = $this->apiClient->selectHeaderAccept(array('application/json'));
        if (!is_null($_header_accept)) {
            $headerParams['Accept'] = $_header_accept;
        }
        $headerParams['Content-Type'] = $this->apiClient->selectHeaderContentType(array('application/json'));

        // path params
        if ($promptId !== null) {
            $resourcePath = str_replace(
                "{" . "promptId" . "}",
                $this->apiClient->getSerializer()->toPathValue($promptId),
                $resourcePath
            );
        }
        // path params
        if ($languageCode !== null) {
            $resourcePath = str_replace(
                "{" . "languageCode" . "}",
                $this->apiClient->getSerializer()->toPathValue($languageCode),
                $resourcePath
            );
        }
        // default format to json
        $resourcePath = str_replace("{format}", "json", $resourcePath);

        // body params
        $_tempBody = null;
        if (isset($body)) {
            $_tempBody = $body;
        }

        // for model (json/xml)
        if (isset($_tempBody)) {
            $httpBody = $_tempBody; // $_tempBody is the method argument, if present
        } elseif (count($formParams) > 0) {
            $httpBody = $formParams; // for HTTP post (form)
        }
        // this endpoint requires OAuth (access token)
        if (strlen($this->apiClient->getConfig()->getAccessToken()) !== 0) {
            $headerParams['Authorization'] = 'Bearer ' . $this->apiClient->getConfig()->getAccessToken();
        }
        // make the API Call
        try {
            list($response, $statusCode, $httpHeader) = $this->apiClient->callApi(
                $resourcePath,
                'PUT',
                $queryParams,
                $httpBody,
                $headerParams,
                '\PureCloudSDK\SystemPromptAsset',
                '/api/v2/architect/systemprompts/{promptId}/resources/{languageCode}'
            );

            return array($this->apiClient->getSerializer()->deserialize($response, '\PureCloudSDK\SystemPromptAsset', $httpHeader), $statusCode, $httpHeader);
        } catch (ApiException $e) {
            switch ($e->getCode()) {
                case 200:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\SystemPromptAsset', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 400:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 401:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 403:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 404:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 415:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 429:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 500:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 503:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
                case 504:
                    $data = $this->apiClient->getSerializer()->deserialize($e->getResponseBody(), '\PureCloudSDK\ErrorBody', $e->getResponseHeaders());
                    $e->setResponseObject($data);
                    break;
            }

            throw $e;
        }
    }

}
