<?php
/**
 * BillingTaskResult
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * BillingTaskResult Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class BillingTaskResult implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'BillingTaskResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'taskType' => 'string',
        'status' => 'string',
        'resultId' => 'string',
        'resultUri' => 'string',
        'resultDownloadUrl' => 'string',
        'errorCode' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'taskType' => 'taskType',
        'status' => 'status',
        'resultId' => 'resultId',
        'resultUri' => 'resultUri',
        'resultDownloadUrl' => 'resultDownloadUrl',
        'errorCode' => 'errorCode',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'taskType' => 'setTaskType',
        'status' => 'setStatus',
        'resultId' => 'setResultId',
        'resultUri' => 'setResultUri',
        'resultDownloadUrl' => 'setResultDownloadUrl',
        'errorCode' => 'setErrorCode',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'taskType' => 'getTaskType',
        'status' => 'getStatus',
        'resultId' => 'getResultId',
        'resultUri' => 'getResultUri',
        'resultDownloadUrl' => 'getResultDownloadUrl',
        'errorCode' => 'getErrorCode',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TASK_TYPE_GENERATE_PCV_USAGE_REPORT = 'GENERATE_PCV_USAGE_REPORT';
    const TASK_TYPE_GENERATE_BILLABLE_USAGE_REPORT = 'GENERATE_BILLABLE_USAGE_REPORT';
    const TASK_TYPE_GENERATE_CONCURRENT_USAGE_REPORT = 'GENERATE_CONCURRENT_USAGE_REPORT';
    const TASK_TYPE_CREATE_QUOTE = 'CREATE_QUOTE';
    const TASK_TYPE_CREATE_SALESFORCE_ACCOUNT = 'CREATE_SALESFORCE_ACCOUNT';
    const TASK_TYPE_SUBMIT_QUOTE = 'SUBMIT_QUOTE';
    const TASK_TYPE_GENERATE_CONTRACT = 'GENERATE_CONTRACT';
    const TASK_TYPE_OTHER = 'OTHER';
    const STATUS_IN_PROGRESS = 'IN_PROGRESS';
    const STATUS_SUCCEEDED = 'SUCCEEDED';
    const STATUS_FAILED = 'FAILED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTaskTypeAllowableValues()
    {
        return [
            self::TASK_TYPE_GENERATE_PCV_USAGE_REPORT,
            self::TASK_TYPE_GENERATE_BILLABLE_USAGE_REPORT,
            self::TASK_TYPE_GENERATE_CONCURRENT_USAGE_REPORT,
            self::TASK_TYPE_CREATE_QUOTE,
            self::TASK_TYPE_CREATE_SALESFORCE_ACCOUNT,
            self::TASK_TYPE_SUBMIT_QUOTE,
            self::TASK_TYPE_GENERATE_CONTRACT,
            self::TASK_TYPE_OTHER,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_IN_PROGRESS,
            self::STATUS_SUCCEEDED,
            self::STATUS_FAILED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['taskType'] = isset($data['taskType']) ? $data['taskType'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['resultId'] = isset($data['resultId']) ? $data['resultId'] : null;
        $this->container['resultUri'] = isset($data['resultUri']) ? $data['resultUri'] : null;
        $this->container['resultDownloadUrl'] = isset($data['resultDownloadUrl']) ? $data['resultDownloadUrl'] : null;
        $this->container['errorCode'] = isset($data['errorCode']) ? $data['errorCode'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("GENERATE_PCV_USAGE_REPORT", "GENERATE_BILLABLE_USAGE_REPORT", "GENERATE_CONCURRENT_USAGE_REPORT", "CREATE_QUOTE", "CREATE_SALESFORCE_ACCOUNT", "SUBMIT_QUOTE", "GENERATE_CONTRACT", "OTHER");
        if (!in_array($this->container['taskType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'taskType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("IN_PROGRESS", "SUCCEEDED", "FAILED");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("GENERATE_PCV_USAGE_REPORT", "GENERATE_BILLABLE_USAGE_REPORT", "GENERATE_CONCURRENT_USAGE_REPORT", "CREATE_QUOTE", "CREATE_SALESFORCE_ACCOUNT", "SUBMIT_QUOTE", "GENERATE_CONTRACT", "OTHER");
        if (!in_array($this->container['taskType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("IN_PROGRESS", "SUCCEEDED", "FAILED");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets taskType
     * @return string
     */
    public function getTaskType()
    {
        return $this->container['taskType'];
    }

    /**
     * Sets taskType
     * @param string $taskType
     * @return $this
     */
    public function setTaskType($taskType)
    {
        $allowed_values = array('GENERATE_PCV_USAGE_REPORT', 'GENERATE_BILLABLE_USAGE_REPORT', 'GENERATE_CONCURRENT_USAGE_REPORT', 'CREATE_QUOTE', 'CREATE_SALESFORCE_ACCOUNT', 'SUBMIT_QUOTE', 'GENERATE_CONTRACT', 'OTHER');
        if (!in_array($taskType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'taskType', must be one of 'GENERATE_PCV_USAGE_REPORT', 'GENERATE_BILLABLE_USAGE_REPORT', 'GENERATE_CONCURRENT_USAGE_REPORT', 'CREATE_QUOTE', 'CREATE_SALESFORCE_ACCOUNT', 'SUBMIT_QUOTE', 'GENERATE_CONTRACT', 'OTHER'");
        }
        $this->container['taskType'] = $taskType;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('IN_PROGRESS', 'SUCCEEDED', 'FAILED');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'IN_PROGRESS', 'SUCCEEDED', 'FAILED'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets resultId
     * @return string
     */
    public function getResultId()
    {
        return $this->container['resultId'];
    }

    /**
     * Sets resultId
     * @param string $resultId
     * @return $this
     */
    public function setResultId($resultId)
    {
        $this->container['resultId'] = $resultId;

        return $this;
    }

    /**
     * Gets resultUri
     * @return string
     */
    public function getResultUri()
    {
        return $this->container['resultUri'];
    }

    /**
     * Sets resultUri
     * @param string $resultUri
     * @return $this
     */
    public function setResultUri($resultUri)
    {
        $this->container['resultUri'] = $resultUri;

        return $this;
    }

    /**
     * Gets resultDownloadUrl
     * @return string
     */
    public function getResultDownloadUrl()
    {
        return $this->container['resultDownloadUrl'];
    }

    /**
     * Sets resultDownloadUrl
     * @param string $resultDownloadUrl
     * @return $this
     */
    public function setResultDownloadUrl($resultDownloadUrl)
    {
        $this->container['resultDownloadUrl'] = $resultDownloadUrl;

        return $this;
    }

    /**
     * Gets errorCode
     * @return string
     */
    public function getErrorCode()
    {
        return $this->container['errorCode'];
    }

    /**
     * Sets errorCode
     * @param string $errorCode
     * @return $this
     */
    public function setErrorCode($errorCode)
    {
        $this->container['errorCode'] = $errorCode;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


