<?php
/**
 * Campaign
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Campaign Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Campaign implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Campaign';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'version' => 'int',
        'contactList' => '\PureCloudSDK\UriReference',
        'queue' => '\PureCloudSDK\UriReference',
        'dialingMode' => 'string',
        'script' => '\PureCloudSDK\UriReference',
        'edgeGroup' => '\PureCloudSDK\UriReference',
        'campaignStatus' => 'string',
        'phoneColumns' => '\PureCloudSDK\PhoneColumn[]',
        'abandonRate' => 'double',
        'dncLists' => '\PureCloudSDK\UriReference[]',
        'callableTimeSet' => '\PureCloudSDK\UriReference',
        'callAnalysisResponseSet' => '\PureCloudSDK\UriReference',
        'errors' => '\PureCloudSDK\RestErrorDetail[]',
        'callerName' => 'string',
        'callerAddress' => 'string',
        'outboundLineCount' => 'int',
        'ruleSets' => '\PureCloudSDK\UriReference[]',
        'skipPreviewDisabled' => 'bool',
        'previewTimeOutSeconds' => 'int',
        'contactSort' => '\PureCloudSDK\ContactSort',
        'contactSorts' => '\PureCloudSDK\ContactSort[]',
        'noAnswerTimeout' => 'int',
        'callAnalysisLanguage' => 'string',
        'priority' => 'int',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'version' => 'version',
        'contactList' => 'contactList',
        'queue' => 'queue',
        'dialingMode' => 'dialingMode',
        'script' => 'script',
        'edgeGroup' => 'edgeGroup',
        'campaignStatus' => 'campaignStatus',
        'phoneColumns' => 'phoneColumns',
        'abandonRate' => 'abandonRate',
        'dncLists' => 'dncLists',
        'callableTimeSet' => 'callableTimeSet',
        'callAnalysisResponseSet' => 'callAnalysisResponseSet',
        'errors' => 'errors',
        'callerName' => 'callerName',
        'callerAddress' => 'callerAddress',
        'outboundLineCount' => 'outboundLineCount',
        'ruleSets' => 'ruleSets',
        'skipPreviewDisabled' => 'skipPreviewDisabled',
        'previewTimeOutSeconds' => 'previewTimeOutSeconds',
        'contactSort' => 'contactSort',
        'contactSorts' => 'contactSorts',
        'noAnswerTimeout' => 'noAnswerTimeout',
        'callAnalysisLanguage' => 'callAnalysisLanguage',
        'priority' => 'priority',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'version' => 'setVersion',
        'contactList' => 'setContactList',
        'queue' => 'setQueue',
        'dialingMode' => 'setDialingMode',
        'script' => 'setScript',
        'edgeGroup' => 'setEdgeGroup',
        'campaignStatus' => 'setCampaignStatus',
        'phoneColumns' => 'setPhoneColumns',
        'abandonRate' => 'setAbandonRate',
        'dncLists' => 'setDncLists',
        'callableTimeSet' => 'setCallableTimeSet',
        'callAnalysisResponseSet' => 'setCallAnalysisResponseSet',
        'errors' => 'setErrors',
        'callerName' => 'setCallerName',
        'callerAddress' => 'setCallerAddress',
        'outboundLineCount' => 'setOutboundLineCount',
        'ruleSets' => 'setRuleSets',
        'skipPreviewDisabled' => 'setSkipPreviewDisabled',
        'previewTimeOutSeconds' => 'setPreviewTimeOutSeconds',
        'contactSort' => 'setContactSort',
        'contactSorts' => 'setContactSorts',
        'noAnswerTimeout' => 'setNoAnswerTimeout',
        'callAnalysisLanguage' => 'setCallAnalysisLanguage',
        'priority' => 'setPriority',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'version' => 'getVersion',
        'contactList' => 'getContactList',
        'queue' => 'getQueue',
        'dialingMode' => 'getDialingMode',
        'script' => 'getScript',
        'edgeGroup' => 'getEdgeGroup',
        'campaignStatus' => 'getCampaignStatus',
        'phoneColumns' => 'getPhoneColumns',
        'abandonRate' => 'getAbandonRate',
        'dncLists' => 'getDncLists',
        'callableTimeSet' => 'getCallableTimeSet',
        'callAnalysisResponseSet' => 'getCallAnalysisResponseSet',
        'errors' => 'getErrors',
        'callerName' => 'getCallerName',
        'callerAddress' => 'getCallerAddress',
        'outboundLineCount' => 'getOutboundLineCount',
        'ruleSets' => 'getRuleSets',
        'skipPreviewDisabled' => 'getSkipPreviewDisabled',
        'previewTimeOutSeconds' => 'getPreviewTimeOutSeconds',
        'contactSort' => 'getContactSort',
        'contactSorts' => 'getContactSorts',
        'noAnswerTimeout' => 'getNoAnswerTimeout',
        'callAnalysisLanguage' => 'getCallAnalysisLanguage',
        'priority' => 'getPriority',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DIALING_MODE_AGENTLESS = 'agentless';
    const DIALING_MODE_PREVIEW = 'preview';
    const DIALING_MODE_POWER = 'power';
    const DIALING_MODE_PREDICTIVE = 'predictive';
    const DIALING_MODE_PROGRESSIVE = 'progressive';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDialingModeAllowableValues()
    {
        return [
            self::DIALING_MODE_AGENTLESS,
            self::DIALING_MODE_PREVIEW,
            self::DIALING_MODE_POWER,
            self::DIALING_MODE_PREDICTIVE,
            self::DIALING_MODE_PROGRESSIVE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['contactList'] = isset($data['contactList']) ? $data['contactList'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['dialingMode'] = isset($data['dialingMode']) ? $data['dialingMode'] : null;
        $this->container['script'] = isset($data['script']) ? $data['script'] : null;
        $this->container['edgeGroup'] = isset($data['edgeGroup']) ? $data['edgeGroup'] : null;
        $this->container['campaignStatus'] = isset($data['campaignStatus']) ? $data['campaignStatus'] : null;
        $this->container['phoneColumns'] = isset($data['phoneColumns']) ? $data['phoneColumns'] : null;
        $this->container['abandonRate'] = isset($data['abandonRate']) ? $data['abandonRate'] : null;
        $this->container['dncLists'] = isset($data['dncLists']) ? $data['dncLists'] : null;
        $this->container['callableTimeSet'] = isset($data['callableTimeSet']) ? $data['callableTimeSet'] : null;
        $this->container['callAnalysisResponseSet'] = isset($data['callAnalysisResponseSet']) ? $data['callAnalysisResponseSet'] : null;
        $this->container['errors'] = isset($data['errors']) ? $data['errors'] : null;
        $this->container['callerName'] = isset($data['callerName']) ? $data['callerName'] : null;
        $this->container['callerAddress'] = isset($data['callerAddress']) ? $data['callerAddress'] : null;
        $this->container['outboundLineCount'] = isset($data['outboundLineCount']) ? $data['outboundLineCount'] : null;
        $this->container['ruleSets'] = isset($data['ruleSets']) ? $data['ruleSets'] : null;
        $this->container['skipPreviewDisabled'] = isset($data['skipPreviewDisabled']) ? $data['skipPreviewDisabled'] : null;
        $this->container['previewTimeOutSeconds'] = isset($data['previewTimeOutSeconds']) ? $data['previewTimeOutSeconds'] : null;
        $this->container['contactSort'] = isset($data['contactSort']) ? $data['contactSort'] : null;
        $this->container['contactSorts'] = isset($data['contactSorts']) ? $data['contactSorts'] : null;
        $this->container['noAnswerTimeout'] = isset($data['noAnswerTimeout']) ? $data['noAnswerTimeout'] : null;
        $this->container['callAnalysisLanguage'] = isset($data['callAnalysisLanguage']) ? $data['callAnalysisLanguage'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['contactList'] === null) {
            $invalid_properties[] = "'contactList' can't be null";
        }
        if ($this->container['queue'] === null) {
            $invalid_properties[] = "'queue' can't be null";
        }
        if ($this->container['dialingMode'] === null) {
            $invalid_properties[] = "'dialingMode' can't be null";
        }
        $allowed_values = array("agentless", "preview", "power", "predictive", "progressive");
        if (!in_array($this->container['dialingMode'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'dialingMode', must be one of #{allowed_values}.";
        }

        if ($this->container['script'] === null) {
            $invalid_properties[] = "'script' can't be null";
        }
        if ($this->container['edgeGroup'] === null) {
            $invalid_properties[] = "'edgeGroup' can't be null";
        }
        if ($this->container['campaignStatus'] === null) {
            $invalid_properties[] = "'campaignStatus' can't be null";
        }
        if ($this->container['phoneColumns'] === null) {
            $invalid_properties[] = "'phoneColumns' can't be null";
        }
        if ($this->container['callAnalysisResponseSet'] === null) {
            $invalid_properties[] = "'callAnalysisResponseSet' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['contactList'] === null) {
            return false;
        }
        if ($this->container['queue'] === null) {
            return false;
        }
        if ($this->container['dialingMode'] === null) {
            return false;
        }
        $allowed_values = array("agentless", "preview", "power", "predictive", "progressive");
        if (!in_array($this->container['dialingMode'], $allowed_values)) {
            return false;
        }
        if ($this->container['script'] === null) {
            return false;
        }
        if ($this->container['edgeGroup'] === null) {
            return false;
        }
        if ($this->container['campaignStatus'] === null) {
            return false;
        }
        if ($this->container['phoneColumns'] === null) {
            return false;
        }
        if ($this->container['callAnalysisResponseSet'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required for updates, must match the version number of the most recent update
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets contactList
     * @return \PureCloudSDK\UriReference
     */
    public function getContactList()
    {
        return $this->container['contactList'];
    }

    /**
     * Sets contactList
     * @param \PureCloudSDK\UriReference $contactList identifier of the contact list for the campaign
     * @return $this
     */
    public function setContactList($contactList)
    {
        $this->container['contactList'] = $contactList;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\UriReference
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\UriReference $queue identifier of the agent assignment queue, required for all dialing modes other than agentless
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets dialingMode
     * @return string
     */
    public function getDialingMode()
    {
        return $this->container['dialingMode'];
    }

    /**
     * Sets dialingMode
     * @param string $dialingMode dialing mode of the campaign
     * @return $this
     */
    public function setDialingMode($dialingMode)
    {
        $allowed_values = array('agentless', 'preview', 'power', 'predictive', 'progressive');
        if (!in_array($dialingMode, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'dialingMode', must be one of 'agentless', 'preview', 'power', 'predictive', 'progressive'");
        }
        $this->container['dialingMode'] = $dialingMode;

        return $this;
    }

    /**
     * Gets script
     * @return \PureCloudSDK\UriReference
     */
    public function getScript()
    {
        return $this->container['script'];
    }

    /**
     * Sets script
     * @param \PureCloudSDK\UriReference $script identifier of the campaign script, required for all dialing modes other than agentless
     * @return $this
     */
    public function setScript($script)
    {
        $this->container['script'] = $script;

        return $this;
    }

    /**
     * Gets edgeGroup
     * @return \PureCloudSDK\UriReference
     */
    public function getEdgeGroup()
    {
        return $this->container['edgeGroup'];
    }

    /**
     * Sets edgeGroup
     * @param \PureCloudSDK\UriReference $edgeGroup identifier of the edge group, required for all dialing modes other than preview
     * @return $this
     */
    public function setEdgeGroup($edgeGroup)
    {
        $this->container['edgeGroup'] = $edgeGroup;

        return $this;
    }

    /**
     * Gets campaignStatus
     * @return string
     */
    public function getCampaignStatus()
    {
        return $this->container['campaignStatus'];
    }

    /**
     * Sets campaignStatus
     * @param string $campaignStatus status of the campaign; can be set to 'on' or 'off'
     * @return $this
     */
    public function setCampaignStatus($campaignStatus)
    {
        $this->container['campaignStatus'] = $campaignStatus;

        return $this;
    }

    /**
     * Gets phoneColumns
     * @return \PureCloudSDK\PhoneColumn[]
     */
    public function getPhoneColumns()
    {
        return $this->container['phoneColumns'];
    }

    /**
     * Sets phoneColumns
     * @param \PureCloudSDK\PhoneColumn[] $phoneColumns the contact list phone columns to be called for the campaign
     * @return $this
     */
    public function setPhoneColumns($phoneColumns)
    {
        $this->container['phoneColumns'] = $phoneColumns;

        return $this;
    }

    /**
     * Gets abandonRate
     * @return double
     */
    public function getAbandonRate()
    {
        return $this->container['abandonRate'];
    }

    /**
     * Sets abandonRate
     * @param double $abandonRate the targeted abandon rate percentage
     * @return $this
     */
    public function setAbandonRate($abandonRate)
    {
        $this->container['abandonRate'] = $abandonRate;

        return $this;
    }

    /**
     * Gets dncLists
     * @return \PureCloudSDK\UriReference[]
     */
    public function getDncLists()
    {
        return $this->container['dncLists'];
    }

    /**
     * Sets dncLists
     * @param \PureCloudSDK\UriReference[] $dncLists identifiers of the do not call lists
     * @return $this
     */
    public function setDncLists($dncLists)
    {
        $this->container['dncLists'] = $dncLists;

        return $this;
    }

    /**
     * Gets callableTimeSet
     * @return \PureCloudSDK\UriReference
     */
    public function getCallableTimeSet()
    {
        return $this->container['callableTimeSet'];
    }

    /**
     * Sets callableTimeSet
     * @param \PureCloudSDK\UriReference $callableTimeSet the identifier of the callable time set
     * @return $this
     */
    public function setCallableTimeSet($callableTimeSet)
    {
        $this->container['callableTimeSet'] = $callableTimeSet;

        return $this;
    }

    /**
     * Gets callAnalysisResponseSet
     * @return \PureCloudSDK\UriReference
     */
    public function getCallAnalysisResponseSet()
    {
        return $this->container['callAnalysisResponseSet'];
    }

    /**
     * Sets callAnalysisResponseSet
     * @param \PureCloudSDK\UriReference $callAnalysisResponseSet the identifier of the call analysis response set, required for all dialing modes other than preview
     * @return $this
     */
    public function setCallAnalysisResponseSet($callAnalysisResponseSet)
    {
        $this->container['callAnalysisResponseSet'] = $callAnalysisResponseSet;

        return $this;
    }

    /**
     * Gets errors
     * @return \PureCloudSDK\RestErrorDetail[]
     */
    public function getErrors()
    {
        return $this->container['errors'];
    }

    /**
     * Sets errors
     * @param \PureCloudSDK\RestErrorDetail[] $errors a list of current error conditions associated with the campaign
     * @return $this
     */
    public function setErrors($errors)
    {
        $this->container['errors'] = $errors;

        return $this;
    }

    /**
     * Gets callerName
     * @return string
     */
    public function getCallerName()
    {
        return $this->container['callerName'];
    }

    /**
     * Sets callerName
     * @param string $callerName caller id name to be displayed on the outbound call
     * @return $this
     */
    public function setCallerName($callerName)
    {
        $this->container['callerName'] = $callerName;

        return $this;
    }

    /**
     * Gets callerAddress
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['callerAddress'];
    }

    /**
     * Sets callerAddress
     * @param string $callerAddress caller id phone number to be displayed on the outbound call
     * @return $this
     */
    public function setCallerAddress($callerAddress)
    {
        $this->container['callerAddress'] = $callerAddress;

        return $this;
    }

    /**
     * Gets outboundLineCount
     * @return int
     */
    public function getOutboundLineCount()
    {
        return $this->container['outboundLineCount'];
    }

    /**
     * Sets outboundLineCount
     * @param int $outboundLineCount for agentless campaigns, the number of outbound lines to be concurrently dialed
     * @return $this
     */
    public function setOutboundLineCount($outboundLineCount)
    {
        $this->container['outboundLineCount'] = $outboundLineCount;

        return $this;
    }

    /**
     * Gets ruleSets
     * @return \PureCloudSDK\UriReference[]
     */
    public function getRuleSets()
    {
        return $this->container['ruleSets'];
    }

    /**
     * Sets ruleSets
     * @param \PureCloudSDK\UriReference[] $ruleSets identifiers of the rule sets
     * @return $this
     */
    public function setRuleSets($ruleSets)
    {
        $this->container['ruleSets'] = $ruleSets;

        return $this;
    }

    /**
     * Gets skipPreviewDisabled
     * @return bool
     */
    public function getSkipPreviewDisabled()
    {
        return $this->container['skipPreviewDisabled'];
    }

    /**
     * Sets skipPreviewDisabled
     * @param bool $skipPreviewDisabled for preview campaigns, indicator of whether the agent can skip a preview without placing a call
     * @return $this
     */
    public function setSkipPreviewDisabled($skipPreviewDisabled)
    {
        $this->container['skipPreviewDisabled'] = $skipPreviewDisabled;

        return $this;
    }

    /**
     * Gets previewTimeOutSeconds
     * @return int
     */
    public function getPreviewTimeOutSeconds()
    {
        return $this->container['previewTimeOutSeconds'];
    }

    /**
     * Sets previewTimeOutSeconds
     * @param int $previewTimeOutSeconds for preview campaigns, number of seconds before a call will be automatically placed. A value of 0 indicates no automatic placement of calls
     * @return $this
     */
    public function setPreviewTimeOutSeconds($previewTimeOutSeconds)
    {
        $this->container['previewTimeOutSeconds'] = $previewTimeOutSeconds;

        return $this;
    }

    /**
     * Gets contactSort
     * @return \PureCloudSDK\ContactSort
     */
    public function getContactSort()
    {
        return $this->container['contactSort'];
    }

    /**
     * Sets contactSort
     * @param \PureCloudSDK\ContactSort $contactSort information determining the order in which the contacts will be dialed
     * @return $this
     */
    public function setContactSort($contactSort)
    {
        $this->container['contactSort'] = $contactSort;

        return $this;
    }

    /**
     * Gets contactSorts
     * @return \PureCloudSDK\ContactSort[]
     */
    public function getContactSorts()
    {
        return $this->container['contactSorts'];
    }

    /**
     * Sets contactSorts
     * @param \PureCloudSDK\ContactSort[] $contactSorts column prioritized information determining the order in which the contacts will be dialed
     * @return $this
     */
    public function setContactSorts($contactSorts)
    {
        $this->container['contactSorts'] = $contactSorts;

        return $this;
    }

    /**
     * Gets noAnswerTimeout
     * @return int
     */
    public function getNoAnswerTimeout()
    {
        return $this->container['noAnswerTimeout'];
    }

    /**
     * Sets noAnswerTimeout
     * @param int $noAnswerTimeout for non-preview campaigns, how long to wait before dispositioning as 'no-answer', default 30 seconds
     * @return $this
     */
    public function setNoAnswerTimeout($noAnswerTimeout)
    {
        $this->container['noAnswerTimeout'] = $noAnswerTimeout;

        return $this;
    }

    /**
     * Gets callAnalysisLanguage
     * @return string
     */
    public function getCallAnalysisLanguage()
    {
        return $this->container['callAnalysisLanguage'];
    }

    /**
     * Sets callAnalysisLanguage
     * @param string $callAnalysisLanguage The language the edge will use to analyse the call
     * @return $this
     */
    public function setCallAnalysisLanguage($callAnalysisLanguage)
    {
        $this->container['callAnalysisLanguage'] = $callAnalysisLanguage;

        return $this;
    }

    /**
     * Gets priority
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param int $priority The priority of this campaign relative to other campaigns
     * @return $this
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


