<?php
/**
 * CampaignRuleAction
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CampaignRuleAction Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CampaignRuleAction implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CampaignRuleAction';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'parameters' => '\PureCloudSDK\CampaignRuleParameters',
        'actionType' => 'string',
        'campaignRuleActionEntities' => '\PureCloudSDK\CampaignRuleActionEntities'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'parameters' => 'parameters',
        'actionType' => 'actionType',
        'campaignRuleActionEntities' => 'campaignRuleActionEntities'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'parameters' => 'setParameters',
        'actionType' => 'setActionType',
        'campaignRuleActionEntities' => 'setCampaignRuleActionEntities'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'parameters' => 'getParameters',
        'actionType' => 'getActionType',
        'campaignRuleActionEntities' => 'getCampaignRuleActionEntities'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const ACTION_TYPE_TURN_ON_CAMPAIGN = 'turnOnCampaign';
    const ACTION_TYPE_TURN_OFF_CAMPAIGN = 'turnOffCampaign';
    const ACTION_TYPE_TURN_ON_SEQUENCE = 'turnOnSequence';
    const ACTION_TYPE_TURN_OFF_SEQUENCE = 'turnOffSequence';
    const ACTION_TYPE_SET_CAMPAIGN_PRIORITY = 'setCampaignPriority';
    const ACTION_TYPE_RECYCLE_CAMPAIGN = 'recycleCampaign';
    const ACTION_TYPE_SET_CAMPAIGN_DIALING_MODE = 'setCampaignDialingMode';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getActionTypeAllowableValues()
    {
        return [
            self::ACTION_TYPE_TURN_ON_CAMPAIGN,
            self::ACTION_TYPE_TURN_OFF_CAMPAIGN,
            self::ACTION_TYPE_TURN_ON_SEQUENCE,
            self::ACTION_TYPE_TURN_OFF_SEQUENCE,
            self::ACTION_TYPE_SET_CAMPAIGN_PRIORITY,
            self::ACTION_TYPE_RECYCLE_CAMPAIGN,
            self::ACTION_TYPE_SET_CAMPAIGN_DIALING_MODE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['parameters'] = isset($data['parameters']) ? $data['parameters'] : null;
        $this->container['actionType'] = isset($data['actionType']) ? $data['actionType'] : null;
        $this->container['campaignRuleActionEntities'] = isset($data['campaignRuleActionEntities']) ? $data['campaignRuleActionEntities'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("turnOnCampaign", "turnOffCampaign", "turnOnSequence", "turnOffSequence", "setCampaignPriority", "recycleCampaign", "setCampaignDialingMode");
        if (!in_array($this->container['actionType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'actionType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("turnOnCampaign", "turnOffCampaign", "turnOnSequence", "turnOffSequence", "setCampaignPriority", "recycleCampaign", "setCampaignDialingMode");
        if (!in_array($this->container['actionType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets parameters
     * @return \PureCloudSDK\CampaignRuleParameters
     */
    public function getParameters()
    {
        return $this->container['parameters'];
    }

    /**
     * Sets parameters
     * @param \PureCloudSDK\CampaignRuleParameters $parameters
     * @return $this
     */
    public function setParameters($parameters)
    {
        $this->container['parameters'] = $parameters;

        return $this;
    }

    /**
     * Gets actionType
     * @return string
     */
    public function getActionType()
    {
        return $this->container['actionType'];
    }

    /**
     * Sets actionType
     * @param string $actionType
     * @return $this
     */
    public function setActionType($actionType)
    {
        $allowed_values = array('turnOnCampaign', 'turnOffCampaign', 'turnOnSequence', 'turnOffSequence', 'setCampaignPriority', 'recycleCampaign', 'setCampaignDialingMode');
        if (!in_array($actionType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'actionType', must be one of 'turnOnCampaign', 'turnOffCampaign', 'turnOnSequence', 'turnOffSequence', 'setCampaignPriority', 'recycleCampaign', 'setCampaignDialingMode'");
        }
        $this->container['actionType'] = $actionType;

        return $this;
    }

    /**
     * Gets campaignRuleActionEntities
     * @return \PureCloudSDK\CampaignRuleActionEntities
     */
    public function getCampaignRuleActionEntities()
    {
        return $this->container['campaignRuleActionEntities'];
    }

    /**
     * Sets campaignRuleActionEntities
     * @param \PureCloudSDK\CampaignRuleActionEntities $campaignRuleActionEntities
     * @return $this
     */
    public function setCampaignRuleActionEntities($campaignRuleActionEntities)
    {
        $this->container['campaignRuleActionEntities'] = $campaignRuleActionEntities;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


