<?php
/**
 * ContactList
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ContactList Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ContactList implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ContactList';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'version' => 'int',
        'columnNames' => 'string[]',
        'phoneColumns' => '\PureCloudSDK\ContactPhoneNumberColumn[]',
        'importStatus' => '\PureCloudSDK\ImportStatus',
        'previewModeColumnName' => 'string',
        'previewModeAcceptedValues' => 'string[]',
        'size' => 'int',
        'attemptLimits' => '\PureCloudSDK\UriReference',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'version' => 'version',
        'columnNames' => 'columnNames',
        'phoneColumns' => 'phoneColumns',
        'importStatus' => 'importStatus',
        'previewModeColumnName' => 'previewModeColumnName',
        'previewModeAcceptedValues' => 'previewModeAcceptedValues',
        'size' => 'size',
        'attemptLimits' => 'attemptLimits',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'version' => 'setVersion',
        'columnNames' => 'setColumnNames',
        'phoneColumns' => 'setPhoneColumns',
        'importStatus' => 'setImportStatus',
        'previewModeColumnName' => 'setPreviewModeColumnName',
        'previewModeAcceptedValues' => 'setPreviewModeAcceptedValues',
        'size' => 'setSize',
        'attemptLimits' => 'setAttemptLimits',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'version' => 'getVersion',
        'columnNames' => 'getColumnNames',
        'phoneColumns' => 'getPhoneColumns',
        'importStatus' => 'getImportStatus',
        'previewModeColumnName' => 'getPreviewModeColumnName',
        'previewModeAcceptedValues' => 'getPreviewModeAcceptedValues',
        'size' => 'getSize',
        'attemptLimits' => 'getAttemptLimits',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['columnNames'] = isset($data['columnNames']) ? $data['columnNames'] : null;
        $this->container['phoneColumns'] = isset($data['phoneColumns']) ? $data['phoneColumns'] : null;
        $this->container['importStatus'] = isset($data['importStatus']) ? $data['importStatus'] : null;
        $this->container['previewModeColumnName'] = isset($data['previewModeColumnName']) ? $data['previewModeColumnName'] : null;
        $this->container['previewModeAcceptedValues'] = isset($data['previewModeAcceptedValues']) ? $data['previewModeAcceptedValues'] : null;
        $this->container['size'] = isset($data['size']) ? $data['size'] : null;
        $this->container['attemptLimits'] = isset($data['attemptLimits']) ? $data['attemptLimits'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['columnNames'] === null) {
            $invalid_properties[] = "'columnNames' can't be null";
        }
        if ($this->container['phoneColumns'] === null) {
            $invalid_properties[] = "'phoneColumns' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['columnNames'] === null) {
            return false;
        }
        if ($this->container['phoneColumns'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Last modified time of the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version Required for updates, must match the version number of the most recent update
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets columnNames
     * @return string[]
     */
    public function getColumnNames()
    {
        return $this->container['columnNames'];
    }

    /**
     * Sets columnNames
     * @param string[] $columnNames the contact column names
     * @return $this
     */
    public function setColumnNames($columnNames)
    {
        $this->container['columnNames'] = $columnNames;

        return $this;
    }

    /**
     * Gets phoneColumns
     * @return \PureCloudSDK\ContactPhoneNumberColumn[]
     */
    public function getPhoneColumns()
    {
        return $this->container['phoneColumns'];
    }

    /**
     * Sets phoneColumns
     * @param \PureCloudSDK\ContactPhoneNumberColumn[] $phoneColumns the columns containing phone numbers
     * @return $this
     */
    public function setPhoneColumns($phoneColumns)
    {
        $this->container['phoneColumns'] = $phoneColumns;

        return $this;
    }

    /**
     * Gets importStatus
     * @return \PureCloudSDK\ImportStatus
     */
    public function getImportStatus()
    {
        return $this->container['importStatus'];
    }

    /**
     * Sets importStatus
     * @param \PureCloudSDK\ImportStatus $importStatus the status of the import process
     * @return $this
     */
    public function setImportStatus($importStatus)
    {
        $this->container['importStatus'] = $importStatus;

        return $this;
    }

    /**
     * Gets previewModeColumnName
     * @return string
     */
    public function getPreviewModeColumnName()
    {
        return $this->container['previewModeColumnName'];
    }

    /**
     * Sets previewModeColumnName
     * @param string $previewModeColumnName the name of the column that holds the indicators for contacts that are to be dialed in preview mode only
     * @return $this
     */
    public function setPreviewModeColumnName($previewModeColumnName)
    {
        $this->container['previewModeColumnName'] = $previewModeColumnName;

        return $this;
    }

    /**
     * Gets previewModeAcceptedValues
     * @return string[]
     */
    public function getPreviewModeAcceptedValues()
    {
        return $this->container['previewModeAcceptedValues'];
    }

    /**
     * Sets previewModeAcceptedValues
     * @param string[] $previewModeAcceptedValues list of user-defined values indicating the contact is to be dialed in preview mode only
     * @return $this
     */
    public function setPreviewModeAcceptedValues($previewModeAcceptedValues)
    {
        $this->container['previewModeAcceptedValues'] = $previewModeAcceptedValues;

        return $this;
    }

    /**
     * Gets size
     * @return int
     */
    public function getSize()
    {
        return $this->container['size'];
    }

    /**
     * Sets size
     * @param int $size the number of contacts in the contact list
     * @return $this
     */
    public function setSize($size)
    {
        $this->container['size'] = $size;

        return $this;
    }

    /**
     * Gets attemptLimits
     * @return \PureCloudSDK\UriReference
     */
    public function getAttemptLimits()
    {
        return $this->container['attemptLimits'];
    }

    /**
     * Sets attemptLimits
     * @param \PureCloudSDK\UriReference $attemptLimits the associated AttemptLimits
     * @return $this
     */
    public function setAttemptLimits($attemptLimits)
    {
        $this->container['attemptLimits'] = $attemptLimits;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


