<?php
/**
 * CreateCallRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CreateCallRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateCallRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateCallRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'phoneNumber' => 'string',
        'callFromQueueId' => 'string',
        'callQueueId' => 'string',
        'callUserId' => 'string',
        'priority' => 'int',
        'languageId' => 'string',
        'routingSkillsIds' => 'string[]',
        'conversationIds' => 'string[]',
        'participants' => '\PureCloudSDK\Destination[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'phoneNumber' => 'phoneNumber',
        'callFromQueueId' => 'callFromQueueId',
        'callQueueId' => 'callQueueId',
        'callUserId' => 'callUserId',
        'priority' => 'priority',
        'languageId' => 'languageId',
        'routingSkillsIds' => 'routingSkillsIds',
        'conversationIds' => 'conversationIds',
        'participants' => 'participants'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'phoneNumber' => 'setPhoneNumber',
        'callFromQueueId' => 'setCallFromQueueId',
        'callQueueId' => 'setCallQueueId',
        'callUserId' => 'setCallUserId',
        'priority' => 'setPriority',
        'languageId' => 'setLanguageId',
        'routingSkillsIds' => 'setRoutingSkillsIds',
        'conversationIds' => 'setConversationIds',
        'participants' => 'setParticipants'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'phoneNumber' => 'getPhoneNumber',
        'callFromQueueId' => 'getCallFromQueueId',
        'callQueueId' => 'getCallQueueId',
        'callUserId' => 'getCallUserId',
        'priority' => 'getPriority',
        'languageId' => 'getLanguageId',
        'routingSkillsIds' => 'getRoutingSkillsIds',
        'conversationIds' => 'getConversationIds',
        'participants' => 'getParticipants'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['phoneNumber'] = isset($data['phoneNumber']) ? $data['phoneNumber'] : null;
        $this->container['callFromQueueId'] = isset($data['callFromQueueId']) ? $data['callFromQueueId'] : null;
        $this->container['callQueueId'] = isset($data['callQueueId']) ? $data['callQueueId'] : null;
        $this->container['callUserId'] = isset($data['callUserId']) ? $data['callUserId'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['languageId'] = isset($data['languageId']) ? $data['languageId'] : null;
        $this->container['routingSkillsIds'] = isset($data['routingSkillsIds']) ? $data['routingSkillsIds'] : null;
        $this->container['conversationIds'] = isset($data['conversationIds']) ? $data['conversationIds'] : null;
        $this->container['participants'] = isset($data['participants']) ? $data['participants'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets phoneNumber
     * @return string
     */
    public function getPhoneNumber()
    {
        return $this->container['phoneNumber'];
    }

    /**
     * Sets phoneNumber
     * @param string $phoneNumber The phone number to dial.
     * @return $this
     */
    public function setPhoneNumber($phoneNumber)
    {
        $this->container['phoneNumber'] = $phoneNumber;

        return $this;
    }

    /**
     * Gets callFromQueueId
     * @return string
     */
    public function getCallFromQueueId()
    {
        return $this->container['callFromQueueId'];
    }

    /**
     * Sets callFromQueueId
     * @param string $callFromQueueId The queue ID to call on behalf of.
     * @return $this
     */
    public function setCallFromQueueId($callFromQueueId)
    {
        $this->container['callFromQueueId'] = $callFromQueueId;

        return $this;
    }

    /**
     * Gets callQueueId
     * @return string
     */
    public function getCallQueueId()
    {
        return $this->container['callQueueId'];
    }

    /**
     * Sets callQueueId
     * @param string $callQueueId The queue ID to call.
     * @return $this
     */
    public function setCallQueueId($callQueueId)
    {
        $this->container['callQueueId'] = $callQueueId;

        return $this;
    }

    /**
     * Gets callUserId
     * @return string
     */
    public function getCallUserId()
    {
        return $this->container['callUserId'];
    }

    /**
     * Sets callUserId
     * @param string $callUserId The user ID to call.
     * @return $this
     */
    public function setCallUserId($callUserId)
    {
        $this->container['callUserId'] = $callUserId;

        return $this;
    }

    /**
     * Gets priority
     * @return int
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param int $priority The priority to assign to this call (if calling a queue).
     * @return $this
     */
    public function setPriority($priority)
    {
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets languageId
     * @return string
     */
    public function getLanguageId()
    {
        return $this->container['languageId'];
    }

    /**
     * Sets languageId
     * @param string $languageId The language skill ID to use for routing this call (if calling a queue).
     * @return $this
     */
    public function setLanguageId($languageId)
    {
        $this->container['languageId'] = $languageId;

        return $this;
    }

    /**
     * Gets routingSkillsIds
     * @return string[]
     */
    public function getRoutingSkillsIds()
    {
        return $this->container['routingSkillsIds'];
    }

    /**
     * Sets routingSkillsIds
     * @param string[] $routingSkillsIds The skill ID's to use for routing this call (if calling a queue).
     * @return $this
     */
    public function setRoutingSkillsIds($routingSkillsIds)
    {
        $this->container['routingSkillsIds'] = $routingSkillsIds;

        return $this;
    }

    /**
     * Gets conversationIds
     * @return string[]
     */
    public function getConversationIds()
    {
        return $this->container['conversationIds'];
    }

    /**
     * Sets conversationIds
     * @param string[] $conversationIds The list of existing call conversations to merge into a new ad-hoc conference.
     * @return $this
     */
    public function setConversationIds($conversationIds)
    {
        $this->container['conversationIds'] = $conversationIds;

        return $this;
    }

    /**
     * Gets participants
     * @return \PureCloudSDK\Destination[]
     */
    public function getParticipants()
    {
        return $this->container['participants'];
    }

    /**
     * Sets participants
     * @param \PureCloudSDK\Destination[] $participants The list of participants to call to create a new ad-hoc conference.
     * @return $this
     */
    public function setParticipants($participants)
    {
        $this->container['participants'] = $participants;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


