<?php
/**
 * CreateQueueRequest
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * CreateQueueRequest Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class CreateQueueRequest implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'CreateQueueRequest';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'description' => 'string',
        'version' => 'int',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'modifiedBy' => 'string',
        'createdBy' => 'string',
        'state' => 'string',
        'modifiedByApp' => 'string',
        'createdByApp' => 'string',
        'mediaSettings' => 'map[string,\PureCloudSDK\MediaSetting]',
        'bullseye' => '\PureCloudSDK\Bullseye',
        'acwSettings' => '\PureCloudSDK\AcwSettings',
        'skillEvaluationMethod' => 'string',
        'queueFlow' => '\PureCloudSDK\UriReference',
        'callingPartyName' => 'string',
        'callingPartyNumber' => 'string',
        'outboundEmailAddress' => '\PureCloudSDK\QueueEmailAddress',
        'sourceQueueId' => 'string',
        'memberCount' => 'int',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'description' => 'description',
        'version' => 'version',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'modifiedBy' => 'modifiedBy',
        'createdBy' => 'createdBy',
        'state' => 'state',
        'modifiedByApp' => 'modifiedByApp',
        'createdByApp' => 'createdByApp',
        'mediaSettings' => 'mediaSettings',
        'bullseye' => 'bullseye',
        'acwSettings' => 'acwSettings',
        'skillEvaluationMethod' => 'skillEvaluationMethod',
        'queueFlow' => 'queueFlow',
        'callingPartyName' => 'callingPartyName',
        'callingPartyNumber' => 'callingPartyNumber',
        'outboundEmailAddress' => 'outboundEmailAddress',
        'sourceQueueId' => 'sourceQueueId',
        'memberCount' => 'memberCount',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'description' => 'setDescription',
        'version' => 'setVersion',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'modifiedBy' => 'setModifiedBy',
        'createdBy' => 'setCreatedBy',
        'state' => 'setState',
        'modifiedByApp' => 'setModifiedByApp',
        'createdByApp' => 'setCreatedByApp',
        'mediaSettings' => 'setMediaSettings',
        'bullseye' => 'setBullseye',
        'acwSettings' => 'setAcwSettings',
        'skillEvaluationMethod' => 'setSkillEvaluationMethod',
        'queueFlow' => 'setQueueFlow',
        'callingPartyName' => 'setCallingPartyName',
        'callingPartyNumber' => 'setCallingPartyNumber',
        'outboundEmailAddress' => 'setOutboundEmailAddress',
        'sourceQueueId' => 'setSourceQueueId',
        'memberCount' => 'setMemberCount',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'description' => 'getDescription',
        'version' => 'getVersion',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'modifiedBy' => 'getModifiedBy',
        'createdBy' => 'getCreatedBy',
        'state' => 'getState',
        'modifiedByApp' => 'getModifiedByApp',
        'createdByApp' => 'getCreatedByApp',
        'mediaSettings' => 'getMediaSettings',
        'bullseye' => 'getBullseye',
        'acwSettings' => 'getAcwSettings',
        'skillEvaluationMethod' => 'getSkillEvaluationMethod',
        'queueFlow' => 'getQueueFlow',
        'callingPartyName' => 'getCallingPartyName',
        'callingPartyNumber' => 'getCallingPartyNumber',
        'outboundEmailAddress' => 'getOutboundEmailAddress',
        'sourceQueueId' => 'getSourceQueueId',
        'memberCount' => 'getMemberCount',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATE_ACTIVE = 'active';
    const STATE_INACTIVE = 'inactive';
    const STATE_DELETED = 'deleted';
    const SKILL_EVALUATION_METHOD_NONE = 'NONE';
    const SKILL_EVALUATION_METHOD_BEST = 'BEST';
    const SKILL_EVALUATION_METHOD_ALL = 'ALL';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStateAllowableValues()
    {
        return [
            self::STATE_ACTIVE,
            self::STATE_INACTIVE,
            self::STATE_DELETED,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSkillEvaluationMethodAllowableValues()
    {
        return [
            self::SKILL_EVALUATION_METHOD_NONE,
            self::SKILL_EVALUATION_METHOD_BEST,
            self::SKILL_EVALUATION_METHOD_ALL,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['modifiedBy'] = isset($data['modifiedBy']) ? $data['modifiedBy'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['modifiedByApp'] = isset($data['modifiedByApp']) ? $data['modifiedByApp'] : null;
        $this->container['createdByApp'] = isset($data['createdByApp']) ? $data['createdByApp'] : null;
        $this->container['mediaSettings'] = isset($data['mediaSettings']) ? $data['mediaSettings'] : null;
        $this->container['bullseye'] = isset($data['bullseye']) ? $data['bullseye'] : null;
        $this->container['acwSettings'] = isset($data['acwSettings']) ? $data['acwSettings'] : null;
        $this->container['skillEvaluationMethod'] = isset($data['skillEvaluationMethod']) ? $data['skillEvaluationMethod'] : null;
        $this->container['queueFlow'] = isset($data['queueFlow']) ? $data['queueFlow'] : null;
        $this->container['callingPartyName'] = isset($data['callingPartyName']) ? $data['callingPartyName'] : null;
        $this->container['callingPartyNumber'] = isset($data['callingPartyNumber']) ? $data['callingPartyNumber'] : null;
        $this->container['outboundEmailAddress'] = isset($data['outboundEmailAddress']) ? $data['outboundEmailAddress'] : null;
        $this->container['sourceQueueId'] = isset($data['sourceQueueId']) ? $data['sourceQueueId'] : null;
        $this->container['memberCount'] = isset($data['memberCount']) ? $data['memberCount'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'state', must be one of #{allowed_values}.";
        }

        if ($this->container['mediaSettings'] === null) {
            $invalid_properties[] = "'mediaSettings' can't be null";
        }
        if ($this->container['acwSettings'] === null) {
            $invalid_properties[] = "'acwSettings' can't be null";
        }
        if ($this->container['skillEvaluationMethod'] === null) {
            $invalid_properties[] = "'skillEvaluationMethod' can't be null";
        }
        $allowed_values = array("NONE", "BEST", "ALL");
        if (!in_array($this->container['skillEvaluationMethod'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'skillEvaluationMethod', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("active", "inactive", "deleted");
        if (!in_array($this->container['state'], $allowed_values)) {
            return false;
        }
        if ($this->container['mediaSettings'] === null) {
            return false;
        }
        if ($this->container['acwSettings'] === null) {
            return false;
        }
        if ($this->container['skillEvaluationMethod'] === null) {
            return false;
        }
        $allowed_values = array("NONE", "BEST", "ALL");
        if (!in_array($this->container['skillEvaluationMethod'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets version
     * @return int
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param int $version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets modifiedBy
     * @return string
     */
    public function getModifiedBy()
    {
        return $this->container['modifiedBy'];
    }

    /**
     * Sets modifiedBy
     * @param string $modifiedBy
     * @return $this
     */
    public function setModifiedBy($modifiedBy)
    {
        $this->container['modifiedBy'] = $modifiedBy;

        return $this;
    }

    /**
     * Gets createdBy
     * @return string
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param string $createdBy
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets state
     * @return string
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param string $state
     * @return $this
     */
    public function setState($state)
    {
        $allowed_values = array('active', 'inactive', 'deleted');
        if (!in_array($state, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'state', must be one of 'active', 'inactive', 'deleted'");
        }
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets modifiedByApp
     * @return string
     */
    public function getModifiedByApp()
    {
        return $this->container['modifiedByApp'];
    }

    /**
     * Sets modifiedByApp
     * @param string $modifiedByApp
     * @return $this
     */
    public function setModifiedByApp($modifiedByApp)
    {
        $this->container['modifiedByApp'] = $modifiedByApp;

        return $this;
    }

    /**
     * Gets createdByApp
     * @return string
     */
    public function getCreatedByApp()
    {
        return $this->container['createdByApp'];
    }

    /**
     * Sets createdByApp
     * @param string $createdByApp
     * @return $this
     */
    public function setCreatedByApp($createdByApp)
    {
        $this->container['createdByApp'] = $createdByApp;

        return $this;
    }

    /**
     * Gets mediaSettings
     * @return map[string,\PureCloudSDK\MediaSetting]
     */
    public function getMediaSettings()
    {
        return $this->container['mediaSettings'];
    }

    /**
     * Sets mediaSettings
     * @param map[string,\PureCloudSDK\MediaSetting] $mediaSettings The media settings for the queue.
     * @return $this
     */
    public function setMediaSettings($mediaSettings)
    {
        $this->container['mediaSettings'] = $mediaSettings;

        return $this;
    }

    /**
     * Gets bullseye
     * @return \PureCloudSDK\Bullseye
     */
    public function getBullseye()
    {
        return $this->container['bullseye'];
    }

    /**
     * Sets bullseye
     * @param \PureCloudSDK\Bullseye $bullseye The bulls-eye settings for the queue.
     * @return $this
     */
    public function setBullseye($bullseye)
    {
        $this->container['bullseye'] = $bullseye;

        return $this;
    }

    /**
     * Gets acwSettings
     * @return \PureCloudSDK\AcwSettings
     */
    public function getAcwSettings()
    {
        return $this->container['acwSettings'];
    }

    /**
     * Sets acwSettings
     * @param \PureCloudSDK\AcwSettings $acwSettings The ACW settings for the queue.
     * @return $this
     */
    public function setAcwSettings($acwSettings)
    {
        $this->container['acwSettings'] = $acwSettings;

        return $this;
    }

    /**
     * Gets skillEvaluationMethod
     * @return string
     */
    public function getSkillEvaluationMethod()
    {
        return $this->container['skillEvaluationMethod'];
    }

    /**
     * Sets skillEvaluationMethod
     * @param string $skillEvaluationMethod The skill evaluation method to use when routing conversations.
     * @return $this
     */
    public function setSkillEvaluationMethod($skillEvaluationMethod)
    {
        $allowed_values = array('NONE', 'BEST', 'ALL');
        if (!in_array($skillEvaluationMethod, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'skillEvaluationMethod', must be one of 'NONE', 'BEST', 'ALL'");
        }
        $this->container['skillEvaluationMethod'] = $skillEvaluationMethod;

        return $this;
    }

    /**
     * Gets queueFlow
     * @return \PureCloudSDK\UriReference
     */
    public function getQueueFlow()
    {
        return $this->container['queueFlow'];
    }

    /**
     * Sets queueFlow
     * @param \PureCloudSDK\UriReference $queueFlow The in-queue flow to use for conversations waiting in queue.
     * @return $this
     */
    public function setQueueFlow($queueFlow)
    {
        $this->container['queueFlow'] = $queueFlow;

        return $this;
    }

    /**
     * Gets callingPartyName
     * @return string
     */
    public function getCallingPartyName()
    {
        return $this->container['callingPartyName'];
    }

    /**
     * Sets callingPartyName
     * @param string $callingPartyName The name to use for caller identification for outbound calls from this queue.
     * @return $this
     */
    public function setCallingPartyName($callingPartyName)
    {
        $this->container['callingPartyName'] = $callingPartyName;

        return $this;
    }

    /**
     * Gets callingPartyNumber
     * @return string
     */
    public function getCallingPartyNumber()
    {
        return $this->container['callingPartyNumber'];
    }

    /**
     * Sets callingPartyNumber
     * @param string $callingPartyNumber The phone number to use for caller identification for outbound calls from this queue.
     * @return $this
     */
    public function setCallingPartyNumber($callingPartyNumber)
    {
        $this->container['callingPartyNumber'] = $callingPartyNumber;

        return $this;
    }

    /**
     * Gets outboundEmailAddress
     * @return \PureCloudSDK\QueueEmailAddress
     */
    public function getOutboundEmailAddress()
    {
        return $this->container['outboundEmailAddress'];
    }

    /**
     * Sets outboundEmailAddress
     * @param \PureCloudSDK\QueueEmailAddress $outboundEmailAddress
     * @return $this
     */
    public function setOutboundEmailAddress($outboundEmailAddress)
    {
        $this->container['outboundEmailAddress'] = $outboundEmailAddress;

        return $this;
    }

    /**
     * Gets sourceQueueId
     * @return string
     */
    public function getSourceQueueId()
    {
        return $this->container['sourceQueueId'];
    }

    /**
     * Sets sourceQueueId
     * @param string $sourceQueueId The id of an existing queue to copy the settings from when creating a new queue.
     * @return $this
     */
    public function setSourceQueueId($sourceQueueId)
    {
        $this->container['sourceQueueId'] = $sourceQueueId;

        return $this;
    }

    /**
     * Gets memberCount
     * @return int
     */
    public function getMemberCount()
    {
        return $this->container['memberCount'];
    }

    /**
     * Sets memberCount
     * @param int $memberCount
     * @return $this
     */
    public function setMemberCount($memberCount)
    {
        $this->container['memberCount'] = $memberCount;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


