<?php
/**
 * DiagnosticEmail
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DiagnosticEmail Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DiagnosticEmail implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DiagnosticEmail';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'subject' => 'string',
        'topic' => 'string',
        'description' => 'string',
        'priority' => 'string',
        'type' => 'string',
        'data' => 'object'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'subject' => 'subject',
        'topic' => 'topic',
        'description' => 'description',
        'priority' => 'priority',
        'type' => 'type',
        'data' => 'data'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'subject' => 'setSubject',
        'topic' => 'setTopic',
        'description' => 'setDescription',
        'priority' => 'setPriority',
        'type' => 'setType',
        'data' => 'setData'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'subject' => 'getSubject',
        'topic' => 'getTopic',
        'description' => 'getDescription',
        'priority' => 'getPriority',
        'type' => 'getType',
        'data' => 'getData'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const TOPIC_ADMIN = 'Admin';
    const TOPIC_DOCUMENTS = 'Documents';
    const TOPIC_CHAT = 'Chat';
    const TOPIC_VIDEO_CHAT = 'Video Chat';
    const TOPIC_LOGIN = 'Login';
    const TOPIC_SLOWNESS = 'Slowness';
    const TOPIC_OTHER = 'Other';
    const PRIORITY__4___LOW = '4 - LOW';
    const PRIORITY__3___MEDIUM = '3 - MEDIUM';
    const PRIORITY__2___HIGH = '2 - HIGH';
    const PRIORITY__1___CRITICAL = '1 - CRITICAL';
    const TYPE_PROBLEM = 'Problem';
    const TYPE_QUESTION = 'Question';
    const TYPE_ENHANCEMENT_REQUEST = 'Enhancement Request';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTopicAllowableValues()
    {
        return [
            self::TOPIC_ADMIN,
            self::TOPIC_DOCUMENTS,
            self::TOPIC_CHAT,
            self::TOPIC_VIDEO_CHAT,
            self::TOPIC_LOGIN,
            self::TOPIC_SLOWNESS,
            self::TOPIC_OTHER,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getPriorityAllowableValues()
    {
        return [
            self::PRIORITY__4___LOW,
            self::PRIORITY__3___MEDIUM,
            self::PRIORITY__2___HIGH,
            self::PRIORITY__1___CRITICAL,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getTypeAllowableValues()
    {
        return [
            self::TYPE_PROBLEM,
            self::TYPE_QUESTION,
            self::TYPE_ENHANCEMENT_REQUEST,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['subject'] = isset($data['subject']) ? $data['subject'] : null;
        $this->container['topic'] = isset($data['topic']) ? $data['topic'] : null;
        $this->container['description'] = isset($data['description']) ? $data['description'] : null;
        $this->container['priority'] = isset($data['priority']) ? $data['priority'] : null;
        $this->container['type'] = isset($data['type']) ? $data['type'] : null;
        $this->container['data'] = isset($data['data']) ? $data['data'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['topic'] === null) {
            $invalid_properties[] = "'topic' can't be null";
        }
        $allowed_values = array("Admin", "Documents", "Chat", "Video Chat", "Login", "Slowness", "Other");
        if (!in_array($this->container['topic'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'topic', must be one of #{allowed_values}.";
        }

        $allowed_values = array("4 - LOW", "3 - MEDIUM", "2 - HIGH", "1 - CRITICAL");
        if (!in_array($this->container['priority'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'priority', must be one of #{allowed_values}.";
        }

        $allowed_values = array("Problem", "Question", "Enhancement Request");
        if (!in_array($this->container['type'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'type', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['topic'] === null) {
            return false;
        }
        $allowed_values = array("Admin", "Documents", "Chat", "Video Chat", "Login", "Slowness", "Other");
        if (!in_array($this->container['topic'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("4 - LOW", "3 - MEDIUM", "2 - HIGH", "1 - CRITICAL");
        if (!in_array($this->container['priority'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("Problem", "Question", "Enhancement Request");
        if (!in_array($this->container['type'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets subject
     * @return string
     */
    public function getSubject()
    {
        return $this->container['subject'];
    }

    /**
     * Sets subject
     * @param string $subject Subject of Issue Report
     * @return $this
     */
    public function setSubject($subject)
    {
        $this->container['subject'] = $subject;

        return $this;
    }

    /**
     * Gets topic
     * @return string
     */
    public function getTopic()
    {
        return $this->container['topic'];
    }

    /**
     * Sets topic
     * @param string $topic Functional Area of Issue
     * @return $this
     */
    public function setTopic($topic)
    {
        $allowed_values = array('Admin', 'Documents', 'Chat', 'Video Chat', 'Login', 'Slowness', 'Other');
        if (!in_array($topic, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'topic', must be one of 'Admin', 'Documents', 'Chat', 'Video Chat', 'Login', 'Slowness', 'Other'");
        }
        $this->container['topic'] = $topic;

        return $this;
    }

    /**
     * Gets description
     * @return string
     */
    public function getDescription()
    {
        return $this->container['description'];
    }

    /**
     * Sets description
     * @param string $description Detailed Description of Issue
     * @return $this
     */
    public function setDescription($description)
    {
        $this->container['description'] = $description;

        return $this;
    }

    /**
     * Gets priority
     * @return string
     */
    public function getPriority()
    {
        return $this->container['priority'];
    }

    /**
     * Sets priority
     * @param string $priority
     * @return $this
     */
    public function setPriority($priority)
    {
        $allowed_values = array('4 - LOW', '3 - MEDIUM', '2 - HIGH', '1 - CRITICAL');
        if (!in_array($priority, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'priority', must be one of '4 - LOW', '3 - MEDIUM', '2 - HIGH', '1 - CRITICAL'");
        }
        $this->container['priority'] = $priority;

        return $this;
    }

    /**
     * Gets type
     * @return string
     */
    public function getType()
    {
        return $this->container['type'];
    }

    /**
     * Sets type
     * @param string $type Type of Issue
     * @return $this
     */
    public function setType($type)
    {
        $allowed_values = array('Problem', 'Question', 'Enhancement Request');
        if (!in_array($type, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'type', must be one of 'Problem', 'Question', 'Enhancement Request'");
        }
        $this->container['type'] = $type;

        return $this;
    }

    /**
     * Gets data
     * @return object
     */
    public function getData()
    {
        return $this->container['data'];
    }

    /**
     * Sets data
     * @param object $data Json blob of data to be included with this report.
     * @return $this
     */
    public function setData($data)
    {
        $this->container['data'] = $data;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


