<?php
/**
 * Document
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Document Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Document implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Document';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'changeNumber' => 'int',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'dateUploaded' => '\DateTime',
        'contentUri' => 'string',
        'workspace' => '\PureCloudSDK\UriReference',
        'createdBy' => '\PureCloudSDK\UriReference',
        'uploadedBy' => '\PureCloudSDK\UriReference',
        'contentType' => 'string',
        'contentLength' => 'int',
        'systemType' => 'string',
        'filename' => 'string',
        'pageCount' => 'int',
        'read' => 'bool',
        'callerAddress' => 'string',
        'receiverAddress' => 'string',
        'tags' => 'string[]',
        'tagValues' => '\PureCloudSDK\TagValue[]',
        'attributes' => '\PureCloudSDK\DocumentAttribute[]',
        'thumbnails' => '\PureCloudSDK\DocumentThumbnail[]',
        'uploadStatus' => '\PureCloudSDK\UriReference',
        'uploadDestinationUri' => 'string',
        'uploadMethod' => 'string',
        'lockInfo' => '\PureCloudSDK\LockInfo',
        'acl' => 'string[]',
        'sharingStatus' => 'string',
        'sharingUri' => 'string',
        'downloadSharingUri' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'changeNumber' => 'changeNumber',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'dateUploaded' => 'dateUploaded',
        'contentUri' => 'contentUri',
        'workspace' => 'workspace',
        'createdBy' => 'createdBy',
        'uploadedBy' => 'uploadedBy',
        'contentType' => 'contentType',
        'contentLength' => 'contentLength',
        'systemType' => 'systemType',
        'filename' => 'filename',
        'pageCount' => 'pageCount',
        'read' => 'read',
        'callerAddress' => 'callerAddress',
        'receiverAddress' => 'receiverAddress',
        'tags' => 'tags',
        'tagValues' => 'tagValues',
        'attributes' => 'attributes',
        'thumbnails' => 'thumbnails',
        'uploadStatus' => 'uploadStatus',
        'uploadDestinationUri' => 'uploadDestinationUri',
        'uploadMethod' => 'uploadMethod',
        'lockInfo' => 'lockInfo',
        'acl' => 'acl',
        'sharingStatus' => 'sharingStatus',
        'sharingUri' => 'sharingUri',
        'downloadSharingUri' => 'downloadSharingUri',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'changeNumber' => 'setChangeNumber',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'dateUploaded' => 'setDateUploaded',
        'contentUri' => 'setContentUri',
        'workspace' => 'setWorkspace',
        'createdBy' => 'setCreatedBy',
        'uploadedBy' => 'setUploadedBy',
        'contentType' => 'setContentType',
        'contentLength' => 'setContentLength',
        'systemType' => 'setSystemType',
        'filename' => 'setFilename',
        'pageCount' => 'setPageCount',
        'read' => 'setRead',
        'callerAddress' => 'setCallerAddress',
        'receiverAddress' => 'setReceiverAddress',
        'tags' => 'setTags',
        'tagValues' => 'setTagValues',
        'attributes' => 'setAttributes',
        'thumbnails' => 'setThumbnails',
        'uploadStatus' => 'setUploadStatus',
        'uploadDestinationUri' => 'setUploadDestinationUri',
        'uploadMethod' => 'setUploadMethod',
        'lockInfo' => 'setLockInfo',
        'acl' => 'setAcl',
        'sharingStatus' => 'setSharingStatus',
        'sharingUri' => 'setSharingUri',
        'downloadSharingUri' => 'setDownloadSharingUri',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'changeNumber' => 'getChangeNumber',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'dateUploaded' => 'getDateUploaded',
        'contentUri' => 'getContentUri',
        'workspace' => 'getWorkspace',
        'createdBy' => 'getCreatedBy',
        'uploadedBy' => 'getUploadedBy',
        'contentType' => 'getContentType',
        'contentLength' => 'getContentLength',
        'systemType' => 'getSystemType',
        'filename' => 'getFilename',
        'pageCount' => 'getPageCount',
        'read' => 'getRead',
        'callerAddress' => 'getCallerAddress',
        'receiverAddress' => 'getReceiverAddress',
        'tags' => 'getTags',
        'tagValues' => 'getTagValues',
        'attributes' => 'getAttributes',
        'thumbnails' => 'getThumbnails',
        'uploadStatus' => 'getUploadStatus',
        'uploadDestinationUri' => 'getUploadDestinationUri',
        'uploadMethod' => 'getUploadMethod',
        'lockInfo' => 'getLockInfo',
        'acl' => 'getAcl',
        'sharingStatus' => 'getSharingStatus',
        'sharingUri' => 'getSharingUri',
        'downloadSharingUri' => 'getDownloadSharingUri',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const SYSTEM_TYPE_DOCUMENT = 'DOCUMENT';
    const SYSTEM_TYPE_FAX = 'FAX';
    const SYSTEM_TYPE_RECORDING = 'RECORDING';
    const UPLOAD_METHOD_SINGLE_PUT = 'SINGLE_PUT';
    const UPLOAD_METHOD_MULTIPART_POST = 'MULTIPART_POST';
    const SHARING_STATUS_NONE = 'NONE';
    const SHARING_STATUS_LIMITED = 'LIMITED';
    const SHARING_STATUS_PUBLIC = 'PUBLIC';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSystemTypeAllowableValues()
    {
        return [
            self::SYSTEM_TYPE_DOCUMENT,
            self::SYSTEM_TYPE_FAX,
            self::SYSTEM_TYPE_RECORDING,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getUploadMethodAllowableValues()
    {
        return [
            self::UPLOAD_METHOD_SINGLE_PUT,
            self::UPLOAD_METHOD_MULTIPART_POST,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getSharingStatusAllowableValues()
    {
        return [
            self::SHARING_STATUS_NONE,
            self::SHARING_STATUS_LIMITED,
            self::SHARING_STATUS_PUBLIC,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['changeNumber'] = isset($data['changeNumber']) ? $data['changeNumber'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['dateUploaded'] = isset($data['dateUploaded']) ? $data['dateUploaded'] : null;
        $this->container['contentUri'] = isset($data['contentUri']) ? $data['contentUri'] : null;
        $this->container['workspace'] = isset($data['workspace']) ? $data['workspace'] : null;
        $this->container['createdBy'] = isset($data['createdBy']) ? $data['createdBy'] : null;
        $this->container['uploadedBy'] = isset($data['uploadedBy']) ? $data['uploadedBy'] : null;
        $this->container['contentType'] = isset($data['contentType']) ? $data['contentType'] : null;
        $this->container['contentLength'] = isset($data['contentLength']) ? $data['contentLength'] : null;
        $this->container['systemType'] = isset($data['systemType']) ? $data['systemType'] : null;
        $this->container['filename'] = isset($data['filename']) ? $data['filename'] : null;
        $this->container['pageCount'] = isset($data['pageCount']) ? $data['pageCount'] : null;
        $this->container['read'] = isset($data['read']) ? $data['read'] : null;
        $this->container['callerAddress'] = isset($data['callerAddress']) ? $data['callerAddress'] : null;
        $this->container['receiverAddress'] = isset($data['receiverAddress']) ? $data['receiverAddress'] : null;
        $this->container['tags'] = isset($data['tags']) ? $data['tags'] : null;
        $this->container['tagValues'] = isset($data['tagValues']) ? $data['tagValues'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['thumbnails'] = isset($data['thumbnails']) ? $data['thumbnails'] : null;
        $this->container['uploadStatus'] = isset($data['uploadStatus']) ? $data['uploadStatus'] : null;
        $this->container['uploadDestinationUri'] = isset($data['uploadDestinationUri']) ? $data['uploadDestinationUri'] : null;
        $this->container['uploadMethod'] = isset($data['uploadMethod']) ? $data['uploadMethod'] : null;
        $this->container['lockInfo'] = isset($data['lockInfo']) ? $data['lockInfo'] : null;
        $this->container['acl'] = isset($data['acl']) ? $data['acl'] : null;
        $this->container['sharingStatus'] = isset($data['sharingStatus']) ? $data['sharingStatus'] : null;
        $this->container['sharingUri'] = isset($data['sharingUri']) ? $data['sharingUri'] : null;
        $this->container['downloadSharingUri'] = isset($data['downloadSharingUri']) ? $data['downloadSharingUri'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("DOCUMENT", "FAX", "RECORDING");
        if (!in_array($this->container['systemType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'systemType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("SINGLE_PUT", "MULTIPART_POST");
        if (!in_array($this->container['uploadMethod'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'uploadMethod', must be one of #{allowed_values}.";
        }

        $allowed_values = array("NONE", "LIMITED", "PUBLIC");
        if (!in_array($this->container['sharingStatus'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'sharingStatus', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("DOCUMENT", "FAX", "RECORDING");
        if (!in_array($this->container['systemType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("SINGLE_PUT", "MULTIPART_POST");
        if (!in_array($this->container['uploadMethod'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("NONE", "LIMITED", "PUBLIC");
        if (!in_array($this->container['sharingStatus'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets changeNumber
     * @return int
     */
    public function getChangeNumber()
    {
        return $this->container['changeNumber'];
    }

    /**
     * Sets changeNumber
     * @param int $changeNumber
     * @return $this
     */
    public function setChangeNumber($changeNumber)
    {
        $this->container['changeNumber'] = $changeNumber;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets dateUploaded
     * @return \DateTime
     */
    public function getDateUploaded()
    {
        return $this->container['dateUploaded'];
    }

    /**
     * Sets dateUploaded
     * @param \DateTime $dateUploaded Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateUploaded($dateUploaded)
    {
        $this->container['dateUploaded'] = $dateUploaded;

        return $this;
    }

    /**
     * Gets contentUri
     * @return string
     */
    public function getContentUri()
    {
        return $this->container['contentUri'];
    }

    /**
     * Sets contentUri
     * @param string $contentUri
     * @return $this
     */
    public function setContentUri($contentUri)
    {
        $this->container['contentUri'] = $contentUri;

        return $this;
    }

    /**
     * Gets workspace
     * @return \PureCloudSDK\UriReference
     */
    public function getWorkspace()
    {
        return $this->container['workspace'];
    }

    /**
     * Sets workspace
     * @param \PureCloudSDK\UriReference $workspace
     * @return $this
     */
    public function setWorkspace($workspace)
    {
        $this->container['workspace'] = $workspace;

        return $this;
    }

    /**
     * Gets createdBy
     * @return \PureCloudSDK\UriReference
     */
    public function getCreatedBy()
    {
        return $this->container['createdBy'];
    }

    /**
     * Sets createdBy
     * @param \PureCloudSDK\UriReference $createdBy
     * @return $this
     */
    public function setCreatedBy($createdBy)
    {
        $this->container['createdBy'] = $createdBy;

        return $this;
    }

    /**
     * Gets uploadedBy
     * @return \PureCloudSDK\UriReference
     */
    public function getUploadedBy()
    {
        return $this->container['uploadedBy'];
    }

    /**
     * Sets uploadedBy
     * @param \PureCloudSDK\UriReference $uploadedBy
     * @return $this
     */
    public function setUploadedBy($uploadedBy)
    {
        $this->container['uploadedBy'] = $uploadedBy;

        return $this;
    }

    /**
     * Gets contentType
     * @return string
     */
    public function getContentType()
    {
        return $this->container['contentType'];
    }

    /**
     * Sets contentType
     * @param string $contentType
     * @return $this
     */
    public function setContentType($contentType)
    {
        $this->container['contentType'] = $contentType;

        return $this;
    }

    /**
     * Gets contentLength
     * @return int
     */
    public function getContentLength()
    {
        return $this->container['contentLength'];
    }

    /**
     * Sets contentLength
     * @param int $contentLength
     * @return $this
     */
    public function setContentLength($contentLength)
    {
        $this->container['contentLength'] = $contentLength;

        return $this;
    }

    /**
     * Gets systemType
     * @return string
     */
    public function getSystemType()
    {
        return $this->container['systemType'];
    }

    /**
     * Sets systemType
     * @param string $systemType
     * @return $this
     */
    public function setSystemType($systemType)
    {
        $allowed_values = array('DOCUMENT', 'FAX', 'RECORDING');
        if (!in_array($systemType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'systemType', must be one of 'DOCUMENT', 'FAX', 'RECORDING'");
        }
        $this->container['systemType'] = $systemType;

        return $this;
    }

    /**
     * Gets filename
     * @return string
     */
    public function getFilename()
    {
        return $this->container['filename'];
    }

    /**
     * Sets filename
     * @param string $filename
     * @return $this
     */
    public function setFilename($filename)
    {
        $this->container['filename'] = $filename;

        return $this;
    }

    /**
     * Gets pageCount
     * @return int
     */
    public function getPageCount()
    {
        return $this->container['pageCount'];
    }

    /**
     * Sets pageCount
     * @param int $pageCount
     * @return $this
     */
    public function setPageCount($pageCount)
    {
        $this->container['pageCount'] = $pageCount;

        return $this;
    }

    /**
     * Gets read
     * @return bool
     */
    public function getRead()
    {
        return $this->container['read'];
    }

    /**
     * Sets read
     * @param bool $read
     * @return $this
     */
    public function setRead($read)
    {
        $this->container['read'] = $read;

        return $this;
    }

    /**
     * Gets callerAddress
     * @return string
     */
    public function getCallerAddress()
    {
        return $this->container['callerAddress'];
    }

    /**
     * Sets callerAddress
     * @param string $callerAddress
     * @return $this
     */
    public function setCallerAddress($callerAddress)
    {
        $this->container['callerAddress'] = $callerAddress;

        return $this;
    }

    /**
     * Gets receiverAddress
     * @return string
     */
    public function getReceiverAddress()
    {
        return $this->container['receiverAddress'];
    }

    /**
     * Sets receiverAddress
     * @param string $receiverAddress
     * @return $this
     */
    public function setReceiverAddress($receiverAddress)
    {
        $this->container['receiverAddress'] = $receiverAddress;

        return $this;
    }

    /**
     * Gets tags
     * @return string[]
     */
    public function getTags()
    {
        return $this->container['tags'];
    }

    /**
     * Sets tags
     * @param string[] $tags
     * @return $this
     */
    public function setTags($tags)
    {
        $this->container['tags'] = $tags;

        return $this;
    }

    /**
     * Gets tagValues
     * @return \PureCloudSDK\TagValue[]
     */
    public function getTagValues()
    {
        return $this->container['tagValues'];
    }

    /**
     * Sets tagValues
     * @param \PureCloudSDK\TagValue[] $tagValues
     * @return $this
     */
    public function setTagValues($tagValues)
    {
        $this->container['tagValues'] = $tagValues;

        return $this;
    }

    /**
     * Gets attributes
     * @return \PureCloudSDK\DocumentAttribute[]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param \PureCloudSDK\DocumentAttribute[] $attributes
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets thumbnails
     * @return \PureCloudSDK\DocumentThumbnail[]
     */
    public function getThumbnails()
    {
        return $this->container['thumbnails'];
    }

    /**
     * Sets thumbnails
     * @param \PureCloudSDK\DocumentThumbnail[] $thumbnails
     * @return $this
     */
    public function setThumbnails($thumbnails)
    {
        $this->container['thumbnails'] = $thumbnails;

        return $this;
    }

    /**
     * Gets uploadStatus
     * @return \PureCloudSDK\UriReference
     */
    public function getUploadStatus()
    {
        return $this->container['uploadStatus'];
    }

    /**
     * Sets uploadStatus
     * @param \PureCloudSDK\UriReference $uploadStatus
     * @return $this
     */
    public function setUploadStatus($uploadStatus)
    {
        $this->container['uploadStatus'] = $uploadStatus;

        return $this;
    }

    /**
     * Gets uploadDestinationUri
     * @return string
     */
    public function getUploadDestinationUri()
    {
        return $this->container['uploadDestinationUri'];
    }

    /**
     * Sets uploadDestinationUri
     * @param string $uploadDestinationUri
     * @return $this
     */
    public function setUploadDestinationUri($uploadDestinationUri)
    {
        $this->container['uploadDestinationUri'] = $uploadDestinationUri;

        return $this;
    }

    /**
     * Gets uploadMethod
     * @return string
     */
    public function getUploadMethod()
    {
        return $this->container['uploadMethod'];
    }

    /**
     * Sets uploadMethod
     * @param string $uploadMethod
     * @return $this
     */
    public function setUploadMethod($uploadMethod)
    {
        $allowed_values = array('SINGLE_PUT', 'MULTIPART_POST');
        if (!in_array($uploadMethod, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'uploadMethod', must be one of 'SINGLE_PUT', 'MULTIPART_POST'");
        }
        $this->container['uploadMethod'] = $uploadMethod;

        return $this;
    }

    /**
     * Gets lockInfo
     * @return \PureCloudSDK\LockInfo
     */
    public function getLockInfo()
    {
        return $this->container['lockInfo'];
    }

    /**
     * Sets lockInfo
     * @param \PureCloudSDK\LockInfo $lockInfo
     * @return $this
     */
    public function setLockInfo($lockInfo)
    {
        $this->container['lockInfo'] = $lockInfo;

        return $this;
    }

    /**
     * Gets acl
     * @return string[]
     */
    public function getAcl()
    {
        return $this->container['acl'];
    }

    /**
     * Sets acl
     * @param string[] $acl A list of permitted action rights for the user making the request
     * @return $this
     */
    public function setAcl($acl)
    {
        $this->container['acl'] = $acl;

        return $this;
    }

    /**
     * Gets sharingStatus
     * @return string
     */
    public function getSharingStatus()
    {
        return $this->container['sharingStatus'];
    }

    /**
     * Sets sharingStatus
     * @param string $sharingStatus
     * @return $this
     */
    public function setSharingStatus($sharingStatus)
    {
        $allowed_values = array('NONE', 'LIMITED', 'PUBLIC');
        if (!in_array($sharingStatus, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'sharingStatus', must be one of 'NONE', 'LIMITED', 'PUBLIC'");
        }
        $this->container['sharingStatus'] = $sharingStatus;

        return $this;
    }

    /**
     * Gets sharingUri
     * @return string
     */
    public function getSharingUri()
    {
        return $this->container['sharingUri'];
    }

    /**
     * Sets sharingUri
     * @param string $sharingUri
     * @return $this
     */
    public function setSharingUri($sharingUri)
    {
        $this->container['sharingUri'] = $sharingUri;

        return $this;
    }

    /**
     * Gets downloadSharingUri
     * @return string
     */
    public function getDownloadSharingUri()
    {
        return $this->container['downloadSharingUri'];
    }

    /**
     * Sets downloadSharingUri
     * @param string $downloadSharingUri
     * @return $this
     */
    public function setDownloadSharingUri($downloadSharingUri)
    {
        $this->container['downloadSharingUri'] = $downloadSharingUri;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


