<?php
/**
 * DomainEdgeSoftwareUpdateDto
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * DomainEdgeSoftwareUpdateDto Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class DomainEdgeSoftwareUpdateDto implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'DomainEdgeSoftwareUpdateDto';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'version' => '\PureCloudSDK\DomainEdgeSoftwareVersionDto',
        'maxDownloadRate' => 'int',
        'downloadStartTime' => '\DateTime',
        'executeStartTime' => '\DateTime',
        'executeStopTime' => '\DateTime',
        'executeOnIdle' => 'bool',
        'status' => 'string',
        'edgeUri' => 'string',
        'callDrainingWaitTimeSeconds' => 'int',
        'current' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'version' => 'version',
        'maxDownloadRate' => 'maxDownloadRate',
        'downloadStartTime' => 'downloadStartTime',
        'executeStartTime' => 'executeStartTime',
        'executeStopTime' => 'executeStopTime',
        'executeOnIdle' => 'executeOnIdle',
        'status' => 'status',
        'edgeUri' => 'edgeUri',
        'callDrainingWaitTimeSeconds' => 'callDrainingWaitTimeSeconds',
        'current' => 'current'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'version' => 'setVersion',
        'maxDownloadRate' => 'setMaxDownloadRate',
        'downloadStartTime' => 'setDownloadStartTime',
        'executeStartTime' => 'setExecuteStartTime',
        'executeStopTime' => 'setExecuteStopTime',
        'executeOnIdle' => 'setExecuteOnIdle',
        'status' => 'setStatus',
        'edgeUri' => 'setEdgeUri',
        'callDrainingWaitTimeSeconds' => 'setCallDrainingWaitTimeSeconds',
        'current' => 'setCurrent'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'version' => 'getVersion',
        'maxDownloadRate' => 'getMaxDownloadRate',
        'downloadStartTime' => 'getDownloadStartTime',
        'executeStartTime' => 'getExecuteStartTime',
        'executeStopTime' => 'getExecuteStopTime',
        'executeOnIdle' => 'getExecuteOnIdle',
        'status' => 'getStatus',
        'edgeUri' => 'getEdgeUri',
        'callDrainingWaitTimeSeconds' => 'getCallDrainingWaitTimeSeconds',
        'current' => 'getCurrent'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const STATUS_NONE = 'NONE';
    const STATUS_INIT = 'INIT';
    const STATUS_IN_PROGRESS = 'IN_PROGRESS';
    const STATUS_EXPIRED = 'EXPIRED';
    const STATUS_EXCEPTION = 'EXCEPTION';
    const STATUS_ABORTED = 'ABORTED';
    const STATUS_FAILED = 'FAILED';
    const STATUS_SUCCEEDED = 'SUCCEEDED';
    const STATUS_DELETE = 'DELETE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_NONE,
            self::STATUS_INIT,
            self::STATUS_IN_PROGRESS,
            self::STATUS_EXPIRED,
            self::STATUS_EXCEPTION,
            self::STATUS_ABORTED,
            self::STATUS_FAILED,
            self::STATUS_SUCCEEDED,
            self::STATUS_DELETE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['version'] = isset($data['version']) ? $data['version'] : null;
        $this->container['maxDownloadRate'] = isset($data['maxDownloadRate']) ? $data['maxDownloadRate'] : null;
        $this->container['downloadStartTime'] = isset($data['downloadStartTime']) ? $data['downloadStartTime'] : null;
        $this->container['executeStartTime'] = isset($data['executeStartTime']) ? $data['executeStartTime'] : null;
        $this->container['executeStopTime'] = isset($data['executeStopTime']) ? $data['executeStopTime'] : null;
        $this->container['executeOnIdle'] = isset($data['executeOnIdle']) ? $data['executeOnIdle'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['edgeUri'] = isset($data['edgeUri']) ? $data['edgeUri'] : null;
        $this->container['callDrainingWaitTimeSeconds'] = isset($data['callDrainingWaitTimeSeconds']) ? $data['callDrainingWaitTimeSeconds'] : null;
        $this->container['current'] = isset($data['current']) ? $data['current'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['version'] === null) {
            $invalid_properties[] = "'version' can't be null";
        }
        $allowed_values = array("NONE", "INIT", "IN_PROGRESS", "EXPIRED", "EXCEPTION", "ABORTED", "FAILED", "SUCCEEDED", "DELETE");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['version'] === null) {
            return false;
        }
        $allowed_values = array("NONE", "INIT", "IN_PROGRESS", "EXPIRED", "EXCEPTION", "ABORTED", "FAILED", "SUCCEEDED", "DELETE");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets version
     * @return \PureCloudSDK\DomainEdgeSoftwareVersionDto
     */
    public function getVersion()
    {
        return $this->container['version'];
    }

    /**
     * Sets version
     * @param \PureCloudSDK\DomainEdgeSoftwareVersionDto $version Version
     * @return $this
     */
    public function setVersion($version)
    {
        $this->container['version'] = $version;

        return $this;
    }

    /**
     * Gets maxDownloadRate
     * @return int
     */
    public function getMaxDownloadRate()
    {
        return $this->container['maxDownloadRate'];
    }

    /**
     * Sets maxDownloadRate
     * @param int $maxDownloadRate
     * @return $this
     */
    public function setMaxDownloadRate($maxDownloadRate)
    {
        $this->container['maxDownloadRate'] = $maxDownloadRate;

        return $this;
    }

    /**
     * Gets downloadStartTime
     * @return \DateTime
     */
    public function getDownloadStartTime()
    {
        return $this->container['downloadStartTime'];
    }

    /**
     * Sets downloadStartTime
     * @param \DateTime $downloadStartTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDownloadStartTime($downloadStartTime)
    {
        $this->container['downloadStartTime'] = $downloadStartTime;

        return $this;
    }

    /**
     * Gets executeStartTime
     * @return \DateTime
     */
    public function getExecuteStartTime()
    {
        return $this->container['executeStartTime'];
    }

    /**
     * Sets executeStartTime
     * @param \DateTime $executeStartTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExecuteStartTime($executeStartTime)
    {
        $this->container['executeStartTime'] = $executeStartTime;

        return $this;
    }

    /**
     * Gets executeStopTime
     * @return \DateTime
     */
    public function getExecuteStopTime()
    {
        return $this->container['executeStopTime'];
    }

    /**
     * Sets executeStopTime
     * @param \DateTime $executeStopTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setExecuteStopTime($executeStopTime)
    {
        $this->container['executeStopTime'] = $executeStopTime;

        return $this;
    }

    /**
     * Gets executeOnIdle
     * @return bool
     */
    public function getExecuteOnIdle()
    {
        return $this->container['executeOnIdle'];
    }

    /**
     * Sets executeOnIdle
     * @param bool $executeOnIdle
     * @return $this
     */
    public function setExecuteOnIdle($executeOnIdle)
    {
        $this->container['executeOnIdle'] = $executeOnIdle;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('NONE', 'INIT', 'IN_PROGRESS', 'EXPIRED', 'EXCEPTION', 'ABORTED', 'FAILED', 'SUCCEEDED', 'DELETE');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'NONE', 'INIT', 'IN_PROGRESS', 'EXPIRED', 'EXCEPTION', 'ABORTED', 'FAILED', 'SUCCEEDED', 'DELETE'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets edgeUri
     * @return string
     */
    public function getEdgeUri()
    {
        return $this->container['edgeUri'];
    }

    /**
     * Sets edgeUri
     * @param string $edgeUri
     * @return $this
     */
    public function setEdgeUri($edgeUri)
    {
        $this->container['edgeUri'] = $edgeUri;

        return $this;
    }

    /**
     * Gets callDrainingWaitTimeSeconds
     * @return int
     */
    public function getCallDrainingWaitTimeSeconds()
    {
        return $this->container['callDrainingWaitTimeSeconds'];
    }

    /**
     * Sets callDrainingWaitTimeSeconds
     * @param int $callDrainingWaitTimeSeconds
     * @return $this
     */
    public function setCallDrainingWaitTimeSeconds($callDrainingWaitTimeSeconds)
    {
        $this->container['callDrainingWaitTimeSeconds'] = $callDrainingWaitTimeSeconds;

        return $this;
    }

    /**
     * Gets current
     * @return bool
     */
    public function getCurrent()
    {
        return $this->container['current'];
    }

    /**
     * Sets current
     * @param bool $current
     * @return $this
     */
    public function setCurrent($current)
    {
        $this->container['current'] = $current;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


