<?php
/**
 * Exploration
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * Exploration Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class Exploration implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'Exploration';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'dateCreated' => '\DateTime',
        'dateModified' => '\DateTime',
        'allWords' => 'string',
        'anyWords' => 'string',
        'excludeWords' => 'string',
        'exactPhrase' => 'string',
        'socialAccount' => '\PureCloudSDK\SocialAccount',
        'socialAccountId' => 'string',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'dateCreated' => 'dateCreated',
        'dateModified' => 'dateModified',
        'allWords' => 'allWords',
        'anyWords' => 'anyWords',
        'excludeWords' => 'excludeWords',
        'exactPhrase' => 'exactPhrase',
        'socialAccount' => 'socialAccount',
        'socialAccountId' => 'socialAccountId',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'dateCreated' => 'setDateCreated',
        'dateModified' => 'setDateModified',
        'allWords' => 'setAllWords',
        'anyWords' => 'setAnyWords',
        'excludeWords' => 'setExcludeWords',
        'exactPhrase' => 'setExactPhrase',
        'socialAccount' => 'setSocialAccount',
        'socialAccountId' => 'setSocialAccountId',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'dateCreated' => 'getDateCreated',
        'dateModified' => 'getDateModified',
        'allWords' => 'getAllWords',
        'anyWords' => 'getAnyWords',
        'excludeWords' => 'getExcludeWords',
        'exactPhrase' => 'getExactPhrase',
        'socialAccount' => 'getSocialAccount',
        'socialAccountId' => 'getSocialAccountId',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['dateCreated'] = isset($data['dateCreated']) ? $data['dateCreated'] : null;
        $this->container['dateModified'] = isset($data['dateModified']) ? $data['dateModified'] : null;
        $this->container['allWords'] = isset($data['allWords']) ? $data['allWords'] : null;
        $this->container['anyWords'] = isset($data['anyWords']) ? $data['anyWords'] : null;
        $this->container['excludeWords'] = isset($data['excludeWords']) ? $data['excludeWords'] : null;
        $this->container['exactPhrase'] = isset($data['exactPhrase']) ? $data['exactPhrase'] : null;
        $this->container['socialAccount'] = isset($data['socialAccount']) ? $data['socialAccount'] : null;
        $this->container['socialAccountId'] = isset($data['socialAccountId']) ? $data['socialAccountId'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['socialAccount'] === null) {
            $invalid_properties[] = "'socialAccount' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['socialAccount'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets dateCreated
     * @return \DateTime
     */
    public function getDateCreated()
    {
        return $this->container['dateCreated'];
    }

    /**
     * Sets dateCreated
     * @param \DateTime $dateCreated Creation date for the entity. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateCreated($dateCreated)
    {
        $this->container['dateCreated'] = $dateCreated;

        return $this;
    }

    /**
     * Gets dateModified
     * @return \DateTime
     */
    public function getDateModified()
    {
        return $this->container['dateModified'];
    }

    /**
     * Sets dateModified
     * @param \DateTime $dateModified Date the entity was last modified. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setDateModified($dateModified)
    {
        $this->container['dateModified'] = $dateModified;

        return $this;
    }

    /**
     * Gets allWords
     * @return string
     */
    public function getAllWords()
    {
        return $this->container['allWords'];
    }

    /**
     * Sets allWords
     * @param string $allWords A tweet must contain every one of these words in any order
     * @return $this
     */
    public function setAllWords($allWords)
    {
        $this->container['allWords'] = $allWords;

        return $this;
    }

    /**
     * Gets anyWords
     * @return string
     */
    public function getAnyWords()
    {
        return $this->container['anyWords'];
    }

    /**
     * Sets anyWords
     * @param string $anyWords A tweet must contain any one of these words
     * @return $this
     */
    public function setAnyWords($anyWords)
    {
        $this->container['anyWords'] = $anyWords;

        return $this;
    }

    /**
     * Gets excludeWords
     * @return string
     */
    public function getExcludeWords()
    {
        return $this->container['excludeWords'];
    }

    /**
     * Sets excludeWords
     * @param string $excludeWords If a tweet contains any one of these words, it is thrown out
     * @return $this
     */
    public function setExcludeWords($excludeWords)
    {
        $this->container['excludeWords'] = $excludeWords;

        return $this;
    }

    /**
     * Gets exactPhrase
     * @return string
     */
    public function getExactPhrase()
    {
        return $this->container['exactPhrase'];
    }

    /**
     * Sets exactPhrase
     * @param string $exactPhrase A tweet must contain this exact quoted phrase
     * @return $this
     */
    public function setExactPhrase($exactPhrase)
    {
        $this->container['exactPhrase'] = $exactPhrase;

        return $this;
    }

    /**
     * Gets socialAccount
     * @return \PureCloudSDK\SocialAccount
     */
    public function getSocialAccount()
    {
        return $this->container['socialAccount'];
    }

    /**
     * Sets socialAccount
     * @param \PureCloudSDK\SocialAccount $socialAccount The social account associated with this Exploration
     * @return $this
     */
    public function setSocialAccount($socialAccount)
    {
        $this->container['socialAccount'] = $socialAccount;

        return $this;
    }

    /**
     * Gets socialAccountId
     * @return string
     */
    public function getSocialAccountId()
    {
        return $this->container['socialAccountId'];
    }

    /**
     * Sets socialAccountId
     * @param string $socialAccountId The id of the social account associated with this Exploration
     * @return $this
     */
    public function setSocialAccountId($socialAccountId)
    {
        $this->container['socialAccountId'] = $socialAccountId;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


