<?php
/**
 * FacetResult
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FacetResult Class Doc Comment
 *
 * @category    Class */
 // @description Used as part of the searchResult to return facet results to the caller
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FacetResult implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FacetResult';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'requestName' => 'string',
        'requestFieldName' => 'string',
        'fieldType' => 'string',
        'requestType' => 'string',
        'results' => '\PureCloudSDK\FacetResultItem[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'requestName' => 'requestName',
        'requestFieldName' => 'requestFieldName',
        'fieldType' => 'fieldType',
        'requestType' => 'requestType',
        'results' => 'results'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'requestName' => 'setRequestName',
        'requestFieldName' => 'setRequestFieldName',
        'fieldType' => 'setFieldType',
        'requestType' => 'setRequestType',
        'results' => 'setResults'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'requestName' => 'getRequestName',
        'requestFieldName' => 'getRequestFieldName',
        'fieldType' => 'getFieldType',
        'requestType' => 'getRequestType',
        'results' => 'getResults'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const FIELD_TYPE_NUMBER = 'NUMBER';
    const FIELD_TYPE_STRING = 'STRING';
    const FIELD_TYPE_DATE = 'DATE';
    const FIELD_TYPE_BOOLEAN = 'BOOLEAN';
    const FIELD_TYPE_LIST = 'LIST';
    const FIELD_TYPE_GROUP = 'GROUP';
    const REQUEST_TYPE_TERM = 'TERM';
    const REQUEST_TYPE_RANGE = 'RANGE';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getFieldTypeAllowableValues()
    {
        return [
            self::FIELD_TYPE_NUMBER,
            self::FIELD_TYPE_STRING,
            self::FIELD_TYPE_DATE,
            self::FIELD_TYPE_BOOLEAN,
            self::FIELD_TYPE_LIST,
            self::FIELD_TYPE_GROUP,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getRequestTypeAllowableValues()
    {
        return [
            self::REQUEST_TYPE_TERM,
            self::REQUEST_TYPE_RANGE,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['requestName'] = isset($data['requestName']) ? $data['requestName'] : null;
        $this->container['requestFieldName'] = isset($data['requestFieldName']) ? $data['requestFieldName'] : null;
        $this->container['fieldType'] = isset($data['fieldType']) ? $data['fieldType'] : null;
        $this->container['requestType'] = isset($data['requestType']) ? $data['requestType'] : null;
        $this->container['results'] = isset($data['results']) ? $data['results'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("NUMBER", "STRING", "DATE", "BOOLEAN", "LIST", "GROUP");
        if (!in_array($this->container['fieldType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'fieldType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("TERM", "RANGE");
        if (!in_array($this->container['requestType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'requestType', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("NUMBER", "STRING", "DATE", "BOOLEAN", "LIST", "GROUP");
        if (!in_array($this->container['fieldType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("TERM", "RANGE");
        if (!in_array($this->container['requestType'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets requestName
     * @return string
     */
    public function getRequestName()
    {
        return $this->container['requestName'];
    }

    /**
     * Sets requestName
     * @param string $requestName This was the name passed in as part of the facetRequest
     * @return $this
     */
    public function setRequestName($requestName)
    {
        $this->container['requestName'] = $requestName;

        return $this;
    }

    /**
     * Gets requestFieldName
     * @return string
     */
    public function getRequestFieldName()
    {
        return $this->container['requestFieldName'];
    }

    /**
     * Sets requestFieldName
     * @param string $requestFieldName The field name that the facet was requested for.
     * @return $this
     */
    public function setRequestFieldName($requestFieldName)
    {
        $this->container['requestFieldName'] = $requestFieldName;

        return $this;
    }

    /**
     * Gets fieldType
     * @return string
     */
    public function getFieldType()
    {
        return $this->container['fieldType'];
    }

    /**
     * Sets fieldType
     * @param string $fieldType data type of the field being returned (if this is a mixed field this will be unknown)
     * @return $this
     */
    public function setFieldType($fieldType)
    {
        $allowed_values = array('NUMBER', 'STRING', 'DATE', 'BOOLEAN', 'LIST', 'GROUP');
        if (!in_array($fieldType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'fieldType', must be one of 'NUMBER', 'STRING', 'DATE', 'BOOLEAN', 'LIST', 'GROUP'");
        }
        $this->container['fieldType'] = $fieldType;

        return $this;
    }

    /**
     * Gets requestType
     * @return string
     */
    public function getRequestType()
    {
        return $this->container['requestType'];
    }

    /**
     * Sets requestType
     * @param string $requestType the facet request type that was made.
     * @return $this
     */
    public function setRequestType($requestType)
    {
        $allowed_values = array('TERM', 'RANGE');
        if (!in_array($requestType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'requestType', must be one of 'TERM', 'RANGE'");
        }
        $this->container['requestType'] = $requestType;

        return $this;
    }

    /**
     * Gets results
     * @return \PureCloudSDK\FacetResultItem[]
     */
    public function getResults()
    {
        return $this->container['results'];
    }

    /**
     * Sets results
     * @param \PureCloudSDK\FacetResultItem[] $results
     * @return $this
     */
    public function setResults($results)
    {
        $this->container['results'] = $results;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


