<?php
/**
 * FlowDetails
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FlowDetails Class Doc Comment
 *
 * @category    Class */
 // @description Details about the current state of a Flow Instance
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowDetails implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowDetails';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'flowConfigId' => '\PureCloudSDK\FlowConfigId',
        'launchTime' => '\DateTime',
        'launchType' => 'string',
        'launchedBy' => '\PureCloudSDK\User',
        'status' => 'string',
        'associatedDocuments' => '\PureCloudSDK\AssociatedDocument[]',
        'flowCompletionTime' => '\DateTime',
        'flowCompletionReason' => 'string',
        'flowErrorInfo' => '\PureCloudSDK\ErrorBody',
        'publicVariables' => '\PureCloudSDK\DataValue[]',
        'outputVariables' => '\PureCloudSDK\DataValue[]',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'flowConfigId' => 'flowConfigId',
        'launchTime' => 'launchTime',
        'launchType' => 'launchType',
        'launchedBy' => 'launchedBy',
        'status' => 'status',
        'associatedDocuments' => 'associatedDocuments',
        'flowCompletionTime' => 'flowCompletionTime',
        'flowCompletionReason' => 'flowCompletionReason',
        'flowErrorInfo' => 'flowErrorInfo',
        'publicVariables' => 'publicVariables',
        'outputVariables' => 'outputVariables',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'flowConfigId' => 'setFlowConfigId',
        'launchTime' => 'setLaunchTime',
        'launchType' => 'setLaunchType',
        'launchedBy' => 'setLaunchedBy',
        'status' => 'setStatus',
        'associatedDocuments' => 'setAssociatedDocuments',
        'flowCompletionTime' => 'setFlowCompletionTime',
        'flowCompletionReason' => 'setFlowCompletionReason',
        'flowErrorInfo' => 'setFlowErrorInfo',
        'publicVariables' => 'setPublicVariables',
        'outputVariables' => 'setOutputVariables',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'flowConfigId' => 'getFlowConfigId',
        'launchTime' => 'getLaunchTime',
        'launchType' => 'getLaunchType',
        'launchedBy' => 'getLaunchedBy',
        'status' => 'getStatus',
        'associatedDocuments' => 'getAssociatedDocuments',
        'flowCompletionTime' => 'getFlowCompletionTime',
        'flowCompletionReason' => 'getFlowCompletionReason',
        'flowErrorInfo' => 'getFlowErrorInfo',
        'publicVariables' => 'getPublicVariables',
        'outputVariables' => 'getOutputVariables',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const LAUNCH_TYPE_UNKNOWN = 'UNKNOWN';
    const LAUNCH_TYPE_NORMAL = 'NORMAL';
    const LAUNCH_TYPE_TEST = 'TEST';
    const LAUNCH_TYPE_AUTOMATIC = 'AUTOMATIC';
    const STATUS_UNKNOWN = 'UNKNOWN';
    const STATUS_RUNNING = 'RUNNING';
    const STATUS_ERROR = 'ERROR';
    const STATUS_TERMINATED = 'TERMINATED';
    const STATUS_COMPLETED = 'COMPLETED';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getLaunchTypeAllowableValues()
    {
        return [
            self::LAUNCH_TYPE_UNKNOWN,
            self::LAUNCH_TYPE_NORMAL,
            self::LAUNCH_TYPE_TEST,
            self::LAUNCH_TYPE_AUTOMATIC,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getStatusAllowableValues()
    {
        return [
            self::STATUS_UNKNOWN,
            self::STATUS_RUNNING,
            self::STATUS_ERROR,
            self::STATUS_TERMINATED,
            self::STATUS_COMPLETED,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['flowConfigId'] = isset($data['flowConfigId']) ? $data['flowConfigId'] : null;
        $this->container['launchTime'] = isset($data['launchTime']) ? $data['launchTime'] : null;
        $this->container['launchType'] = isset($data['launchType']) ? $data['launchType'] : null;
        $this->container['launchedBy'] = isset($data['launchedBy']) ? $data['launchedBy'] : null;
        $this->container['status'] = isset($data['status']) ? $data['status'] : null;
        $this->container['associatedDocuments'] = isset($data['associatedDocuments']) ? $data['associatedDocuments'] : null;
        $this->container['flowCompletionTime'] = isset($data['flowCompletionTime']) ? $data['flowCompletionTime'] : null;
        $this->container['flowCompletionReason'] = isset($data['flowCompletionReason']) ? $data['flowCompletionReason'] : null;
        $this->container['flowErrorInfo'] = isset($data['flowErrorInfo']) ? $data['flowErrorInfo'] : null;
        $this->container['publicVariables'] = isset($data['publicVariables']) ? $data['publicVariables'] : null;
        $this->container['outputVariables'] = isset($data['outputVariables']) ? $data['outputVariables'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['flowConfigId'] === null) {
            $invalid_properties[] = "'flowConfigId' can't be null";
        }
        if ($this->container['launchTime'] === null) {
            $invalid_properties[] = "'launchTime' can't be null";
        }
        if ($this->container['launchType'] === null) {
            $invalid_properties[] = "'launchType' can't be null";
        }
        $allowed_values = array("UNKNOWN", "NORMAL", "TEST", "AUTOMATIC");
        if (!in_array($this->container['launchType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'launchType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED");
        if (!in_array($this->container['status'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'status', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['flowConfigId'] === null) {
            return false;
        }
        if ($this->container['launchTime'] === null) {
            return false;
        }
        if ($this->container['launchType'] === null) {
            return false;
        }
        $allowed_values = array("UNKNOWN", "NORMAL", "TEST", "AUTOMATIC");
        if (!in_array($this->container['launchType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("UNKNOWN", "RUNNING", "ERROR", "TERMINATED", "COMPLETED");
        if (!in_array($this->container['status'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name The instance name for this flow in relation to its primary document.  If the flow is not a document-centric type, this value will be empty.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets flowConfigId
     * @return \PureCloudSDK\FlowConfigId
     */
    public function getFlowConfigId()
    {
        return $this->container['flowConfigId'];
    }

    /**
     * Sets flowConfigId
     * @param \PureCloudSDK\FlowConfigId $flowConfigId The FlowConfigId that was used to launch this flow.
     * @return $this
     */
    public function setFlowConfigId($flowConfigId)
    {
        $this->container['flowConfigId'] = $flowConfigId;

        return $this;
    }

    /**
     * Gets launchTime
     * @return \DateTime
     */
    public function getLaunchTime()
    {
        return $this->container['launchTime'];
    }

    /**
     * Sets launchTime
     * @param \DateTime $launchTime The time the flow was launched. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setLaunchTime($launchTime)
    {
        $this->container['launchTime'] = $launchTime;

        return $this;
    }

    /**
     * Gets launchType
     * @return string
     */
    public function getLaunchType()
    {
        return $this->container['launchType'];
    }

    /**
     * Sets launchType
     * @param string $launchType The launch mode for this flow instance.
     * @return $this
     */
    public function setLaunchType($launchType)
    {
        $allowed_values = array('UNKNOWN', 'NORMAL', 'TEST', 'AUTOMATIC');
        if (!in_array($launchType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'launchType', must be one of 'UNKNOWN', 'NORMAL', 'TEST', 'AUTOMATIC'");
        }
        $this->container['launchType'] = $launchType;

        return $this;
    }

    /**
     * Gets launchedBy
     * @return \PureCloudSDK\User
     */
    public function getLaunchedBy()
    {
        return $this->container['launchedBy'];
    }

    /**
     * Sets launchedBy
     * @param \PureCloudSDK\User $launchedBy The user who launched the flow, if the flow was launched as the result of that user's action.
     * @return $this
     */
    public function setLaunchedBy($launchedBy)
    {
        $this->container['launchedBy'] = $launchedBy;

        return $this;
    }

    /**
     * Gets status
     * @return string
     */
    public function getStatus()
    {
        return $this->container['status'];
    }

    /**
     * Sets status
     * @param string $status The flow's running status, which indicates whether the flow is running normally or completed, etc.
     * @return $this
     */
    public function setStatus($status)
    {
        $allowed_values = array('UNKNOWN', 'RUNNING', 'ERROR', 'TERMINATED', 'COMPLETED');
        if (!in_array($status, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'status', must be one of 'UNKNOWN', 'RUNNING', 'ERROR', 'TERMINATED', 'COMPLETED'");
        }
        $this->container['status'] = $status;

        return $this;
    }

    /**
     * Gets associatedDocuments
     * @return \PureCloudSDK\AssociatedDocument[]
     */
    public function getAssociatedDocuments()
    {
        return $this->container['associatedDocuments'];
    }

    /**
     * Sets associatedDocuments
     * @param \PureCloudSDK\AssociatedDocument[] $associatedDocuments The documents associated with this flow.
     * @return $this
     */
    public function setAssociatedDocuments($associatedDocuments)
    {
        $this->container['associatedDocuments'] = $associatedDocuments;

        return $this;
    }

    /**
     * Gets flowCompletionTime
     * @return \DateTime
     */
    public function getFlowCompletionTime()
    {
        return $this->container['flowCompletionTime'];
    }

    /**
     * Sets flowCompletionTime
     * @param \DateTime $flowCompletionTime The time the flow completed, if applicable. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setFlowCompletionTime($flowCompletionTime)
    {
        $this->container['flowCompletionTime'] = $flowCompletionTime;

        return $this;
    }

    /**
     * Gets flowCompletionReason
     * @return string
     */
    public function getFlowCompletionReason()
    {
        return $this->container['flowCompletionReason'];
    }

    /**
     * Sets flowCompletionReason
     * @param string $flowCompletionReason The completion reason set at the flow completion time, if applicable.
     * @return $this
     */
    public function setFlowCompletionReason($flowCompletionReason)
    {
        $this->container['flowCompletionReason'] = $flowCompletionReason;

        return $this;
    }

    /**
     * Gets flowErrorInfo
     * @return \PureCloudSDK\ErrorBody
     */
    public function getFlowErrorInfo()
    {
        return $this->container['flowErrorInfo'];
    }

    /**
     * Sets flowErrorInfo
     * @param \PureCloudSDK\ErrorBody $flowErrorInfo Additional information if the flow is in error
     * @return $this
     */
    public function setFlowErrorInfo($flowErrorInfo)
    {
        $this->container['flowErrorInfo'] = $flowErrorInfo;

        return $this;
    }

    /**
     * Gets publicVariables
     * @return \PureCloudSDK\DataValue[]
     */
    public function getPublicVariables()
    {
        return $this->container['publicVariables'];
    }

    /**
     * Sets publicVariables
     * @param \PureCloudSDK\DataValue[] $publicVariables List of the flow's public variables, if any
     * @return $this
     */
    public function setPublicVariables($publicVariables)
    {
        $this->container['publicVariables'] = $publicVariables;

        return $this;
    }

    /**
     * Gets outputVariables
     * @return \PureCloudSDK\DataValue[]
     */
    public function getOutputVariables()
    {
        return $this->container['outputVariables'];
    }

    /**
     * Sets outputVariables
     * @param \PureCloudSDK\DataValue[] $outputVariables List of the flow's output variables, if any.  Output variables are only supplied for Completed flows.
     * @return $this
     */
    public function setOutputVariables($outputVariables)
    {
        $this->container['outputVariables'] = $outputVariables;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


