<?php
/**
 * FlowHistoryItem
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * FlowHistoryItem Class Doc Comment
 *
 * @category    Class */
 // @description Information about one flow history item
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class FlowHistoryItem implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'FlowHistoryItem';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'historyEventTime' => '\DateTime',
        'state' => '\PureCloudSDK\FlowState',
        'workItem' => '\PureCloudSDK\WorkItem',
        'user' => '\PureCloudSDK\User',
        'queue' => '\PureCloudSDK\Queue',
        'historyEventData' => '\PureCloudSDK\FlowHistoryDataItem[]',
        'historyEventType' => 'string',
        'success' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'historyEventTime' => 'historyEventTime',
        'state' => 'state',
        'workItem' => 'workItem',
        'user' => 'user',
        'queue' => 'queue',
        'historyEventData' => 'historyEventData',
        'historyEventType' => 'historyEventType',
        'success' => 'success'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'historyEventTime' => 'setHistoryEventTime',
        'state' => 'setState',
        'workItem' => 'setWorkItem',
        'user' => 'setUser',
        'queue' => 'setQueue',
        'historyEventData' => 'setHistoryEventData',
        'historyEventType' => 'setHistoryEventType',
        'success' => 'setSuccess'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'historyEventTime' => 'getHistoryEventTime',
        'state' => 'getState',
        'workItem' => 'getWorkItem',
        'user' => 'getUser',
        'queue' => 'getQueue',
        'historyEventData' => 'getHistoryEventData',
        'historyEventType' => 'getHistoryEventType',
        'success' => 'getSuccess'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const HISTORY_EVENT_TYPE_FLOW_INSTANCE_START = 'FLOW_INSTANCE_START';
    const HISTORY_EVENT_TYPE_FLOW_INSTANCE_GOTO = 'FLOW_INSTANCE_GOTO';
    const HISTORY_EVENT_TYPE_FLOW_INSTANCE_TERMINATE = 'FLOW_INSTANCE_TERMINATE';
    const HISTORY_EVENT_TYPE_FLOW_INSTANCE_END = 'FLOW_INSTANCE_END';
    const HISTORY_EVENT_TYPE_TASK_INSTANCE_START = 'TASK_INSTANCE_START';
    const HISTORY_EVENT_TYPE_TASK_INSTANCE_END = 'TASK_INSTANCE_END';
    const HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_SAVE = 'WORK_ITEM_INSTANCE_SAVE';
    const HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_ACQUIRE = 'WORK_ITEM_INSTANCE_ACQUIRE';
    const HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_SUBMIT = 'WORK_ITEM_INSTANCE_SUBMIT';
    const HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_OFFER = 'WORK_ITEM_INSTANCE_OFFER';
    const HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_REASSIGN = 'WORK_ITEM_INSTANCE_REASSIGN';
    const HISTORY_EVENT_TYPE_FLOW_INSTANCE_ERROR = 'FLOW_INSTANCE_ERROR';
    const HISTORY_EVENT_TYPE_FLOW_INSTANCE_RETRY = 'FLOW_INSTANCE_RETRY';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getHistoryEventTypeAllowableValues()
    {
        return [
            self::HISTORY_EVENT_TYPE_FLOW_INSTANCE_START,
            self::HISTORY_EVENT_TYPE_FLOW_INSTANCE_GOTO,
            self::HISTORY_EVENT_TYPE_FLOW_INSTANCE_TERMINATE,
            self::HISTORY_EVENT_TYPE_FLOW_INSTANCE_END,
            self::HISTORY_EVENT_TYPE_TASK_INSTANCE_START,
            self::HISTORY_EVENT_TYPE_TASK_INSTANCE_END,
            self::HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_SAVE,
            self::HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_ACQUIRE,
            self::HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_SUBMIT,
            self::HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_OFFER,
            self::HISTORY_EVENT_TYPE_WORK_ITEM_INSTANCE_REASSIGN,
            self::HISTORY_EVENT_TYPE_FLOW_INSTANCE_ERROR,
            self::HISTORY_EVENT_TYPE_FLOW_INSTANCE_RETRY,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['historyEventTime'] = isset($data['historyEventTime']) ? $data['historyEventTime'] : null;
        $this->container['state'] = isset($data['state']) ? $data['state'] : null;
        $this->container['workItem'] = isset($data['workItem']) ? $data['workItem'] : null;
        $this->container['user'] = isset($data['user']) ? $data['user'] : null;
        $this->container['queue'] = isset($data['queue']) ? $data['queue'] : null;
        $this->container['historyEventData'] = isset($data['historyEventData']) ? $data['historyEventData'] : null;
        $this->container['historyEventType'] = isset($data['historyEventType']) ? $data['historyEventType'] : null;
        $this->container['success'] = isset($data['success']) ? $data['success'] : false;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        if ($this->container['historyEventTime'] === null) {
            $invalid_properties[] = "'historyEventTime' can't be null";
        }
        if ($this->container['historyEventType'] === null) {
            $invalid_properties[] = "'historyEventType' can't be null";
        }
        $allowed_values = array("FLOW_INSTANCE_START", "FLOW_INSTANCE_GOTO", "FLOW_INSTANCE_TERMINATE", "FLOW_INSTANCE_END", "TASK_INSTANCE_START", "TASK_INSTANCE_END", "WORK_ITEM_INSTANCE_SAVE", "WORK_ITEM_INSTANCE_ACQUIRE", "WORK_ITEM_INSTANCE_SUBMIT", "WORK_ITEM_INSTANCE_OFFER", "WORK_ITEM_INSTANCE_REASSIGN", "FLOW_INSTANCE_ERROR", "FLOW_INSTANCE_RETRY");
        if (!in_array($this->container['historyEventType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'historyEventType', must be one of #{allowed_values}.";
        }

        if ($this->container['success'] === null) {
            $invalid_properties[] = "'success' can't be null";
        }
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        if ($this->container['historyEventTime'] === null) {
            return false;
        }
        if ($this->container['historyEventType'] === null) {
            return false;
        }
        $allowed_values = array("FLOW_INSTANCE_START", "FLOW_INSTANCE_GOTO", "FLOW_INSTANCE_TERMINATE", "FLOW_INSTANCE_END", "TASK_INSTANCE_START", "TASK_INSTANCE_END", "WORK_ITEM_INSTANCE_SAVE", "WORK_ITEM_INSTANCE_ACQUIRE", "WORK_ITEM_INSTANCE_SUBMIT", "WORK_ITEM_INSTANCE_OFFER", "WORK_ITEM_INSTANCE_REASSIGN", "FLOW_INSTANCE_ERROR", "FLOW_INSTANCE_RETRY");
        if (!in_array($this->container['historyEventType'], $allowed_values)) {
            return false;
        }
        if ($this->container['success'] === null) {
            return false;
        }
        return true;
    }


    /**
     * Gets historyEventTime
     * @return \DateTime
     */
    public function getHistoryEventTime()
    {
        return $this->container['historyEventTime'];
    }

    /**
     * Sets historyEventTime
     * @param \DateTime $historyEventTime The time when the history item occurred. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setHistoryEventTime($historyEventTime)
    {
        $this->container['historyEventTime'] = $historyEventTime;

        return $this;
    }

    /**
     * Gets state
     * @return \PureCloudSDK\FlowState
     */
    public function getState()
    {
        return $this->container['state'];
    }

    /**
     * Sets state
     * @param \PureCloudSDK\FlowState $state The State sequence that applies to the history event, if applicable.
     * @return $this
     */
    public function setState($state)
    {
        $this->container['state'] = $state;

        return $this;
    }

    /**
     * Gets workItem
     * @return \PureCloudSDK\WorkItem
     */
    public function getWorkItem()
    {
        return $this->container['workItem'];
    }

    /**
     * Sets workItem
     * @param \PureCloudSDK\WorkItem $workItem Information about the work item associated with the history event, if applicable.
     * @return $this
     */
    public function setWorkItem($workItem)
    {
        $this->container['workItem'] = $workItem;

        return $this;
    }

    /**
     * Gets user
     * @return \PureCloudSDK\User
     */
    public function getUser()
    {
        return $this->container['user'];
    }

    /**
     * Sets user
     * @param \PureCloudSDK\User $user The user associated with this history event, if applicable.
     * @return $this
     */
    public function setUser($user)
    {
        $this->container['user'] = $user;

        return $this;
    }

    /**
     * Gets queue
     * @return \PureCloudSDK\Queue
     */
    public function getQueue()
    {
        return $this->container['queue'];
    }

    /**
     * Sets queue
     * @param \PureCloudSDK\Queue $queue The queue associated with this history event, if applicable.
     * @return $this
     */
    public function setQueue($queue)
    {
        $this->container['queue'] = $queue;

        return $this;
    }

    /**
     * Gets historyEventData
     * @return \PureCloudSDK\FlowHistoryDataItem[]
     */
    public function getHistoryEventData()
    {
        return $this->container['historyEventData'];
    }

    /**
     * Sets historyEventData
     * @param \PureCloudSDK\FlowHistoryDataItem[] $historyEventData Data elements associated with this history event.
     * @return $this
     */
    public function setHistoryEventData($historyEventData)
    {
        $this->container['historyEventData'] = $historyEventData;

        return $this;
    }

    /**
     * Gets historyEventType
     * @return string
     */
    public function getHistoryEventType()
    {
        return $this->container['historyEventType'];
    }

    /**
     * Sets historyEventType
     * @param string $historyEventType The type of the history event being reported.
     * @return $this
     */
    public function setHistoryEventType($historyEventType)
    {
        $allowed_values = array('FLOW_INSTANCE_START', 'FLOW_INSTANCE_GOTO', 'FLOW_INSTANCE_TERMINATE', 'FLOW_INSTANCE_END', 'TASK_INSTANCE_START', 'TASK_INSTANCE_END', 'WORK_ITEM_INSTANCE_SAVE', 'WORK_ITEM_INSTANCE_ACQUIRE', 'WORK_ITEM_INSTANCE_SUBMIT', 'WORK_ITEM_INSTANCE_OFFER', 'WORK_ITEM_INSTANCE_REASSIGN', 'FLOW_INSTANCE_ERROR', 'FLOW_INSTANCE_RETRY');
        if (!in_array($historyEventType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'historyEventType', must be one of 'FLOW_INSTANCE_START', 'FLOW_INSTANCE_GOTO', 'FLOW_INSTANCE_TERMINATE', 'FLOW_INSTANCE_END', 'TASK_INSTANCE_START', 'TASK_INSTANCE_END', 'WORK_ITEM_INSTANCE_SAVE', 'WORK_ITEM_INSTANCE_ACQUIRE', 'WORK_ITEM_INSTANCE_SUBMIT', 'WORK_ITEM_INSTANCE_OFFER', 'WORK_ITEM_INSTANCE_REASSIGN', 'FLOW_INSTANCE_ERROR', 'FLOW_INSTANCE_RETRY'");
        }
        $this->container['historyEventType'] = $historyEventType;

        return $this;
    }

    /**
     * Gets success
     * @return bool
     */
    public function getSuccess()
    {
        return $this->container['success'];
    }

    /**
     * Sets success
     * @param bool $success Whether or not the flow item was successful (if a 'notification' event this will default to true)
     * @return $this
     */
    public function setSuccess($success)
    {
        $this->container['success'] = $success;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


