<?php
/**
 * NumberRate
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * NumberRate Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class NumberRate implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'NumberRate';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'name' => 'string',
        'compositeKey' => 'string',
        'effectiveDate' => '\DateTime',
        'domain' => 'string',
        'currency' => 'string',
        'purchaseGroup' => '\PureCloudSDK\PurchaseGroupDisplay',
        'nonRecurringCost' => 'float',
        'monthlyRecurringCost' => 'float',
        'selfUri' => 'string'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'name' => 'name',
        'compositeKey' => 'compositeKey',
        'effectiveDate' => 'effectiveDate',
        'domain' => 'domain',
        'currency' => 'currency',
        'purchaseGroup' => 'purchaseGroup',
        'nonRecurringCost' => 'nonRecurringCost',
        'monthlyRecurringCost' => 'monthlyRecurringCost',
        'selfUri' => 'selfUri'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'name' => 'setName',
        'compositeKey' => 'setCompositeKey',
        'effectiveDate' => 'setEffectiveDate',
        'domain' => 'setDomain',
        'currency' => 'setCurrency',
        'purchaseGroup' => 'setPurchaseGroup',
        'nonRecurringCost' => 'setNonRecurringCost',
        'monthlyRecurringCost' => 'setMonthlyRecurringCost',
        'selfUri' => 'setSelfUri'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'name' => 'getName',
        'compositeKey' => 'getCompositeKey',
        'effectiveDate' => 'getEffectiveDate',
        'domain' => 'getDomain',
        'currency' => 'getCurrency',
        'purchaseGroup' => 'getPurchaseGroup',
        'nonRecurringCost' => 'getNonRecurringCost',
        'monthlyRecurringCost' => 'getMonthlyRecurringCost',
        'selfUri' => 'getSelfUri'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const DOMAIN_CA = 'CA';
    const DOMAIN_FR = 'FR';
    const DOMAIN_GB = 'GB';
    const DOMAIN_IE = 'IE';
    const DOMAIN_US = 'US';
    const DOMAIN_NA_TF = 'NA_TF';
    const CURRENCY_USD = 'USD';
    const CURRENCY_CAD = 'CAD';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDomainAllowableValues()
    {
        return [
            self::DOMAIN_CA,
            self::DOMAIN_FR,
            self::DOMAIN_GB,
            self::DOMAIN_IE,
            self::DOMAIN_US,
            self::DOMAIN_NA_TF,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getCurrencyAllowableValues()
    {
        return [
            self::CURRENCY_USD,
            self::CURRENCY_CAD,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['compositeKey'] = isset($data['compositeKey']) ? $data['compositeKey'] : null;
        $this->container['effectiveDate'] = isset($data['effectiveDate']) ? $data['effectiveDate'] : null;
        $this->container['domain'] = isset($data['domain']) ? $data['domain'] : null;
        $this->container['currency'] = isset($data['currency']) ? $data['currency'] : null;
        $this->container['purchaseGroup'] = isset($data['purchaseGroup']) ? $data['purchaseGroup'] : null;
        $this->container['nonRecurringCost'] = isset($data['nonRecurringCost']) ? $data['nonRecurringCost'] : null;
        $this->container['monthlyRecurringCost'] = isset($data['monthlyRecurringCost']) ? $data['monthlyRecurringCost'] : null;
        $this->container['selfUri'] = isset($data['selfUri']) ? $data['selfUri'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("CA", "FR", "GB", "IE", "US", "NA_TF");
        if (!in_array($this->container['domain'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'domain', must be one of #{allowed_values}.";
        }

        $allowed_values = array("USD", "CAD");
        if (!in_array($this->container['currency'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'currency', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("CA", "FR", "GB", "IE", "US", "NA_TF");
        if (!in_array($this->container['domain'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("USD", "CAD");
        if (!in_array($this->container['currency'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id The globally unique identifier for the object.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets compositeKey
     * @return string
     */
    public function getCompositeKey()
    {
        return $this->container['compositeKey'];
    }

    /**
     * Sets compositeKey
     * @param string $compositeKey
     * @return $this
     */
    public function setCompositeKey($compositeKey)
    {
        $this->container['compositeKey'] = $compositeKey;

        return $this;
    }

    /**
     * Gets effectiveDate
     * @return \DateTime
     */
    public function getEffectiveDate()
    {
        return $this->container['effectiveDate'];
    }

    /**
     * Sets effectiveDate
     * @param \DateTime $effectiveDate Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEffectiveDate($effectiveDate)
    {
        $this->container['effectiveDate'] = $effectiveDate;

        return $this;
    }

    /**
     * Gets domain
     * @return string
     */
    public function getDomain()
    {
        return $this->container['domain'];
    }

    /**
     * Sets domain
     * @param string $domain
     * @return $this
     */
    public function setDomain($domain)
    {
        $allowed_values = array('CA', 'FR', 'GB', 'IE', 'US', 'NA_TF');
        if (!in_array($domain, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'domain', must be one of 'CA', 'FR', 'GB', 'IE', 'US', 'NA_TF'");
        }
        $this->container['domain'] = $domain;

        return $this;
    }

    /**
     * Gets currency
     * @return string
     */
    public function getCurrency()
    {
        return $this->container['currency'];
    }

    /**
     * Sets currency
     * @param string $currency
     * @return $this
     */
    public function setCurrency($currency)
    {
        $allowed_values = array('USD', 'CAD');
        if (!in_array($currency, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'currency', must be one of 'USD', 'CAD'");
        }
        $this->container['currency'] = $currency;

        return $this;
    }

    /**
     * Gets purchaseGroup
     * @return \PureCloudSDK\PurchaseGroupDisplay
     */
    public function getPurchaseGroup()
    {
        return $this->container['purchaseGroup'];
    }

    /**
     * Sets purchaseGroup
     * @param \PureCloudSDK\PurchaseGroupDisplay $purchaseGroup
     * @return $this
     */
    public function setPurchaseGroup($purchaseGroup)
    {
        $this->container['purchaseGroup'] = $purchaseGroup;

        return $this;
    }

    /**
     * Gets nonRecurringCost
     * @return float
     */
    public function getNonRecurringCost()
    {
        return $this->container['nonRecurringCost'];
    }

    /**
     * Sets nonRecurringCost
     * @param float $nonRecurringCost
     * @return $this
     */
    public function setNonRecurringCost($nonRecurringCost)
    {
        $this->container['nonRecurringCost'] = $nonRecurringCost;

        return $this;
    }

    /**
     * Gets monthlyRecurringCost
     * @return float
     */
    public function getMonthlyRecurringCost()
    {
        return $this->container['monthlyRecurringCost'];
    }

    /**
     * Sets monthlyRecurringCost
     * @param float $monthlyRecurringCost
     * @return $this
     */
    public function setMonthlyRecurringCost($monthlyRecurringCost)
    {
        $this->container['monthlyRecurringCost'] = $monthlyRecurringCost;

        return $this;
    }

    /**
     * Gets selfUri
     * @return string
     */
    public function getSelfUri()
    {
        return $this->container['selfUri'];
    }

    /**
     * Sets selfUri
     * @param string $selfUri The URI for this object
     * @return $this
     */
    public function setSelfUri($selfUri)
    {
        $this->container['selfUri'] = $selfUri;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


