<?php
/**
 * ParticipantBasic
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * ParticipantBasic Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class ParticipantBasic implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'ParticipantBasic';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'id' => 'string',
        'startTime' => '\DateTime',
        'endTime' => '\DateTime',
        'connectedTime' => '\DateTime',
        'name' => 'string',
        'userUri' => 'string',
        'userId' => 'string',
        'externalContactId' => 'string',
        'externalOrganizationId' => 'string',
        'queueId' => 'string',
        'groupId' => 'string',
        'queueName' => 'string',
        'purpose' => 'string',
        'participantType' => 'string',
        'consultParticipantId' => 'string',
        'address' => 'string',
        'ani' => 'string',
        'aniName' => 'string',
        'dnis' => 'string',
        'locale' => 'string',
        'wrapupRequired' => 'bool',
        'wrapupPrompt' => 'string',
        'wrapupTimeoutMs' => 'int',
        'wrapupSkipped' => 'bool',
        'wrapup' => '\PureCloudSDK\Wrapup',
        'monitoredParticipantId' => 'string',
        'attributes' => 'map[string,string]',
        'calls' => '\PureCloudSDK\CallBasic[]',
        'callbacks' => '\PureCloudSDK\CallbackBasic[]',
        'chats' => '\PureCloudSDK\ConversationChat[]',
        'cobrowsesessions' => '\PureCloudSDK\Cobrowsesession[]',
        'emails' => '\PureCloudSDK\Email[]',
        'screenshares' => '\PureCloudSDK\Screenshare[]',
        'socialExpressions' => '\PureCloudSDK\SocialExpression[]',
        'videos' => '\PureCloudSDK\Video[]',
        'evaluations' => '\PureCloudSDK\Evaluation[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'id' => 'id',
        'startTime' => 'startTime',
        'endTime' => 'endTime',
        'connectedTime' => 'connectedTime',
        'name' => 'name',
        'userUri' => 'userUri',
        'userId' => 'userId',
        'externalContactId' => 'externalContactId',
        'externalOrganizationId' => 'externalOrganizationId',
        'queueId' => 'queueId',
        'groupId' => 'groupId',
        'queueName' => 'queueName',
        'purpose' => 'purpose',
        'participantType' => 'participantType',
        'consultParticipantId' => 'consultParticipantId',
        'address' => 'address',
        'ani' => 'ani',
        'aniName' => 'aniName',
        'dnis' => 'dnis',
        'locale' => 'locale',
        'wrapupRequired' => 'wrapupRequired',
        'wrapupPrompt' => 'wrapupPrompt',
        'wrapupTimeoutMs' => 'wrapupTimeoutMs',
        'wrapupSkipped' => 'wrapupSkipped',
        'wrapup' => 'wrapup',
        'monitoredParticipantId' => 'monitoredParticipantId',
        'attributes' => 'attributes',
        'calls' => 'calls',
        'callbacks' => 'callbacks',
        'chats' => 'chats',
        'cobrowsesessions' => 'cobrowsesessions',
        'emails' => 'emails',
        'screenshares' => 'screenshares',
        'socialExpressions' => 'socialExpressions',
        'videos' => 'videos',
        'evaluations' => 'evaluations'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'id' => 'setId',
        'startTime' => 'setStartTime',
        'endTime' => 'setEndTime',
        'connectedTime' => 'setConnectedTime',
        'name' => 'setName',
        'userUri' => 'setUserUri',
        'userId' => 'setUserId',
        'externalContactId' => 'setExternalContactId',
        'externalOrganizationId' => 'setExternalOrganizationId',
        'queueId' => 'setQueueId',
        'groupId' => 'setGroupId',
        'queueName' => 'setQueueName',
        'purpose' => 'setPurpose',
        'participantType' => 'setParticipantType',
        'consultParticipantId' => 'setConsultParticipantId',
        'address' => 'setAddress',
        'ani' => 'setAni',
        'aniName' => 'setAniName',
        'dnis' => 'setDnis',
        'locale' => 'setLocale',
        'wrapupRequired' => 'setWrapupRequired',
        'wrapupPrompt' => 'setWrapupPrompt',
        'wrapupTimeoutMs' => 'setWrapupTimeoutMs',
        'wrapupSkipped' => 'setWrapupSkipped',
        'wrapup' => 'setWrapup',
        'monitoredParticipantId' => 'setMonitoredParticipantId',
        'attributes' => 'setAttributes',
        'calls' => 'setCalls',
        'callbacks' => 'setCallbacks',
        'chats' => 'setChats',
        'cobrowsesessions' => 'setCobrowsesessions',
        'emails' => 'setEmails',
        'screenshares' => 'setScreenshares',
        'socialExpressions' => 'setSocialExpressions',
        'videos' => 'setVideos',
        'evaluations' => 'setEvaluations'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'id' => 'getId',
        'startTime' => 'getStartTime',
        'endTime' => 'getEndTime',
        'connectedTime' => 'getConnectedTime',
        'name' => 'getName',
        'userUri' => 'getUserUri',
        'userId' => 'getUserId',
        'externalContactId' => 'getExternalContactId',
        'externalOrganizationId' => 'getExternalOrganizationId',
        'queueId' => 'getQueueId',
        'groupId' => 'getGroupId',
        'queueName' => 'getQueueName',
        'purpose' => 'getPurpose',
        'participantType' => 'getParticipantType',
        'consultParticipantId' => 'getConsultParticipantId',
        'address' => 'getAddress',
        'ani' => 'getAni',
        'aniName' => 'getAniName',
        'dnis' => 'getDnis',
        'locale' => 'getLocale',
        'wrapupRequired' => 'getWrapupRequired',
        'wrapupPrompt' => 'getWrapupPrompt',
        'wrapupTimeoutMs' => 'getWrapupTimeoutMs',
        'wrapupSkipped' => 'getWrapupSkipped',
        'wrapup' => 'getWrapup',
        'monitoredParticipantId' => 'getMonitoredParticipantId',
        'attributes' => 'getAttributes',
        'calls' => 'getCalls',
        'callbacks' => 'getCallbacks',
        'chats' => 'getChats',
        'cobrowsesessions' => 'getCobrowsesessions',
        'emails' => 'getEmails',
        'screenshares' => 'getScreenshares',
        'socialExpressions' => 'getSocialExpressions',
        'videos' => 'getVideos',
        'evaluations' => 'getEvaluations'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const WRAPUP_PROMPT_MANDATORY = 'mandatory';
    const WRAPUP_PROMPT_OPTIONAL = 'optional';
    const WRAPUP_PROMPT_TIMEOUT = 'timeout';
    const WRAPUP_PROMPT_FORCED_TIMEOUT = 'forcedTimeout';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getWrapupPromptAllowableValues()
    {
        return [
            self::WRAPUP_PROMPT_MANDATORY,
            self::WRAPUP_PROMPT_OPTIONAL,
            self::WRAPUP_PROMPT_TIMEOUT,
            self::WRAPUP_PROMPT_FORCED_TIMEOUT,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['id'] = isset($data['id']) ? $data['id'] : null;
        $this->container['startTime'] = isset($data['startTime']) ? $data['startTime'] : null;
        $this->container['endTime'] = isset($data['endTime']) ? $data['endTime'] : null;
        $this->container['connectedTime'] = isset($data['connectedTime']) ? $data['connectedTime'] : null;
        $this->container['name'] = isset($data['name']) ? $data['name'] : null;
        $this->container['userUri'] = isset($data['userUri']) ? $data['userUri'] : null;
        $this->container['userId'] = isset($data['userId']) ? $data['userId'] : null;
        $this->container['externalContactId'] = isset($data['externalContactId']) ? $data['externalContactId'] : null;
        $this->container['externalOrganizationId'] = isset($data['externalOrganizationId']) ? $data['externalOrganizationId'] : null;
        $this->container['queueId'] = isset($data['queueId']) ? $data['queueId'] : null;
        $this->container['groupId'] = isset($data['groupId']) ? $data['groupId'] : null;
        $this->container['queueName'] = isset($data['queueName']) ? $data['queueName'] : null;
        $this->container['purpose'] = isset($data['purpose']) ? $data['purpose'] : null;
        $this->container['participantType'] = isset($data['participantType']) ? $data['participantType'] : null;
        $this->container['consultParticipantId'] = isset($data['consultParticipantId']) ? $data['consultParticipantId'] : null;
        $this->container['address'] = isset($data['address']) ? $data['address'] : null;
        $this->container['ani'] = isset($data['ani']) ? $data['ani'] : null;
        $this->container['aniName'] = isset($data['aniName']) ? $data['aniName'] : null;
        $this->container['dnis'] = isset($data['dnis']) ? $data['dnis'] : null;
        $this->container['locale'] = isset($data['locale']) ? $data['locale'] : null;
        $this->container['wrapupRequired'] = isset($data['wrapupRequired']) ? $data['wrapupRequired'] : null;
        $this->container['wrapupPrompt'] = isset($data['wrapupPrompt']) ? $data['wrapupPrompt'] : null;
        $this->container['wrapupTimeoutMs'] = isset($data['wrapupTimeoutMs']) ? $data['wrapupTimeoutMs'] : null;
        $this->container['wrapupSkipped'] = isset($data['wrapupSkipped']) ? $data['wrapupSkipped'] : null;
        $this->container['wrapup'] = isset($data['wrapup']) ? $data['wrapup'] : null;
        $this->container['monitoredParticipantId'] = isset($data['monitoredParticipantId']) ? $data['monitoredParticipantId'] : null;
        $this->container['attributes'] = isset($data['attributes']) ? $data['attributes'] : null;
        $this->container['calls'] = isset($data['calls']) ? $data['calls'] : null;
        $this->container['callbacks'] = isset($data['callbacks']) ? $data['callbacks'] : null;
        $this->container['chats'] = isset($data['chats']) ? $data['chats'] : null;
        $this->container['cobrowsesessions'] = isset($data['cobrowsesessions']) ? $data['cobrowsesessions'] : null;
        $this->container['emails'] = isset($data['emails']) ? $data['emails'] : null;
        $this->container['screenshares'] = isset($data['screenshares']) ? $data['screenshares'] : null;
        $this->container['socialExpressions'] = isset($data['socialExpressions']) ? $data['socialExpressions'] : null;
        $this->container['videos'] = isset($data['videos']) ? $data['videos'] : null;
        $this->container['evaluations'] = isset($data['evaluations']) ? $data['evaluations'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("mandatory", "optional", "timeout", "forcedTimeout");
        if (!in_array($this->container['wrapupPrompt'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'wrapupPrompt', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("mandatory", "optional", "timeout", "forcedTimeout");
        if (!in_array($this->container['wrapupPrompt'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets id
     * @return string
     */
    public function getId()
    {
        return $this->container['id'];
    }

    /**
     * Sets id
     * @param string $id A globally unique identifier for this conversation.
     * @return $this
     */
    public function setId($id)
    {
        $this->container['id'] = $id;

        return $this;
    }

    /**
     * Gets startTime
     * @return \DateTime
     */
    public function getStartTime()
    {
        return $this->container['startTime'];
    }

    /**
     * Sets startTime
     * @param \DateTime $startTime The timestamp when this participant joined the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setStartTime($startTime)
    {
        $this->container['startTime'] = $startTime;

        return $this;
    }

    /**
     * Gets endTime
     * @return \DateTime
     */
    public function getEndTime()
    {
        return $this->container['endTime'];
    }

    /**
     * Sets endTime
     * @param \DateTime $endTime The timestamp when this participant disconnected from the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setEndTime($endTime)
    {
        $this->container['endTime'] = $endTime;

        return $this;
    }

    /**
     * Gets connectedTime
     * @return \DateTime
     */
    public function getConnectedTime()
    {
        return $this->container['connectedTime'];
    }

    /**
     * Sets connectedTime
     * @param \DateTime $connectedTime The timestamp when this participant was connected to the conversation in the provider clock. Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setConnectedTime($connectedTime)
    {
        $this->container['connectedTime'] = $connectedTime;

        return $this;
    }

    /**
     * Gets name
     * @return string
     */
    public function getName()
    {
        return $this->container['name'];
    }

    /**
     * Sets name
     * @param string $name A human readable name identifying the participant.
     * @return $this
     */
    public function setName($name)
    {
        $this->container['name'] = $name;

        return $this;
    }

    /**
     * Gets userUri
     * @return string
     */
    public function getUserUri()
    {
        return $this->container['userUri'];
    }

    /**
     * Sets userUri
     * @param string $userUri If this participant represents a user, then this will be an URI that can be used to fetch the user.
     * @return $this
     */
    public function setUserUri($userUri)
    {
        $this->container['userUri'] = $userUri;

        return $this;
    }

    /**
     * Gets userId
     * @return string
     */
    public function getUserId()
    {
        return $this->container['userId'];
    }

    /**
     * Sets userId
     * @param string $userId If this participant represents a user, then this will be the globally unique identifier for the user.
     * @return $this
     */
    public function setUserId($userId)
    {
        $this->container['userId'] = $userId;

        return $this;
    }

    /**
     * Gets externalContactId
     * @return string
     */
    public function getExternalContactId()
    {
        return $this->container['externalContactId'];
    }

    /**
     * Sets externalContactId
     * @param string $externalContactId If this participant represents an external contact, then this will be the globally unique identifier for the external contact.
     * @return $this
     */
    public function setExternalContactId($externalContactId)
    {
        $this->container['externalContactId'] = $externalContactId;

        return $this;
    }

    /**
     * Gets externalOrganizationId
     * @return string
     */
    public function getExternalOrganizationId()
    {
        return $this->container['externalOrganizationId'];
    }

    /**
     * Sets externalOrganizationId
     * @param string $externalOrganizationId If this participant represents an external org, then this will be the globally unique identifier for the external org.
     * @return $this
     */
    public function setExternalOrganizationId($externalOrganizationId)
    {
        $this->container['externalOrganizationId'] = $externalOrganizationId;

        return $this;
    }

    /**
     * Gets queueId
     * @return string
     */
    public function getQueueId()
    {
        return $this->container['queueId'];
    }

    /**
     * Sets queueId
     * @param string $queueId If present, the queue id that the communication channel came in on.
     * @return $this
     */
    public function setQueueId($queueId)
    {
        $this->container['queueId'] = $queueId;

        return $this;
    }

    /**
     * Gets groupId
     * @return string
     */
    public function getGroupId()
    {
        return $this->container['groupId'];
    }

    /**
     * Sets groupId
     * @param string $groupId If present, group of users the participant represents.
     * @return $this
     */
    public function setGroupId($groupId)
    {
        $this->container['groupId'] = $groupId;

        return $this;
    }

    /**
     * Gets queueName
     * @return string
     */
    public function getQueueName()
    {
        return $this->container['queueName'];
    }

    /**
     * Sets queueName
     * @param string $queueName If present, the queue name that the communication channel came in on.
     * @return $this
     */
    public function setQueueName($queueName)
    {
        $this->container['queueName'] = $queueName;

        return $this;
    }

    /**
     * Gets purpose
     * @return string
     */
    public function getPurpose()
    {
        return $this->container['purpose'];
    }

    /**
     * Sets purpose
     * @param string $purpose A well known string that specifies the purpose of this participant.
     * @return $this
     */
    public function setPurpose($purpose)
    {
        $this->container['purpose'] = $purpose;

        return $this;
    }

    /**
     * Gets participantType
     * @return string
     */
    public function getParticipantType()
    {
        return $this->container['participantType'];
    }

    /**
     * Sets participantType
     * @param string $participantType A well known string that specifies the type of this participant.
     * @return $this
     */
    public function setParticipantType($participantType)
    {
        $this->container['participantType'] = $participantType;

        return $this;
    }

    /**
     * Gets consultParticipantId
     * @return string
     */
    public function getConsultParticipantId()
    {
        return $this->container['consultParticipantId'];
    }

    /**
     * Sets consultParticipantId
     * @param string $consultParticipantId If this participant is part of a consult transfer, then this will be the participant id of the participant being transferred.
     * @return $this
     */
    public function setConsultParticipantId($consultParticipantId)
    {
        $this->container['consultParticipantId'] = $consultParticipantId;

        return $this;
    }

    /**
     * Gets address
     * @return string
     */
    public function getAddress()
    {
        return $this->container['address'];
    }

    /**
     * Sets address
     * @param string $address The address for the this participant. For a phone call this will be the ANI.
     * @return $this
     */
    public function setAddress($address)
    {
        $this->container['address'] = $address;

        return $this;
    }

    /**
     * Gets ani
     * @return string
     */
    public function getAni()
    {
        return $this->container['ani'];
    }

    /**
     * Sets ani
     * @param string $ani The address for the this participant. For a phone call this will be the ANI.
     * @return $this
     */
    public function setAni($ani)
    {
        $this->container['ani'] = $ani;

        return $this;
    }

    /**
     * Gets aniName
     * @return string
     */
    public function getAniName()
    {
        return $this->container['aniName'];
    }

    /**
     * Sets aniName
     * @param string $aniName The ani-based name for this participant.
     * @return $this
     */
    public function setAniName($aniName)
    {
        $this->container['aniName'] = $aniName;

        return $this;
    }

    /**
     * Gets dnis
     * @return string
     */
    public function getDnis()
    {
        return $this->container['dnis'];
    }

    /**
     * Sets dnis
     * @param string $dnis The address for the this participant. For a phone call this will be the ANI.
     * @return $this
     */
    public function setDnis($dnis)
    {
        $this->container['dnis'] = $dnis;

        return $this;
    }

    /**
     * Gets locale
     * @return string
     */
    public function getLocale()
    {
        return $this->container['locale'];
    }

    /**
     * Sets locale
     * @param string $locale An ISO 639 language code specifying the locale for this participant
     * @return $this
     */
    public function setLocale($locale)
    {
        $this->container['locale'] = $locale;

        return $this;
    }

    /**
     * Gets wrapupRequired
     * @return bool
     */
    public function getWrapupRequired()
    {
        return $this->container['wrapupRequired'];
    }

    /**
     * Sets wrapupRequired
     * @param bool $wrapupRequired True iff this participant is required to enter wrapup for this conversation.
     * @return $this
     */
    public function setWrapupRequired($wrapupRequired)
    {
        $this->container['wrapupRequired'] = $wrapupRequired;

        return $this;
    }

    /**
     * Gets wrapupPrompt
     * @return string
     */
    public function getWrapupPrompt()
    {
        return $this->container['wrapupPrompt'];
    }

    /**
     * Sets wrapupPrompt
     * @param string $wrapupPrompt This field controls how the UI prompts the agent for a wrapup.
     * @return $this
     */
    public function setWrapupPrompt($wrapupPrompt)
    {
        $allowed_values = array('mandatory', 'optional', 'timeout', 'forcedTimeout');
        if (!in_array($wrapupPrompt, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'wrapupPrompt', must be one of 'mandatory', 'optional', 'timeout', 'forcedTimeout'");
        }
        $this->container['wrapupPrompt'] = $wrapupPrompt;

        return $this;
    }

    /**
     * Gets wrapupTimeoutMs
     * @return int
     */
    public function getWrapupTimeoutMs()
    {
        return $this->container['wrapupTimeoutMs'];
    }

    /**
     * Sets wrapupTimeoutMs
     * @param int $wrapupTimeoutMs Specifies how long a timed ACW session will last.
     * @return $this
     */
    public function setWrapupTimeoutMs($wrapupTimeoutMs)
    {
        $this->container['wrapupTimeoutMs'] = $wrapupTimeoutMs;

        return $this;
    }

    /**
     * Gets wrapupSkipped
     * @return bool
     */
    public function getWrapupSkipped()
    {
        return $this->container['wrapupSkipped'];
    }

    /**
     * Sets wrapupSkipped
     * @param bool $wrapupSkipped The UI sets this field when the agent chooses to skip entering a wrapup for this participant.
     * @return $this
     */
    public function setWrapupSkipped($wrapupSkipped)
    {
        $this->container['wrapupSkipped'] = $wrapupSkipped;

        return $this;
    }

    /**
     * Gets wrapup
     * @return \PureCloudSDK\Wrapup
     */
    public function getWrapup()
    {
        return $this->container['wrapup'];
    }

    /**
     * Sets wrapup
     * @param \PureCloudSDK\Wrapup $wrapup Call wrap up or disposition data.
     * @return $this
     */
    public function setWrapup($wrapup)
    {
        $this->container['wrapup'] = $wrapup;

        return $this;
    }

    /**
     * Gets monitoredParticipantId
     * @return string
     */
    public function getMonitoredParticipantId()
    {
        return $this->container['monitoredParticipantId'];
    }

    /**
     * Sets monitoredParticipantId
     * @param string $monitoredParticipantId If this participant is a monitor, then this will be the id of the participant that is being monitored.
     * @return $this
     */
    public function setMonitoredParticipantId($monitoredParticipantId)
    {
        $this->container['monitoredParticipantId'] = $monitoredParticipantId;

        return $this;
    }

    /**
     * Gets attributes
     * @return map[string,string]
     */
    public function getAttributes()
    {
        return $this->container['attributes'];
    }

    /**
     * Sets attributes
     * @param map[string,string] $attributes Additional participant attributes
     * @return $this
     */
    public function setAttributes($attributes)
    {
        $this->container['attributes'] = $attributes;

        return $this;
    }

    /**
     * Gets calls
     * @return \PureCloudSDK\CallBasic[]
     */
    public function getCalls()
    {
        return $this->container['calls'];
    }

    /**
     * Sets calls
     * @param \PureCloudSDK\CallBasic[] $calls
     * @return $this
     */
    public function setCalls($calls)
    {
        $this->container['calls'] = $calls;

        return $this;
    }

    /**
     * Gets callbacks
     * @return \PureCloudSDK\CallbackBasic[]
     */
    public function getCallbacks()
    {
        return $this->container['callbacks'];
    }

    /**
     * Sets callbacks
     * @param \PureCloudSDK\CallbackBasic[] $callbacks
     * @return $this
     */
    public function setCallbacks($callbacks)
    {
        $this->container['callbacks'] = $callbacks;

        return $this;
    }

    /**
     * Gets chats
     * @return \PureCloudSDK\ConversationChat[]
     */
    public function getChats()
    {
        return $this->container['chats'];
    }

    /**
     * Sets chats
     * @param \PureCloudSDK\ConversationChat[] $chats
     * @return $this
     */
    public function setChats($chats)
    {
        $this->container['chats'] = $chats;

        return $this;
    }

    /**
     * Gets cobrowsesessions
     * @return \PureCloudSDK\Cobrowsesession[]
     */
    public function getCobrowsesessions()
    {
        return $this->container['cobrowsesessions'];
    }

    /**
     * Sets cobrowsesessions
     * @param \PureCloudSDK\Cobrowsesession[] $cobrowsesessions
     * @return $this
     */
    public function setCobrowsesessions($cobrowsesessions)
    {
        $this->container['cobrowsesessions'] = $cobrowsesessions;

        return $this;
    }

    /**
     * Gets emails
     * @return \PureCloudSDK\Email[]
     */
    public function getEmails()
    {
        return $this->container['emails'];
    }

    /**
     * Sets emails
     * @param \PureCloudSDK\Email[] $emails
     * @return $this
     */
    public function setEmails($emails)
    {
        $this->container['emails'] = $emails;

        return $this;
    }

    /**
     * Gets screenshares
     * @return \PureCloudSDK\Screenshare[]
     */
    public function getScreenshares()
    {
        return $this->container['screenshares'];
    }

    /**
     * Sets screenshares
     * @param \PureCloudSDK\Screenshare[] $screenshares
     * @return $this
     */
    public function setScreenshares($screenshares)
    {
        $this->container['screenshares'] = $screenshares;

        return $this;
    }

    /**
     * Gets socialExpressions
     * @return \PureCloudSDK\SocialExpression[]
     */
    public function getSocialExpressions()
    {
        return $this->container['socialExpressions'];
    }

    /**
     * Sets socialExpressions
     * @param \PureCloudSDK\SocialExpression[] $socialExpressions
     * @return $this
     */
    public function setSocialExpressions($socialExpressions)
    {
        $this->container['socialExpressions'] = $socialExpressions;

        return $this;
    }

    /**
     * Gets videos
     * @return \PureCloudSDK\Video[]
     */
    public function getVideos()
    {
        return $this->container['videos'];
    }

    /**
     * Sets videos
     * @param \PureCloudSDK\Video[] $videos
     * @return $this
     */
    public function setVideos($videos)
    {
        $this->container['videos'] = $videos;

        return $this;
    }

    /**
     * Gets evaluations
     * @return \PureCloudSDK\Evaluation[]
     */
    public function getEvaluations()
    {
        return $this->container['evaluations'];
    }

    /**
     * Sets evaluations
     * @param \PureCloudSDK\Evaluation[] $evaluations
     * @return $this
     */
    public function setEvaluations($evaluations)
    {
        $this->container['evaluations'] = $evaluations;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


