<?php
/**
 * PhoneCapabilities
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * PhoneCapabilities Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class PhoneCapabilities implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'PhoneCapabilities';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'provisions' => 'bool',
        'registers' => 'bool',
        'dualRegisters' => 'bool',
        'hardwareIdType' => 'string',
        'allowReboot' => 'bool',
        'noRebalance' => 'bool'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'provisions' => 'provisions',
        'registers' => 'registers',
        'dualRegisters' => 'dualRegisters',
        'hardwareIdType' => 'hardwareIdType',
        'allowReboot' => 'allowReboot',
        'noRebalance' => 'noRebalance'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'provisions' => 'setProvisions',
        'registers' => 'setRegisters',
        'dualRegisters' => 'setDualRegisters',
        'hardwareIdType' => 'setHardwareIdType',
        'allowReboot' => 'setAllowReboot',
        'noRebalance' => 'setNoRebalance'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'provisions' => 'getProvisions',
        'registers' => 'getRegisters',
        'dualRegisters' => 'getDualRegisters',
        'hardwareIdType' => 'getHardwareIdType',
        'allowReboot' => 'getAllowReboot',
        'noRebalance' => 'getNoRebalance'
    );

    public static function getters()
    {
        return self::$getters;
    }

    

    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['provisions'] = isset($data['provisions']) ? $data['provisions'] : null;
        $this->container['registers'] = isset($data['registers']) ? $data['registers'] : null;
        $this->container['dualRegisters'] = isset($data['dualRegisters']) ? $data['dualRegisters'] : null;
        $this->container['hardwareIdType'] = isset($data['hardwareIdType']) ? $data['hardwareIdType'] : null;
        $this->container['allowReboot'] = isset($data['allowReboot']) ? $data['allowReboot'] : null;
        $this->container['noRebalance'] = isset($data['noRebalance']) ? $data['noRebalance'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        return true;
    }


    /**
     * Gets provisions
     * @return bool
     */
    public function getProvisions()
    {
        return $this->container['provisions'];
    }

    /**
     * Sets provisions
     * @param bool $provisions
     * @return $this
     */
    public function setProvisions($provisions)
    {
        $this->container['provisions'] = $provisions;

        return $this;
    }

    /**
     * Gets registers
     * @return bool
     */
    public function getRegisters()
    {
        return $this->container['registers'];
    }

    /**
     * Sets registers
     * @param bool $registers
     * @return $this
     */
    public function setRegisters($registers)
    {
        $this->container['registers'] = $registers;

        return $this;
    }

    /**
     * Gets dualRegisters
     * @return bool
     */
    public function getDualRegisters()
    {
        return $this->container['dualRegisters'];
    }

    /**
     * Sets dualRegisters
     * @param bool $dualRegisters
     * @return $this
     */
    public function setDualRegisters($dualRegisters)
    {
        $this->container['dualRegisters'] = $dualRegisters;

        return $this;
    }

    /**
     * Gets hardwareIdType
     * @return string
     */
    public function getHardwareIdType()
    {
        return $this->container['hardwareIdType'];
    }

    /**
     * Sets hardwareIdType
     * @param string $hardwareIdType
     * @return $this
     */
    public function setHardwareIdType($hardwareIdType)
    {
        $this->container['hardwareIdType'] = $hardwareIdType;

        return $this;
    }

    /**
     * Gets allowReboot
     * @return bool
     */
    public function getAllowReboot()
    {
        return $this->container['allowReboot'];
    }

    /**
     * Sets allowReboot
     * @param bool $allowReboot
     * @return $this
     */
    public function setAllowReboot($allowReboot)
    {
        $this->container['allowReboot'] = $allowReboot;

        return $this;
    }

    /**
     * Gets noRebalance
     * @return bool
     */
    public function getNoRebalance()
    {
        return $this->container['noRebalance'];
    }

    /**
     * Sets noRebalance
     * @param bool $noRebalance
     * @return $this
     */
    public function setNoRebalance($noRebalance)
    {
        $this->container['noRebalance'] = $noRebalance;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


