<?php
/**
 * AggregateMetricData
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AggregateMetricData Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AggregateMetricData implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AggregateMetricData';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'metric' => 'string',
        'qualifier' => 'string',
        'stats' => '\PureCloudSDK\StatisticalSummary'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'metric' => 'metric',
        'qualifier' => 'qualifier',
        'stats' => 'stats'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'metric' => 'setMetric',
        'qualifier' => 'setQualifier',
        'stats' => 'setStats'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'metric' => 'getMetric',
        'qualifier' => 'getQualifier',
        'stats' => 'getStats'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const METRIC_T_SEGMENT_DURATION = 'tSegmentDuration';
    const METRIC_T_CONVERSATION_DURATION = 'tConversationDuration';
    const METRIC_O_TOTAL_CRITICAL_SCORE = 'oTotalCriticalScore';
    const METRIC_O_TOTAL_SCORE = 'oTotalScore';
    const METRIC_N_EVALUATIONS = 'nEvaluations';
    const METRIC_T_ABANDON = 'tAbandon';
    const METRIC_T_IVR = 'tIvr';
    const METRIC_T_ANSWERED = 'tAnswered';
    const METRIC_T_ACD = 'tAcd';
    const METRIC_T_TALK = 'tTalk';
    const METRIC_T_HELD = 'tHeld';
    const METRIC_T_TALK_COMPLETE = 'tTalkComplete';
    const METRIC_T_HELD_COMPLETE = 'tHeldComplete';
    const METRIC_T_ACW = 'tAcw';
    const METRIC_T_HANDLE = 'tHandle';
    const METRIC_T_WAIT = 'tWait';
    const METRIC_T_AGENT_ROUTING_STATUS = 'tAgentRoutingStatus';
    const METRIC_T_ORGANIZATION_PRESENCE = 'tOrganizationPresence';
    const METRIC_T_SYSTEM_PRESENCE = 'tSystemPresence';
    const METRIC_T_USER_RESPONSE_TIME = 'tUserResponseTime';
    const METRIC_T_AGENT_RESPONSE_TIME = 'tAgentResponseTime';
    const METRIC_N_OFFERED = 'nOffered';
    const METRIC_N_OVER_SLA = 'nOverSla';
    const METRIC_N_TRANSFERRED = 'nTransferred';
    const METRIC_N_OUTBOUND_ATTEMPTED = 'nOutboundAttempted';
    const METRIC_N_OUTBOUND_CONNECTED = 'nOutboundConnected';
    const METRIC_N_OUTBOUND_ABANDONED = 'nOutboundAbandoned';
    const METRIC_N_ERROR = 'nError';
    const METRIC_O_SERVICE_TARGET = 'oServiceTarget';
    const METRIC_O_SERVICE_LEVEL = 'oServiceLevel';
    const METRIC_T_ACTIVE = 'tActive';
    const METRIC_T_INACTIVE = 'tInactive';
    const METRIC_O_ACTIVE_USERS = 'oActiveUsers';
    const METRIC_O_MEMBER_USERS = 'oMemberUsers';
    const METRIC_O_ACTIVE_QUEUES = 'oActiveQueues';
    const METRIC_O_MEMBER_QUEUES = 'oMemberQueues';
    const METRIC_O_INTERACTING = 'oInteracting';
    const METRIC_O_WAITING = 'oWaiting';
    const METRIC_O_ON_QUEUE_USERS = 'oOnQueueUsers';
    const METRIC_O_OFF_QUEUE_USERS = 'oOffQueueUsers';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMetricAllowableValues()
    {
        return [
            self::METRIC_T_SEGMENT_DURATION,
            self::METRIC_T_CONVERSATION_DURATION,
            self::METRIC_O_TOTAL_CRITICAL_SCORE,
            self::METRIC_O_TOTAL_SCORE,
            self::METRIC_N_EVALUATIONS,
            self::METRIC_T_ABANDON,
            self::METRIC_T_IVR,
            self::METRIC_T_ANSWERED,
            self::METRIC_T_ACD,
            self::METRIC_T_TALK,
            self::METRIC_T_HELD,
            self::METRIC_T_TALK_COMPLETE,
            self::METRIC_T_HELD_COMPLETE,
            self::METRIC_T_ACW,
            self::METRIC_T_HANDLE,
            self::METRIC_T_WAIT,
            self::METRIC_T_AGENT_ROUTING_STATUS,
            self::METRIC_T_ORGANIZATION_PRESENCE,
            self::METRIC_T_SYSTEM_PRESENCE,
            self::METRIC_T_USER_RESPONSE_TIME,
            self::METRIC_T_AGENT_RESPONSE_TIME,
            self::METRIC_N_OFFERED,
            self::METRIC_N_OVER_SLA,
            self::METRIC_N_TRANSFERRED,
            self::METRIC_N_OUTBOUND_ATTEMPTED,
            self::METRIC_N_OUTBOUND_CONNECTED,
            self::METRIC_N_OUTBOUND_ABANDONED,
            self::METRIC_N_ERROR,
            self::METRIC_O_SERVICE_TARGET,
            self::METRIC_O_SERVICE_LEVEL,
            self::METRIC_T_ACTIVE,
            self::METRIC_T_INACTIVE,
            self::METRIC_O_ACTIVE_USERS,
            self::METRIC_O_MEMBER_USERS,
            self::METRIC_O_ACTIVE_QUEUES,
            self::METRIC_O_MEMBER_QUEUES,
            self::METRIC_O_INTERACTING,
            self::METRIC_O_WAITING,
            self::METRIC_O_ON_QUEUE_USERS,
            self::METRIC_O_OFF_QUEUE_USERS,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['metric'] = isset($data['metric']) ? $data['metric'] : null;
        $this->container['qualifier'] = isset($data['qualifier']) ? $data['qualifier'] : null;
        $this->container['stats'] = isset($data['stats']) ? $data['stats'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("tSegmentDuration", "tConversationDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "nOffered", "nOverSla", "nTransferred", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers");
        if (!in_array($this->container['metric'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'metric', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("tSegmentDuration", "tConversationDuration", "oTotalCriticalScore", "oTotalScore", "nEvaluations", "tAbandon", "tIvr", "tAnswered", "tAcd", "tTalk", "tHeld", "tTalkComplete", "tHeldComplete", "tAcw", "tHandle", "tWait", "tAgentRoutingStatus", "tOrganizationPresence", "tSystemPresence", "tUserResponseTime", "tAgentResponseTime", "nOffered", "nOverSla", "nTransferred", "nOutboundAttempted", "nOutboundConnected", "nOutboundAbandoned", "nError", "oServiceTarget", "oServiceLevel", "tActive", "tInactive", "oActiveUsers", "oMemberUsers", "oActiveQueues", "oMemberQueues", "oInteracting", "oWaiting", "oOnQueueUsers", "oOffQueueUsers");
        if (!in_array($this->container['metric'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets metric
     * @return string
     */
    public function getMetric()
    {
        return $this->container['metric'];
    }

    /**
     * Sets metric
     * @param string $metric
     * @return $this
     */
    public function setMetric($metric)
    {
        $allowed_values = array('tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'nOffered', 'nOverSla', 'nTransferred', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers');
        if (!in_array($metric, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'metric', must be one of 'tSegmentDuration', 'tConversationDuration', 'oTotalCriticalScore', 'oTotalScore', 'nEvaluations', 'tAbandon', 'tIvr', 'tAnswered', 'tAcd', 'tTalk', 'tHeld', 'tTalkComplete', 'tHeldComplete', 'tAcw', 'tHandle', 'tWait', 'tAgentRoutingStatus', 'tOrganizationPresence', 'tSystemPresence', 'tUserResponseTime', 'tAgentResponseTime', 'nOffered', 'nOverSla', 'nTransferred', 'nOutboundAttempted', 'nOutboundConnected', 'nOutboundAbandoned', 'nError', 'oServiceTarget', 'oServiceLevel', 'tActive', 'tInactive', 'oActiveUsers', 'oMemberUsers', 'oActiveQueues', 'oMemberQueues', 'oInteracting', 'oWaiting', 'oOnQueueUsers', 'oOffQueueUsers'");
        }
        $this->container['metric'] = $metric;

        return $this;
    }

    /**
     * Gets qualifier
     * @return string
     */
    public function getQualifier()
    {
        return $this->container['qualifier'];
    }

    /**
     * Sets qualifier
     * @param string $qualifier
     * @return $this
     */
    public function setQualifier($qualifier)
    {
        $this->container['qualifier'] = $qualifier;

        return $this;
    }

    /**
     * Gets stats
     * @return \PureCloudSDK\StatisticalSummary
     */
    public function getStats()
    {
        return $this->container['stats'];
    }

    /**
     * Sets stats
     * @param \PureCloudSDK\StatisticalSummary $stats
     * @return $this
     */
    public function setStats($stats)
    {
        $this->container['stats'] = $stats;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


