<?php
/**
 * AnalyticsSession
 *
 * PHP version 5
 *
 * @category Class
 * @package  PureCloudSDK
 * @author   http://github.com/swagger-api/swagger-codegen
 * @license  http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link     https://github.com/swagger-api/swagger-codegen
 */

/**
 * PureCloud Platform API
 *
 * With the PureCloud Platform API, you can control all aspects of your PureCloud environment. With the APIs you can access the system configuration, manage conversations and more.
 *
 * OpenAPI spec version: v2
 * Contact: DeveloperEvangelists@inin.com
 * Generated by: https://github.com/swagger-api/swagger-codegen.git
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * NOTE: This class is auto generated by the swagger code generator program.
 * https://github.com/swagger-api/swagger-codegen
 * Do not edit the class manually.
 */

namespace PureCloudSDK;

use \ArrayAccess;

/**
 * AnalyticsSession Class Doc Comment
 *
 * @category    Class */
/** 
 * @package     PureCloudSDK
 * @author      http://github.com/swagger-api/swagger-codegen
 * @license     http://www.apache.org/licenses/LICENSE-2.0 Apache Licene v2
 * @link        https://github.com/swagger-api/swagger-codegen
 */
class AnalyticsSession implements ArrayAccess
{
    /**
      * The original name of the model.
      * @var string
      */
    protected static $swaggerModelName = 'AnalyticsSession';

    /**
      * Array of property to type mappings. Used for (de)serialization
      * @var string[]
      */
    protected static $swaggerTypes = array(
        'mediaType' => 'string',
        'sessionId' => 'string',
        'addressOther' => 'string',
        'addressSelf' => 'string',
        'ani' => 'string',
        'direction' => 'string',
        'dnis' => 'string',
        'outboundCampaignId' => 'string',
        'outboundContactId' => 'string',
        'outboundContactListId' => 'string',
        'dispositionAnalyzer' => 'string',
        'dispositionName' => 'string',
        'edgeId' => 'string',
        'remoteNameDisplayable' => 'string',
        'roomId' => 'string',
        'monitoredSessionId' => 'string',
        'monitoredParticipantId' => 'string',
        'callbackUserName' => 'string',
        'callbackNumbers' => 'string[]',
        'callbackScheduledTime' => '\DateTime',
        'scriptId' => 'string',
        'skipEnabled' => 'bool',
        'timeoutSeconds' => 'int',
        'cobrowseRole' => 'string',
        'cobrowseRoomId' => 'string',
        'mediaBridgeId' => 'string',
        'screenShareAddressSelf' => 'string',
        'sharingScreen' => 'bool',
        'screenShareRoomId' => 'string',
        'videoRoomId' => 'string',
        'videoAddressSelf' => 'string',
        'segments' => '\PureCloudSDK\AnalyticsConversationSegment[]'
    );

    public static function swaggerTypes()
    {
        return self::$swaggerTypes;
    }

    /**
     * Array of attributes where the key is the local name, and the value is the original name
     * @var string[]
     */
    protected static $attributeMap = array(
        'mediaType' => 'mediaType',
        'sessionId' => 'sessionId',
        'addressOther' => 'addressOther',
        'addressSelf' => 'addressSelf',
        'ani' => 'ani',
        'direction' => 'direction',
        'dnis' => 'dnis',
        'outboundCampaignId' => 'outboundCampaignId',
        'outboundContactId' => 'outboundContactId',
        'outboundContactListId' => 'outboundContactListId',
        'dispositionAnalyzer' => 'dispositionAnalyzer',
        'dispositionName' => 'dispositionName',
        'edgeId' => 'edgeId',
        'remoteNameDisplayable' => 'remoteNameDisplayable',
        'roomId' => 'roomId',
        'monitoredSessionId' => 'monitoredSessionId',
        'monitoredParticipantId' => 'monitoredParticipantId',
        'callbackUserName' => 'callbackUserName',
        'callbackNumbers' => 'callbackNumbers',
        'callbackScheduledTime' => 'callbackScheduledTime',
        'scriptId' => 'scriptId',
        'skipEnabled' => 'skipEnabled',
        'timeoutSeconds' => 'timeoutSeconds',
        'cobrowseRole' => 'cobrowseRole',
        'cobrowseRoomId' => 'cobrowseRoomId',
        'mediaBridgeId' => 'mediaBridgeId',
        'screenShareAddressSelf' => 'screenShareAddressSelf',
        'sharingScreen' => 'sharingScreen',
        'screenShareRoomId' => 'screenShareRoomId',
        'videoRoomId' => 'videoRoomId',
        'videoAddressSelf' => 'videoAddressSelf',
        'segments' => 'segments'
    );

    public static function attributeMap()
    {
        return self::$attributeMap;
    }

    /**
     * Array of attributes to setter functions (for deserialization of responses)
     * @var string[]
     */
    protected static $setters = array(
        'mediaType' => 'setMediaType',
        'sessionId' => 'setSessionId',
        'addressOther' => 'setAddressOther',
        'addressSelf' => 'setAddressSelf',
        'ani' => 'setAni',
        'direction' => 'setDirection',
        'dnis' => 'setDnis',
        'outboundCampaignId' => 'setOutboundCampaignId',
        'outboundContactId' => 'setOutboundContactId',
        'outboundContactListId' => 'setOutboundContactListId',
        'dispositionAnalyzer' => 'setDispositionAnalyzer',
        'dispositionName' => 'setDispositionName',
        'edgeId' => 'setEdgeId',
        'remoteNameDisplayable' => 'setRemoteNameDisplayable',
        'roomId' => 'setRoomId',
        'monitoredSessionId' => 'setMonitoredSessionId',
        'monitoredParticipantId' => 'setMonitoredParticipantId',
        'callbackUserName' => 'setCallbackUserName',
        'callbackNumbers' => 'setCallbackNumbers',
        'callbackScheduledTime' => 'setCallbackScheduledTime',
        'scriptId' => 'setScriptId',
        'skipEnabled' => 'setSkipEnabled',
        'timeoutSeconds' => 'setTimeoutSeconds',
        'cobrowseRole' => 'setCobrowseRole',
        'cobrowseRoomId' => 'setCobrowseRoomId',
        'mediaBridgeId' => 'setMediaBridgeId',
        'screenShareAddressSelf' => 'setScreenShareAddressSelf',
        'sharingScreen' => 'setSharingScreen',
        'screenShareRoomId' => 'setScreenShareRoomId',
        'videoRoomId' => 'setVideoRoomId',
        'videoAddressSelf' => 'setVideoAddressSelf',
        'segments' => 'setSegments'
    );

    public static function setters()
    {
        return self::$setters;
    }

    /**
     * Array of attributes to getter functions (for serialization of requests)
     * @var string[]
     */
    protected static $getters = array(
        'mediaType' => 'getMediaType',
        'sessionId' => 'getSessionId',
        'addressOther' => 'getAddressOther',
        'addressSelf' => 'getAddressSelf',
        'ani' => 'getAni',
        'direction' => 'getDirection',
        'dnis' => 'getDnis',
        'outboundCampaignId' => 'getOutboundCampaignId',
        'outboundContactId' => 'getOutboundContactId',
        'outboundContactListId' => 'getOutboundContactListId',
        'dispositionAnalyzer' => 'getDispositionAnalyzer',
        'dispositionName' => 'getDispositionName',
        'edgeId' => 'getEdgeId',
        'remoteNameDisplayable' => 'getRemoteNameDisplayable',
        'roomId' => 'getRoomId',
        'monitoredSessionId' => 'getMonitoredSessionId',
        'monitoredParticipantId' => 'getMonitoredParticipantId',
        'callbackUserName' => 'getCallbackUserName',
        'callbackNumbers' => 'getCallbackNumbers',
        'callbackScheduledTime' => 'getCallbackScheduledTime',
        'scriptId' => 'getScriptId',
        'skipEnabled' => 'getSkipEnabled',
        'timeoutSeconds' => 'getTimeoutSeconds',
        'cobrowseRole' => 'getCobrowseRole',
        'cobrowseRoomId' => 'getCobrowseRoomId',
        'mediaBridgeId' => 'getMediaBridgeId',
        'screenShareAddressSelf' => 'getScreenShareAddressSelf',
        'sharingScreen' => 'getSharingScreen',
        'screenShareRoomId' => 'getScreenShareRoomId',
        'videoRoomId' => 'getVideoRoomId',
        'videoAddressSelf' => 'getVideoAddressSelf',
        'segments' => 'getSegments'
    );

    public static function getters()
    {
        return self::$getters;
    }

    const MEDIA_TYPE_VOICE = 'voice';
    const MEDIA_TYPE_CHAT = 'chat';
    const MEDIA_TYPE_EMAIL = 'email';
    const MEDIA_TYPE_CALLBACK = 'callback';
    const MEDIA_TYPE_COBROWSE = 'cobrowse';
    const MEDIA_TYPE_VIDEO = 'video';
    const MEDIA_TYPE_SCREENSHARE = 'screenshare';
    const DIRECTION_INBOUND = 'inbound';
    const DIRECTION_OUTBOUND = 'outbound';
    

    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getMediaTypeAllowableValues()
    {
        return [
            self::MEDIA_TYPE_VOICE,
            self::MEDIA_TYPE_CHAT,
            self::MEDIA_TYPE_EMAIL,
            self::MEDIA_TYPE_CALLBACK,
            self::MEDIA_TYPE_COBROWSE,
            self::MEDIA_TYPE_VIDEO,
            self::MEDIA_TYPE_SCREENSHARE,
        ];
    }
    
    /**
     * Gets allowable values of the enum
     * @return string[]
     */
    public function getDirectionAllowableValues()
    {
        return [
            self::DIRECTION_INBOUND,
            self::DIRECTION_OUTBOUND,
        ];
    }
    

    /**
     * Associative array for storing property values
     * @var mixed[]
     */
    protected $container = array();

    /**
     * Constructor
     * @param mixed[] $data Associated array of property value initalizing the model
     */
    public function __construct(array $data = null)
    {
        $this->container['mediaType'] = isset($data['mediaType']) ? $data['mediaType'] : null;
        $this->container['sessionId'] = isset($data['sessionId']) ? $data['sessionId'] : null;
        $this->container['addressOther'] = isset($data['addressOther']) ? $data['addressOther'] : null;
        $this->container['addressSelf'] = isset($data['addressSelf']) ? $data['addressSelf'] : null;
        $this->container['ani'] = isset($data['ani']) ? $data['ani'] : null;
        $this->container['direction'] = isset($data['direction']) ? $data['direction'] : null;
        $this->container['dnis'] = isset($data['dnis']) ? $data['dnis'] : null;
        $this->container['outboundCampaignId'] = isset($data['outboundCampaignId']) ? $data['outboundCampaignId'] : null;
        $this->container['outboundContactId'] = isset($data['outboundContactId']) ? $data['outboundContactId'] : null;
        $this->container['outboundContactListId'] = isset($data['outboundContactListId']) ? $data['outboundContactListId'] : null;
        $this->container['dispositionAnalyzer'] = isset($data['dispositionAnalyzer']) ? $data['dispositionAnalyzer'] : null;
        $this->container['dispositionName'] = isset($data['dispositionName']) ? $data['dispositionName'] : null;
        $this->container['edgeId'] = isset($data['edgeId']) ? $data['edgeId'] : null;
        $this->container['remoteNameDisplayable'] = isset($data['remoteNameDisplayable']) ? $data['remoteNameDisplayable'] : null;
        $this->container['roomId'] = isset($data['roomId']) ? $data['roomId'] : null;
        $this->container['monitoredSessionId'] = isset($data['monitoredSessionId']) ? $data['monitoredSessionId'] : null;
        $this->container['monitoredParticipantId'] = isset($data['monitoredParticipantId']) ? $data['monitoredParticipantId'] : null;
        $this->container['callbackUserName'] = isset($data['callbackUserName']) ? $data['callbackUserName'] : null;
        $this->container['callbackNumbers'] = isset($data['callbackNumbers']) ? $data['callbackNumbers'] : null;
        $this->container['callbackScheduledTime'] = isset($data['callbackScheduledTime']) ? $data['callbackScheduledTime'] : null;
        $this->container['scriptId'] = isset($data['scriptId']) ? $data['scriptId'] : null;
        $this->container['skipEnabled'] = isset($data['skipEnabled']) ? $data['skipEnabled'] : null;
        $this->container['timeoutSeconds'] = isset($data['timeoutSeconds']) ? $data['timeoutSeconds'] : null;
        $this->container['cobrowseRole'] = isset($data['cobrowseRole']) ? $data['cobrowseRole'] : null;
        $this->container['cobrowseRoomId'] = isset($data['cobrowseRoomId']) ? $data['cobrowseRoomId'] : null;
        $this->container['mediaBridgeId'] = isset($data['mediaBridgeId']) ? $data['mediaBridgeId'] : null;
        $this->container['screenShareAddressSelf'] = isset($data['screenShareAddressSelf']) ? $data['screenShareAddressSelf'] : null;
        $this->container['sharingScreen'] = isset($data['sharingScreen']) ? $data['sharingScreen'] : null;
        $this->container['screenShareRoomId'] = isset($data['screenShareRoomId']) ? $data['screenShareRoomId'] : null;
        $this->container['videoRoomId'] = isset($data['videoRoomId']) ? $data['videoRoomId'] : null;
        $this->container['videoAddressSelf'] = isset($data['videoAddressSelf']) ? $data['videoAddressSelf'] : null;
        $this->container['segments'] = isset($data['segments']) ? $data['segments'] : null;
    }

    /**
     * show all the invalid properties with reasons.
     *
     * @return array invalid properties with reasons
     */
    public function listInvalidProperties()
    {
        $invalid_properties = array();
        $allowed_values = array("voice", "chat", "email", "callback", "cobrowse", "video", "screenshare");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'mediaType', must be one of #{allowed_values}.";
        }

        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            $invalid_properties[] = "invalid value for 'direction', must be one of #{allowed_values}.";
        }

        return $invalid_properties;
    }

    /**
     * validate all the properties in the model
     * return true if all passed
     *
     * @return bool True if all properteis are valid
     */
    public function valid()
    {
        $allowed_values = array("voice", "chat", "email", "callback", "cobrowse", "video", "screenshare");
        if (!in_array($this->container['mediaType'], $allowed_values)) {
            return false;
        }
        $allowed_values = array("inbound", "outbound");
        if (!in_array($this->container['direction'], $allowed_values)) {
            return false;
        }
        return true;
    }


    /**
     * Gets mediaType
     * @return string
     */
    public function getMediaType()
    {
        return $this->container['mediaType'];
    }

    /**
     * Sets mediaType
     * @param string $mediaType
     * @return $this
     */
    public function setMediaType($mediaType)
    {
        $allowed_values = array('voice', 'chat', 'email', 'callback', 'cobrowse', 'video', 'screenshare');
        if (!in_array($mediaType, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'mediaType', must be one of 'voice', 'chat', 'email', 'callback', 'cobrowse', 'video', 'screenshare'");
        }
        $this->container['mediaType'] = $mediaType;

        return $this;
    }

    /**
     * Gets sessionId
     * @return string
     */
    public function getSessionId()
    {
        return $this->container['sessionId'];
    }

    /**
     * Sets sessionId
     * @param string $sessionId
     * @return $this
     */
    public function setSessionId($sessionId)
    {
        $this->container['sessionId'] = $sessionId;

        return $this;
    }

    /**
     * Gets addressOther
     * @return string
     */
    public function getAddressOther()
    {
        return $this->container['addressOther'];
    }

    /**
     * Sets addressOther
     * @param string $addressOther
     * @return $this
     */
    public function setAddressOther($addressOther)
    {
        $this->container['addressOther'] = $addressOther;

        return $this;
    }

    /**
     * Gets addressSelf
     * @return string
     */
    public function getAddressSelf()
    {
        return $this->container['addressSelf'];
    }

    /**
     * Sets addressSelf
     * @param string $addressSelf
     * @return $this
     */
    public function setAddressSelf($addressSelf)
    {
        $this->container['addressSelf'] = $addressSelf;

        return $this;
    }

    /**
     * Gets ani
     * @return string
     */
    public function getAni()
    {
        return $this->container['ani'];
    }

    /**
     * Sets ani
     * @param string $ani
     * @return $this
     */
    public function setAni($ani)
    {
        $this->container['ani'] = $ani;

        return $this;
    }

    /**
     * Gets direction
     * @return string
     */
    public function getDirection()
    {
        return $this->container['direction'];
    }

    /**
     * Sets direction
     * @param string $direction
     * @return $this
     */
    public function setDirection($direction)
    {
        $allowed_values = array('inbound', 'outbound');
        if (!in_array($direction, $allowed_values)) {
            throw new \InvalidArgumentException("Invalid value for 'direction', must be one of 'inbound', 'outbound'");
        }
        $this->container['direction'] = $direction;

        return $this;
    }

    /**
     * Gets dnis
     * @return string
     */
    public function getDnis()
    {
        return $this->container['dnis'];
    }

    /**
     * Sets dnis
     * @param string $dnis
     * @return $this
     */
    public function setDnis($dnis)
    {
        $this->container['dnis'] = $dnis;

        return $this;
    }

    /**
     * Gets outboundCampaignId
     * @return string
     */
    public function getOutboundCampaignId()
    {
        return $this->container['outboundCampaignId'];
    }

    /**
     * Sets outboundCampaignId
     * @param string $outboundCampaignId
     * @return $this
     */
    public function setOutboundCampaignId($outboundCampaignId)
    {
        $this->container['outboundCampaignId'] = $outboundCampaignId;

        return $this;
    }

    /**
     * Gets outboundContactId
     * @return string
     */
    public function getOutboundContactId()
    {
        return $this->container['outboundContactId'];
    }

    /**
     * Sets outboundContactId
     * @param string $outboundContactId
     * @return $this
     */
    public function setOutboundContactId($outboundContactId)
    {
        $this->container['outboundContactId'] = $outboundContactId;

        return $this;
    }

    /**
     * Gets outboundContactListId
     * @return string
     */
    public function getOutboundContactListId()
    {
        return $this->container['outboundContactListId'];
    }

    /**
     * Sets outboundContactListId
     * @param string $outboundContactListId
     * @return $this
     */
    public function setOutboundContactListId($outboundContactListId)
    {
        $this->container['outboundContactListId'] = $outboundContactListId;

        return $this;
    }

    /**
     * Gets dispositionAnalyzer
     * @return string
     */
    public function getDispositionAnalyzer()
    {
        return $this->container['dispositionAnalyzer'];
    }

    /**
     * Sets dispositionAnalyzer
     * @param string $dispositionAnalyzer
     * @return $this
     */
    public function setDispositionAnalyzer($dispositionAnalyzer)
    {
        $this->container['dispositionAnalyzer'] = $dispositionAnalyzer;

        return $this;
    }

    /**
     * Gets dispositionName
     * @return string
     */
    public function getDispositionName()
    {
        return $this->container['dispositionName'];
    }

    /**
     * Sets dispositionName
     * @param string $dispositionName
     * @return $this
     */
    public function setDispositionName($dispositionName)
    {
        $this->container['dispositionName'] = $dispositionName;

        return $this;
    }

    /**
     * Gets edgeId
     * @return string
     */
    public function getEdgeId()
    {
        return $this->container['edgeId'];
    }

    /**
     * Sets edgeId
     * @param string $edgeId
     * @return $this
     */
    public function setEdgeId($edgeId)
    {
        $this->container['edgeId'] = $edgeId;

        return $this;
    }

    /**
     * Gets remoteNameDisplayable
     * @return string
     */
    public function getRemoteNameDisplayable()
    {
        return $this->container['remoteNameDisplayable'];
    }

    /**
     * Sets remoteNameDisplayable
     * @param string $remoteNameDisplayable
     * @return $this
     */
    public function setRemoteNameDisplayable($remoteNameDisplayable)
    {
        $this->container['remoteNameDisplayable'] = $remoteNameDisplayable;

        return $this;
    }

    /**
     * Gets roomId
     * @return string
     */
    public function getRoomId()
    {
        return $this->container['roomId'];
    }

    /**
     * Sets roomId
     * @param string $roomId
     * @return $this
     */
    public function setRoomId($roomId)
    {
        $this->container['roomId'] = $roomId;

        return $this;
    }

    /**
     * Gets monitoredSessionId
     * @return string
     */
    public function getMonitoredSessionId()
    {
        return $this->container['monitoredSessionId'];
    }

    /**
     * Sets monitoredSessionId
     * @param string $monitoredSessionId
     * @return $this
     */
    public function setMonitoredSessionId($monitoredSessionId)
    {
        $this->container['monitoredSessionId'] = $monitoredSessionId;

        return $this;
    }

    /**
     * Gets monitoredParticipantId
     * @return string
     */
    public function getMonitoredParticipantId()
    {
        return $this->container['monitoredParticipantId'];
    }

    /**
     * Sets monitoredParticipantId
     * @param string $monitoredParticipantId
     * @return $this
     */
    public function setMonitoredParticipantId($monitoredParticipantId)
    {
        $this->container['monitoredParticipantId'] = $monitoredParticipantId;

        return $this;
    }

    /**
     * Gets callbackUserName
     * @return string
     */
    public function getCallbackUserName()
    {
        return $this->container['callbackUserName'];
    }

    /**
     * Sets callbackUserName
     * @param string $callbackUserName
     * @return $this
     */
    public function setCallbackUserName($callbackUserName)
    {
        $this->container['callbackUserName'] = $callbackUserName;

        return $this;
    }

    /**
     * Gets callbackNumbers
     * @return string[]
     */
    public function getCallbackNumbers()
    {
        return $this->container['callbackNumbers'];
    }

    /**
     * Sets callbackNumbers
     * @param string[] $callbackNumbers
     * @return $this
     */
    public function setCallbackNumbers($callbackNumbers)
    {
        $this->container['callbackNumbers'] = $callbackNumbers;

        return $this;
    }

    /**
     * Gets callbackScheduledTime
     * @return \DateTime
     */
    public function getCallbackScheduledTime()
    {
        return $this->container['callbackScheduledTime'];
    }

    /**
     * Sets callbackScheduledTime
     * @param \DateTime $callbackScheduledTime Date time is represented as an ISO-8601 string. For example: yyyy-MM-ddTHH:mm:ss.SSSZ
     * @return $this
     */
    public function setCallbackScheduledTime($callbackScheduledTime)
    {
        $this->container['callbackScheduledTime'] = $callbackScheduledTime;

        return $this;
    }

    /**
     * Gets scriptId
     * @return string
     */
    public function getScriptId()
    {
        return $this->container['scriptId'];
    }

    /**
     * Sets scriptId
     * @param string $scriptId
     * @return $this
     */
    public function setScriptId($scriptId)
    {
        $this->container['scriptId'] = $scriptId;

        return $this;
    }

    /**
     * Gets skipEnabled
     * @return bool
     */
    public function getSkipEnabled()
    {
        return $this->container['skipEnabled'];
    }

    /**
     * Sets skipEnabled
     * @param bool $skipEnabled
     * @return $this
     */
    public function setSkipEnabled($skipEnabled)
    {
        $this->container['skipEnabled'] = $skipEnabled;

        return $this;
    }

    /**
     * Gets timeoutSeconds
     * @return int
     */
    public function getTimeoutSeconds()
    {
        return $this->container['timeoutSeconds'];
    }

    /**
     * Sets timeoutSeconds
     * @param int $timeoutSeconds
     * @return $this
     */
    public function setTimeoutSeconds($timeoutSeconds)
    {
        $this->container['timeoutSeconds'] = $timeoutSeconds;

        return $this;
    }

    /**
     * Gets cobrowseRole
     * @return string
     */
    public function getCobrowseRole()
    {
        return $this->container['cobrowseRole'];
    }

    /**
     * Sets cobrowseRole
     * @param string $cobrowseRole
     * @return $this
     */
    public function setCobrowseRole($cobrowseRole)
    {
        $this->container['cobrowseRole'] = $cobrowseRole;

        return $this;
    }

    /**
     * Gets cobrowseRoomId
     * @return string
     */
    public function getCobrowseRoomId()
    {
        return $this->container['cobrowseRoomId'];
    }

    /**
     * Sets cobrowseRoomId
     * @param string $cobrowseRoomId
     * @return $this
     */
    public function setCobrowseRoomId($cobrowseRoomId)
    {
        $this->container['cobrowseRoomId'] = $cobrowseRoomId;

        return $this;
    }

    /**
     * Gets mediaBridgeId
     * @return string
     */
    public function getMediaBridgeId()
    {
        return $this->container['mediaBridgeId'];
    }

    /**
     * Sets mediaBridgeId
     * @param string $mediaBridgeId
     * @return $this
     */
    public function setMediaBridgeId($mediaBridgeId)
    {
        $this->container['mediaBridgeId'] = $mediaBridgeId;

        return $this;
    }

    /**
     * Gets screenShareAddressSelf
     * @return string
     */
    public function getScreenShareAddressSelf()
    {
        return $this->container['screenShareAddressSelf'];
    }

    /**
     * Sets screenShareAddressSelf
     * @param string $screenShareAddressSelf
     * @return $this
     */
    public function setScreenShareAddressSelf($screenShareAddressSelf)
    {
        $this->container['screenShareAddressSelf'] = $screenShareAddressSelf;

        return $this;
    }

    /**
     * Gets sharingScreen
     * @return bool
     */
    public function getSharingScreen()
    {
        return $this->container['sharingScreen'];
    }

    /**
     * Sets sharingScreen
     * @param bool $sharingScreen
     * @return $this
     */
    public function setSharingScreen($sharingScreen)
    {
        $this->container['sharingScreen'] = $sharingScreen;

        return $this;
    }

    /**
     * Gets screenShareRoomId
     * @return string
     */
    public function getScreenShareRoomId()
    {
        return $this->container['screenShareRoomId'];
    }

    /**
     * Sets screenShareRoomId
     * @param string $screenShareRoomId
     * @return $this
     */
    public function setScreenShareRoomId($screenShareRoomId)
    {
        $this->container['screenShareRoomId'] = $screenShareRoomId;

        return $this;
    }

    /**
     * Gets videoRoomId
     * @return string
     */
    public function getVideoRoomId()
    {
        return $this->container['videoRoomId'];
    }

    /**
     * Sets videoRoomId
     * @param string $videoRoomId
     * @return $this
     */
    public function setVideoRoomId($videoRoomId)
    {
        $this->container['videoRoomId'] = $videoRoomId;

        return $this;
    }

    /**
     * Gets videoAddressSelf
     * @return string
     */
    public function getVideoAddressSelf()
    {
        return $this->container['videoAddressSelf'];
    }

    /**
     * Sets videoAddressSelf
     * @param string $videoAddressSelf
     * @return $this
     */
    public function setVideoAddressSelf($videoAddressSelf)
    {
        $this->container['videoAddressSelf'] = $videoAddressSelf;

        return $this;
    }

    /**
     * Gets segments
     * @return \PureCloudSDK\AnalyticsConversationSegment[]
     */
    public function getSegments()
    {
        return $this->container['segments'];
    }

    /**
     * Sets segments
     * @param \PureCloudSDK\AnalyticsConversationSegment[] $segments
     * @return $this
     */
    public function setSegments($segments)
    {
        $this->container['segments'] = $segments;

        return $this;
    }
    /**
     * Returns true if offset exists. False otherwise.
     * @param  integer $offset Offset
     * @return boolean
     */
    public function offsetExists($offset)
    {
        return isset($this->container[$offset]);
    }

    /**
     * Gets offset.
     * @param  integer $offset Offset
     * @return mixed
     */
    public function offsetGet($offset)
    {
        return isset($this->container[$offset]) ? $this->container[$offset] : null;
    }

    /**
     * Sets value based on offset.
     * @param  integer $offset Offset
     * @param  mixed   $value  Value to be set
     * @return void
     */
    public function offsetSet($offset, $value)
    {
        if (is_null($offset)) {
            $this->container[] = $value;
        } else {
            $this->container[$offset] = $value;
        }
    }

    /**
     * Unsets offset.
     * @param  integer $offset Offset
     * @return void
     */
    public function offsetUnset($offset)
    {
        unset($this->container[$offset]);
    }

    /**
     * Gets the string presentation of the object
     * @return string
     */
    public function __toString()
    {
        if (defined('JSON_PRETTY_PRINT')) { // use JSON pretty print
            return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this), JSON_PRETTY_PRINT);
        }

        return json_encode(\PureCloudSDK\ObjectSerializer::sanitizeForSerialization($this));
    }
}


